/* Copyright 2026 Marimo. All rights reserved. */
"use no memo";

import type { ColumnPinningState } from "@tanstack/react-table";
import { isEqual } from "lodash-es";
import React from "react";
import { useInternalStateWithSync } from "@/hooks/useInternalStateWithSync";
import { SELECT_COLUMN_ID } from "../types";

interface UseColumnPinningResult {
  columnPinning: ColumnPinningState;
  setColumnPinning: React.Dispatch<React.SetStateAction<ColumnPinningState>>;
}

export function useColumnPinning(
  freezeColumnsLeft?: string[],
  freezeColumnsRight?: string[],
): UseColumnPinningResult {
  const [columnPinning, setColumnPinning] =
    useInternalStateWithSync<ColumnPinningState>(
      {
        left: maybeAddSelectColumnId(freezeColumnsLeft),
        right: freezeColumnsRight,
      },
      isEqual,
    );

  const setColumnPinningWithFreeze = (
    newState: React.SetStateAction<ColumnPinningState>,
  ) => {
    setColumnPinning((prevState) => {
      const updatedState =
        typeof newState === "function" ? newState(prevState) : newState;
      return {
        left: maybeAddSelectColumnId(updatedState.left),
        right: updatedState.right,
      };
    });
  };

  return { columnPinning, setColumnPinning: setColumnPinningWithFreeze };
}

function maybeAddSelectColumnId(freezeColumns: string[] | undefined): string[] {
  if (!freezeColumns || freezeColumns.length === 0) {
    return [];
  }
  return freezeColumns.includes(SELECT_COLUMN_ID)
    ? freezeColumns
    : [SELECT_COLUMN_ID, ...freezeColumns];
}
