# Security Policy

marimo is committed to providing a secure environment for notebook development and application deployment. For a comprehensive overview of marimo's security model and features, see our [Security documentation](https://docs.marimo.io/security/).

## Reporting a Vulnerability

To report a security vulnerability, [please draft an advisory through
Github](https://github.com/marimo-team/marimo/security/advisories/new), or
email the marimo team; security [at] marimo [dot] io.

### What Warrants a Security Advisory

We issue CVEs and security advisories when:

- A vulnerability could affect long-running app deployments
- End-users are directly impacted
- The issue has security implications beyond normal bug fixes

General safety improvements and hardening work are documented in our [release notes](https://github.com/marimo-team/marimo/releases) without formal advisories.

Advisories will be escalated to a CVE and/or a general advisory issued if end-users
are directly impacted. Attribution for any actionable report will be provided
in the section below (unless anonymity is preferred).

### molab Security

For security issues affecting [molab](https://docs.marimo.io/guides/molab/) (our hosted platform):

- Reports can be submitted through the same channels above
- We handle disclosure on a case-by-case basis
- General security improvements are disclosed publicly when applicable
- User-specific issues are handled privately through direct notification

## Recognition and Thanks

We deeply appreciate the security research community's efforts to improve marimo's security. Responsible disclosure helps protect all marimo users, and we recognize the time and expertise that goes into security research.

We would like to acknowledge and thank the following individuals for their responsible disclosure of security issues:

 - @AlexanderBarabanov
 - @pwntester
 - @s-celles
 - @acepace
 - @devgi
 - @W-M-T (Ward Theunisse)

Your contributions help keep marimo safe for the entire community. We encourage security researchers to report issues and welcome your help in making marimo more secure.
