# Guides

These guides cover marimo's core concepts.

!!! tip "Learn by doing!"

    Prefer a hands-on learning experience? marimo comes packaged with interactive
    tutorials that you can launch with `marimo tutorial` at the command line.

| Guide                                                 | Description                                                |
| :---------------------------------------------------- | :--------------------------------------------------------- |
| [Running cells](reactivity.md)                        | Understanding how marimo runs cells                        |
| [Interactive elements](interactivity.md)              | Using interactive UI elements                              |
| [Visualizing outputs](outputs.md)                     | Creating markdown, plots, and other visual outputs         |
| [Migrating from Jupyter](coming_from/jupyter.md)      | Tips for transitioning from Jupyter                        |
| [Expensive notebooks](expensive_notebooks.md)         | Tips for working with expensive notebooks                  |
| [Understanding errors](understanding_errors/index.md) | Understanding marimo's constraints on notebook code        |
| [Lint rules](lint_rules/index.md)                    | Comprehensive linting system and rule reference           |
| [Working with data](working_with_data/index.md)       | Using SQL cells, no-code dataframe, and reactive plots     |
| [Package management](package_management/index.md)     | Inlining dependencies in notebook files and other package management guides |
| [Generate with AI](generate_with_ai/index.md)         | Generate notebooks with AI                                 |
| [Editor features](editor_features/index.md)           | View variables, dataframe schemas, docstrings, and more    |
| [Using your own editor](editor_features/watching.md)  | Edit notebooks in your own editor and stream changes back to the browser |
| [Apps](apps.md)                                       | Running notebooks as apps                                  |
| [Scripts](scripts.md)                                 | Running notebooks as scripts                               |
| [Reusing functions and classes](reusing_functions.md) | Importing functions and classes defined in marimo notebooks |
| [Tests](testing/index.md)                             | Running unit tests in notebooks                            |
| [Export notebooks](exporting.md)                      | Exporting notebooks to HTML, ipynb, flat scripts, and more |
| [Cloud notebooks with molab](molab.md)             | Share links to cloud-based marimo notebooks, similar to Google Colab                      |
| [Publish to the web](publishing/index.md)             | Edit and publish notebooks on the web                      |
| [Run notebooks with WebAssembly](wasm.md)             | Create notebooks in our online playground                  |
| [Deploying](deploying/index.md)                       | Deploying marimo notebooks and apps                        |
| [Configuration](configuration/index.md)               | Configure various settings                                 |
| [Coming from other tools](coming_from/index.md)       | Transitioning from Jupyter and other tools                 |
| [Extending marimo](integrating_with_marimo/index.md)  | Rich displays of objects, custom UI plugins                |
| [State management](state.md)                          | Advanced: mutable reactive state                           |
| [Best practices](best_practices.md)                   | Best practices to help you get the most out of marimo      |
| [Debugging](debugging.md)                             | Interactive debugging with pdb, debugpy, and AI assistance |
| [Troubleshooting](troubleshooting.md)                 | Troubleshooting notebooks                                  |
