# Security

marimo takes security seriously. This document describes marimo's security model, our approach to vulnerability disclosure, and how to report security issues.

## Security Model

When you open a notebook, marimo assumes you might not trust its contents until you explicitly choose to run it. Once you've run code, marimo treats the outputs as trusted since they came from your execution.

Like other notebooks, marimo allows arbitrary code execution when you run cells. This means that if you run code from untrusted sources, you could inadvertently execute malicious code. Therefore, it's important to only run notebooks from sources you trust or to review the code before executing it.

However, marimo implements several security measures to minimize risks when opening and editing notebooks.
Our blanket policy is that no user code is executed without explicit user action (either as javascript or python).

### Content sanitization

marimo sanitizes HTML and JavaScript in specific contexts to prevent malicious code from executing when you open untrusted notebooks.
All user content shown before execution is sanitized to remove all scripts (including markdown and custom HTML outputs).

After initial execution, outputs are trusted since they were generated by your code.
Being a responsible notebook user means running code from sources you trust, and/or reviewing code before executing it.

### Static loading

Although marimo notebook are just python files, opening a notebook through `marimo edit` does not execute it as a module.
marimo notebooks are statically loaded, meaning they are parsed but not executed as Python modules when opened.
This prevents arbitrary code execution at load time.
Code only runs when you explicitly execute cells.

### Run modes and trust

marimo behaves differently depending on how you run it:

**Edit mode** (`marimo edit`):

- Content is sanitized until you run your first cell or `auto_instantiate` is enabled (by default it is `disabled`)
- After you run code, subsequent outputs are trusted (you created them)
- Token authentication enabled by default for remote access

**Run mode** (`marimo run`):

- Notebooks run as web applications
- Content is treated as a trusted website (no sanitization)
- Token authentication can be configured via CLI flags or custom middleware

This distinction reflects the different threat models: editing is exploratory and may involve untrusted notebooks; deployed apps are intentional publications.

### Authentication

marimo provides token-based authentication:

- Enabled by default when running `marimo edit`
- Configurable in run mode via `--token` and `--token-password` flags
- Extensible through ASGI middleware for custom authentication schemes

See the [Authentication guide](guides/deploying/authentication.md) for more details.

### Added security measures on [https://molab.marimo.io](https://molab.marimo.io)

[molab](https://molab.marimo.io) takes a few other addition precautions.

- Auto-running cells is disabled on notebook load (you can disable this during your session)
- Custom head tags are disabled

These restrictions prevent code execution without explicit user consent.

## Security Advisories

marimo publishes security advisories for vulnerabilities that affect production deployments, particularly long-running applications.
We follow responsible disclosure practices and work with security researchers to address issues.

### CVE Policy

We issue CVEs and security advisories when:

- A vulnerability could affect long-running app deployments
- End-users are directly impacted
- The issue has security implications beyond normal bug fixes

For general safety improvements and hardening work, we document changes in our [release notes](https://github.com/marimo-team/marimo/releases) without issuing formal advisories.

## molab Security

[molab](guides/molab.md) is marimo's hosted notebook platform. For security issues affecting molab:

- We handle disclosure on a case-by-case basis
- General security improvements are disclosed publicly when applicable, and will be documented on this page.
- User-specific issues are handled privately through direct notification
- Reports can be submitted through the same channels: [GitHub advisories](https://github.com/marimo-team/marimo/security/advisories/new) or security [at] marimo [dot] io

## Reporting Vulnerabilities

We appreciate the security research community's efforts to improve marimo's security. If you discover a vulnerability:

**How to report:**

1. [Draft a security advisory on GitHub](https://github.com/marimo-team/marimo/security/advisories/new), or
2. Email the marimo team at security [at] marimo [dot] io

**What to expect:**

- We review all reports and respond to actionable issues
- Advisories affecting end-users are escalated to CVEs when appropriate
- We provide attribution for all reports (unless you prefer to remain anonymous)
- We have a small allocation for bug bounties; please inquire if interested.

**Recognition:**

We're grateful to [the security researchers](https://github.com/marimo-team/marimo/blob/main/SECURITY.md) who have responsibly disclosed vulnerabilities.
Your contributions help keep marimo safe for the entire community. We encourage responsible disclosure and recognize all security researchers who help improve marimo.

## Staying Up to Date

marimo ships new releases approximately once per week, and we provide immediate updates for major security disclosures. To ensure you have the latest security fixes, we recommend using `uv` to keep marimo up to date:

```bash
# Install or update to the latest version
uv pip install --upgrade marimo
```

Using `uv` ensures you benefit from the latest security improvements and patches as soon as they're available.

## Questions?

For security questions or concerns, please reach out to security [at] marimo [dot] io.
For general questions about marimo, see our [FAQ](faq.md) or join us on [Discord](https://marimo.io/discord).

### Previous Advisories

<details>
<summary>Click to expand previous security advisories</summary>

<ul>
  <li><strong><a href="https://github.com/marimo-team/marimo/security/advisories/GHSA-xjv7-6w92-42r7">[GHSA-xjv7-6w92-42r7]</a></strong>: Unauthenticated proxy vulnerability in matplotlib endpoint. The <code>/mpl/[port]/[route]</code> endpoint allowed external attackers to reach internal services. Affected versions 0.9.20 through 0.16.3. Fixed in 0.16.4. </li>

  <li><strong>[molab-0]</strong>: iframe sandbox escape via markdown render. In molab, an attacker could exploit a vulnerability in the iframe sandboxing to escape the iframe and execute code in the parent context. Fixed in molab deployment on 2025-10-19.</li>
</ul>

</details>
