/* Copyright 2026 Marimo. All rights reserved. */
import { memo } from "react";
import { renderHTML } from "../../../plugins/core/RenderHTML";
import { cn } from "../../../utils/cn";

interface Props {
  html: string;
  alwaysSanitizeHtml: boolean;
  inline?: boolean;
  className?: string;
}

export const HtmlOutput: React.FC<Props> = memo(
  ({ html, inline = false, className, alwaysSanitizeHtml }) => {
    if (!html) {
      return null;
    }

    return (
      <div className={cn(className, { "inline-flex": inline, block: !inline })}>
        {renderHTML({ html, alwaysSanitizeHtml })}
      </div>
    );
  },
);
HtmlOutput.displayName = "HtmlOutput";
