# Contributing to Awesome Ruby

Thanks for taking the time to contribute 🤝

The following is a set of guidelines for contributing to Awesome Ruby. These are just guidelines, not rules, use your best judgment and feel free to propose changes to this project.

## How Can I Contribute?

### Creating Issues

Do you know any cool Ruby project that isn't listed here? It isn't also on the [open issues](https://github.com/markets/awesome-ruby/issues) or [pull requests](https://github.com/markets/awesome-ruby/pulls)?
Please create a new issue or submit a pull request, we will be happy to receive it!

### Submitting Pull Requests

Feel free to take any open issue, just make sure that you follow the contribution guidelines.

### Voting and commenting

Just use GitHub reactions and comments to express your feelings/experience about open suggestions (additions or removals).

## Contribution Guidelines

* Please search previous suggestions before making a new one, as yours may be a duplicate.
* Use the following format: `[Library](url) - Description.`
* The link should be the name of the package or project.
* Links and categories should be sorted alphabetically.
* Add one link per pull-request.
* Keep descriptions concise, clear and simple, and end them with a period/stop.
* Check your spelling and grammar.
* New categories, or improvements to the existing ones are also welcome.
* Make sure your text editor is set to remove trailing whitespace.

## Quality standard

To stay on the list, projects should follow these quality standards:

* Generally used (at least **30k downloads**) and useful to the community.
* Actively maintained (even if that just means take care of open issues and/or keep compatibility with current Ruby versions).
* Stable.
* Documented.
* Tests.

Thanks to all [contributors](https://github.com/markets/awesome-ruby/graphs/contributors), you're awesome and wouldn't be possible without you!
