import { cn } from "@site/src/css/utils";

export const NetlifyLogo = ({
  className,
  ...rest
}: React.SVGProps<SVGSVGElement>) => (
  <svg
    xmlns="http://www.w3.org/2000/svg"
    viewBox="0 0 128 113"
    fill="currentColor"
    className={cn(className, "")}
    {...rest}
  >
    <g clipPath="url(#clip0_236_138)">
      <path
        d="M34.593 94.0509H33.3844L27.3514 88.0179V86.8094L36.5743 77.5866H42.9639L43.8158 78.4385V84.8281L34.593 94.0509Z"
        fill="currentColor"
      />
      <path
        d="M27.3514 25.816V24.6074L33.3844 18.5744H34.593L43.8158 27.7972V34.1868L42.9639 35.0388H36.5743L27.3514 25.816Z"
        fill="currentColor"
      />
      <path
        d="M80.4594 74.6047H71.6824L70.9493 73.8717V53.3259C70.9493 49.6705 69.5129 46.8372 65.1046 46.7382C62.836 46.6787 60.2405 46.7382 57.4668 46.8471L57.0507 47.2731V73.8618L56.3176 74.5948H47.5406L46.8075 73.8618V38.7636L47.5406 38.0305H67.2939C74.9713 38.0305 81.1925 44.2517 81.1925 51.9291V73.8717L80.4594 74.6047Z"
        fill="currentColor"
      />
      <path
        d="M35.8412 61.4491H0.73307L0 60.716V51.9192L0.73307 51.1861H35.8412L36.5743 51.9192V60.716L35.8412 61.4491Z"
        fill="currentColor"
      />
      <path
        d="M127.277 61.4491H92.1687L91.4356 60.716V51.9192L92.1687 51.1861H127.277L128.01 51.9192V60.716L127.277 61.4491Z"
        fill="currentColor"
      />
      <path
        d="M58.9428 27.0642V0.73307L59.6759 0H68.4727L69.2058 0.73307V27.0642L68.4727 27.7972H59.6759L58.9428 27.0642Z"
        fill="currentColor"
      />
      <path
        d="M58.9428 111.902V85.5711L59.6759 84.838H68.4727L69.2058 85.5711V111.902L68.4727 112.635H59.6759L58.9428 111.902Z"
        fill="currentColor"
      />
    </g>
    <defs>
      <clipPath id="clip0_236_138">
        <rect width="128" height="112.635" fill="white" />
      </clipPath>
    </defs>
  </svg>
);
