import { openai } from '@ai-sdk/openai';
import { Agent } from '@mastra/core/agent';
import { toolUsingNativeBindings, toolWithNativeBindingPackageDep } from '@inner/inner-tools';
import { lodashTool } from '@/tools/lodash';
import { calculatorTool } from '@/tools/calculator-tool';
import { helloWorldTool } from '@inner/hello-world';

export const innerAgent = new Agent({
  id: 'inner-agent',
  name: 'Inner Agent',
  instructions: 'You are a helpful assistant.',
  model: openai('gpt-4o'),
  tools: { helloWorldTool, lodashTool, toolUsingNativeBindings, toolWithNativeBindingPackageDep, calculatorTool },
});
