import { Mastra } from '@mastra/core/mastra';
import { LibSQLStore } from '@mastra/libsql';

import { dane, daneChangeLog, daneCommitMessage, daneIssueLabeler, daneLinkChecker } from './agents/index.js';
import { daneNewContributor } from './agents/new-contributor.js';
import { danePackagePublisher } from './agents/package-publisher.js';
import { changelogWorkflow } from './workflows/changelog.js';
import { githubFirstContributorMessage } from './workflows/first-contributor.js';
import { messageWorkflow, githubIssueLabeler, commitMessageGenerator } from './workflows/index.js';
import { linkCheckerWorkflow } from './workflows/link-checker.js';
import { packagePublisher } from './workflows/publish-packages.js';
import { telephoneGameWorkflow } from './workflows/telephone-game.js';

// @ts-ignore
export const mastra: Mastra = new Mastra({
  agents: {
    dane,
    danePackagePublisher,
    daneLinkChecker,
    daneIssueLabeler,
    daneCommitMessage,
    daneChangeLog,
    daneNewContributor,
  },
  storage: new LibSQLStore({
    id: 'dane-storage',
    url: ':memory:',
  }),
  workflows: {
    message: messageWorkflow,
    githubIssueLabeler: githubIssueLabeler,
    commitMessage: commitMessageGenerator,
    packagePublisher: packagePublisher,
    telephoneGame: telephoneGameWorkflow,
    changelog: changelogWorkflow,
    githubFirstContributorMessage: githubFirstContributorMessage,
    linkChecker: linkCheckerWorkflow,
  },
});
