import { processApifyServers } from './processors/apify';
import { processApiTrackerServers } from './processors/apitracker';
import { processDockerServers } from './processors/docker';
import { processFleurServers } from './processors/fleur';
import { processMcpRunServers } from './processors/mcprun';
import { processPulseMcpServers } from './processors/pulse';
import type { RegistryFile } from './types';

// Registry data with post-processing functions
export const registryData: RegistryFile = {
  registries: [
    {
      id: 'apitracker',
      name: 'API Tracker',
      description: 'Discover the best APIs and developer resources',
      url: 'https://apitracker.com/',
      servers_url: 'https://apitracker.io/api/mcp-servers',
      tags: ['verified'],
      postProcessServers: processApiTrackerServers,
    },
    {
      id: 'docker-mcp-catalog',
      name: 'Docker MCP Catalog',
      description: 'A collection of secure, high quality MCP servers as docker images',
      url: 'https://hub.docker.com/catalogs/mcp',
      servers_url: 'https://hub.docker.com/v2/repositories/mcp/',
      tags: ['verified'],
      count: 102,
      postProcessServers: processDockerServers,
    },
    {
      id: 'apify',
      name: 'Apify',
      description: 'A MCP marketplace enabling AI agents to use 5,000+ ready-made servers and Actors.',
      url: 'https://apify.com/store',
      servers_url: 'https://api.apify.com/v2/store',
      tags: ['verified'],
      count: '5000+',
      postProcessServers: processApifyServers,
    },
    {
      id: 'awesome-mcp-servers',
      name: 'Awesome MCP servers',
      description: 'A curated list of awesome Model Context Protocol (MCP) servers.',
      url: 'https://github.com/punkpeye/awesome-mcp-servers',
      tags: ['open-source'],
      count: 370,
    },
    {
      id: 'cline',
      name: 'Cline.bot',
      description: 'MCP servers for Cline.bot',
      url: 'https://cline.bot/mcp-marketplace',
      tags: ['verified'],
    },
    {
      id: 'cursor',
      name: 'Cursor MCP Registry',
      description: 'Browse MCPs or post a MCP to reach 250,000+ monthly active developers.',
      url: 'https://cursor.directory/mcp',
      tags: ['verified'],
      count: '1800+',
    },
    {
      id: 'fleur',
      name: 'Fleur',
      description: 'Fleur is the app store for Claude',
      url: 'https://www.fleurmcp.com/',
      servers_url: 'https://raw.githubusercontent.com/fleuristes/app-registry/refs/heads/main/apps.json',
      tags: ['verified'],
      postProcessServers: processFleurServers,
    },
    {
      id: 'glama',
      name: 'Glama MCP Server',
      description: 'Production-ready and experimental MCP servers that extend AI capabilities.',
      url: 'https://glama.ai/mcp/servers',
      tags: ['open-source'],
      count: 3457,
    },
    {
      id: 'gumloop',
      name: 'Gumloop',
      description: 'An exhaustive list of MCP servers.',
      url: 'https://www.gumloop.com/mcp',
      tags: ['open-source'],
      count: 20,
    },
    {
      id: 'klavisai',
      name: 'Klavis AI',
      description: 'Klavis AI is open source MCP integrations for AI Applications',
      url: 'https://github.com/Klavis-AI/klavis',
      tags: ['open-source'],
    },
    {
      id: 'make',
      name: 'Make MCP',
      description: 'Connect AI models to 1000+ apps with Make automation platform',
      url: 'https://developers.make.com/mcp-server',
      tags: ['verified'],
    },
    {
      id: 'composio',
      name: 'MCP Composio',
      description: 'Instantly Connect to 100+ Managed MCP Servers with Built-In Auth',
      url: 'https://mcp.composio.dev/',
      tags: ['verified'],
      count: '100+',
    },
    {
      id: 'mcpbar',
      name: 'MCP Bar',
      description: 'Open Registry & Package Manager for MCP Servers',
      url: 'https://www.mcp.bar/',
      tags: ['open-source'],
      count: 4429,
    },
    {
      id: 'mcpget',
      name: 'MCP-Get',
      description: 'mcp-get helps you easily install protocol servers.',
      url: 'https://mcp-get.com/',
      tags: ['open-source'],
      count: 69,
    },
    {
      id: 'mcpmarket',
      name: 'MCP Market',
      description: 'Explore our curated collection of MCP servers to connect AI to your favorite tools.',
      url: 'https://mcpmarket.com/',
      count: 12454,
    },
    {
      id: 'mcprepository',
      name: 'MCP Repository',
      description: 'Discover the ultimate resource for Model Context Protocol at MCP Repository',
      url: 'https://mcprepository.com',
      tags: ['verified'],
    },
    {
      id: 'mcpresolver',
      name: 'MCP Resolver',
      description: 'Find and connect to the right MCP servers for your AI applications',
      url: 'https://mcpresolver.com/',
      tags: ['verified'],
    },
    {
      id: 'mcprun',
      name: 'MCP Run',
      description: 'One platform for vertical AI across your entire organization.',
      url: 'https://www.mcp.run/',
      servers_url: 'https://www.mcp.run/api/servlets',
      tags: ['verified'],
      postProcessServers: processMcpRunServers,
    },
    {
      id: 'mcpserversorg',
      name: 'MCP Servers',
      description: 'A collection of servers for the Model Context Protocol.',
      url: 'https://mcpservers.org/',
      tags: ['open-source'],
      count: 212,
    },
    {
      id: 'mcpso',
      name: 'MCP.so',
      description: 'Find Awesome MCP Servers and Clients',
      url: 'https://mcp.so/',
      tags: ['verified'],
      count: 7682,
    },
    {
      id: 'mcpstore',
      name: 'MCP Store',
      description: 'Discover and use a variety of MCP servers for your AI applications',
      url: 'http://mcpstore.co/',
      tags: ['open-source'],
    },
    {
      id: 'modelcontextprotocol-servers',
      name: 'modelcontextprotocol/servers',
      description: 'This repository is a collection of reference implementations for the Model Context Protocol (MCP).',
      url: 'https://github.com/modelcontextprotocol/servers',
      tags: ['official'],
      count: 307,
    },
    {
      id: 'opentools',
      name: 'OpenTools',
      description: 'This registry documents the capabilities of 400+ tools across 160+ MCP servers.',
      url: 'https://opentools.com/registry',
      tags: ['verified'],
      count: 171,
    },
    {
      id: 'pipedream',
      name: 'Pipedream MCP',
      description: 'The AI developer toolkit for integrations',
      url: 'https://mcp.pipedream.com/',
      tags: ['verified'],
    },
    {
      id: 'pulse',
      name: 'Pulse MCP',
      description: 'Browse and discover MCP use cases, servers, clients, and news.',
      url: 'https://www.pulsemcp.com/',
      servers_url: 'https://api.pulsemcp.com/v0beta/servers',
      tags: ['verified'],
      count: 3653,
      postProcessServers: processPulseMcpServers,
    },
    {
      id: 'smithery',
      name: 'Smithery',
      description: 'Extend your agent with 4,274 capabilities via Model Context Protocol servers.',
      url: 'https://smithery.ai/',
      servers_url: 'https://registry.smithery.ai/servers',
      tags: ['verified'],
      count: 4274,
    },
    {
      id: 'supermachine',
      name: 'SuperMachine',
      description: 'AI-powered tools and MCP servers for developers and businesses',
      url: 'https://supermachine.ai/',
      tags: ['verified'],
    },
    {
      id: 'zapier',
      name: 'Zapier MCP',
      description: 'Connect your AI to any app with Zapier MCP',
      url: 'https://zapier.com/mcp',
      tags: ['verified'],
    },
  ],
};
