import { createTool } from '@mastra/core/tools';
import { Agent } from '@mastra/core/agent';
import { z } from 'zod';
import { weatherTool } from '../tools/weather';
import { MCPClient } from '@mastra/mcp';

const client = new MCPClient({
  id: 'weather-server',
  servers: {
    weather: {
      // Note: The MCP server ID gets slugified, so 'myMcpServer' becomes 'my-mcp-server'
      url: new URL(`http://localhost:4114/api/mcp/my-mcp-server/mcp`),
    },
  },
});

export const weatherAgent = new Agent({
  id: 'weather-agent',
  name: 'Weather Agent',
  instructions:
    'You are a weather agent. When asked about weather in any city, use the get_weather tool with the city name as the postal code. When asked for clipboard contents you also get that.',
  model: 'openai/gpt-4o',
  tools: async () => {
    const tools = await client.listTools();
    return {
      get_weather: weatherTool,
      clipboard: createTool({
        id: 'clipboard',
        description: 'Returns the contents of the users clipboard',
        inputSchema: z.object({}),
      }),
      ...tools,
    };
  },
});
