import React, { type ReactNode } from "react";
import clsx from "clsx";
import { useWindowSize } from "@docusaurus/theme-common";
import { useDoc } from "@docusaurus/plugin-content-docs/client";
import DocItemPaginator from "@theme/DocItem/Paginator";
import DocVersionBanner from "@theme/DocVersionBanner";
import DocVersionBadge from "@theme/DocVersionBadge";
import DocItemFooter from "@theme/DocItem/Footer";
import DocItemTOCMobile from "@theme/DocItem/TOC/Mobile";
import DocItemTOCDesktop from "@theme/DocItem/TOC/Desktop";
import DocItemContent from "@theme/DocItem/Content";
import DocBreadcrumbs from "@theme/DocBreadcrumbs";
import ContentVisibility from "@theme/ContentVisibility";
import type { Props } from "@theme/DocItem/Layout";

import styles from "./styles.module.css";
import SubscribeForm from "@site/src/components/subscribe-form";
import { FeedbackTrigger } from "@site/src/components/feedback-trigger";

/**
 * Decide if the toc should be rendered, on mobile or desktop viewports
 */
function useDocTOC() {
  const { frontMatter, toc } = useDoc();
  const windowSize = useWindowSize();

  const hidden = frontMatter.hide_table_of_contents;
  const canRender = !hidden && toc.length > 0;

  const mobile = canRender ? <DocItemTOCMobile /> : undefined;

  const desktop =
    canRender && (windowSize === "desktop" || windowSize === "ssr") ? (
      <DocItemTOCDesktop />
    ) : undefined;

  return {
    hidden,
    mobile,
    desktop,
  };
}

export default function DocItemLayout({ children }: Props): ReactNode {
  const docTOC = useDocTOC();
  const { metadata } = useDoc();
  return (
    <div id="doc-item-container" className="row @container">
      <div className={clsx("col", !docTOC.hidden && styles.docItemCol)}>
        <ContentVisibility metadata={metadata} />
        <DocVersionBanner />
        <div className={styles.docItemContainer}>
          <article>
            <DocBreadcrumbs />
            <DocVersionBadge />
            {docTOC.mobile}
            <DocItemContent>{children}</DocItemContent>
            {/* TODO: Fix display of prev/next, especially on mobile since the arrows are missing and the click targets are unclear. Add slight borders making it more obvious */}
            <DocItemFooter />
          </article>
          <DocItemPaginator />
        </div>
      </div>

      {docTOC.desktop ? (
        <div id="toc-column" className={clsx("col col--3")}>
          <div className="">{docTOC.desktop}</div>
        </div>
      ) : (
        <div id="toc-column" className={clsx("col col--3")}>
          {/* TODO: Do not hide on mobile, properly add feedback and newsletter form */}
          <div className="hidden xl:flex flex-col gap-4 px-1.5">
            <SubscribeForm />
            <FeedbackTrigger />
          </div>
        </div>
      )}
    </div>
  );
}
