import Link from "@docusaurus/Link";
import { GitHubIconLink } from "@site/src/components/github-icon-link";
import NavbarLayout from "@theme/Navbar/Layout";
import NavbarMobileSidebarToggle from "@theme/Navbar/MobileSidebar/Toggle";
import { type ReactNode } from "react";
import SearchContainer, { AskAI } from "./Search";
import { Logo } from "./logo";
import { TabSwitcher } from "./tab-switcher";

function NavbarContentDesktop() {
  return (
    <div className="flex px-4 border-b-[0.5px] h-(--ifm-navbar-height) border-(--border-subtle) mx-auto w-full items-center justify-between @container">
      <div className="flex gap-2 items-center">
        <Link href="/docs/v1">
          <Logo />
        </Link>
        <div className="hidden lg:block">
          <TabSwitcher />
        </div>
      </div>

      <div className="flex gap-2 items-center">
        <div className="flex items-center">
          <GitHubIconLink />
        </div>

        <div className="flex gap-2 items-center">
          <SearchContainer locale="en" />
          <div className="hidden lg:block">
            <AskAI />
          </div>
        </div>
        <NavbarMobileSidebarToggle />
      </div>
    </div>
  );
}

export default function Navbar(): ReactNode {
  return (
    <NavbarLayout>
      <NavbarContentDesktop />
    </NavbarLayout>
  );
}
