export function GitHubIcon(props: React.SVGProps<SVGSVGElement>) {
  return (
    <svg
      width="24"
      height="24"
      fill="currentColor"
      viewBox="3 3 18 18"
      {...props}
    >
      <title>GitHub</title>
      <path d="M12 3C7.0275 3 3 7.12937 3 12.2276C3 16.3109 5.57625 19.7597 9.15374 20.9824C9.60374 21.0631 9.77249 20.7863 9.77249 20.5441C9.77249 20.3249 9.76125 19.5982 9.76125 18.8254C7.5 19.2522 6.915 18.2602 6.735 17.7412C6.63375 17.4759 6.19499 16.6569 5.8125 16.4378C5.4975 16.2647 5.0475 15.838 5.80124 15.8264C6.51 15.8149 7.01625 16.4954 7.18499 16.7723C7.99499 18.1679 9.28875 17.7758 9.80625 17.5335C9.885 16.9337 10.1212 16.53 10.38 16.2993C8.3775 16.0687 6.285 15.2728 6.285 11.7432C6.285 10.7397 6.63375 9.9092 7.20749 9.26326C7.1175 9.03257 6.8025 8.08674 7.2975 6.81794C7.2975 6.81794 8.05125 6.57571 9.77249 7.76377C10.4925 7.55615 11.2575 7.45234 12.0225 7.45234C12.7875 7.45234 13.5525 7.55615 14.2725 7.76377C15.9937 6.56418 16.7475 6.81794 16.7475 6.81794C17.2424 8.08674 16.9275 9.03257 16.8375 9.26326C17.4113 9.9092 17.76 10.7281 17.76 11.7432C17.76 15.2843 15.6563 16.0687 13.6537 16.2993C13.98 16.5877 14.2613 17.1414 14.2613 18.0065C14.2613 19.2407 14.25 20.2326 14.25 20.5441C14.25 20.7863 14.4188 21.0746 14.8688 20.9824C16.6554 20.364 18.2079 19.1866 19.3078 17.6162C20.4077 16.0457 20.9995 14.1611 21 12.2276C21 7.12937 16.9725 3 12 3Z" />
    </svg>
  );
}

export function MastraLogo(props: React.SVGProps<SVGSVGElement>) {
  return (
    <svg
      width="119"
      height="36"
      viewBox="0 0 119 36"
      fill="none"
      xmlns="http://www.w3.org/2000/svg"
      {...props}
    >
      <circle
        cx="18.0002"
        cy="18.0002"
        r="15.2365"
        stroke="currentColor"
        strokeWidth="1.25409"
      />
      <ellipse
        cx="18.0008"
        cy="18"
        rx="15.2365"
        ry="10.2193"
        transform="rotate(45 18.0008 18)"
        stroke="currentColor"
        strokeWidth="1.25409"
      />
      <path
        d="M11.7793 18.0547H24.3007"
        stroke="currentColor"
        strokeWidth="1.25409"
      />
      <path
        d="M14.8574 21.2354L21.2192 14.8736"
        stroke="currentColor"
        strokeWidth="1.25409"
      />
      <path
        d="M21.2207 21.2354L14.8589 14.8736"
        stroke="currentColor"
        strokeWidth="1.25409"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M7.57571 11.2943C4.93105 13.0681 3.39081 15.4508 3.39081 17.9997C3.39081 20.5486 4.93105 22.9313 7.57571 24.7051C10.2163 26.4762 13.9001 27.592 18.0003 27.592C22.1004 27.592 25.7842 26.4762 28.4248 24.7051C31.0695 22.9313 32.6097 20.5486 32.6097 17.9997C32.6097 15.4508 31.0695 13.0681 28.4248 11.2943C25.7842 9.5232 22.1004 8.40741 18.0003 8.40741C13.9001 8.40741 10.2163 9.5232 7.57571 11.2943ZM6.87715 10.2528C9.75106 8.32521 13.6855 7.15332 18.0003 7.15332C22.315 7.15332 26.2495 8.32521 29.1234 10.2528C31.9932 12.1776 33.8638 14.9046 33.8638 17.9997C33.8638 21.0948 31.9932 23.8218 29.1234 25.7466C26.2495 27.6742 22.315 28.8461 18.0003 28.8461C13.6855 28.8461 9.75106 27.6742 6.87715 25.7466C4.00728 23.8218 2.13672 21.0948 2.13672 17.9997C2.13672 14.9046 4.00728 12.1776 6.87715 10.2528Z"
        fill="currentColor"
      />
      <path
        d="M46.56 11.56H48.48V14.152C49.128 12.208 50.616 11.272 52.488 11.272C54.408 11.272 56.136 12.304 56.808 14.488C57.432 12.328 59.136 11.272 61.128 11.272C63.624 11.272 65.76 13 65.76 16.72V25H63.84V16.72C63.84 14.488 62.808 12.976 60.624 12.976C58.224 12.976 57.12 14.776 57.12 17.2V25H55.2V16.72C55.2 14.488 54.168 12.976 51.984 12.976C49.584 12.976 48.48 14.776 48.48 17.2V25H46.56V11.56ZM68.2022 21.688C68.2022 19.936 69.3062 18.568 71.4422 17.896L76.1462 16.408C76.0742 13.936 74.9462 13 72.8342 13C71.7062 13 70.5542 13.264 68.8502 13.936V12.088C70.2902 11.608 71.7302 11.272 73.0742 11.272C76.4822 11.272 78.0662 13.432 78.0662 16.6V25H76.1462V22.936C75.4262 24.376 73.9622 25.288 72.1142 25.288C69.6662 25.288 68.2022 23.704 68.2022 21.688ZM70.1222 21.592C70.1222 22.768 71.0582 23.68 72.5222 23.68C74.3222 23.68 76.1462 22.336 76.1462 20.32V18.112L72.0422 19.408C70.6982 19.84 70.1222 20.656 70.1222 21.592ZM84.0589 25.288C83.0989 25.288 81.9949 25.096 80.6989 24.52V22.696C81.9469 23.296 83.0749 23.56 84.0589 23.56C85.8349 23.56 86.6269 22.648 86.6269 21.52C86.6269 20.248 85.6189 19.744 84.2029 19.072C82.4989 18.256 80.5309 17.416 80.5309 14.992C80.5309 12.784 82.1389 11.272 84.9949 11.272C85.9069 11.272 86.9629 11.416 88.1869 11.8V13.552C87.0109 13.216 85.9309 13 84.9949 13C83.2429 13 82.4509 13.888 82.4509 14.968C82.4509 16.144 83.4589 16.576 84.8509 17.248C86.5789 18.064 88.5469 18.976 88.5469 21.496C88.5469 23.752 86.9389 25.288 84.0589 25.288ZM96.1318 25.168C93.6118 25.168 92.3878 23.944 92.3878 21.52V13.288H90.3478V11.56H92.3878V8.728L94.3078 8.128V11.56H98.0278V13.288H94.3078V21.208C94.3078 23.08 94.8838 23.44 96.2518 23.44C96.8758 23.44 97.4998 23.368 98.0278 23.272V25C97.3558 25.096 96.7558 25.168 96.1318 25.168ZM100.419 11.56H102.339V14.752C103.011 12.64 104.811 11.416 107.139 11.416V13.336C106.971 13.312 106.827 13.312 106.659 13.312C104.163 13.312 102.339 14.92 102.339 18.16V25H100.419V11.56ZM108.21 21.688C108.21 19.936 109.314 18.568 111.45 17.896L116.154 16.408C116.082 13.936 114.954 13 112.842 13C111.714 13 110.562 13.264 108.858 13.936V12.088C110.298 11.608 111.738 11.272 113.082 11.272C116.49 11.272 118.074 13.432 118.074 16.6V25H116.154V22.936C115.434 24.376 113.97 25.288 112.122 25.288C109.674 25.288 108.21 23.704 108.21 21.688ZM110.13 21.592C110.13 22.768 111.066 23.68 112.53 23.68C114.33 23.68 116.154 22.336 116.154 20.32V18.112L112.05 19.408C110.706 19.84 110.13 20.656 110.13 21.592Z"
        fill="currentColor"
      />
    </svg>
  );
}
