// @ts-nocheck

import { Mastra } from "@mastra/core/mastra";
import { Agent } from '@mastra/core/agent';
import { createTool } from '@mastra/core/tools';
import { createWorkflow } from '@mastra/core/workflows';
import { createScorer } from '@mastra/core/evals';
import { MCPServer } from '@mastra/mcp';
import { z } from 'zod';

import { LibSQLStore, LibSQLVector } from '@mastra/libsql';
import { PostgresStore } from '@mastra/pg';
import { D1Store } from '@mastra/cloudflare-d1';
import { MongoDBStore } from '@mastra/mongodb';
import { DynamoDBStore } from '@mastra/dynamodb';

import { PgVector } from '@mastra/pg';
import { ChromaVector } from '@mastra/chroma';
import { PineconeVector } from '@mastra/pinecone';
import { QdrantVector } from '@mastra/qdrant';
import { LanceVector } from '@mastra/lance';

const libsqlStorage = new LibSQLStore({
  url: ':memory:',
});

const libsqlVector = new LibSQLVector({
  url: "file:../../mastra.db",
});

const postgresStorage = new PostgresStore({
  connectionString: process.env.DATABASE_URL!,
});

const d1Storage = new D1Store({
  accountId: process.env.CLOUDFLARE_ACCOUNT_ID!,
  apiToken: process.env.CLOUDFLARE_API_TOKEN!,
  databaseId: process.env.D1_DATABASE_ID!,
});

const mongodbStorage = new MongoDBStore({
  url: process.env.MONGODB_URI!,
  dbName: 'mastra',
});

const dynamodbStorage = new DynamoDBStore({
  name: 'DynamoDBStore',
  config: {
    region: 'us-east-1',
    tableName: 'mastra-table',
  },
});

const pgVector = new PgVector({
  connectionString: process.env.DATABASE_URL!,
});

const chromaVector = new ChromaVector({
  url: 'http://localhost:8000',
});

const pineconeVector = new PineconeVector({
  apiKey: process.env.PINECONE_API_KEY!,
});

const qdrantVector = new QdrantVector({
  url: process.env.QDRANT_URL!,
});

const lanceVector = new LanceVector({
  uri: './lancedb',
});

const agent = new Agent({
  name: 'Support Agent',
  instructions: 'Help users',
  model: 'openai/gpt-4',
});

export const agent2 = new Agent({
  name: 'Support Agent',
  instructions: 'Help users',
  model: 'openai/gpt-4',
});

const workflow = createWorkflow({
  execute: async ({ step }) => {
    return await step.run('process', async () => {
      return { done: true };
    });
  },
});

const tool = createTool({
  description: 'Get weather',
  inputSchema: z.object({
    city: z.string(),
  }),
  execute: async ({ context }) => {
    return { temp: 72 };
  },
});

const scorer = createScorer({
  name: 'Quality Scorer',
  description: 'Score quality',
  executor: async ({ input }) => {
    return { score: 0.95 };
  },
});

const mcpServer = new MCPServer({
  name: 'Weather MCP Server',
  version: '1.0.0',
  description: 'Provides weather tools',
  tools: {
    weather: tool,
  },
});

function getAgent() {
  return new Agent({
    name: 'Function Agent',
    instructions: 'Help users',
    model: 'openai/gpt-4',
  });
}

export default new Agent({
  name: 'Default Agent',
  instructions: 'Default agent',
  model: 'openai/gpt-4',
});

export default createTool({
  description: 'Default tool',
  inputSchema: z.object({}),
  execute: async () => ({}),
});

export const mastra = new Mastra({
  storage: new LibSQLStore({
    url: ":memory:",
  }),
});

// Edge case: Nested createTool (CallExpression) inside MCPServer
const mcpServerWithInlineTool = new MCPServer({
  name: 'Inline Tool Server',
  version: '1.0.0',
  tools: {
    inlineTool: createTool({
      description: 'Inline tool without id',
      inputSchema: z.object({}),
      execute: async () => ({}),
    }),
  },
});

// Edge case: Nested primitive WITH id already present (should NOT add comment)
export const mastraWithId = new Mastra({
  storage: new LibSQLStore({
    id: 'my-storage',
    url: ":memory:",
  }),
});

// Edge case: Multiple nested primitives in same Mastra config
export const mastraMultiple = new Mastra({
  storage: new PostgresStore({
    connectionString: process.env.DATABASE_URL!,
  }),
  vectors: {
    default: new PgVector({
      connectionString: process.env.DATABASE_URL!,
    }),
  },
});

// Edge case: Array of inline tools
const mcpServerWithToolArray = new MCPServer({
  name: 'Array Tool Server',
  version: '1.0.0',
  tools: [
    createTool({
      description: 'First tool',
      inputSchema: z.object({}),
      execute: async () => ({}),
    }),
    createTool({
      description: 'Second tool',
      inputSchema: z.object({}),
      execute: async () => ({}),
    }),
  ],
});
