import { ToolIconMap } from '@/domains/tools/components/ToolIcon';
import { MCPToolType } from '@mastra/core/mcp';
import { Txt } from '@/ds/components/Txt';
import { Icon } from '@/ds/icons';

export interface ToolInformationProps {
  toolDescription: string;
  toolId: string;
  toolType?: MCPToolType;
}

export const ToolInformation = ({ toolDescription, toolId, toolType }: ToolInformationProps) => {
  const ToolIconComponent = ToolIconMap[toolType || 'tool'];

  return (
    <div className="p-5 border-b border-border1">
      <div className="text-neutral6 flex gap-2">
        <div>
          <Icon size="lg" className="bg-surface4 rounded-md p-1">
            <ToolIconComponent />
          </Icon>
        </div>

        <div className="flex gap-4 justify-between w-full min-w-0">
          <div>
            <Txt variant="header-md" as="h2" className="font-medium truncate">
              {toolId}
            </Txt>
            <Txt variant="ui-sm" className="text-neutral3">
              {toolDescription}
            </Txt>
          </div>
        </div>
      </div>
    </div>
  );
};
