import { Handle, Position } from '@xyflow/react';
import type { NodeProps, Node } from '@xyflow/react';
import { useState } from 'react';

import { Txt } from '@/ds/components/Txt';
import { cn } from '@/lib/utils';

import { Collapsible, CollapsibleContent, CollapsibleTrigger } from '@/ds/components/Collapsible';
import { ChevronDown, Footprints } from 'lucide-react';
import { Badge } from '@/ds/components/Badge';
import { Icon } from '@/ds/icons';
import { BADGE_COLORS, BADGE_ICONS } from './workflow-node-badges';

export type AfterNode = Node<
  {
    steps: string[];
  },
  'after-node'
>;

export function WorkflowAfterNode({ data }: NodeProps<AfterNode>) {
  const { steps } = data;
  const [open, setOpen] = useState(true);

  return (
    <Collapsible
      open={open}
      onOpenChange={setOpen}
      className={cn('bg-surface4 rounded-md w-[274px] flex flex-col p-2 gap-2')}
    >
      <Handle type="target" position={Position.Top} style={{ visibility: 'hidden' }} />

      <CollapsibleTrigger className="flex items-center justify-between w-full">
        <Badge icon={<BADGE_ICONS.after className="text-current" style={{ color: BADGE_COLORS.after }} />}>AFTER</Badge>
        <Icon>
          <ChevronDown
            className={cn('transition-transform text-neutral3', {
              'transform rotate-180': open,
            })}
          />
        </Icon>
      </CollapsibleTrigger>
      <CollapsibleContent className="flex flex-col gap-2">
        {steps.map(step => (
          <div className="text-sm bg-surface5 flex items-center gap-1.5 rounded-sm  p-2" key={step}>
            <Footprints className="text-current w-4 h-4" />
            <Txt variant="ui-xs" className="text-neutral6 capitalize">
              {step}
            </Txt>
          </div>
        ))}
      </CollapsibleContent>
      <Handle type="source" position={Position.Bottom} style={{ visibility: 'hidden' }} />
    </Collapsible>
  );
}
