import { cn } from '@/lib/utils';
import React from 'react';

export type SectionHeadingProps = {
  headingLevel?: 'h2' | 'h3' | 'h4';
  children: React.ReactNode;
  className?: string;
};

export function SectionHeading({ headingLevel = 'h2', children, className }: SectionHeadingProps) {
  const HeadingTag = headingLevel;

  return (
    <HeadingTag
      className={cn(
        'flex items-center gap-2 text-ui-lg font-bold text-neutral4',
        '[&>svg]:w-[1.2em] [&>svg]:h-[1.2em] [&>svg]:opacity-50',
        className,
      )}
    >
      {children}
    </HeadingTag>
  );
}
