import { Select, SelectContent, SelectItem, SelectTrigger, SelectValue } from '@/ds/components/Select';
import { AutoFormFieldProps } from '@autoform/react';
import React from 'react';

export const SelectField: React.FC<AutoFormFieldProps> = ({ field, inputProps, error, id, value }) => {
  const { key, ...props } = inputProps;

  return (
    <Select
      {...props}
      value={value}
      onValueChange={value => {
        const syntheticEvent = {
          target: {
            value,
            name: inputProps.name,
          },
        } as React.ChangeEvent<HTMLInputElement>;
        props.onChange(syntheticEvent);
      }}
    >
      <SelectTrigger id={id} className={error ? 'border-accent2' : ''}>
        <SelectValue placeholder="Select an option" />
      </SelectTrigger>
      <SelectContent>
        {(field.options || []).map(([key, label]) => (
          <SelectItem key={key} value={key}>
            {label}
          </SelectItem>
        ))}
      </SelectContent>
    </Select>
  );
};
