import sys

from sphinx_gallery import gen_rst


def matplotlib_reduced_latex_scraper(block, block_vars, gallery_conf,
                                     **kwargs):
    """
    Reduce srcset when creating a PDF.

    Because sphinx-gallery runs *very* early, we cannot modify this even in the
    earliest builder-inited signal. Thus we do it at scraping time.
    """
    from sphinx_gallery.scrapers import matplotlib_scraper

    if gallery_conf['builder_name'] == 'latex':
        gallery_conf['image_srcset'] = []
    return matplotlib_scraper(block, block_vars, gallery_conf, **kwargs)


# Clear basic_units module to re-register with unit registry on import.
def clear_basic_units(gallery_conf, fname):
    return sys.modules.pop('basic_units', None)


# Monkey-patching gallery header to include search keywords
EXAMPLE_HEADER = """
.. DO NOT EDIT.
.. THIS FILE WAS AUTOMATICALLY GENERATED BY SPHINX-GALLERY.
.. TO MAKE CHANGES, EDIT THE SOURCE PYTHON FILE:
.. "{0}"
.. LINE NUMBERS ARE GIVEN BELOW.

.. only:: html

    .. meta::
        :keywords: codex

    .. note::
        :class: sphx-glr-download-link-note

        :ref:`Go to the end <sphx_glr_download_{1}>`
        to download the full example code{2}

.. rst-class:: sphx-glr-example-title

.. _sphx_glr_{1}:

"""


def patch_header(gallery_conf, fname):
    gen_rst.EXAMPLE_HEADER = EXAMPLE_HEADER
