# Awesome Swift
 
<!-- 

PLEASE DO NOT UPDATE THIS FILE, UPDATE CONTENTS.JSON INSTEAD. THANK YOU :-)

 -->



| Awesome | Linux | Projects | Updated |
|:-------:|:-----:|:--------:|:-------:|
| [![Awesome](https://cdn.rawgit.com/sindresorhus/awesome/d7305f38d29fed78fa85652e3a63e154dd8e8829/media/badge.svg)](https://github.com/sindresorhus/awesome) | :penguin: | 1080 | July 31, 2025 |

In parternship with:

[![Codemotion](https://github.com/matteocrippa/awesome-swift/blob/master/.github/images/codemotion_logo.png?raw=true)](https://codemo.tech/partners)



### Contents

- [Guides](#guides)
  - [Newsletter](#newsletter)
  - [Official Guides](#official-guides)
  - [Style Guides](#style-guides)
  - [Third party Guides](#third-party-guides)
- [Boilerplates](#boilerplates)
- [REPL](#repl)
- [Editor Support](#editor-support)
  - [Emacs](#emacs)
  - [Google Colaboratory](#google-colaboratory)
  - [Vim](#vim)
- [Benchmark](#benchmark)
- [Converters](#converters)
- [Other Awesome Lists](#other-awesome-lists)
- [Dependency Managers](#dependency-managers)
- [Patterns](#patterns)
- [Misc](#misc)
- [Libs](#libs)
  - [Accessibility](#accessibility)
  - [AI](#ai)
  - [Algorithm](#algorithm)
  - [Analytics](#analytics)
  - [Animation](#animation)
  - [API](#api)
  - [App Routing](#app-routing)
  - [App Store](#app-store)
  - [Audio](#audio)
  - [Augmented Reality](#augmented-reality)
  - [Authentication](#authentication)
  - [Bots](#bots)
  - [Cache](#cache)
  - [Chart](#chart)
  - [Chat](#chat)
  - [Colors](#colors)
  - [Command Line](#command-line)
  - [Concurrency](#concurrency)
  - [Currency](#currency)
  - [Data Management](#data-management)
    - [CBOR](#cbor)
    - [Core Data](#core-data)
    - [CSV](#csv)
    - [Firebase](#firebase)
    - [GraphQL](#graphql)
    - [JSON](#json)
    - [Key Value Store](#key-value-store)
    - [MongoDB](#mongodb)
    - [Multi Database](#multi-database)
    - [ORM](#orm)
    - [Other Data](#other-data)
    - [Realm](#realm)
    - [SQL drivers](#sql-drivers)
    - [SQLite](#sqlite)
    - [TOML](#toml)
    - [XML](#xml)
    - [YAML](#yaml)
    - [ZIP](#zip)
  - [Date](#date)
  - [Dependency Injection](#dependency-injection)
  - [Device](#device)
  - [Documentation](#documentation)
  - [Email](#email)
  - [Embedded Systems](#embedded-systems)
    - [Peripherals](#peripherals)
  - [Events](#events)
  - [Files](#files)
  - [Fonts](#fonts)
  - [Game Engine](#game-engine)
    - [2D](#game-engine-2d)
  - [Games](#games)
  - [Gesture](#gesture)
  - [Hardware](#hardware)
    - [3D Touch](#3d-touch)
    - [Bluetooth](#bluetooth)
    - [Camera](#camera)
      - [Barcode](#barcode)
    - [Haptic Feedback](#haptic-feedback)
    - [iBeacon](#ibeacon)
    - [Sensors](#sensors)
  - [Images](#images)
  - [Key Value Coding](#key-value-coding)
  - [Keyboard](#keyboard)
  - [Kit](#kit)
  - [Layout](#layout)
    - [Auto Layout](#auto-layout)
  - [Localization](#localization)
  - [Location](#location)
  - [Logging](#logging)
  - [Maps](#maps)
  - [Math](#math)
  - [Natural Language Processing](#natural-language-processing)
  - [Network](#network)
    - [HTML](#html)
    - [Messaging Protocol](#messaging-protocol)
    - [SOAP](#soap)
    - [Socket](#socket)
    - [Webserver](#webserver)
  - [OCR](#ocr)
  - [Optimization](#optimization)
  - [PDF](#pdf)
  - [Quality](#quality)
  - [Scripting](#scripting)
  - [SDK](#sdk)
  - [Security](#security)
    - [Cryptography](#cryptography)
    - [Keychain](#keychain)
  - [Streaming](#streaming)
  - [Styling](#styling)
  - [SVG](#svg)
  - [System](#system)
  - [Testing](#testing)
    - [Mock](#mock)
  - [Text](#text)
  - [Thread](#thread)
  - [UI](#ui)
    - [Alert](#alert)
    - [Blur](#blur)
    - [Button](#button)
    - [Calendar](#calendar)
    - [Cards](#cards)
    - [Form](#form)
    - [HUD](#hud)
    - [Label](#label)
    - [Menu](#menu)
    - [Pagination](#pagination)
    - [Payment](#payment)
    - [Permissions](#permissions)
    - [Scroll Bars](#scroll-bars)
    - [StackView](#stackview)
    - [Switch](#switch)
    - [Tab](#tab)
    - [Template](#template)
    - [TextField](#textfield)
    - [Transition](#transition)
    - [3D](#ui-3d)
    - [UICollectionView](#uicollectionview)
    - [UITableView](#uitableview)
    - [Walkthrough](#walkthrough)
  - [Utility](#utility)
  - [Validation](#validation)
    - [Phone Numbers](#phone-numbers)
  - [Version Manager](#version-manager)
  - [Video](#video)
- [Serverless](#serverless)

## Guides
*An awesome list of Swift related guides.* 

### Newsletter
[back to top](#readme) 

* [Open Source Updates for Swift Projects](https://ossp-updates.beehiiv.com/) - A bi-weekly newsletter to give you the latest updates on popular and unknown open source projects written or related to Swift.

### Official Guides
[back to top](#readme) 

* [API Design Guidelines](https://www.swift.org/documentation/api-design-guidelines/) - Official Swift API design guidelines.
* [Apple eBook](https://books.apple.com/us/book/the-swift-programming-language-swift-5-7/id881256329) - Official Apple eBook for Swift beginners.
* [Getting Started](https://www.swift.org/getting-started/) - Find information about the how to use the Swift programming language.
* [Introducing SwiftUI](https://developer.apple.com/tutorials/swiftui) - Official SwiftUI tutorial with 4+ hours of content and interactive tutorials.

### Style Guides
[back to top](#readme) 

* [Airbnb](https://github.com/airbnb/swift) - Airbnb's Official Style Guide.
* [Google](https://google.github.io/swift/) - This style guide is based on Apple’s excellent Swift standard library style and also incorporates feedback from usage across multiple Swift projects within Google.
* [LinkedIn](https://github.com/linkedin/swift-style-guide) - LinkedIn's Official Style Guide.
* [Raywenderlich](https://github.com/kodecocodes/swift-style-guide) - Raywenderlich guide, a must read.

### Third party Guides
[back to top](#readme) 

* [30 Days of Swift](https://github.com/allenwong/30DaysofSwift) - A cool 30 days tutorial.
* [About Swift](https://github.com/NicolaLancellotti/about-swift) - A playground about the Swift language.
* [Awesome Swift Education](https://github.com/hsavit1/Awesome-Swift-Education) - An organized list of essential Swift Language Topics.
* [Conferences.digital](https://github.com/zagahr/Conferences.digital) - Watch conference videos in a native macOS app.
* [Developing iOS Apps with Swift](https://podcasts.apple.com/us/podcast/developing-ios-11-apps-with-swift/id1315130780) - Stanford course by Paul Hegarty.
* [Hacking With Swift](https://www.hackingwithswift.com) - Complete training course that teaches app development through 30 hands-on projects, for free.
* [Ray Wenderlich Tutorials, Videos, Podcasts and books](https://www.kodeco.com) - High quality programming tutorials.
* [Swift & SwiftUI Tutorials](https://janeshswift.com) - SwiftUI learning with Ease.
* [Swift Education](https://github.com/swifteducation) - A community of educators sharing materials for teaching Swift and app development.
* [swift-tips](https://github.com/vincent-pradeilles/swift-tips) - A series of useful tips by Vincent Pradeilles.
* [SwiftDoc](https://swiftdoc.org/) - Auto-generated documentation.
* [SwiftGuide CN](https://github.com/ipader/SwiftGuide) - A Chinese written guide.
* [SwiftTips](https://github.com/JohnSundell/SwiftTips) - A collection of useful tips by John Sundell.

## Boilerplates

* [iOS project template](https://github.com/messeb/ios-project-template) - iOS project template with fastlane lanes, Travis CI jobs and GitHub integrations of Codecov, HoundCI for SwiftLint and Danger.
* [Model-View-Presenter template](https://github.com/onl1ner/ios-mvp-template) - A flexible and easy template created to speed up the development of your iOS application based on the MVP pattern.
* [Swift Module Template](https://github.com/fulldecent/swift6-module-template) - An opinionated starting point for awesome, reusable modules.

## REPL

* [Online Swift Playground](http://online.swiftplayground.run) - Online Swift Playground.
* [SwiftFiddle](https://swiftfiddle.com) - Playground for making, sharing, and embedding Swift code.

## Editor Support
*Support for your favorite editors.* 

### Emacs
[back to top](#readme) 

* [swift-mode](https://github.com/swift-emacs/swift-mode) - Emacs support, including partial flycheck error support.

### Google Colaboratory
[back to top](#readme) 

* [swift-colab](https://github.com/philipturner/swift-colab) - Run Swift in a browser.

### Vim
[back to top](#readme) 

* [swift-vim](https://github.com/keith/swift.vim) - Vim runtime files.
* [vim-polyglot](https://github.com/sheerun/vim-polyglot) - Language pack for vim that includes vim-swift.

## Benchmark

* [xcprofiler](https://github.com/giginet/xcprofiler) - Command line utility to profile compilation time.

## Converters

* [Swiftify](https://swiftify.com/#/converter/code/) - Objective-C to Swift online code converter and Xcode extension.
* [Zolang](https://github.com/Zolang/Zolang) :penguin: - A DSL for generating code in multiple programming languages.

## Other Awesome Lists
*Check out apps on these projects:* 
* [Awesome iOS Interview](https://github.com/dashvlas/awesome-ios-interview) - List of the questions that helps you to prepare for the interview.
* [awesome-macOS](https://github.com/iCHAIT/awesome-macOS) - A curated list of awesome applications, softwares, tools and shiny things for macOS.
* [example-ios-apps](https://github.com/jogendra/example-ios-apps) - An amazing list for people who are beginners and learning ios development and for ios developers who need any example app or feature.
* [open-source-ios-apps](https://github.com/dkhamsing/open-source-ios-apps) - A collaborative list of open-source iOS Apps.
* [open-source-mac-os-apps](https://github.com/serhii-londar/open-source-mac-os-apps) - Awesome list of open source applications for macOS.

## Dependency Managers
*Dependency manager software for Swift.* 
* [Accio](https://github.com/JamitLabs/Accio) - A SwiftPM based dependency manager for iOS & Co. with improvements over Carthage.
* [Carthage](https://github.com/Carthage/Carthage) - A new dependency manager.
* [CocoaPods](https://github.com/CocoaPods/CocoaPods) - The most used dependency manager.
* [Mint](https://github.com/yonaskolb/Mint) - A package manager that installs and runs Swift command line tools.
* [swift-package-manager](https://github.com/swiftlang/swift-package-manager) - SPM is the Package Manager for the Swift Programming Language.
* [Swiftly](https://github.com/swiftlang/swiftly) - Swift CLI toolchain installer to install different versions of Swift.

## Patterns

* [App Architecture](https://github.com/objcio/app-architecture) - A sample Code of the App Architecture Book.
* [CleanArchitectureRxSwift](https://github.com/sergdort/CleanArchitectureRxSwift) - Example of Clean Architecture of iOS app using RxSwift.
* [Design-Patterns-In-Swift](https://github.com/ochococo/Design-Patterns-In-Swift) - Design Patterns.
* [GoodReactor](https://github.com/GoodRequest/GoodReactor) - ⚛️ GoodReactor is a Redux-inspired Reactor framework for communication between the View Model, View Controller, and Coordinator.
* [Reactant](https://github.com/Brightify/Reactant) - Reactant is a reactive architecture for iOS.
* [ReduxUI](https://github.com/gre4ixin/ReduxUI) - Redux framework for easy use with SwiftUI.
* [SimplexArchitecture](https://github.com/Ryu0118/swiftui-simplex-architecture) - A Simple architecture that decouples state changes from SwiftUI's View
* [Spin](https://github.com/Spinners/Spin.Swift) - Provides a versatile Feedback Loop implementation working with RxSwift, ReactiveSwift and Combine.
* [StateViewController](https://github.com/davidask/StateViewController) - Stateful UIVIewController composition — the MVC cure for Massive View Controllers.
* [SwiftUI Atom Properties](https://github.com/ra1028/swiftui-atom-properties) - A Reactive Data-Binding and Dependency Injection Library for SwiftUI x Concurrency.
* [The Composable Architecture](https://github.com/pointfreeco/swift-composable-architecture) - A library for building applications in a consistent and understandable way, with composition, testing, and ergonomics in mind.
* [Viperit](https://github.com/ferranabello/Viperit) - Viper Framework for iOS.

## Misc
*Miscellaneous Swift related projects* 
* [Beak](https://github.com/yonaskolb/Beak) - A command line interface for your Swift scripts.
* [BetterCodable](https://github.com/marksands/BetterCodable) - Level up your `Codable` structs through property wrappers. The goal of these property wrappers is to avoid implementing a custom `init(from decoder: Decoder)` throws and suffer through boilerplate.
* [CodableWrappers](https://github.com/GottaGetSwifty/CodableWrappers) - A Collection of PropertyWrappers to make custom Serialization of Codable Types easy.
* [Forked](https://github.com/drewmccormack/Forked) - Generalized approach to managing shared data in Swift applications to support Local-first apps.
* [Fugen](https://github.com/almazrafi/Fugen) - A command line tool for exporting resources and generating code from your Figma files.
* [MemberwiseInit](https://github.com/gohanlon/swift-memberwise-init-macro) - `@MemberwiseInit` is a Swift Macro that can more often provide your intended `init`, while following the same safe-by-default semantics of Swift’s memberwise initializers.
* [Model2App](https://github.com/Q-Mobile/Model2App) - Turn your data model into a working CRUD app.
* [Surmagic](https://github.com/gurhub/surmagic) - Create XCFrameworks with ease! A Command Line Tool to create XCFramework for multiple platforms at one shot! iOS, Mac Catalyst, tvOS, macOS, and watchOS.
* [SwagGen](https://github.com/yonaskolb/SwagGen) :penguin: - A command line tool for generating a REST API from a Swagger spec based off Stencil templates.
* [Swiftbrew](https://github.com/swiftbrew/Swiftbrew) - Homebrew for Swift packages.
* [SwiftGen](https://github.com/SwiftGen/SwiftGen) - A suite of tools to auto-generate code for various assets of your project.
* [SwiftKit](https://github.com/SvenTiigi/SwiftKit) - Start your next Open-Source Swift Framework 📦.
* [SwiftPlate](https://github.com/JohnSundell/SwiftPlate) - Easily generate cross platform framework projects from the command line.
* [Toybox](https://github.com/giginet/Toybox) - Xcode Playground management made easy.
* [Tuist](https://github.com/tuist/tuist) - An open source command line tool to create, maintain and interact with your Xcode projects at scale.
* [xc](https://github.com/s2mr/xc) - A tool to open the Xcode project file by the specified version.
* [xcbeautify](https://github.com/cpisciotta/xcbeautify) - Little beautifier tool for xcodebuild.
* [XcodeGen](https://github.com/yonaskolb/XcodeGen) - Tool for generating Xcode projects from a YAML file and your project directory.
* [xcodeproj](https://github.com/tuist/xcodeproj) - A library to read, update and write Xcode projects and workspaces.

## Libs
*Here you can find a list of snippets and libs for your Swift projects.* 

### Accessibility
[back to top](#readme) 

* [Capable](https://github.com/chrs1885/Capable) - Keep track of accessibility settings, leverage high contrast colors, and use scalable fonts to enable users with disabilities to use your app.

### AI
*Libs for AI based projects (Machine Learning, Neural Networks etc).* [back to top](#readme) 

* [CoreML-Models](https://github.com/likedan/Awesome-CoreML-Models) - A collection of unique Core ML Models.
* [DL4S](https://github.com/palle-k/DL4S) - Automatic differentiation, fast tensor operations and dynamic neural networks from CNNs and RNNs to transformers.
* [OpenAI](https://github.com/MacPaw/OpenAI) - Swift package for OpenAI public API.

### Algorithm
[back to top](#readme) 

* [Algorithm](https://github.com/CosmicMind/Algorithm) - A toolset for writing algorithms and probability models.
* [BTree](https://github.com/attaswift/BTree) - Fast sorted collections for Swift using in-memory B-trees.
* [swift-algorithm-club](https://github.com/kodecocodes/swift-algorithm-club) - Algorithms and data structures, with explanations.
* [SwiftLCS](https://github.com/Frugghi/SwiftLCS) :penguin: - implementation of the longest common subsequence (LCS) algorithm.

### Analytics
*Analytics related libraries to easily track your app usage* [back to top](#readme) 

* [Aptabase](https://github.com/aptabase/aptabase) - Open Source, Privacy-First and Simple Analytics for Swift Apps.
* [Tracker Aggregator](https://github.com/kafejo/Tracker-Aggregator) - Versatile analytics abstraction layer.
* [Umbrella](https://github.com/devxoul/Umbrella) - Analytics abstraction layer.

### Animation
*Libs to help with animation* [back to top](#readme) 

* [Advance](https://github.com/timdonnelly/Advance) - A powerful animation framework for iOS, tvOS, and OS X.
* [AnimatedGradient](https://github.com/exyte/AnimatedGradient) - Animated linear gradient library written with SwiftUI
* [ChainPageCollectionView](https://github.com/jindulys/ChainPageCollectionView) - Fancy two-level collection view layout and animation.
* [CocoaSprings](https://github.com/MacPaw/CocoaSprings) - Interactive spring animations for iOS/macOS.
* [Comets](https://github.com/cruisediary/Comets) - Animating Particles.
* [Ease](https://github.com/roberthein/Ease) - Animate everything with Ease.
* [EasyAnimation](https://github.com/icanzilb/EasyAnimation) - A library to take the power of UIView.animateWithDuration(_:, animations:...) to a whole new level.
* [Elephant](https://github.com/s2mr/Elephant) - Elegant SVG animation kit.
* [FlightAnimator](https://github.com/AntonTheDev/FlightAnimator) - Natural Blocks Based Core Animation Framework.
* [Gemini](https://github.com/shoheiyokoyama/Gemini) - Gemini is rich scroll based animation framework.
* [IBAnimatable](https://github.com/IBAnimatable/IBAnimatable) - Design and prototype UI, interaction, navigation, transition and animation for App Store ready Apps in Interface Builder with IBAnimatable.
* [Interpolate](https://github.com/marmelroy/Interpolate) - Interpolation framework for creating interactive gesture-driven animations.
* [lottie-ios](https://github.com/airbnb/lottie-ios) - An iOS library to natively render After Effects vector animations.
* [Pastel](https://github.com/cruisediary/Pastel) - Gradient animation effect like Instagram.
* [Poi](https://github.com/HideakiTouhara/Poi) - Poi makes you use card UI like tinder UI .You can use it like tableview method.
* [Presentation](https://github.com/hyperoslo/Presentation) - A library to help you to make tutorials, release notes and animated pages.
* [Pulsator](https://github.com/shu223/pulsator) - Pulse animation for iOS.
* [Sica](https://github.com/cats-oss/Sica) - Simple Interface Core Animation. Run type-safe animation sequencially or parallelly.
* [Spring](https://github.com/MengTo/Spring) - A library to simplify iOS animations.
* [SpriteKitEasingSwift](https://github.com/craiggrummitt/SpriteKitEasingSwift) - Better Easing for SpriteKit.
* [spruce-ios](https://github.com/willowtreeapps/spruce-ios) - Choreograph animations on the screen.
* [Stellar](https://github.com/AugustRush/Stellar) - A Physical animation library.
* [TheAnimation](https://github.com/marty-suzuki/TheAnimation) - Type-safe CAAnimation wrapper. It makes preventing to set wrong type values.
* [ViewAnimator](https://github.com/marcosgriselli/ViewAnimator) - Brings your UI to life with just one line.
* [YapAnimator](https://github.com/yapstudios/YapAnimator) - Your fast and friendly physics-based animation system.

### API
*Quick libs to get access to third party API services* [back to top](#readme) 

* [GitHubAPI](https://github.com/serhii-londar/GithubAPI) - Implementation of GitHub REST API v3.
* [GitHubRestAPISwiftOpenAPI](https://github.com/Wei18/github-rest-api-swift-openapi) - Scheduled generated GitHub's REST API as Swift code from OpenAPI specification.
* [PXGoogleDirections](https://github.com/poulpix/PXGoogleDirections) - Google Directions API helper.
* [RandomUserSwift](https://github.com/dingwilson/RandomUserSwift) - Framework to Generate Random Users - An Unofficial SDK for randomuser.me.
* [reddift](https://github.com/sonsongithub/reddift) - reddit API wrapper.
* [Swifter Twitter](https://github.com/mattdonnelly/Swifter) - Twitter framework.
* [Swiftkube](https://github.com/swiftkube/client) :penguin: - Swift client for Kubernetes.
* [SwiftlySalesforce](https://github.com/mike4aday/SwiftlySalesforce) - Framework for rapid development of native iOS apps that integrate with Salesforce.
* [SwiftyInsta](https://github.com/TheM4hd1/SwiftyInsta) - Private and Tokenless Instagram RESTful API.

### App Routing
*Internal app routing systems.* [back to top](#readme) 

* [Appz](https://github.com/SwiftKitz/Appz) - Launch external apps and deeplink with ease.
* [Crossroad](https://github.com/giginet/Crossroad) - :oncoming_bus: Crossroad is an URL router focused on handling Custom URL Schemes.
* [LightRoute](https://github.com/SpectralDragon/LiteRoute) - Routing between VIPER modules.
* [Linker](https://github.com/MaksimKurpa/Linker) - Lightweight way to handle internal and external deeplinks for iOS.
* [MonarchRouter](https://github.com/nikans/MonarchRouter) - Declarative state- and URL-based router. Complex automatic View Controllers hierarchy transitions. Time-tested server-side conventions.
* [RxFlow](https://github.com/RxSwiftCommunity/RxFlow) - RxFlow is a navigation framework for iOS applications based on a Reactive Flow Coordinator pattern.
* [SwiftCurrent](https://github.com/wwt/SwiftCurrent) - Manage complex workflows wherever Swift can be built. It comes with built-in support for UIKit, Storyboards, and SwiftUI.
* [SwiftRouter](https://github.com/skyline75489/SwiftRouter) - A URL Router for iOS.
* [URLNavigator](https://github.com/devxoul/URLNavigator) - Elegant URL Routing.

### App Store
*Libs to help with apple app store, in app purchases and receipt validation.* [back to top](#readme) 

* [Apphud](https://github.com/apphud/ApphudSDK) - Lightweight library to easily handle auto-renewable subscriptions with no backend required.
* [AppReview](https://github.com/mezhevikin/AppReview) - A tiny library to request review on the AppStore via SKStoreReviewController.
* [InAppPurchase](https://github.com/jinSasaki/InAppPurchase) - A Simple, Lightweight and Safe framework for In App Purchase.
* [merchantkit](https://github.com/benjaminmayo/merchantkit) - A modern In-App Purchases management framework for iOS.
* [SwiftyStoreKit](https://github.com/bizz84/SwiftyStoreKit) - Lightweight In App Purchases framework.

### Audio
*Libs to work with audio* [back to top](#readme) 

* [AudioKit](https://github.com/audiokit/AudioKit) - Powerful audio synthesis, processing and analysis, without the steep learning curve.
* [AudioPlayer](https://github.com/delannoyk/AudioPlayer) - A wrapper around AVPlayer with some cool features.
* [AudioPlayerSwift](https://github.com/tbaranes/AudioPlayerSwift) - AudioPlayer is a simple class for playing audio (basic and advanced usage) in iOS, OS X and tvOS apps.
* [Beethoven](https://github.com/vadymmarkov/Beethoven) - An audio processing library for pitch detection of musical signals.
* [FDSoundActivatedRecorder](https://github.com/fulldecent/FDSoundActivatedRecorder) - Start recording when the user speaks.
* [FDWaveformView](https://github.com/fulldecent/FDWaveformView) - An easy way to display an audio waveform in your app.
* [FluidAudio](https://github.com/FluidInference/FluidAudio) - SDK for real-time speaker diarization and identification on iOS/macOS, with CoreML models converted directly from PyTorch to leverage Apple Neural Engine for better performance on older devices.
* [ModernAVPlayer](https://github.com/noreasonprojects/ModernAVPlayer) - Persistence AVPlayer to resume playback after bad network connection even in background mode.
* [MusicKit](https://github.com/0thernet/MusicKit) - A framework for composing and transforming music.
* [Soundable](https://github.com/lcardevnas/Soundable) - Soundable allows you to play sounds, single and in sequence, in a very easy way.
* [SwiftAudioPlayer](https://github.com/tanhakabir/SwiftAudioPlayer) - Simple audio player for iOS that streams and performs realtime audio manipulations with AVAudioEngine.
* [SwiftySound](https://github.com/adamcichy/SwiftySound) - Simple library that lets you play sounds with a single line of code.
* [voice-overlay-ios](https://github.com/algolia/voice-overlay-ios) - An overlay that gets your user’s voice permission and input as text in a customizable UI.

### Augmented Reality
[back to top](#readme) 

* [ARHeadsetKit](https://github.com/philipturner/ARHeadsetKit) - High-level framework for using $5 Google Cardboard to replicate Microsoft Hololens.
* [ARKit-CoreLocation](https://github.com/AndrewHartAR/ARKit-CoreLocation) - Combines the high accuracy of AR with the scale of GPS data.
* [ARKit-Navigation](https://github.com/chriswebb09/ARKitNavigationDemo) - Navigation in augmented reality with MapKit.
* [ARVideoKit](https://github.com/AFathi/ARVideoKit) - Capture & record ARKit videos, photos, Live Photos, and GIFs.

### Authentication
*Easy way to manage auth in your apps.* [back to top](#readme) 

* [Cely](https://github.com/cely-tools/Cely) - A Plug-n-Play login framework.
* [LinkedInSignIn](https://github.com/serhii-londar/LinkedInSignIn) - Simple view controller to log in and retrieve an access token from LinkedIn.
* [LoginKit](https://github.com/IcaliaLabs/LoginKit) - LoginKit is a quick and easy way to add a Login/Signup UX to your iOS app.
* [ReCaptcha](https://github.com/fjcaetano/ReCaptcha) - [In]visible ReCaptcha for iOS.
* [SpotifyLogin](https://github.com/spotify/SpotifyLogin) - Authenticate with the Spotify API.

### Bots
*Libs to build bot* [back to top](#readme) 

* [Telegram Bot SDK](https://github.com/rapierorg/telegram-bot-swift) :penguin: - Unofficial SDK.
* [Telegrammer](https://github.com/givip/Telegrammer) :penguin: - Open-source framework for Telegram Bots developers. It was built on top of Apple/SwiftNIO which help to demonstrate excellent performance.

### Cache
[back to top](#readme) 

* [AwesomeCache](https://github.com/aschuch/AwesomeCache) - Manage cache easy.
* [Cache](https://github.com/hyperoslo/Cache) - Nothing but Cache.
* [CachyKit](https://github.com/Sadmansamee/CachyKit) - A Caching Library that can cache JSON, Image, Zip or AnyObject with expiry date/TTYL and force refresh.
* [Cachyr](https://github.com/nrkno/yr-cachyr) - A small key-value data cache for iOS, macOS and tvOS.
* [Carlos](https://github.com/spring-media/Carlos) - A simple but flexible cache.
* [EVURLCache](https://github.com/evermeer/EVURLCache) - If you want to make your app still works when it's offline.
* [MemoryCache](https://github.com/yysskk/MemoryCache) - Type-safe memory cache.

### Chart
[back to top](#readme) 

* [Charts](https://github.com/ChartsOrg/Charts) - Beautiful charts for iOS/tvOS/OSX (port of MPAndroidChart).
* [ChartView](https://github.com/AppPear/ChartView) - Swift package for displaying beautiful charts effortlessly
* [FLCharts](https://github.com/francescoleoni98/FLCharts) - Easy to use and highly customizable charts library for iOS.
* [ScrollableGraphView](https://github.com/philackm/ScrollableGraphView) - Adaptive scrollable graph view for iOS to visualise simple discrete datasets.
* [SwiftChart](https://github.com/gpbl/SwiftChart) - A simple line and area charting library for iOS. Supports multiple series, partially filled series and touch events.
* [SwiftCharts](https://github.com/ivnsch/SwiftCharts) - Highly customizable charts for iOS.
* [SwiftUICharts](https://github.com/willdale/SwiftUICharts) - A charts / plotting library for SwiftUI. Works on macOS, iOS, watchOS, and tvOS and has accessibility and Localization features built in.
* [TKRadarChart](https://github.com/TBXark/TKRadarChart) - A customizable radar chart.

### Chat
*Libs to get access to build chat app* [back to top](#readme) 

* [Chatto](https://github.com/badoo/Chatto) - A lightweight framework to build chat applications.
* [ExyteChat](https://github.com/exyte/chat) - SwiftUI Chat UI framework with fully customizable message cells, input view, and a built-in media picker
* [InputBarAccessoryView](https://github.com/nathantannar4/InputBarAccessoryView) - A simple and easily customizable InputAccessoryView for making powerful input bars with autocomplete and attachments.
* [MessageKit](https://github.com/MessageKit/MessageKit) - A community-driven replacement for JSQMessagesViewController.
* [MessengerKit](https://github.com/steve228uk/MessengerKit) - A UI framework for building messenger interfaces.
* [Real-time Chat with Firebase](https://github.com/instamobile/messenger-iOS-chat-swift-firestore) - Functional real-time chat app with Firebase Firestore using MessageKit.

### Colors
*Interesting snippets related to color management and utility.* [back to top](#readme) 

* [ChromaColorPicker](https://github.com/joncardasis/ChromaColorPicker) - An intuitive and fun iOS color picker.
* [ColorKit](https://github.com/Boris-Em/ColorKit) - Advanced color manipulation for iOS.
* [DynamicColor](https://github.com/yannickl/DynamicColor) - An extension to manipulate colors easily.
* [Gradients](https://github.com/Gradients/Gradients) - A curated collection of splendid 180+ gradients.
* [Hue](https://github.com/zenangst/Hue) - Hue is the all-in-one coloring utility that you'll ever need.
* [PrettyColors](https://github.com/jdhealy/PrettyColors) - Styles and colors text in the Terminal with ANSI escape codes. Conforms to ECMA Standard 48.
* [SheetyColors](https://github.com/chrs1885/SheetyColors) - An action sheet styled color picker for iOS.
* [SwiftGen-Colors](https://github.com/SwiftGen/SwiftGen#uicolor) - A tool to auto-generate `enums` for your `UIColor` constants.
* [SwiftHEXColors](https://github.com/thii/SwiftHEXColors) - HEX color handling as an extension for UIColor.
* [UIColor-Hex-Swift](https://github.com/yeahdongcn/UIColor-Hex-Swift) - Hex to UIColor converter.
* [UIGradient](https://github.com/dqhieu/UIGradient) - A simple and powerful library for using gradient layer, image, color.

### Command Line
*Create command line applications.* [back to top](#readme) 

* [Ashen](https://github.com/colinta/Ashen) - A framework for writing terminal applications in Swift. Based on The Elm Architecture.
* [Commander](https://github.com/kylef/Commander) :penguin: - Compose beautiful command line interfaces.
* [Guaka](https://github.com/nsomar/Guaka) :penguin: - The smart and beautiful (POSIX compliant) command line framework.
* [LineNoise](https://github.com/andybest/linenoise-swift) :penguin: - A zero-dependency replacement for readline.
* [nef](https://github.com/bow-swift/nef) - A set of command line tools that lets you have compile time verification of your documentation written as Xcode Playground.
* [Progress.swift](https://github.com/jkandzi/Progress.swift) :penguin: - Add beautiful progress bars to your command line.
* [Swift Argument Parser](https://github.com/apple/swift-argument-parser) - Straightforward, type-safe argument parsing for Swift.
* [SwiftCLI](https://github.com/jakeheis/SwiftCLI) :penguin: - A powerful framework that can be used to develop a CLI.
* [Swiftline](https://github.com/nsomar/Swiftline) - A set of tools to help you create command line applications.
* [SwiftShell](https://github.com/kareman/SwiftShell) - A library for creating command-line applications and running shell commands.
* [SwiftyTextTable](https://github.com/scottrhoyt/SwiftyTextTable) :penguin: - A lightweight library to generate text tables.

### Concurrency
*Easier ways to work with concurrency.* [back to top](#readme) 

* [async+](https://github.com/async-plus/async-plus) :penguin: - A chainable interface for Swift 5.5's async/await.
* [AsyncNinja](https://github.com/AsyncNinja/AsyncNinja) - A complete set of concurrency and reactive programming primitives.
* [AsyncQueue](https://github.com/dfed/swift-async-queue) :penguin: - A library of queues that enable sending ordered tasks from synchronous to asynchronous contexts.
* [Futures](https://github.com/davidask/Futures) :penguin: - Lightweight promises for iOS, macOS, tvOS, watchOS, and server-side.
* [GroupWork](https://github.com/quanvo87/GroupWork) :penguin: - Easy concurrent, asynchronous tasks.
* [Hydra](https://github.com/malcommac/Hydra) - Promises & Await - Write better async code.
* [Queuer](https://github.com/FabrizioBrancati/Queuer) :penguin: - A queue manager, built on top of OperationQueue and Dispatch (aka GCD).
* [SwiftCoroutine](https://github.com/belozierov/SwiftCoroutine) :penguin: - Coroutines for iOS, macOS and Linux.
* [Throttler](https://github.com/boraseoksoon/Throttler) - Throttle massive number of asynchronous inputs in a single drop of one line API.
* [Venice](https://github.com/Zewo/Venice) :penguin: - Communicating sequential processes (CSP), Linux ready.

### Currency
[back to top](#readme) 


### Data Management
[back to top](#readme) 


#### CBOR
*Concise Binary Object Representation.* [back to top](#readme) 

* [CBORCoding](https://github.com/SomeRandomiOSDev/CBORCoding) :penguin: - Easy CBOR encoding and decoding for iOS, macOS, tvOS and watchOS.

#### Core Data
*No more pain with Core Data, here are some interesting libs to handle data management.* [back to top](#readme) 

* [AERecord](https://github.com/tadija/AERecord) - Super awesome Core Data wrapper library for iOS.
* [CloudCore](https://github.com/deeje/CloudCore/) - Robust CloudKit synchronization: offline editing, relationships, shared and public databases, and more.
* [CoreStore](https://github.com/JohnEstropia/CoreStore) - simple and elegant way to handle Core Data.
* [DataKernel](https://github.com/mrdekk/DataKernel) - DataKernel is a minimalistic wrapper around Core Data stack to ease persistence operations. No external dependencies.
* [Graph](https://github.com/CosmicMind/Graph) - An elegant data-driven framework for Core Data.
* [JSQCoreDataKit](https://github.com/jessesquires/JSQCoreDataKit) - A swifter Core Data stack.
* [JustPersist](https://github.com/justeat/JustPersist) - Easiest and safest way to do persistence on iOS with Core Data support out of the box.
* [QueryKit](https://github.com/QueryKit/QueryKit) - An easy way to play with Core Data filtering.
* [Skopelos](https://github.com/albertodebortoli/Skopelos) - A minimalistic, thread safe, non-boilerplate and super easy to use version of Active Record on Core Data.
* [SugarRecord](https://github.com/modo-studio/SugarRecord) - Helps with Core Data and Realm.

#### CSV
*Helpful libraries to parse from and serialize to comma-separated value representations.* [back to top](#readme) 

* [CodableCSV](https://github.com/dehesa/CodableCSV) :penguin: - Read and write CSV files row-by-row or through Swift's Codable interface.
* [CSVParser](https://github.com/Nero5023/CSVParser) :penguin: - Fast parser for CSV.

#### Firebase
[back to top](#readme) 

* [Ballcap](https://github.com/1amageek/Ballcap-iOS) - Ballcap is a database schema design framework for Cloud Firestore.

#### GraphQL
[back to top](#readme) 

* [SociableWeaver](https://github.com/NicholasBellucci/SociableWeaver) - Build declarative GraphQL queries and mutations.

#### JSON
*Struggling using json data? Here are some interesting ways to handle it.* [back to top](#readme) 

* [AlamofireObjectMapper](https://github.com/tristanhimmelman/AlamofireObjectMapper) - An Alamofire extension which converts JSON response data into objects using ObjectMapper.
* [Alembic](https://github.com/ra1028/Alembic) - Functional JSON parsing, mapping to objects, and serialize to JSON.
* [Argo](https://github.com/thoughtbot/Argo) - JSON parsing library.
* [Arrow](https://github.com/freshOS/Arrow) - Elegant JSON Parsing.
* [Decodable](https://github.com/Anviking/Decodable) :penguin: - JSON parsing.
* [Elevate](https://github.com/Nike-Inc/Elevate) - JSON parsing framework that makes parsing simple, reliable and composable.
* [EVReflection](https://github.com/evermeer/EVReflection) - Reflection based JSON encoding and decoding. Including support for NSDictionary, NSCoding, Printable, Hashable and Equatable.
* [HandyJSON](https://github.com/alibaba/handyjson) - A handy JSON-object serialization/deserialization library.
* [Himotoki](https://github.com/ikesyo/Himotoki) - A type-safe JSON decoding library.
* [JASON](https://github.com/delba/JASON) - JSON parsing with outstanding performances and convenient operators.
* [JSONHelper](https://github.com/isair/JSONHelper) - Lightning fast JSON deserialization and value conversion library for iOS & OS X.
* [JSONNeverDie](https://github.com/johnlui/JSONNeverDie) - Auto reflection tool from JSON to Model, user friendly JSON encoder / decoder, aims to never die.
* [ObjectMapper](https://github.com/tristanhimmelman/ObjectMapper) - JSON object mapper.
* [PMJSON](https://github.com/postmates/PMJSON) - JSON encoding/decoding library.
* [ReerCodable](https://github.com/reers/ReerCodable) - Codable extensions using Swift macro.
* [Sextant](https://github.com/KittyMac/Sextant) :penguin: - High performance JSONPath queries
* [SwiftyJSON](https://github.com/SwiftyJSON/SwiftyJSON) - A lib for JSON with error handling.
* [SwiftyJSONAccelerator](https://github.com/insanoid/SwiftyJSONAccelerator) - macOS app to generate Swift 5 models for JSON (with Codeable).

#### Key Value Store
[back to top](#readme) 

* [Default](https://github.com/Nirma/Default) - Modern interface to UserDefaults + Codable support.
* [Defaults](https://github.com/sindresorhus/Defaults) - Strongly-typed UserDefaults with support for Codable and key observation.
* [DefaultsKit](https://github.com/nmdias/DefaultsKit) - Simple, Strongly Typed UserDefaults for iOS, macOS and tvOS.
* [Prephirences](https://github.com/phimage/Prephirences) - Manage application preferences, NSUserDefaults, iCloud, Keychain and more.
* [SecureDefaults](https://github.com/vpeschenkov/SecureDefaults) - A lightweight wrapper over UserDefaults & NSUserDefaults with an extra AES-256 encryption layer.
* [Storez](https://github.com/SwiftKitz/Storez) - Safe, statically-typed, store-agnostic key-value storage.
* [SwiftStore](https://github.com/hemantasapkota/SwiftStore) - A Key-Value store backed by LevelDB.
* [SwiftyUserDefaults](https://github.com/sunshinejr/SwiftyUserDefaults) - Cleaner, nicer syntax for NSUserDefaults.
* [Zephyr](https://github.com/ArtSabintsev/Zephyr) - Effortlessly synchronize NSUserDefaults over iCloud.

#### MongoDB
[back to top](#readme) 

* [MongoKitten](https://github.com/orlandos-nl/MongoKitten) :penguin: - MongoDB Connector.
* [Perfect-MongoDB](https://github.com/PerfectlySoft/Perfect-MongoDB) :penguin: - A stand-alone wrapper around the mongo-c client library, enabling access to MongoDB servers.

#### Multi Database
*Data management layers that involve multiple sources.* [back to top](#readme) 

* [ModelAssistant](https://github.com/ssamadgh/ModelAssistant) - Elegant library to manage the interactions between view and model.
* [PersistenceKit](https://github.com/Teknasyon-Teknoloji/PersistenceKit) - Store and retrieve Codable objects to various persistence layers, in a couple lines of code!
* [Shallows](https://github.com/dreymonde/Shallows) - Your lightweight persistence toolbox.

#### ORM
[back to top](#readme) 

* [fluent](https://github.com/vapor/fluent) :penguin: - Simple ActiveRecord implementation.
* [Perfect-CRUD](https://github.com/PerfectlySoft/Perfect-CRUD) :penguin: - CRUD is an object-relational mapping (ORM) system using Codable protocol.

#### Other Data
*Other ways to persist data* [back to top](#readme) 

* [CacheAdvance](https://github.com/dfed/CacheAdvance) - A performant cache for logging systems. CacheAdvance persists log events 30x faster than SQLite.
* [CoreXLSX](https://github.com/CoreOffice/CoreXLSX) - Excel spreadsheet (XLSX) format support.
* [Disk](https://github.com/saoudrizwan/Disk) - Delightful framework for iOS to easily persist structs, images, and data.
* [EVCloudKitDao](https://github.com/evermeer/EVCloudKitDao) - Simplified access to CloudKit with support for subscriptions and local caching.
* [KeyPathKit](https://github.com/vincent-pradeilles/KeyPathKit) - KeyPathKit provides a seamless syntax to manipulate data using typed keypaths.
* [LeetCode-Swift](https://github.com/soapyigu/LeetCode-Swift) - Solutions to LeetCode interview questions.
* [Pencil](https://github.com/naru-jpn/pencil) - Write any value to file.
* [StorageManager](https://github.com/iAmrSalman/StorageManager) - Safe and easy way to use FileManager as Database.

#### Realm
[back to top](#readme) 

* [Realm](https://github.com/realm/realm-swift) - Realm is a mobile database: a replacement for Core Data & SQLite.
* [RealmWrapper](https://github.com/k-lpmg/RealmWrapper) - Safe and easy wrappers for RealmSwift.
* [Unrealm](https://github.com/matghazaryan/Unrealm) - Unrealm enables you to easily store Swift native Classes, Structs and Enums into Realm.

#### SQL drivers
[back to top](#readme) 

* [MySQL Swift](https://github.com/novi/mysql-swift) :penguin: - MySQL client library.
* [Perfect-MySQL](https://github.com/PerfectlySoft/Perfect-MySQL) :penguin: - A stand-alone wrapper around the MySQL client library, enabling access to MySQL servers.
* [Perfect-PostgreSQL](https://github.com/PerfectlySoft/Perfect-PostgreSQL) :penguin: - A stand-alone wrapper around the libpq client library, enabling access to PostgreSQL servers.

#### SQLite
*Are you interested in storing your app data using SQLite? Here are some interesting resources.* [back to top](#readme) 

* [GRDB.swift](https://github.com/groue/GRDB.swift) - A versatile SQLite toolkit.
* [SQLite.swift](https://github.com/stephencelis/SQLite.swift) - Framework wrapping SQLite3. Small. Simple. Safe.
* [SQLiteDB](https://github.com/FahimF/SQLiteDB) - SQLite wrapper.

#### TOML
*Tom's Obvious, Minimal Language.* [back to top](#readme) 

* [TOMLDecoder](https://github.com/dduan/TOMLDecoder) - Latest TOML standard, decoded.

#### XML
*If you prefer to manage XML data formatted entries, here are some helpful libs* [back to top](#readme) 

* [AEXML](https://github.com/tadija/AEXML) - xml wrapper.
* [CheatyXML](https://github.com/lobodart/CheatyXML) - A powerful framework designed to manage XML easily.
* [SwiftyXML](https://github.com/chenyunguiMilook/SwiftyXML) - The most swifty way to deal with XML.
* [SWXMLHash](https://github.com/drmohundro/SWXMLHash) - Simple XML parsing.
* [XMLCoder](https://github.com/CoreOffice/XMLCoder) - XMLEncoder & XMLDecoder based on Codable protocols from the standard library.
* [XMLMapper](https://github.com/gcharita/XMLMapper) - A simple way to map XML to Objects.

#### YAML
[back to top](#readme) 

* [YamlSwift](https://github.com/behrang/YamlSwift) - Load YAML and JSON documents.
* [Yams](https://github.com/jpsim/Yams) :penguin: - Sweet YAML parser.

#### ZIP
[back to top](#readme) 

* [Zip](https://github.com/marmelroy/Zip) - Framework for zipping and unzipping files.
* [Zip Foundation](https://github.com/weichsel/ZIPFoundation) - A library to create, read and modify ZIP archive files.

### Date
*Handle date formatting easily.* [back to top](#readme) 

* [AnyDate](https://github.com/Kawoou/AnyDate) - Date & Time API inspired from Java 8 DateTime API.
* [Chronology](https://github.com/davedelong/time) - Building a better date/time library.
* [DateHelper](https://github.com/melvitax/DateHelper) - Simple date helper.
* [Datez](https://github.com/SwiftKitz/Datez) - Library for dealing with `NSDate`, `NSCalendar`, `NSDateComponents`, and `NSTimeInterval`.
* [Datify](https://github.com/hemangshah/Datify) - Easypeasy date functions.
* [NVDate](https://github.com/novalagung/nvdate) - Date extension library.
* [SwiftDate](https://github.com/malcommac/SwiftDate) - Easy NSDate Management.
* [Time](https://github.com/dreymonde/Time) - Type-safe time calculations, powered by generics.
* [Timepiece](https://github.com/naoty/Timepiece) - Intuitive NSDate extensions.
* [TrueTime.swift](https://github.com/instacart/TrueTime.swift) - Get the true current time impervious to device clock time changes (NTP library).
* [TypedDate](https://github.com/Ryu0118/swift-typed-date) - Enhancing Date handling by enabling type-level customization of date components

### Dependency Injection
*Dependency injection libs* [back to top](#readme) 

* [Cleanse](https://github.com/square/Cleanse) - A Lightweight Dependency Injection Framework by Square.
* [Corridor](https://github.com/symentis/Corridor) - A Coreader-like Dependency Injection μFramework.
* [Deli](https://github.com/kawoou/Deli) - Deli is an easy-to-use Dependency Injection(DI).
* [DIKit](https://github.com/Liftric/DIKit) - Dependency Injection Framework for Swift, inspired by KOIN.
* [Dip](https://github.com/AliSoftware/Dip) - A simple Dependency Injection Container.
* [DITranquillity](https://github.com/ivlevAstef/DITranquillity/) - Dependency injection framework with tranquility.
* [Locatable](https://github.com/vincent-pradeilles/locatable) - A micro-framework that leverages Property Wrappers to implement the Service Locator pattern.
* [Pure](https://github.com/devxoul/Pure) - A way to do a dependency injection without a DI container.
* [SafeDI](https://github.com/dfed/safedi) - Compile-time safe dependency injection.
* [Swinject](https://github.com/Swinject/Swinject) - A dependency injection framework.
* [Typhoon](https://github.com/appsquickly/Typhoon) - Dependency injection toolkit.
* [Weaver](https://github.com/scribd/Weaver) - A declarative, easy-to-use and safe Dependency Injection framework.

### Device
*A collection of libs to recognize your device.* [back to top](#readme) 

* [Device](https://github.com/Ekhoo/Device) - Light weight tool for detecting the current device and screen size.
* [Device.swift](https://github.com/schickling/Device.swift) - Super-lightweight library to detect used device.
* [DeviceKit](https://github.com/devicekit/DeviceKit) - DeviceKit is a value-type replacement of UIDevice.
* [Deviice](https://github.com/andrealufino/Deviice) - Swift library to easily check the current device and some more info about it.
* [Luminous](https://github.com/andrealufino/Luminous) - Get everything you need to know about the device.
* [Thingy](https://github.com/bojan/Thingy) - A modern device detection and querying library.
* [UIDeviceComplete](https://github.com/Nirma/UIDeviceComplete) - UIDevice extensions that fill in the missing pieces.

### Documentation
*Generate documentation for Swift code* [back to top](#readme) 

* [jazzy](https://github.com/realm/jazzy/) - Soulful docs.
* [SourceDocs](https://github.com/SourceDocs/SourceDocs) - Generate Markdown reference documentation that lives with your code.

### Email
[back to top](#readme) 


### Embedded Systems
*Build your embedded Linux projects on a RaspberryPi, BeagleBone, C.H.I.P. and other boards.* [back to top](#readme) 

* [SwiftyGPIO](https://github.com/uraimo/SwiftyGPIO) :penguin: - Interact with Linux GPIO/SPI/PWM on ARM.

#### Peripherals
*Interact with specific external peripherals.* [back to top](#readme) 


### Events
*Alternatives to NSNotificationCenter, Key-Value-Observation, or delegation.* [back to top](#readme) 

* [Bond](https://github.com/DeclarativeHub/Bond) - Binding framework.
* [Combinative](https://github.com/noppefoxwolf/Combinative) - UI event handling using Apple's combine framework.
* [EmitterKit](https://github.com/aleclarson/emitter-kit) - Implementation of event emitters and listeners.
* [FutureKit](https://github.com/FutureKit/FutureKit) - Future/Promises Library.
* [Katana](https://github.com/BendingSpoons/katana-swift) - Write apps a la React and Redux.
* [LightweightObservable](https://github.com/fxm90/LightweightObservable) - A lightweight implementation of an observable sequence that you can subscribe to.
* [NoticeObserveKit](https://github.com/marty-suzuki/NoticeObserveKit) - NoticeObserveKit is type-safe NotificationCenter wrapper that associates notice type with info type.
* [Notificationz](https://github.com/SwiftKitz/Notificationz) - Helping you own `NSNotificationCenter` by providing a simple, customizable adapter.
* [Observable](https://github.com/roberthein/Observable) - The easiest way to observe values.
* [OneWay](https://github.com/DevYeom/OneWay) - State management with unidirectional data flow.
* [OpenCombine](https://github.com/OpenCombine/OpenCombine) - Open source implementation of Apple's Combine framework for processing values over time.
* [PMKVObserver](https://github.com/postmates/PMKVObserver/) - Modern thread-safe and type-safe key-value observing.
* [PromiseKit](https://github.com/mxcl/PromiseKit) - Async promise programming lib.
* [ReactiveCocoa](https://github.com/ReactiveCocoa/ReactiveCocoa) - ReactiveCocoa (RAC) is a Cocoa framework inspired by Functional Reactive Programming. It provides APIs for composing and transforming streams of values over time.
* [ReactorKit](https://github.com/ReactorKit/ReactorKit) - A framework for reactive and unidirectional application architecture.
* [ReSwift](https://github.com/ReSwift/ReSwift) - Unidirectional Data Flow.
* [RxSwift](https://github.com/ReactiveX/RxSwift) - Microsoft Reactive Extensions (Rx).
* [Signals](https://github.com/artman/Signals) - Replaces delegates and notifications.
* [SwiftEventBus](https://github.com/cesarferreira/SwiftEventBus) - A publish/subscribe event bus optimized for iOS.
* [Tempura](https://github.com/BendingSpoons/tempura-swift) - A holistic approach to iOS development, inspired by Redux and MVVM.
* [Tokamak](https://github.com/TokamakUI/Tokamak) - React-like declarative API for building native UI components with easy to use one-way data binding.
* [Tomorrowland](https://github.com/lilyball/Tomorrowland) - Lightweight Promises.
* [TopicEventBus](https://github.com/mcmatan/topicEventBus) - Publish–subscribe design pattern implementation framework, with ability to publish events by topic.
* [VueFlux](https://github.com/ra1028/VueFlux) - Unidirectional Data Flow State Management Architecture - Inspired by Vuex and Flux.
* [When](https://github.com/vadymmarkov/When) - A lightweight implementation of Promises.

### Files
[back to top](#readme) 

* [ExtendedAttributes](https://github.com/sindresorhus/ExtendedAttributes) - Manage extended attributes for files and folders.
* [FileKit](https://github.com/nvzqz/FileKit) - Simple and expressive file management.
* [FileProvider](https://github.com/amosavian/FileProvider) - FileManager replacement for Local, iCloud and Remote (WebDAV/FTP/Dropbox/OneDrive/SMB2) files for iOS/tvOS and macOS.
* [KZFileWatchers](https://github.com/krzysztofzablocki/KZFileWatchers) - A micro-framework for observing file changes, both local and remote.
* [PathKit](https://github.com/kylef/PathKit) :penguin: - Effortless path operations.
* [Pathos](https://github.com/dduan/Pathos) :penguin: - Efficient Unix file management.

### Fonts
*A collection of font related snippets.* [back to top](#readme) 

* [FontAwesome.swift](https://github.com/thii/FontAwesome.swift) - Use FontAwesome in your projects.
* [FontBlaster](https://github.com/ArtSabintsev/FontBlaster) - Programmatically load custom fonts into your iOS app.
* [Inkwell](https://github.com/ninjaprox/Inkwell) - An inkwell to use custom fonts on the fly.
* [IoniconsKit](https://github.com/keitaoouchi/IoniconsKit) - Use ionicons as UIImage / UIFont in your projects.
* [OcticonsKit](https://github.com/keitaoouchi/OcticonsKit) - Use Octicons as UIImage / UIFont in your projects.
* [SwiftIconFont](https://github.com/segecey/SwiftIconFont) - Fontawesome, Iconic, Ionicons, Octicon ports.
* [SwiftIcons](https://github.com/ranesr/SwiftIcons) - Library for Font Icons: dripicons, emoji, font awesome, icofont, ionicons, linear icons, map icons, material icons, open iconic, state, weather.
* [SwiftUI-FontIcon](https://github.com/huybuidac/SwiftUIFontIcon) - Font icons for SwiftUI: font awesome, ionicons, material icons.
* [SYSymbol](https://github.com/Nirma/SFSymbol) - All the SFSymbols at your fingertips.
* [UIFontComplete](https://github.com/Nirma/UIFontComplete) - Font management (System & Custom) for iOS and tvOS.

### Game Engine
[back to top](#readme) 

* [glide engine](https://github.com/cocoatoucher/Glide) - SpriteKit and GameplayKit based engine for making 2d games, with practical examples and tutorials.
* [Raylib for Swift](https://github.com/STREGAsGate/Raylib) :penguin: - A Cross-Platform Swift package for Raylib. Builds Raylib from source so no need to fiddle with libraries. Just add as a dependency in you game package and go!
* [SwiftGodot](https://migueldeicaza.github.io/SwiftGodotDocs/tutorials/swiftgodot-tutorials/) - Swift bindings for the Godot game engine to build extensions or act as an api with SwiftGodotKit.

#### 2D
[back to top](#readme) 

* [ImagineEngine](https://github.com/JohnSundell/ImagineEngine) - Blazing fasst 2D gaming engine.

### Games
[back to top](#readme) 

* [FDChessboardView](https://github.com/fulldecent/FDChessboardView) - A view controller for chess boards
* [Sage](https://github.com/nvzqz/Sage) :penguin: - A cross-platform chess library.

### Gesture
[back to top](#readme) 

* [ShowTime](https://github.com/KaneCheshire/ShowTime) - Show off your iOS taps and gestures for demos and videos with just one line of code.
* [SwiftyGestureRecognition](https://github.com/b3ll/SwiftyGestureRecognition) - UIGestureRecognizers in Xcode Playgrounds.
* [SwipyCell](https://github.com/moritzsternemann/SwipyCell) - UITableViewCell implementing swiping to trigger actions (known from the Mailbox App).
* [Tactile](https://github.com/delba/Tactile) - A safer and more idiomatic way to respond to gestures and control events.

### Hardware
*A category dedicated to hardware related libs* [back to top](#readme) 


#### 3D Touch
*Easy handle new 3D Touch / Force Touch feature thanks to these libs.* [back to top](#readme) 


#### Bluetooth
*Wrappers around CoreBluetooth* [back to top](#readme) 

* [BlueCap](https://github.com/troystribling/BlueCap) - Wrapper around CoreBluetooth and much more.
* [Bluejay](https://github.com/steamclock/bluejay) - A simple framework for building reliable Bluetooth LE apps.
* [BluetoothKit](https://github.com/rhummelmose/BluetoothKit) - Easily communicate between iOS/OSX devices using BLE.
* [RxBluetoothKit](https://github.com/polidea/RxBluetoothKit) - iOS & OSX Bluetooth library for RxSwift.
* [SwiftyBluetooth](https://github.com/jordanebelanger/SwiftyBluetooth) - Simple and reliable closure based wrapper around CoreBluetooth.

#### Camera
*Awesome camera libs* [back to top](#readme) 

* [CameraBackground](https://github.com/yonat/CameraBackground) - Show camera layer as a background to any UIView.
* [CameraKit-iOS](https://github.com/CameraKit/camerakit-ios) - Massively increase camera performance and ease of use in your next project.
* [FDTake](https://github.com/fulldecent/FDTake) - Easily take a photo or video or choose from library.
* [Fusuma](https://github.com/ytakzk/Fusuma) - Instagram-like photo browser and a camera feature.
* [MediaPicker](https://github.com/exyte/mediapicker) - SwiftUI customizable media picker - supports camera and gallery with albums
* [MijickCamera](https://github.com/Mijick/Camera) - Camera made simple. Fully customizable camera library that significantly reduces implementation time and effort.
* [NextLevel](https://github.com/NextLevel/NextLevel) - Rad Media Capture.

##### Barcode
*Barcode, QR-code, other code readers* [back to top](#readme) 

* [BarcodeScanner](https://github.com/hyperoslo/BarcodeScanner) - A simple and beautiful barcode scanner view controller.
* [EFQRCode](https://github.com/EFPrefix/EFQRCode) - A better way to operate quick response code.
* [QRCodeReader.swift](https://github.com/yannickl/QRCodeReader.swift) - Simple QRCode reader.

#### Haptic Feedback
*Libraries that involve the use of Haptic Feedback* [back to top](#readme) 

* [Haptica](https://github.com/efremidze/Haptica) - Easy Haptic Feedback Generator.

#### iBeacon
*Interested in using iBeacon in your Swift project? Here some interesting resources.* [back to top](#readme) 

* [SwiftLocation](https://github.com/malcommac/SwiftLocation) - Location & Beacon Monitoring.

#### Sensors
*Manage your device sensors in a faster and easier way* [back to top](#readme) 


### Images
*An interesting list of image related libs..* [back to top](#readme) 

* [Agrume](https://github.com/JanGorman/Agrume) - A lemony fresh iOS image viewer.
* [AlamofireImage](https://github.com/Alamofire/AlamofireImage) - AlamofireImage is an image component library for Alamofire.
* [APNGKit](https://github.com/onevcat/APNGKit) - High performance and delightful way to play with APNG format in iOS.
* [ATGMediaBrowser](https://github.com/altayer-digital/ATGMediaBrowser) - Image slide-show viewer with multiple predefined transition styles, and with ability to create new transitions with ease.
* [AXPhotoViewer](https://github.com/alexhillc/AXPhotoViewer) - An iPhone/iPad photo gallery viewer, useful for viewing a large (or small!) number of photos.
* [BlockiesSwift](https://github.com/Boilertalk/BlockiesSwift) - Unique blocky identicons/profile picture generator.
* [Brightroom](https://github.com/FluidGroup/Brightroom) - An image editor and engine using CoreImage.
* [CTPanoramaView](https://github.com/scihant/CTPanoramaView) - A library that displays spherical or cylindrical panoramas with touch or motion based controls.
* [DTPhotoViewerController](https://github.com/tungvoduc/DTPhotoViewerController) - A fully customizable photo viewer ViewController to display single photo or collection of photos, inspired by Facebook photo viewer.
* [FacebookImagePicker](https://github.com/floriangbh/FacebookImagePicker) - Facebook album photo picker.
* [FaceCrop](https://github.com/Ancestry/FaceCrop) - Detect and center faces in your images using Apple’s Vision Framework.
* [FlexibleImage](https://github.com/kawoou/FlexibleImage) - A simple way to play with images.
* [FMPhotoPicker](https://github.com/congnd/FMPhotoPicker) - A modern, simple and zero-dependency photo picker with an elegant and customizable image editor.
* [gifu](https://github.com/kaishin/gifu) - Highly performant animated GIF support for iOS.
* [GPUImage 2](https://github.com/BradLarson/GPUImage2) - GPUImage 2 is a BSD-licensed framework for GPU-accelerated video and image processing.
* [GPUImage 3](https://github.com/BradLarson/GPUImage3) - GPUImage 3 is a BSD-licensed framework for GPU-accelerated video and image processing using Metal.
* [HanekeSwift](https://github.com/Haneke/HanekeSwift) - A lightweight generic cache for iOS with extra love for images.
* [Harbeth](https://github.com/yangKJ/Harbeth) - Metal API for GPU accelerated Graphics and Video and Camera filter framework.
* [ImageDetect](https://github.com/Feghal/ImageDetect) - Detect and crop faces, barcodes and texts in image with iOS 11 Vision API.
* [ImageLoader](https://github.com/hirohisa/ImageLoaderSwift) - A lightweight and fast image loader for iOS.
* [ImageScout](https://github.com/kaishin/ImageScout) - Implementation of [fastimage](https://pypi.org/project/fastimage/0.2.1/) - supports PNG, GIF, and JPEG.
* [ImageViewer](https://github.com/Krisiacik/ImageViewer) - An image viewer à la Twitter.
* [ImgixSwift](https://github.com/imgix/imgix-swift) - Easily update image urls to be fast and responsive.
* [JLStickerTextView](https://github.com/Textcat/JLStickerTextView) - A UIImageView allow you to add multiple Label (multiple line text support) on it, you can edit, rotate, resize the Label as you want with one finger ,then render the text on Image.
* [Kanvas](https://github.com/tumblr/kanvas-ios) - A iOS library for adding effects, drawings, text, stickers, and making GIFs from existing media or the camera.
* [Kingfisher](https://github.com/onevcat/Kingfisher) - Image download and caching.
* [LetterAvatarKit](https://github.com/vpeschenkov/LetterAvatarKit) - A UIImage extension that generates letter-based avatars.
* [Lightbox](https://github.com/hyperoslo/Lightbox) - A convenient and easy to use image viewer for your iOS app.
* [MapleBacon](https://github.com/JanGorman/MapleBacon) - Image download and caching library.
* [MCScratchImageView](https://github.com/JaylenCoding/MCScratchImageView) - A custom ImageView that is used to cover the surface of other view like a scratch card, user can swipe the mulch to see the view below.
* [Moa](https://github.com/evgenyneu/moa) - An image download extension of the image view for iOS, tvOS and macOS.
* [Nuke](https://github.com/kean/Nuke) - Advanced framework for loading, caching, processing, displaying and preheating images.
* [PassportScanner](https://github.com/evermeer/PassportScanner) - Scan the MRZ code of a passport and extract the first name, last name, passport number, nationality, date of birth, expiration date and personal number.
* [Rough](https://github.com/bakhtiyork/Rough) - Rough lets you draw in a sketchy, hand-drawn-like, style.
* [Sharaku](https://github.com/makomori/Sharaku) - Image filtering UI library like Instagram.
* [Snowflake](https://github.com/onmyway133/Snowflake) - Work with SVG.
* [SwiftDraw](https://github.com/swhitty/SwiftDraw) - Library that converts SVG images to UIImage, NSImage and generates CoreGraphics source code.
* [SwiftGen-Assets](https://github.com/SwiftGen/SwiftGen#assets-catalogs) - A tool to auto-generate `enums` for all your `UIImages` from your Assets Catalogs.
* [SwiftSVG](https://github.com/mchoe/SwiftSVG) - A single pass SVG parser with multiple interface options (String, NS/UIBezierPath, CAShapeLayer, and NS/UIView).
* [SwiftWebImage](https://github.com/geekaurora/SwiftWebImage) - 🚀SwiftUI Image downloader with performant LRU mem/disk cache.
* [SwiftyGif](https://github.com/alexiscreuzot/SwiftyGif) - High performance GIF engine.
* [TinyCrayon](https://github.com/TinyCrayon/TinyCrayon-iOS-SDK) - A smart and easy-to-use image masking and cutout SDK for mobile apps.
* [Toucan](https://github.com/gavinbunney/Toucan) - Image processing api.
* [UIImageColors](https://github.com/jathu/UIImageColors) - iTunes style color fetcher for UIImage.
* [YPImagePicker](https://github.com/Yummypets/YPImagePicker) - Instagram-like image picker & filters for iOS.
* [ZImageCropper](https://github.com/ZaidPathan/ZImageCropper) - Crop image in any shape.

### Key Value Coding
*Libraries for key-value coding* [back to top](#readme) 


### Keyboard
*Do you want to create your own customized keyboard? Here are some interesting resources* [back to top](#readme) 

* [IHKeyboardAvoiding](https://github.com/IdleHandsApps/IHKeyboardAvoiding) - An elegant solution for keeping any UIView visible when the keyboard is being shown. No UIScrollView required.
* [IQKeyboardManager](https://github.com/hackiftekhar/IQKeyboardManager) - Codeless drop-in universal library allows to prevent issues of keyboard sliding up and cover UITextField/UITextView.
* [ISEmojiView](https://github.com/isaced/ISEmojiView) - Emoji Keyboard for iOS
* [KeyboardHideManager](https://github.com/bonyadmitr/KeyboardHideManager) - Codeless manager to hide keyboard by tapping on views for iOS.
* [KeyboardShortcuts](https://github.com/sindresorhus/KeyboardShortcuts) - Add user-customizable global keyboard shortcuts to your macOS app. Includes a Cocoa and SwiftUI component.
* [Ribbon](https://github.com/chriszielinski/Ribbon) - 🎀 A simple cross-platform toolbar/custom input accessory view library for iOS & macOS.
* [Typist](https://github.com/totocaster/Typist) - Small, drop-in UIKit keyboard manager for iOS apps-helps manage keyboard's screen presence and behavior without notification center.

### Kit
*Libraries for coding with a simplified API* [back to top](#readme) 

* [BFKit-Swift](https://github.com/FabrizioBrancati/BFKit-Swift) :penguin: - A collection of useful classes, structs and extensions to develop Apps faster.
* [C4iOS](https://github.com/C4Labs/C4iOS) - Harnesses the power of native iOS programming with a simplified API.
* [ContactsChangeNotifier](https://github.com/yonat/ContactsChangeNotifier) - Which contacts changed outside your app? Better CNContactStoreDidChange notification: Get real changes, without the noise.

### Layout
*Libs to help you with layout.* [back to top](#readme) 

* [AnimatedTabBar](https://github.com/exyte/AnimatedTabBar) - A tabbar with a number of preset animations.
* [BrickKit](https://github.com/wayfair-archive/brickkit-ios) - Create complex and responsive layouts in a simple way.
* [CGLayout](https://github.com/k-o-d-e-n/CGLayout) :penguin: - Powerful autolayout framework, that can manage UIView(NSView), CALayer, not rendered views and etc. Provides placeholders.
* [FlexLayout](https://github.com/layoutBox/FlexLayout) - Nice and clean interface to the highly optimized Facebook yoga Flexbox implementation.
* [FrameLayoutKit](https://github.com/kennic/FrameLayoutKit) - This framework supports complex layouts, including chaining and nesting layout with simple and intuitive operand & DSL syntax.
* [Grid](https://github.com/exyte/Grid) - The most powerful Grid container missed in SwiftUI.
* [LayoutLess](https://github.com/DeclarativeHub/Layoutless) - Write less UI Code.
* [Neon](https://github.com/mamaral/Neon) - A powerful programmatic UI layout framework.
* [PinLayout](https://github.com/layoutBox/PinLayout) - Fast Views layouting without auto layout. No magic, pure code, full control and blazing fast. Concise syntax, intuitive, readable & chainable. [iOS/macOS/tvOS]
* [Scaling Header Scroll View](https://github.com/exyte/ScalingHeaderScrollView) - A scroll view with a sticky header which shrinks as you scroll. Written with SwiftUI.
* [Static](https://github.com/venmo/Static) - A simple static table views for iOS.
* [Stevia](https://github.com/freshOS/Stevia) - Elegant view layout for iOS.

#### Auto Layout
*Bored of using storyboard? Give a try to declarative auto layout libs.* [back to top](#readme) 

* [Bamboo](https://github.com/wordlessj/Bamboo) - Auto Layout (and manual layout) in one line.
* [Cartography](https://github.com/robb/Cartography) - Declarative auto layout lib for your project.
* [Cassowary](https://github.com/tribalworldwidelondon/CassowarySwift) - A linear constraint solving library using the same algorithm as AutoLayout.
* [Cupcake](https://github.com/nerdycat/Cupcake) - An easy way to create and layout UI components for iOS.
* [DeviceLayout](https://github.com/cruisediary/DeviceLayout) - AutoLayout can be set differently for each device.
* [EasyPeasy](https://github.com/nakiostudio/EasyPeasy) - Auto Layout made easy.
* [EasySwiftLayout](https://github.com/Pimine/EasySwiftLayout) - Lightweight Swift framework for Apple's Auto-Layout.
* [EZLayout](https://github.com/alexliubj/EZAnchor) - An easier and faster way to code Autolayout.
* [FixFlex](https://github.com/psharanda/FixFlex) - Declarative autolayout based on NSLayoutAnchor, swifty reimagination of VFL, alternative to UIStackView.
* [HypeUI](https://github.com/hyperconnect/HypeUI) - 🌺 HypeUI is a implementation of Apple's SwiftUI DSL style based on UIKit
* [KVConstraintKit](https://github.com/keshavvishwkarma/KVConstraintKit) - An Impressive Autolayout DSL for iOS, tvOS & OSX.
* [MisterFusion](https://github.com/marty-suzuki/MisterFusion) - DSL for AutoLayout, supports Size Class.
* [Mortar](https://github.com/jmfieldman/Mortar) - A concise but flexible DSL for creating Auto Layout constraints and adding subviews.
* [NorthLayout](https://github.com/banjun/NorthLayout) - Fast path to layout using Visual Format Language (VFL) with extended syntax.
* [PureLayout](https://github.com/PureLayout/PureLayout) - The ultimate API for iOS & OS X Auto Layout.
* [SnapKit](https://github.com/SnapKit/SnapKit) - Autolayout DSL for iOS & OS X.
* [Swiftstraints](https://github.com/Skyvive/Swiftstraints) - Powerful auto-layout framework that lets you write constraints in one line of code.
* [TinyConstraints](https://github.com/roberthein/TinyConstraints) - TinyConstraints is the syntactic sugar that makes Auto Layout sweeter for human use.

### Localization
*Frameworks that helps with localizing your app* [back to top](#readme) 

* [BartyCrouch](https://github.com/FlineDev/BartyCrouch) - Incrementally update/translate your Strings files from Code and Storyboards/XIBs.
* [CrowdinSDK](https://github.com/crowdin/mobile-sdk-ios) - Delivers all new translations from Crowdin project to the application immediately.
* [IBLocalizable](https://github.com/PiXeL16/IBLocalizable) - Localize your views directly in Interface Builder with IBLocalizable.
* [L10n-swift](https://github.com/Decybel07/L10n-swift) - Localization of an application with ability to change language "on the fly" and support for plural forms in any language.
* [LocalizationKit](https://github.com/willpowell8/LocalizationKit_iOS) - Realtime dynamic localization of your app with remote management so you can manage maintain and deploy translations without resubmitting app.
* [Localize](https://github.com/andresilvagomez/Localize) - Localize apps using e.g. regular expressions in Localizable.strings.
* [Localize-Swift](https://github.com/marmelroy/Localize-Swift) - Localize apps using e.g. regular expressions in Localizable.strings.
* [Locheck](https://github.com/Asana/locheck) - Validate .strings and .stringsdict files for errors
* [StringSwitch](https://stringswitch.com) - Easily convert iOS .strings files to Android strings.xml format and vice versa.
* [SwiftGen-L10n](https://github.com/SwiftGen/SwiftGen#localizablestrings) - A tool to auto-generate `enums` for all your Localizable.strings keys (with appropriate associated values if those strings contains printf-format placeholders like `%@`).
* [Translatio](https://github.com/andrealufino/Translatio) - Super lightweight library that helps you to localize strings, even directly in storyboards.

### Location
[back to top](#readme) 

* [AsyncLocationKit](https://github.com/AsyncSwift/AsyncLocationKit) - Wrapper for Apple CoreLocation framework with Modern Concurrency Swift (async/await).
* [STLocationRequest](https://github.com/SvenTiigi/STLocationRequest) - An elegant and simple 3D Flyover Location Request Screen.

### Logging
*Utilities for writing to and reading from the device log* [back to top](#readme) 

* [AEConsole](https://github.com/tadija/AEConsole) - Customizable Console UI overlay with debug log on top of your iOS App.
* [CleanroomLogger](https://github.com/emaloney/CleanroomLogger) - Configurable and extensible high-level logging API that is simple, lightweight and performant.
* [Duration](https://github.com/SwiftStudies/Duration) :penguin: - Lightweight logging library focused on reporting timings for operations.
* [Gedatsu](https://github.com/bannzai/gedatsu) - Provide readable format about AutoLayout error console log.
* [HeliumLogger](https://github.com/Kitura/HeliumLogger) :penguin: - IBM's lightweight logging framework.
* [Printer](https://github.com/hemangshah/printer) - A fancy logger for your next app.
* [Puppy](https://github.com/sushichop/Puppy) :penguin: - A flexible logging library that supports multiple transports and platforms.
* [QorumLogs](https://github.com/Esqarrouth/QorumLogs) - Logging Utility for Xcode & Google Docs.
* [Rainbow](https://github.com/onevcat/Rainbow) :penguin: - Delightful console output.
* [SwiftyBeaver](https://github.com/SwiftyBeaver/SwiftyBeaver) :penguin: - Multi-platform logging during development & release.
* [TinyConsole](https://github.com/Cosmo/TinyConsole) - A tiny log console to display information while using your iOS app.
* [TraceLog](https://github.com/tonystone/tracelog) :penguin: - Dead Simple: logging the way it's meant to be!  Runs on iOS, macOS, and Linux.
* [Watchdog](https://github.com/wojteklu/Watchdog) - Utility for logging excessive blocking on the main thread.
* [WatchdogInspector](https://github.com/tapwork/WatchdogInspector) - A logging tool to show the current framerate (fps) in the status bar of your iOS app.
* [Willow](https://github.com/Nike-Inc/Willow) - Willow is a powerful, yet lightweight logging library.
* [XCGLogger](https://github.com/DaveWoodCom/XCGLogger) - Full featured & Configurable logging utility with log levels, timestamps, and line numbers.

### Maps
[back to top](#readme) 

* [Cluster](https://github.com/efremidze/Cluster) - Easy Map Annotation Clustering.
* [FlyoverKit](https://github.com/SvenTiigi/FlyoverKit) - FlyoverKit enables you to present stunning 360° flyover views on your MKMapView with zero effort while maintaining full configuration possibilities.
* [GEOSwift](https://github.com/GEOSwift/GEOSwift) - Make it easier to work with geographic models and calculate intersections, overlapping, projections etc.
* [LocoKit](https://github.com/sobri909/LocoKit) - A location and activity recording framework for iOS.

### Math
[back to top](#readme) 

* [Arithmosophi](https://github.com/phimage/Arithmosophi) - Set of protocols for Arithmetic and Logical operations.
* [BigInt](https://github.com/attaswift/BigInt) - Arbitrary-precision arithmetic.
* [DDMathParser](https://github.com/davedelong/DDMathParser) - DDMathParser makes it easy to parse a String and evaluate it as a mathematical expression.
* [SigmaSwiftStatistics](https://github.com/evgenyneu/SigmaSwiftStatistics) - A collection of functions for statistical calculation.
* [Upsurge](https://github.com/alejandro-isaza/Upsurge) - Simple and fast matrix and vector math.

### Natural Language Processing
[back to top](#readme) 


### Network
*A list of libs that allow you to decrease the amount of time spent dealing with http requests.* [back to top](#readme) 

* [Alamofire](https://github.com/Alamofire/Alamofire) :penguin: - Elegant networking.
* [APIKit](https://github.com/ishkawa/APIKit) - Library for building type-safe web API client.
* [Ciao](https://github.com/AlTavares/Ciao) - Publish and discover services using mDNS (Bonjour, Zeroconf).
* [CodyFire](https://github.com/CodyFlame/CodyFire) - Powerful Codable API requests builder and manager for iOS. Based on Alamofire.
* [Conduit](https://github.com/mindbody/Conduit) - Robust networking for web APIs.
* [Connectivity](https://github.com/rwbutler/Connectivity) - 🌐 Makes Internet connectivity detection more robust by detecting Wi-Fi networks without Internet access.
* [Dots](https://github.com/iAmrSalman/Dots) - Lightweight Concurrent Networking Framework.
* [GoodNetworking](https://github.com/GoodRequest/GoodNetworking) - 📡 GoodNetworking simplifies HTTP networking.
* [Heimdallr.swift](https://github.com/trivago/Heimdallr.swift) - Easy to use OAuth 2 library for iOS.
* [Just](https://github.com/dduan/Just) :penguin: - HTTP for Humans (a python-requests style HTTP library).
* [Malibu](https://github.com/hyperoslo/Malibu) - A networking library built on promises.
* [Moya](https://github.com/Moya/Moya) - Network abstraction layer.
* [MultiPeer](https://github.com/dingwilson/MultiPeer) - A wrapper for the MultipeerConnectivity framework for automatic offline data transmission between devices.
* [Netfox](https://github.com/kasketis/netfox) - A lightweight, one line setup, network debugging library.
* [Netswift](https://github.com/MrSkwiggs/Netswift) - A type-safe, high-level networking solution.
* [OAuth2](https://github.com/p2/OAuth2) - oauth2 auth lib.
* [OAuthSwift](https://github.com/OAuthSwift/OAuthSwift) - OAuth library for iOS.
* [Pitaya](https://github.com/johnlui/Pitaya) :penguin: - HTTP / HTTPS networking library just incidentally execute on machines.
* [PMHTTP](https://github.com/postmates/PMHTTP) - HTTP framework with a focus on REST and JSON.
* [Postal](https://github.com/snipsco/Postal) - Framework providing simple access to common email providers.
* [Reachability.swift](https://github.com/ashleymills/Reachability.swift) - A replacement for Apple's Reachability with closures.
* [ReactiveAPI](https://github.com/sky-uk/ReactiveAPI) - Write clean, concise and declarative network code relying on URLSession, with the power of RxSwift. Inspired by Retrofit.
* [ResponseDetective](https://github.com/netguru/ResponseDetective) - A non-intrusive framework for intercepting any outgoing requests and incoming responses between your app and server for debugging purposes.
* [RxNetworks](https://github.com/yangKJ/RxNetworks) - Network API With RxSwift + Moya + HandyJSON + Plugins.
* [ShadowsocksX-NG](https://github.com/shadowsocks/ShadowsocksX-NG) - A fast tunnel proxy that helps you bypass firewalls.
* [Siesta](https://bustoutsolutions.github.io/siesta/) - Elegant abstraction for REST APIs that untangles stateful messes. An alternative to callback- and delegate-based networking.
* [SolarNetwork](https://github.com/ThreeGayHub/SolarNetwork) - Elegant network abstraction layer.
* [SwiftHTTP](https://github.com/daltoniam/SwiftHTTP) - NSURLSession wrapper.
* [SwiftyOAuth](https://github.com/delba/SwiftyOAuth) - A small OAuth library with a built-in set of providers.
* [TermiNetwork](https://github.com/billp/TermiNetwork) - 🌏 A zero-dependency networking solution for building modern and secure iOS, watchOS, macOS and tvOS applications.
* [TRON](https://github.com/MLSDev/TRON) - Lightweight network abstraction layer, written on top of Alamofire.
* [Wormholy](https://github.com/pmusolino/Wormholy) - iOS network debugging, like a wizard 🧙‍.

#### HTML
*Need to manipulate contents from html easily?* [back to top](#readme) 

* [Fuzi](https://github.com/cezheng/Fuzi) - A fast & lightweight XML/HTML parser with XPath & CSS support.
* [Kanna](https://github.com/tid-kijyun/Kanna) - Another XML/HTML parser.
* [SwiftSoup](https://github.com/scinfu/SwiftSoup) :penguin: - HTML Parser, with best of DOM, CSS, and jquery.
* [WKZombie](https://github.com/mkoehnke/WKZombie) - Headless browser.
* [ZMarkupParser](https://github.com/ZhgChgLi/ZMarkupParser) - Helps you convert HTML strings into NSAttributedString with customized styles and tags.

#### Messaging Protocol
[back to top](#readme) 

* [CocoaMQTT](https://github.com/emqx/CocoaMQTT) - MQTT for iOS and OS X.
* [Perfect-Notifications](https://github.com/PerfectlySoft/Perfect-Notifications) - iOS Notifications for Linux and OS X.

#### SOAP
[back to top](#readme) 

* [SOAPEngine](https://github.com/priore/SOAPEngine) - Generic SOAP client to access SOAP Web Services using iOS, Mac OS X, and Apple TV.

#### Socket
[back to top](#readme) 

* [BlueSocket](https://github.com/Kitura/BlueSocket ) - IBM's cross platform low level socket framework.
* [BlueSSLService](https://github.com/Kitura/BlueSSLService) - SSL/TLS add-in for IBM's low level socket framework.
* [DNWebSocket](https://github.com/GlebRadchenko/DNWebSocket) - Object-Oriented, Autobahn tested WebSocket Library (RFC 6455).
* [RxWebSocket](https://github.com/fjcaetano/RxWebSocket) - Reactive WebSockets.
* [Socket.IO](https://github.com/socketio/socket.io-client-swift) :penguin: - Socket.IO client for iOS/OS X.
* [sockets](https://github.com/vapor-community/sockets) :penguin: - TCP, UDP; Client, Server; Linux, OS X.
* [Starscream](https://github.com/daltoniam/Starscream) - Websockets for iOS and OSX.
* [SwiftSocket](https://github.com/swiftsocket/SwiftSocket) - Simple TCP socket library.
* [SwiftWebSocket](https://github.com/tidwall/SwiftWebSocket) - A high performance WebSocket client library .

#### Webserver
*Would you like host a webserver in your device? Here you can find how to do it.* [back to top](#readme) 

* [Ambassador](https://github.com/envoy/Ambassador) - Super lightweight web framework based on SWSGI.
* [Curassow](https://github.com/kylef-archive/Curassow) :penguin: - HTTP server using the pre-fork worker model.
* [Embassy](https://github.com/envoy/Embassy) :penguin: - Super lightweight async HTTP server library.
* [Kitura](https://github.com/Kitura/Kitura) :penguin: - IBM's web framework and server for web services.
* [Lightning](https://github.com/skylab-inc/Lightning) :penguin: - Multiplatform Single-threaded Non-blocking Web and Networking Framework.
* [Noze.io](https://github.com/NozeIO/Noze.io) :penguin: - Evented I/O streams like Node.js.
* [Perfect](https://github.com/PerfectlySoft/Perfect) :penguin: - Server-side Swift. The Perfect library, application server, connectors and example apps.
* [swifter](https://github.com/httpswift/swifter) :penguin: - Http server with routing handler.
* [Vapor](https://github.com/vapor/vapor) :penguin: - Elegant web framework that works on iOS, OS X, and Ubuntu.
* [Zewo](https://github.com/Zewo/Zewo) :penguin: - Server-Side Swift.

### OCR
[back to top](#readme) 

* [SwiftOCR](https://github.com/NMAC427/SwiftOCR) - Neural Network based OCR lib.

### Optimization
[back to top](#readme) 


### PDF
[back to top](#readme) 

* [PDFGenerator](https://github.com/sgr-ksmt/PDFGenerator) - A simple Generator of PDF. Generate PDF from view(s) or image(s).
* [SimplePDF](https://github.com/nRewik/SimplePDF) - Create a simple PDF effortlessly.
* [UXMPDFKit](https://github.com/uxmstudio/UXMPDFKit) - A PDF viewer and annotator that can be embedded in iOS applications.

### Quality
[back to top](#readme) 

* [AnyLint](https://github.com/FlineDev/AnyLint) :penguin: - Lint anything by combining the power of Swift & regular expressions.
* [IBLinter](https://github.com/IBDecodable/IBLinter) - A linter tool for Interface Builder.
* [L10nLint](https://github.com/s2mr/L10nLint) - A linter tool for Localizable.strings.
* [swift-mod](https://github.com/ra1028/swift-mod) - A tool for Swift code modification intermediating between code generation and formatting.
* [SwiftCop](https://github.com/andresinaka/SwiftCop) - A validation library which inspired by the clarity of Ruby On Rails Active Record validations.
* [SwiftFormat](https://github.com/nicklockwood/SwiftFormat) - A code library and command-line formatting tool for reformatting Swift code.
* [SwiftLint](https://github.com/realm/SwiftLint) - A tool to enforce coding conventions.
* [Swimat](https://github.com/Jintin/Swimat) - Xcode plugin to format code.
* [Tailor](https://github.com/sleekbyte/tailor) :penguin: - Cross-platform static analyzer that helps you to write cleaner code and avoid bugs.

### Scripting
[back to top](#readme) 

* [Swift for Scripting](https://github.com/artemnovichkov/Swift-For-Scripting) - A hand-curated collection of useful and informative scripting material.

### SDK
[back to top](#readme) 


### Security
[back to top](#readme) 

* [SecurePropertyStorage](https://github.com/alexruperez/SecurePropertyStorage) - Helps you define secure storages for your properties using Swift property wrappers.

#### Cryptography
*Deal with cryptography method easily* [back to top](#readme) 

* [BlueCryptor](https://github.com/Kitura/BlueCryptor) - IBM's Cross Platform Crypto library.
* [BlueRSA](https://github.com/Kitura/BlueRSA) - IBM's Cross Platform RSA Crypto library.
* [CryptoSwift](https://github.com/krzyzanowskim/CryptoSwift) :penguin: - Crypto related functions and helpers.
* [IDZSwiftCommonCrypto](https://github.com/iosdevzone/IDZSwiftCommonCrypto) - A wrapper for Apple's Common Crypto library.
* [JOSESwift](https://github.com/airsidemobile/JOSESwift) - A framework for the JOSE standards JWS, JWE, and JWK.
* [RNCryptor](https://github.com/RNCryptor/RNCryptor) - CCCryptor (Apple's AES encryption) wrappers for iOS and Mac.
* [SCrypto](https://github.com/sgl0v/scrypto) - Elegant interface to access the CommonCrypto routines.
* [Siphash](https://github.com/attaswift/SipHash) - Simple and secure hashing with the SipHash algorithm.
* [Swift-Sodium](https://github.com/jedisct1/swift-sodium) - Interface to the Sodium library for common crypto operations for iOS and OS X.
* [Themis](https://github.com/cossacklabs/themis) - Multilanguage framework for making typical encryption schemes easy to use: data at rest, authenticated data exchange, transport protection, authentication, and so on.

#### Keychain
[back to top](#readme) 

* [GoodPersistence](https://github.com/GoodRequest/GoodPersistence) - 💾 GoodPersistence simplifies caching data in keychain and UserDefaults. Using a property wrappers.
* [keychain-swift](https://github.com/evgenyneu/keychain-swift) - Helper functions for saving text in Keychain securely for iOS, OS X, tvOS and watchOS.
* [KeychainAccess](https://github.com/kishikawakatsumi/KeychainAccess) - Simple wrapper for Keychain that works on iOS and OS X.
* [Latch](https://github.com/endocrimes/Latch) - A simple Keychain Wrapper for iOS.
* [SwiftKeychainWrapper](https://github.com/jrendel/SwiftKeychainWrapper) - Simple static wrapper for the iOS Keychain to allow you to use it in a similar fashion to user defaults.
* [Valet](https://github.com/square/Valet) - Valet lets you securely store data in the Keychain without knowing a thing about how the Keychain works. It’s easy. We promise.

### Streaming
[back to top](#readme) 

* [HaishinKit](https://github.com/shogo4405/HaishinKit.swift) - Camera and Microphone streaming library via RTMP, HLS for iOS, macOS, tvOS.
* [Live](https://github.com/ltebean/Live) - Demonstrate how to build a live broadcast app.

### Styling
[back to top](#readme) 

* [Stylist](https://github.com/yonaskolb/Stylist) - Define UI styles in a hot-loadable external yaml or json file.
* [SwiftTheme](https://github.com/wxxsw/SwiftTheme) - Powerful theme/skin manager for iOS 8+.
* [Themes](https://github.com/onmyway133/EasyTheme) - Theme management.

### SVG
[back to top](#readme) 

* [SVGView](https://github.com/exyte/SVGView) - SVG parser and renderer written in SwiftUI.

### System
[back to top](#readme) 

* [BlueSignals](https://github.com/Kitura/BlueSignals) - IBM's Cross Platform OS signal handling library.
* [LaunchAtLogin](https://github.com/sindresorhus/LaunchAtLogin-Legacy) - Easily add 'Launch at Login' functionality to your sandboxed macOS app.
* [SystemKit](https://github.com/beltex/SystemKit/) - OS X system library.

### Testing
*A collection of testing frameworks.* [back to top](#readme) 

* [DVR](https://github.com/venmo/DVR) - A simple network testing framework.
* [Erik](https://github.com/phimage/Erik) - An headless browser to access and manipulate webpages using javascript allowing to run functional tests.
* [Fakery](https://github.com/vadymmarkov/Fakery) - Fake data generator.
* [Mussel](https://github.com/UrbanCompass/Mussel) - A framework for easily testing Push Notifications, Universal Links and Routing in XCUITests.
* [Nimble](https://github.com/Quick/Nimble) - A matcher framework.
* [OHHTTPStubs](https://github.com/AliSoftware/OHHTTPStubs) - A testing library designed to stub your network requests easily.
* [Quick](https://github.com/Quick/Quick) :penguin: - Quick is a behavior-driven development framework.
* [SBTUITestTunnel](https://github.com/Subito-it/SBTUITestTunnel) - UI testing library for interact with network requests, stub CLLocationManager and UNUserNotificationCenter, and fine grain scrolling in table/collection/scroll views
* [Sizes](https://github.com/marcosgriselli/Sizes) - Test your app on different device and font sizes.
* [SnapshotTest](https://github.com/parski/SnapshotTest) - Snapshot testing tool for iOS and tvOS.
* [Spectre](https://github.com/kylef/Spectre) :penguin: - BDD Framework.
* [swift-testing-expectation](https://github.com/dfed/swift-testing-expectation) - Create an asynchronous expectation in Swift Testing.
* [SwiftCheck](https://github.com/typelift/SwiftCheck) - A testing library that automatically generates random data for testing program properties.
* [UI Testing Cheat Sheet](https://github.com/joemasilotti/UI-Testing-Cheat-Sheet) - Answers to common "How do I test this with UI Testing?" questions with a working example app.
* [XCTest](https://github.com/swiftlang/swift-corelibs-xctest) - The XCTest Project, A Swift core library for providing unit test support.

#### Mock
[back to top](#readme) 

* [AutoMockable](https://github.com/vincent-pradeilles/AutoMocker) - A framework that leverages the type system to let you easily create mocked instances of your data types.
* [Cuckoo](https://github.com/Brightify/Cuckoo) - First boilerplate-free mocking framework.
* [Mocker](https://github.com/WeTransfer/Mocker) - Mock Alamofire and URLSession requests without touching your code implementation
* [Mockingbird](https://github.com/Farfetch/mockingbird) - Simplify software testing, by easily mocking any system using HTTP/HTTPS, allowing a team to test and develop against a service that is not complete, unstable or just to reproduce planned cases.
* [Mockingjay](https://github.com/kylef/Mockingjay) - An elegant library for stubbing HTTP requests with ease.
* [Mockit](https://github.com/sabirvirtuoso/Mockit) - A simple mocking framework, inspired by the famous Mockito for Java.
* [MockSwift](https://github.com/leoture/MockSwift) - Mock Framework that uses the power of property wrappers.

### Text
*A collection of text projects.* [back to top](#readme) 

* [Attributed](https://github.com/Nirma/Attributed) - Modern µframework for attributed strings.
* [AttributedTextView](https://github.com/evermeer/AttributedTextView) - Easiest way to create an attributed UITextView with support for multiple links, hashtags and mentions.
* [BonMot](https://github.com/Rightpoint/BonMot) - Beautiful, easy attributed strings for iOS.
* [Croc](https://github.com/JKalash/Croc) - A lightweight Emoji parsing and querying library.
* [edhita](https://github.com/tnantoka/edhita) - Fully open source text editor for iOS.
* [MarkdownKit](https://github.com/bmoliveira/MarkdownKit) - A simple and customizable Markdown Parser.
* [MarkdownView](https://github.com/keitaoouchi/MarkdownView) - iOS Markdown view.
* [MarkyMark](https://github.com/M2Mobi/Marky-Mark) - Converts Markdown into native views or attributed strings.
* [Notepad](https://github.com/ruddfawcett/Notepad) - A fully themeable markdown editor with live syntax highlighting.
* [OEMentions](https://github.com/omar14/OEMentions) - An easy way to add mentions to uitextview like Facebook and Instagram.
* [Parsey](https://github.com/rxwei/Parsey) - Parser combinator framework that supports source location tracking, backtracking prevention, and rich error messages.
* [Pluralize.swift](https://github.com/joshualat/Pluralize.swift) - Great String Pluralize Extension.
* [PredicateFlow](https://github.com/andreadelfante/PredicateFlow) - PredicateFlow is a builder that allows you to write amazing, strong-typed and easy-to-read NSPredicate.
* [PrediKit](https://github.com/KrakenDev/PrediKit) - An NSPredicate DSL for iOS & OS X inspired by SnapKit.
* [Regex by crossroadlabs](https://github.com/crossroadlabs/Regex) :penguin: - Very easy to use Regular Expressions library with rich functionality. Features both operator `=~` and method based APIs. Unit tests covered.
* [Regex by sindresorhus](https://github.com/sindresorhus/Regex) - Swifty regular expressions, fully tested & documented, and with correct Unicode handling.
* [RichEditorView](https://github.com/cjwirth/RichEditorView) -  RichEditorView is a simple, modular, drop-in UIView subclass for Rich Text Editing.
* [Sprinter](https://github.com/nicklockwood/Sprinter) - A library for formatting strings.
* [SwiftRichString](https://github.com/malcommac/SwiftRichString) - Elegant & Painless Attributed Strings Management Library.
* [SwiftVerbalExpressions](https://github.com/VerbalExpressions/SwiftVerbalExpressions) - VerbalExpressions porting.
* [SwiftyAttributes](https://github.com/eddiekaiger/SwiftyAttributes) - Extensions that make it a breeze to work with attributed strings.
* [Tagging](https://github.com/k-lpmg/Tagging) - A TextView that provides easy to use tagging feature for Mention or Hashtag.
* [Texstyle](https://github.com/rosberry/texstyle) - Texstyle allows you to format attributed strings easily.
* [TextAttributes](https://github.com/delba/TextAttributes) - An easier way to compose attributed strings.
* [TextBuilder](https://github.com/davdroman/TextBuilder) - Like a SwiftUI ViewBuilder, but for Text.
* [TwitterTextEditor](https://github.com/twitter/TwitterTextEditor) - A standalone, flexible API that provides a full featured rich text editor for iOS applications.
* [VEditorKit](https://github.com/GeekTree0101/VEditorKit) - Lightweight and Powerful Editor Kit.

### Thread
*Threading, task-based or asynchronous programming, Grand Central Dispatch (GCD) wrapper* [back to top](#readme) 

* [Async](https://github.com/duemunk/Async) - Syntactic sugar for Grand Central Dispatch.
* [AwaitKit](https://github.com/yannickl/AwaitKit) - The ES7 Async/Await control flow.
* [Each](https://github.com/dalu93/Each) - Each is a NSTimer bridge library.
* [GCDTimer](https://github.com/hemantasapkota/GCDTimer) - A well-tested GCD timer.
* [Schedule](https://github.com/luoxiu/Schedule) :penguin: - A missing lightweight task scheduler with an incredibly human-friendly syntax.
* [SwiftyTimer](https://github.com/radex/SwiftyTimer) - API for NSTimer.

### UI
*A collection of pre-packaged transitions & cool ui stuffs.* [back to top](#readme) 

* [ActivityIndicatorView](https://github.com/exyte/ActivityIndicatorView) - A number of preset loading indicators created with SwiftUI.
* [AECoreDataUI](https://github.com/tadija/AERecord) - Core Data driven UI.
* [AGCircularPicker](https://github.com/agilie/AGCircularPicker) - Helpful component for creating a controller aimed to manage any calculated parameter.
* [AMScrollingNavbar](https://github.com/andreamazz/AMScrollingNavbar) - Scrollable UINavigationBar that follows the scrolling of a UIScrollView.
* [Arale](https://github.com/supercomputra/Arale) - A custom stretchable header view for UIScrollView or any its subclasses with UIActivityIndicatorView support for content reloading.
* [BadgeHub](https://github.com/jogendra/BadgeHub) - Make any UIView a full fledged animated notification center. It is a way to quickly add a notification badge icon to a UIView.
* [BatteryView](https://github.com/yonat/BatteryView) - Simple battery shaped UIView.
* [BetterSafariView](https://github.com/stleamist/BetterSafariView) - A better way to present a SFSafariViewController or start a ASWebAuthenticationSession in SwiftUI.
* [BottomSheet](https://github.com/joomcode/BottomSheet) - Powerful Bottom Sheet component with content based size, interactive dismissal and navigation controller support.
* [BreakOutToRefresh](https://github.com/dasdom/BreakOutToRefresh) - A playable pull to refresh view using SpriteKit.
* [BulletinBoard](https://github.com/alexaubry/BulletinBoard) - Generates and manages contextual cards displayed at the bottom of the screen.
* [CapturePreventionKit](https://github.com/Jaesung-Jung/CapturePreventionKit) - Provides `Label` and `ImageView` for `screen capture prevention`.
* [CircularProgress](https://github.com/sindresorhus/CircularProgress) - Circular progress indicator for your macOS app.
* [ClassicKit](https://github.com/Baddaboo/ClassicKit) - A collection of classic-style UI components.
* [ContainerController](https://github.com/mrustaa/ContainerController) - UI Component. This is a copy swipe-panel from app: Apple Maps, Stocks
* [CountryPickerView](https://github.com/kizitonwose/CountryPickerView) - A simple, customizable view for efficiently collecting country information in iOS apps.
* [CustomSegue](https://github.com/phimage/CustomSegue) - Custom segue for OSX Storyboards with slide and cross fade effects.
* [DeckTransition](https://github.com/HarshilShah/DeckTransition) - A library to recreate the iOS 10 Apple Music now playing transition.
* [DockProgress](https://github.com/sindresorhus/DockProgress) - Show progress in your macOS app's Dock icon.
* [Dodo](https://github.com/evgenyneu/Dodo) - A message bar for iOS.
* [Doric Design System Foundation](https://github.com/jayeshk/Doric) - Protocol oriented, type safe, scalable design system foundation framework for iOS.
* [DropDown](https://github.com/AssistoLab/DropDown) - A Material Design drop down for iOS.
* [Elissa](https://github.com/KitchenStories/Elissa) - Displays a notification on top of a UITabBarItem or any UIView anchor view to reveal additional information.
* [EstMusicIndicator](https://github.com/Aufree/ESTMusicIndicator) - Music play indicator like iTunes.
* [Family](https://github.com/zenangst/Family) - A child view controller framework that makes setting up your parent controllers as easy as pie.
* [FAQView](https://github.com/mukeshthawani/faqview) - An easy to use FAQ view for iOS.
* [Fashion](https://github.com/vadymmarkov/Fashion) - Fashion accessories and beauty tools to share and reuse UI styles.
* [FlagKit](https://github.com/madebybowtie/FlagKit) - Beautiful flag icons for usage in apps and on the web.
* [FlexibleHeader](https://github.com/k-lpmg/FlexibleHeader) - A container view that responds to scrolling of UIScrollView.
* [FloatRatingView](https://github.com/glenyi/FloatRatingView) - Floating rating system.
* [Fluid Slider](https://github.com/Ramotion/fluid-slider) - A slider widget with a popup bubble displaying the precise value selected.
* [GaugeKit](https://github.com/skywinder/GaugeKit) - Customizable gauges. Easy reproduce Apple's style gauges.
* [GMStepper](https://github.com/gmertk/GMStepper) - A stepper with a sliding label in the middle.
* [GradientProgressBar](https://github.com/fxm90/GradientProgressBar) - An animated gradient progress bar.
* [GRMustache](https://github.com/groue/GRMustache.swift) - Flexible Mustache templates.
* [GrowingTextView](https://github.com/KennethTsang/GrowingTextView) - UITextView that supports auto growing, placeholder and length limit.
* [HGCircularSlider](https://github.com/HamzaGhazouani/HGCircularSlider) - A custom reusable circular slider control for iOS application.
* [HidesNavigationBarWhenPushed](https://github.com/gontovnik/HidesNavigationBarWhenPushed) - A library, which adds the ability to hide navigation bar when view controller is pushed via hidesNavigationBarWhenPushed flag.
* [HorizontalDial](https://github.com/kciter/HorizontalDial) - A horizontal scroll dial like Instagram.
* [HPParallaxHeader](https://github.com/ngochiencse/HPParallaxHeader) - Simple parallax header for UIScrollView.
* [IGColorPicker](https://github.com/iGenius-Srl/IGColorPicker) - A customizable color picker for iOS.
* [InstantSearch iOS](https://github.com/algolia/instantsearch-ios) - A library of widgets and helpers to build instant-search features on iOS.
* [KALoader](https://github.com/Kirillzzy/KALoader) - Beautiful animated placeholders for showing loading of data.
* [KMNavigationBarTransition](https://github.com/MoZhouqi/KMNavigationBarTransition) - A drop-in universal library helps you to manage the navigation bar styles and makes transition animations smooth between different navigation bar styles while pushing or popping a view controller for all orientations.
* [KMPlaceholderTextView](https://github.com/MoZhouqi/KMPlaceholderTextView) - A UITextView subclass that adds support for multiline placeholder.
* [LeeGo](https://github.com/wangshengjia/LeeGo) - Declarative, configurable & highly reusable UI development as making Lego bricks.
* [LicensePlist](https://github.com/mono0926/LicensePlist) - A command-line tool that automatically generates a Plist of all your dependencies.
* [LiquidLoader](https://github.com/yoavlt/LiquidLoader) - Spinner loader components with liquid animation.
* [LoadingShimmer](https://github.com/jogendra/LoadingShimmer) - An easy way to add a shimmering effect to any view with just one line of code. It is useful as an unobtrusive loading indicator.
* [Macaw](https://github.com/exyte/macaw) - Powerful and easy-to-use vector graphics library with SVG support.
* [Magnetic](https://github.com/efremidze/Magnetic) - SpriteKit Floating Bubble Picker (inspired by Apple Music).
* [Mandoline](https://github.com/blueapron/Mandoline) - An iOS picker view to serve all your 'picking' needs.
* [MantleModal](https://github.com/canalesb93/MantleModal) - A simple modal resource that uses a UIScrollView to allow the user to close the modal by dragging it down.
* [Material](https://github.com/CosmicMind/Material) - Express your creativity with Material, an animation and graphics framework for Google's Material Design and Apple's Flat UI.
* [Material Components for iOS](https://github.com/material-components/material-components-ios) - Modular and customizable Material Design UI components.
* [MaterialKit](https://github.com/nghialv/MaterialKit) - Material design components.
* [MediaBrowser](https://github.com/younatics/MediaBrowser) - Simple iOS photo and video browser with optional grid view, captions and selections.
* [MPParallaxView](https://github.com/DroidsOnRoids/MPParallaxView) - Apple TV Parallax effect.
* [MultiSelectSegmentedControl](https://github.com/yonat/MultiSelectSegmentedControl) - UISegmentedControl remake that supports selecting multiple segments, vertical stacking, combining text and images.
* [MultiSlider](https://github.com/yonat/MultiSlider) - UISlider clone with multiple thumbs and values, range highlight, optional snap intervals, optional value labels, either vertical or horizontal.
* [MXParallaxHeader](https://github.com/maxep/MXParallaxHeader) - Simple parallax header for UIScrollView.
* [MZFormSheetPresentationController](https://github.com/m1entus/MZFormSheetPresentationController) - Provides an alternative to the native iOS UIModalPresentationFormSheet, adding support for iPhone and additional opportunities to setup controller size and feel form sheet.
* [NeumorphismKit](https://github.com/y-okudera/NeumorphismKit) - Neumorphism framework for UIKit.
* [NextGrowingTextView](https://github.com/FluidGroup/NextGrowingTextView) - The next in the generations of 'growing textviews' optimized for iOS 7 and above.
* [NVActivityIndicatorView](https://github.com/ninjaprox/NVActivityIndicatorView) - Collection of nice loading animations.
* [OverlayContainer](https://github.com/applidium/OverlayContainer) - OverlayContainer makes it easier to develop overlay based interfaces, such as the one presented in the Apple Maps or Stocks apps.
* [Partition Kit](https://github.com/kieranb662/PartitionKit) - A SwiftUI Library for creating resizable partitions for View Content.
* [Popovers](https://github.com/aheze/Popovers) - A library to present popovers. Simple, modern, and highly customizable. Not boring!
* [Preferences](https://github.com/sindresorhus/Settings) - Add a preferences window to your macOS app in minutes.
* [ProgressIndicatorView](https://github.com/exyte/ProgressIndicatorView) - A progress indicator view library written in SwiftUI.
* [PullToDismiss](https://github.com/sgr-ksmt/PullToDismiss) - You can dismiss modal viewcontroller by pulling scrollview or navigationbar.
* [RangeSeekSlider](https://github.com/WorldDownTown/RangeSeekSlider) - A customizable range slider like a UISlider for iOS.
* [Reel search](https://github.com/Ramotion/reel-search) - Option list managed as a reel.
* [ResizingTokenField](https://github.com/tadejr/ResizingTokenField) - A UICollectionView-based token field which provides intrinsic content height.
* [RetroProgress](https://github.com/hyperoslo/RetroProgress) - Retro looking progress bar straight from the 90s.
* [SectionedSlider](https://github.com/LeonardoCardoso/SectionedSlider) - Control Center Slider.
* [SelectionDialog](https://github.com/kciter/SelectionDialog) - Simple selection dialog.
* [ShadowView](https://github.com/PierrePerrin/ShadowView) - Make shadows management easy on UIView.
* [Shiny](https://github.com/efremidze/Shiny) - Iridescent Effect View (inspired by Apple Pay Cash).
* [ShowSomeProgress](https://github.com/stoneburner/ShowSomeProgress) - Animated Progress and Activity Indicators for iOS apps.
* [SkeletonView](https://github.com/Juanpe/SkeletonView) - An elegant way to show users that something is happening and also prepare them to which contents he is waiting.
* [SKPhotoBrowser](https://github.com/suzuki-0000/SKPhotoBrowser) - Simple PhotoBrowser/Viewer inspired by facebook, twitter photo browsers.
* [Spots](https://github.com/hyperoslo) - Spots is a view controller framework that makes your setup and future development blazingly fast.
* [SpreadsheetView](https://github.com/kishikawakatsumi/SpreadsheetView) - Full configurable spreadsheet view user interfaces for iOS applications.
* [StarryStars](https://github.com/peterprokop/StarryStars) - Display & edit ratings, fully customizable from interface builder.
* [StatefulViewController](https://github.com/aschuch/StatefulViewController) - Placeholder views based on content, loading, error or empty states.
* [StepProgressView](https://github.com/yonat/StepProgressView) - Step-by-step progress view with labels and shapes. A good replacement for UIActivityIndicatorView and UIProgressView.
* [SweetCurtain](https://github.com/ihormalovanyi/SweetCurtain) - Really sweet and easy bottom pullable sheet implementation. You can find a similar implementation in applications like Apple Maps, Find My, Stocks, etc.
* [SwiftUISkia](https://github.com/rustq/swiftui-skia) - Skia based 2d graphics SwiftUI rendering library, based on Rust to implement software rasterization to perform rendering
* [SwiftyUI](https://github.com/haoking/SwiftyUI) - High performance and lightweight UIView, UIImage, UIImageView, UIlabel, UIButton and more.
* [TagListView](https://github.com/ElaWorkshop/TagListView) - Simple but highly customizable iOS tag list view.
* [Toaster](https://github.com/devxoul/Toaster) - Notification toasts.
* [Twinkle](https://github.com/piemonte/Twinkle) - Easy way to make elements in your iOS app twinkle.
* [UltraDrawerView](https://github.com/super-ultra/UltraDrawerView) - Lightweight, fast and customizable Drawer View implementation identical to Apple Maps, Stocks and etc.
* [URLEmbeddedView](https://github.com/marty-suzuki/URLEmbeddedView) - Automatically caches the object that is confirmed the Open Graph Protocol, and displays it as URL embedded card.
* [Windless](https://github.com/ParkGwangBeom/Windless) - Windless makes it easy to implement invisible layout loading view.
* [WSTagsField](https://github.com/whitesmith/WSTagsField) - An iOS text field that represents different Tags.
* [YMTreeMap](https://github.com/yahoo/YMTreeMap) - Treemap / Heatmap layout engine, based on Squarified.
* [YNSearch](https://github.com/younatics/YNSearch) - Awesome fully customizable search view like Pinterest.

#### Alert
*Libs to display alert, action sheet, notification, popup.* [back to top](#readme) 

* [Alertift](https://github.com/sgr-ksmt/Alertift) - Modern, easy UIAlertController wrapper.
* [Alerts Pickers](https://github.com/dillidon/alerts-and-pickers) - Advanced usage of UIAlertController with TextField, DatePicker, PickerView, TableView and CollectionView.
* [ALRT](https://github.com/mshrwtnb/alrt) - An easier constructor for UIAlertController. Present an alert from anywhere.
* [AwaitToast](https://github.com/k-lpmg/AwaitToast) - 🍞 An async waiting toast with basic toast. Inspired by facebook posting toast.
* [CDAlertView](https://github.com/candostdagdeviren/CDAlertView) - Highly customizable alert/notification/success/error/alarm popup.
* [CFNotify](https://github.com/JT501/SwiftNotify) - A customizable framework to create draggable alert views.
* [EZAlertController](https://github.com/thellimist/EZAlertController) - Easy UIAlertController.
* [FullscreenPopup](https://github.com/Ryu0118/swift-fullscreen-popup) - Present any popup above NavigationBar in SwiftUI
* [GSMessage](https://github.com/wxxsw/GSMessages) - A simple style messages/notifications for iOS 7+.
* [Kamagari](https://github.com/tasanobu-zz/Kamagari) - Simple UIAlertController builder class.
* [Loaf](https://github.com/schmidyy/Loaf) - A simple framework for easy iOS Toasts.
* [MijickPopups](https://github.com/Mijick/Popups) - Popups, popovers, sheets, alerts, toasts, banners, (...) presentation made simple.
* [NotificationBanner](https://github.com/Daltron/NotificationBanner) - The easiest way to display highly customizable in app notification banners in iOS.
* [PMAlertController](https://github.com/pmusolino/PMAlertController) - PMAlertController is a great and customizable substitute to UIAlertController.
* [PopupDialog](https://github.com/orderella/PopupDialog) - A simple, customizable popup dialog. Replaces UIAlertController alert style.
* [PopupView](https://github.com/exyte/PopupView) - Toasts and popups library written with SwiftUI.
* [SCLAlertView](https://github.com/vikmeup/SCLAlertView-Swift) - Animated Alert view.
* [Sheet](https://github.com/ParkGwangBeom/Sheet) - Actionsheet with navigation features such as the Flipboard App.
* [SPAlert](https://github.com/sparrowcode/AlertKit) - Native popup from Apple Music & Feedback in AppStore. Contains Done & Heart presets.
* [StatusAlert](https://github.com/LowKostKustomz/StatusAlert) - Display Apple system-like self-hiding status alerts without interrupting user flow.
* [SweetAlert](https://github.com/codestergit/SweetAlert-iOS) - Alert system.
* [Swift-Prompts](https://github.com/GabrielAlva/Swift-Prompts) - Design custom prompts with a great scope of options to choose from.
* [SwiftEntryKit](https://github.com/huri000/SwiftEntryKit) - A simple and versatile pop-up presenter.
* [SwiftMessages](https://github.com/SwiftKickMobile/SwiftMessages) - A very flexible message bar for iOS.
* [SwiftOverlays](https://github.com/peterprokop/SwiftOverlays) - various popups and notifications.
* [Toast-Swift](https://github.com/BastiaanJansen/Toast-Swift) - An easy to use library to create iOS 14 and newer style toasts.
* [XLActionController](https://github.com/xmartlabs/XLActionController) - Fully customizable and extensible action sheet controller.
* [Zingle](https://github.com/hemangshah/Zingle) - An alert will display underneath your UINavigationBar.

#### Blur
[back to top](#readme) 

* [VisualEffectView](https://github.com/efremidze/VisualEffectView) - UIVisualEffectView subclass with tint color.

#### Button
[back to top](#readme) 

* [AHDownloadButton](https://github.com/amerhukic/AHDownloadButton) - Customizable download button with progress and transition animations. It is based on Apple's App Store download button.
* [DOFavoriteButton](https://github.com/okmr-d/DOFavoriteButton) - Cute Animated Button.
* [ExpandableButton](https://github.com/DimaMishchenko/ExpandableButton) - Customizable and easy to use expandable button.
* [FloatingButton](https://github.com/exyte/FloatingButton) - Easily customizable floating button menu created with SwiftUI.
* [Floaty](https://github.com/kciter/Floaty) - Floating Action Button for iOS.
* [IGStoryButtonKit](https://github.com/KaoruMuta/IGStoryButtonKit) - Easy-to-use button with rich animation inspired by instagram stories.
* [LGButton](https://github.com/loregr/LGButton) - A fully customisable subclass of the native UIControl which allows you to create beautiful buttons without writing any line of code.
* [LTHRadioButton](https://github.com/rolandleth/LTHRadioButton) - A radio button with a pretty animation.
* [MultiToggleButton](https://github.com/yonat/MultiToggleButton) - A UIButton subclass that implements tap-to-toggle button text (like the camera flash and timer buttons).
* [NFDownloadButton](https://github.com/LeonardoCardoso/NFDownloadButton) - Revamped Download Button. It's kinda a reverse engineering of Netflix's app download button.
* [PMSuperButton](https://github.com/pmusolino/PMSuperButton) - A powerful UIButton with super powers, customizable from Storyboard.
* [RadioGroup](https://github.com/yonat/RadioGroup) - The missing iOS radio buttons group.
* [SwiftShareBubbles](https://github.com/takecian/SwiftShareBubbles) - Animated social share buttons control for iOS.
* [TransitionButton](https://github.com/AladinWay/TransitionButton) - UIButton subclass for loading and transition animation.

#### Calendar
[back to top](#readme) 

* [CalendarKit](https://github.com/richardtop/CalendarKit) - Fully customizable calendar day view.
* [CalendarView](https://github.com/mmick66/CalendarView) - Calendar Component, It features both vertical and horizontal layout (and scrolling) and the display of native calendar events.
* [DateTimePicker](https://github.com/itsmeichigo/DateTimePicker) - A nicer iOS UI component for picking date and time.
* [ElegantCalendar](https://github.com/ThasianX/ElegantCalendar) - The elegant full screen calendar missed in SwiftUI.
* [HorizonCalendar](https://github.com/airbnb/HorizonCalendar) - A declarative, performant, iOS calendar UI component that supports use cases ranging from simple date pickers all the way up to fully-featured calendar apps.
* [JTAppleCalendar](https://github.com/patchthecode/JTAppleCalendar) - UI calendar handler.
* [KVKCalendar](https://github.com/kvyatkovskys/KVKCalendar) - A most fully customization calendar for Apple platforms 📅
* [OBCalendar](https://github.com/oBilet/OBCalendar) - OBCalendar is designed for simplicity and customization, it allows you to build beautiful and functional calendar interfaces effortlessly.
* [Workaholic](https://github.com/hemangshah/Workaholic) - A GitHub-like work contribution timeline.

#### Cards
[back to top](#readme) 

* [CardNavigation](https://github.com/james01/CardNavigation) - A navigation controller that displays its view controllers as an interactive stack of cards.
* [CardParts](https://github.com/intuit/CardParts) - A reactive, card-based UI framework built on UIKit for iOS developers.
* [VerticalCardSwiper](https://github.com/JoniVR/VerticalCardSwiper) - A marriage between the Shazam Discover UI and Tinder, built with UICollectionView.

#### Form
[back to top](#readme) 

* [Carbon](https://github.com/ra1028/Carbon) - 🚴 A declarative library for building component-based user interfaces in UITableView and UICollectionView.
* [Eureka](https://github.com/xmartlabs/Eureka) - Elegant iOS form builder.
* [FDBarGauge](https://github.com/fulldecent/FDBarGauge) - Simulate the level indicator on an audio mixing board
* [Former](https://github.com/ra1028/Former) - A fully customizable library for easy creating UITableView based form.
* [ObjectForm](https://github.com/haojianzong/ObjectForm) - A simple yet powerful library to build form for your class models.
* [SwiftyFORM](https://github.com/neoneye/SwiftyFORM) - Forms that can be validated.

#### HUD
[back to top](#readme) 

* [EZLoadingActivity](https://github.com/Esqarrouth/EZLoadingActivity) - Lightweight loading activity HUD.
* [GradientLoadingBar](https://github.com/fxm90/GradientLoadingBar) - An animated gradient loading bar.
* [KRProgressHUD](https://github.com/krimpedance/KRProgressHUD) - A beautiful and customizable progress HUD.
* [PKHUD](https://github.com/pkluz/PKHUD) - Reimplementation of the Apple HUD.

#### Label
[back to top](#readme) 

* [ActiveLabel](https://github.com/optonaut/ActiveLabel.swift) - UILabel drop-in replacement supporting Hashtags (#), Mentions (@) and URLs (http://).
* [Atributika](https://github.com/psharanda/Atributika) - TConvert text with HTML tags, links, hashtags, mentions into NSAttributedString. Make them clickable with UILabel drop-in replacement.
* [CountdownLabel](https://github.com/suzuki-0000/CountdownLabel) - Simple countdown UILabel with morphing animation, and some useful function.
* [GlitchLabel](https://github.com/kciter/GlitchLabel) - Glitching UILabel for iOS.
* [IncrementableLabel](https://github.com/tbaranes/IncrementableLabel) - An UILabel subclass to (de)increment numbers in an UILabel.
* [KDEDateLabel](https://github.com/delannoyk/KDEDateLabel) - An UILabel subclass that updates itself to make time ago's format easier.
* [LTMorphingLabel](https://github.com/lexrus/LTMorphingLabel) - Graceful morphing effects for UILabel.
* [Nantes](https://github.com/instacart/Nantes) - TTTAttributedLabel replacement.
* [TriLabelView](https://github.com/mukeshthawani/TriLabelView) - A triangle shaped corner label view for iOS.

#### Menu
[back to top](#readme) 

* [AKSwiftSlideMenu](https://github.com/ashishkakkad8/AKSwiftSlideMenu) - Slide Menu (Drawer).
* [CircleMenu](https://github.com/Ramotion/circle-menu) - CircleMenu is a simple, elegant UI menu with a circular layout and material design animations.
* [ENSwiftSideMenu](https://github.com/evnaz/ENSwiftSideMenu) - Sliding side menu.
* [FanMenu](https://github.com/exyte/fan-menu) - Menu with a circular layout based on Macaw.
* [FlowingMenu](https://github.com/yannickl/FlowingMenu) - Interactive view transition to display menus with flowing and bouncing effects.
* [GuillotineMenu](https://github.com/Yalantis/GuillotineMenu) - Guillotine style menu.
* [HHFloatingView](https://github.com/hemangshah/HHFloatingView) - An easy to use and setup floating view for your app.
* [InteractiveSideMenu](https://github.com/handsomecode/InteractiveSideMenu) - Customizable iOS Interactive Side Menu.
* [KWDrawerController](https://github.com/Kawoou/KWDrawerController) - Drawer view controller that easy to use.
* [MenuItemKit](https://github.com/cxa/MenuItemKit) - `UIMenuItem` with image and block (closure) support.
* [Pagemenu](https://github.com/PageMenu/PageMenu) - Pagination enabled view controller.
* [PagingKit](https://github.com/kazuhiro4949/PagingKit) - PagingKit provides customizable menu UI.
* [Panels](https://github.com/antoniocasero/Panels) - Panels is a framework to easily add sliding panels to your application.
* [Parchment](https://github.com/rechsteiner/Parchment) - A paging view controller with a highly customizable menu, built on UICollectionView.
* [PopMenu](https://github.com/CaliCastle/PopMenu) - 😎 A cool and customizable popup style action sheet for iOS.
* [SegmentIO](https://github.com/Yalantis/Segmentio) - Animated top/bottom segmented menu for iOS.
* [SideMenu](https://github.com/jonkykong/SideMenu) - Simple side menu control for iOS inspired by Facebook. Right and Left sides. No coding required.
* [SlideMenuControllerSwift](https://github.com/dekatotoro/SlideMenuControllerSwift) - iOS Slide Menu View based on Google+, iQON, Feedly, Ameba iOS app.
* [SwipeMenuViewController](https://github.com/yysskk/SwipeMenuViewController) - Swipable tab and menu View and ViewController.
* [XLPagerTabStrip](https://github.com/xmartlabs/XLPagerTabStrip) - Android PagerTabStrip for iOS.
* [YNDropDownMenu](https://github.com/younatics/YNDropDownMenu) - Adorable iOS drop down menu.

#### Pagination
[back to top](#readme) 

* [CHIPageControl](https://github.com/ChiliLabs/CHIPageControl) - A set of cool animated page controls to replace boring UIPageControl.
* [FlexiblePageControl](https://github.com/shima11/FlexiblePageControl) - A flexible UIPageControl like Instagram.
* [iPages](https://github.com/blsage/iPages) - Quickly implement swipable page views in SwiftUI 📝.
* [Pageboy](https://github.com/uias/Pageboy) - A simple, highly informative page view controller.
* [PageController](https://github.com/hirohisa/PageController) - Infinite paging controller.
* [SlideController](https://github.com/touchlane/SlideController) - It is a nice alternative for UIPageViewController built using power of generic types. Swipe between pages with an interactive title navigation control. Configure horizontal or vertical chains for unlimited pages amount.

#### Payment
[back to top](#readme) 

* [AnimatedCardInput](https://github.com/netguru/AnimatedCardInput) - Customisable and easy to use Credit Card UI.
* [Caishen](https://github.com/prolificinteractive/Caishen) - A Payment Card UI & Validator for iOS.
* [iCard](https://github.com/eliakorkmaz/iCard) - Bank Card Generator using SnapKit DSL.
* [MFCard](https://github.com/MobileFirstInc/MFCard) - Easily integrate Credit Card payments in iOS App.
* [TPInAppReceipt](https://github.com/tikhop/TPInAppReceipt) - A lightweight, pure-Swift library for reading and validating Apple In App Purchase Receipt locally.

#### Permissions
[back to top](#readme) 

* [AREK](https://github.com/ennioma/arek) - AREK is a clean and easy to use wrapper over any kind of iOS permission.
* [Permission](https://github.com/delba/Permission) - A unified API to ask for permissions on iOS.
* [SPPermission](https://github.com/sparrowcode/PermissionsKit) - Simple request permission with native UI and interactive animation.

#### Scroll Bars
[back to top](#readme) 

* [DMScrollBar](https://github.com/batanus/DMScrollBar) - Best in class customizable ScrollBar for any type of ScrollView with Decelerating, Bounce & Rubber band mechanisms and many many more.

#### StackView
[back to top](#readme) 

* [StackViewController](https://github.com/seedco/StackViewController) - Simplify the use of UIStackView.
* [TZStackView](https://github.com/tomvanzummeren/TZStackView) - An iOS9 UIStackView layout component re-implemented for iOS 7 and 8.

#### Switch
[back to top](#readme) 

* [MJMaterialSwitch](https://github.com/JaleelNazir/MJMaterialSwitch) - A Customizable Switch UI for iOS, Inspired from Google's Material Design.
* [paper-switch](https://github.com/Ramotion/paper-switch) - RAMPaperSwitch is a material design UI module which paints over the parent view when the switch is turned on.
* [Switch](https://github.com/T-Pham/Switch) - A switch control with full Interface Builder support.

#### Tab
[back to top](#readme) 

* [Adaptive Tab Bar](https://github.com/Ramotion/adaptive-tab-bar) - Adaptive tab bar.
* [Animated Tab Bar](https://github.com/Ramotion/animated-tab-bar) - RAMAnimatedTabBarController is a module for adding animation to tab bar items.
* [CardTabBar](https://github.com/yusadogru/CardTabBar) - Adding animation to iOS tabbar items.
* [CircleBar](https://github.com/softhausHQ/CircleBar) - A fun, easy-to-use tab bar navigation controller for iOS.
* [ColorMatchTabs](https://github.com/Yalantis/ColorMatchTabs) - Interesting way to display tabs.
* [DTPagerController](https://github.com/tungvoduc/DTPagerController) - Container view controller to display a set of ViewControllers in a horizontal scroll view.
* [ESTabBarController](https://github.com/eggswift/ESTabBarController) - A highly customizable TabBarController component, which is inherited from UITabBarController.
* [HHTabBarView](https://github.com/hemangshah/HHTabBarView) - A lightweight customized tab bar view.
* [PolioPager](https://github.com/YuigaWada/PolioPager) - A flexible TabBarController with search tab like SNKRS.
* [SwiftUIMaterialTabs](https://github.com/SwiftKickMobile/SwiftUIMaterialTabs) - Material 3-style tabs and Sticky Headers rolled into one SwiftUI library
* [TabBar](https://github.com/onl1ner/TabBar) - Highly customizable tab bar for SwiftUI applications.
* [Tabman](https://github.com/uias/Tabman) - A powerful paging view controller with indicator bar.
* [TabPageViewController](https://github.com/EndouMari/TabPageViewController) - Paging view controller and scroll tab view.

#### Template
[back to top](#readme) 

* [Stencil](https://github.com/stencilproject/Stencil) - Simple and powerful template language.
* [SwiftCssParser](https://github.com/100mango/SwiftCssParser) - Extensible CSS parser.
* [Temple](https://github.com/GoodRequest/Temple) - 🗂️ Most advanced project and file templates.

#### TextField
[back to top](#readme) 

* [CBPinEntryView](https://github.com/Fawxy/CBPinEntryView) - Easy to use, very customisable pin entry.
* [CHIOTPField](https://github.com/ChiliLabs/CHIOTPField) - A set of textfields that can be used for One-time passwords, SMS codes, PIN codes, etc.
* [DTTextField](https://github.com/iDhaval/DTTextField) - DTTextField is a custom textfield with floating placeholder and error label.
* [FloatingLabelTextFieldSwiftUI](https://github.com/kishanraja/FloatingLabelTextFieldSwiftUI) - FloatingLabelTextFieldSwiftUI is a small and lightweight SwiftUI framework written in completely SwiftUI (not using UIViewRepresentable) that allows to create beautiful and customisable floating label textfield!
* [HTYTextField](https://github.com/hanton/HTYTextField) - A UITextField with bouncy placeholder.
* [iTextField ⌨️](https://github.com/blsage/iTextField) - A fully-wrapped `UITextField` that works entirely in SwiftUI 🦅.
* [PasswordTextField](https://github.com/PiXeL16/PasswordTextField) - A custom TextField with a switchable icon which shows or hides the password and enforces good password policies.
* [SkyFloatingLabelTextField](https://github.com/Skyscanner/SkyFloatingLabelTextField) - A beautiful and flexible text field control implementation of "Float Label Pattern".
* [StyledTextKit](https://github.com/GitHawkApp/StyledTextKit) - Declarative building and fast rendering attributed string library.
* [TextFieldCounter](https://github.com/serralvo/TextFieldCounter) - UITextField character counter with lovable UX.
* [TextFieldEffects](https://github.com/raulriera/TextFieldEffects) - Several ready to use effects for UITextFields.
* [UITextField-Navigation](https://github.com/T-Pham/UITextField-Navigation) - UITextField-Navigation adds next, previous and done buttons to the keyboard for your UITextFields. Highly customizable.
* [VKPinCodeView](https://github.com/Sunspension/VKPinCodeView) - Simple and elegant UI component for input PIN.

#### Transition
[back to top](#readme) 

* [BubbleTransition](https://github.com/andreamazz/BubbleTransition) - Bubble transition in an easy way.
* [Cards XI](https://github.com/PaoloCuscela/Cards) - Awesome iOS 11 AppStore's Card Views.
* [EasyTransitions](https://github.com/marcosgriselli/EasyTransitions) - A simple way to create custom interactive UIViewController transitions.
* [Hero](https://github.com/HeroTransitions/Hero) - Elegant transition library for iOS.
* [ImageTransition](https://github.com/shtnkgm/ImageTransition) - ImageTransition is a library for smooth animation of images during transitions.
* [Jelly](https://github.com/SebastianBoldt/Jelly) - Jelly provides custom view controller transitions with just a few lines of code.
* [LiquidSwipe](https://github.com/exyte/LiquidSwipe) - Liquid navigation animation
* [MijickNavigattie](https://github.com/Mijick/NavigationView) - Easy navigation with SwiftUI.
* [MusicPlayerTransition](https://github.com/xxxAIRINxxx/MusicPlayerTransition) - Custom interactive transition like Apple Music iOS App.
* [NavigationTransitions](https://github.com/davdroman/swiftui-navigation-transitions) - Pure SwiftUI Navigation transitions.
* [PanSlip](https://github.com/k-lpmg/PanSlip) - Use PanGesture to dismiss view on UIViewController and UIView.
* [PinterestSwift](https://github.com/demonnico/PinterestSwift) - Pinterest style transition.
* [RevealingSplashView](https://github.com/PiXeL16/RevealingSplashView) - A Splash view that animates and reveals its content, inspired by the Twitter splash.
* [SamuraiTransition](https://github.com/hachinobu/SamuraiTransition) - Swift based library providing a collection of ViewController transitions featuring a number of neat cutting animations.
* [SPLarkController](https://github.com/ivanvorobei/SPLarkController) - Custom transition between two controller. Translate to top.
* [SPStorkController](https://github.com/ivanvorobei/SPStorkController) - Now playing controller from Apple Music. Customisable height.
* [StarWars.iOS](https://github.com/Yalantis/StarWars.iOS) - Transition animation to crumble view-controller into tiny pieces.
* [Transition](https://github.com/Touchwonders/Transition) - Easy interactive interruptible custom ViewController transitions.

#### 3D
[back to top](#readme) 

* [Insert3D](https://github.com/Viktoo/Insert3D) - The fastest 🚀 way to embed a 3D model.

#### UICollectionView
[back to top](#readme) 

* [ASCollectionView](https://github.com/abdullahselek/ASCollectionView) - Lightweight custom collection view inspired by Airbnb.
* [AZCollectionViewController](https://github.com/AfrozZaheer/AZCollectionViewController) - Easy way to integrate pagination with dummy views in CollectionView, make Instagram Discover withing minutes.
* [Blueprints](https://github.com/zenangst/Blueprints) - A framework that is meant to make your life easier when working with collection view flow layouts.
* [BouncyLayout](https://github.com/roberthein/BouncyLayout) - Collection view layout that makes your cells bounce.
* [CardsLayout](https://github.com/filletofish/CardsLayout) - Nice card-designed custom CollectionView layout.
* [CenteredCollectionView](https://github.com/BenEmdon/CenteredCollectionView) - A lightweight UICollectionViewLayout that pages and centers it's cells.
* [CheckmarkCollectionViewCell](https://github.com/yonat/CheckmarkCollectionViewCell) - UICollectionViewCell with checkbox when it isSelected and empty circle when not - like Photos.app 'Select' mode.
* [CollectionViewShelfLayout](https://github.com/pitiphong-p/CollectionViewShelfLayout) - A UICollectionViewLayout subclass displays its items as rows of items similar to the App Store Feature tab without a nested UITableView/UICollectionView hack.
* [CollectionViewSlantedLayout](https://github.com/yacir/CollectionViewSlantedLayout) - UICollectionViewLayout to show slanted content.
* [Drag and Drop UICollectionView](https://github.com/mmick66/KDDragAndDropCollectionView) - Dragging and Dropping data across multiple UICollectionViews.
* [FSPagerView](https://github.com/WenchaoD/FSPagerView) - Elegant Screen Slide Library. It is extremely helpful for making Banner View、Product Show、Welcome/Guide Pages、Screen/ViewController Sliders.
* [Gliding Collection](https://github.com/Ramotion/gliding-collection) - Gliding Collection is a smooth, flowing, customizable decision for a UICollectionView Controller.
* [GoodProvider](https://github.com/GoodRequest/GRProvider) - 🚀 UITableView and UICollectionView provider to simplify basic scenarios of showing the data.
* [GravitySlider](https://github.com/ApplikeySolutions/GravitySlider) - Beautiful alternative to the standard UICollectionView flow layout.
* [ShelfView-iOS](https://github.com/tdscientist/ShelfView-iOS) - iOS custom view to display books on shelf.
* [SimpleSource](https://github.com/Squarespace/simple-source ) - Easy and type-safe iOS table and collection views.
* [SwiftSpreadsheet](https://github.com/stuffrabbit/SwiftSpreadsheet) - Fully customizable spreadsheet CollectionViewLayout.
* [TagCellLayout](https://github.com/riteshhgupta/TagCellLayout) - UICollectionView layout for Tags with Left, Center & Right alignments.
* [UICollectionViewSplitLayout](https://github.com/yahoojapan/UICollectionViewSplitLayout) - UICollectionViewSplitLayout makes collection view more responsive.
* [VegaScroll](https://github.com/AppliKeySolutions/VegaScroll) - Lightweight animation flowlayout for UICollectionView.

#### UITableView
[back to top](#readme) 

* [AZTableViewController](https://github.com/AfrozZaheer/AZTableViewController) - Elegant and easy way to integrate pagination with placeholder views.
* [CollapsibleTableSectionViewController](https://github.com/jeantimex/CollapsibleTableSectionViewController) - A library to support collapsible sections in a table view.
* [DGElasticPullToRefresh](https://github.com/gontovnik/DGElasticPullToRefresh) - Elastic pull to refresh.
* [DiffableDataSources](https://github.com/ra1028/DiffableDataSources) - 💾 A library for backporting UITableView/UICollectionViewDiffableDataSource.
* [DTTableViewManager](https://github.com/DenTelezhkin/DTTableViewManager) - Protocol-oriented UITableView management, powered by generics and associated types.
* [ExpandableCell](https://github.com/younatics/ExpandableCell) - Fully refactored YNExapnadableCell with more concise, bug free. Easiest usage of expandable & collapsible cell for iOS. You can customize expandable UITableViewCell whatever you like. ExpandableCell is made because insertRows and deleteRows is hard to use. Just inheirt ExpandableDelegate.
* [FDTextFieldTableViewCell](https://github.com/fulldecent/FDTextFieldTableViewCell) - Adds a UITextField to the cell and places it correctly.
* [folding-cell](https://github.com/Ramotion/folding-cell) - Folding cell transition.
* [GridView](https://github.com/KyoheiG3/GridView) - Can be customized as a time table, spreadsheet, paging and more.
* [HGPlaceholders](https://github.com/HamzaGhazouani/HGPlaceholders) - Nice library to show placeholders and Empty States for any UITableView/UICollectionView in your project.
* [OKTableViewLiaison](https://github.com/okcupid/OKTableViewLiaison) - Framework to help you better manage UITableViews.
* [ParallaxHeader](https://github.com/romansorochak/ParallaxHeader) - Simple way to add parallax header to UIScrollView/UITableView.
* [Persei](https://github.com/Yalantis/Persei) - Animated top menu for UITableView / UICollectionView / UIScrollView.
* [PullToRefreshSwift](https://github.com/dekatotoro/PullToRefreshSwift) - PullToRefresh library.
* [QuickTableViewController](https://github.com/bcylin/QuickTableViewController) - A simple way to create a UITableView for settings.
* [ReverseExtension](https://github.com/marty-suzuki/ReverseExtension) - UITableView extension that enables the insertion of cells the from bottom of a table view.
* [SelectionList](https://github.com/yonat/SelectionList) - Simple single-selection or multiple-selection checklist, based on UITableView.
* [Shoyu](https://github.com/xai3/Shoyu) - Easier way to represent the structure of UITableView.
* [SwiftyComments](https://github.com/tsucres/SwiftyComments) - Nested hierarchy of expandable/collapsible cells to easily build elegant discussion threads.
* [SwipeCellKit](https://github.com/SwipeCellKit/SwipeCellKit) - Swipeable UITableViewCell based on the stock Mail.app.
* [WLEmptyState](https://github.com/WizelineLabs/WLEmptyState) - A component that lets you customize the view when the dataset of UITableView is empty.
* [YNExpandableCell](https://github.com/younatics/YNExpandableCell) - Awesome expandable, collapsible tableview cell for iOS.

#### Walkthrough
[back to top](#readme) 

* [AwesomeSpotlightView](https://github.com/aleksandrshoshiashvili/AwesomeSpotlightView) - Create tutorial or coach tour.
* [BWWalkthrough](https://github.com/ariok/BWWalkthrough) - A class to build custom walkthroughs for your iOS App.
* [ConcentricOnboarding](https://github.com/exyte/ConcentricOnboarding) - SwiftUI library for a walkthrough or onboarding flow with tap actions.
* [Gecco](https://github.com/xai3/Gecco) - Spotlight view for iOS.
* [Instructions](https://github.com/ephread/Instructions) - A library to create app walkthroughs and guided tours.
* [OnboardKit](https://github.com/NikolaKirev/OnboardKit) - Customisable user onboarding for your iOS app.
* [PaperOnboarding](https://github.com/Ramotion/paper-onboarding) - PaperOnboarding is a material design UI slider.
* [SuggestionsKit](https://github.com/AlphanumericCharactersOrSingleHyphenz/SuggestionsKit) - Library for educating users about features in app.
* [SwiftyOnboard](https://github.com/juanpablofernandez/SwiftyOnboard) - An iOS framework that allows developers to create beautiful onboarding experiences.
* [SwiftyWalkthrough](https://github.com/ruipfcosta/SwiftyWalkthrough) - The easiest way to create a great walkthrough experience in your apps.

### Utility
*Some interesting utilities to help you in your projects* [back to top](#readme) 

* [AlexaSkillsKit](https://github.com/choefele/AlexaSkillsKit) - Develop custom Alexa Skills.
* [ApplyStyleKit](https://github.com/shindyu/ApplyStyleKit) - Elegantly, Apply style to UIKit using Method Chain.
* [Basis](https://github.com/typelift/Basis) - Pure Declarative Programming.
* [Bow](https://github.com/bow-swift/bow) - Companion library for Typed Functional Programming.
* [CallbackURLKit](https://github.com/phimage/CallbackURLKit) - Implementation of x-callback-url (Inter app communication).
* [Closures](https://github.com/vhesener/Closures) - Swifty closures for UIKit and Foundation.
* [Codextended](https://github.com/JohnSundell/Codextended) - Extensions giving Codable API type inference super powers.
* [Curry](https://github.com/thoughtbot/Curry) - Function currying.
* [Delegated](https://github.com/dreymonde/Delegated) - Closure-based delegation without memory leaks.
* [DifferenceKit](https://github.com/ra1028/DifferenceKit) - 💻 A fast and flexible O(n) difference algorithm framework.
* [Differific](https://github.com/zenangst/Differific) - A fast and convenient diffing framework.
* [Dollar](https://github.com/ankurp/Dollar) - Similar to Lo-Dash or Underscore in Javascript.
* [DuctTape](https://github.com/marty-suzuki/DuctTape) - 📦 KeyPath dynamicMemberLookup based syntax sugar for Swift.
* [EtherWalletKit](https://github.com/SteadyAction/EtherWalletKit) - Ethereum Wallet Toolkit for iOS - You can implement Ethereum wallet without a server and blockchain knowledge.
* [ExceptionCatcher](https://github.com/sindresorhus/ExceptionCatcher) - Catch Objective-C exceptions.
* [EZSwiftExtensions](https://github.com/Esqarrouth/EZSwiftExtensions) - How standard types and classes were supposed to work.
* [FlagAndCountryCode](https://github.com/exyte/FlagAndCountryCode) - FlagAndCountryCode provides phone codes and flags for every country. Works on UIKit and SwiftUI
* [FluentQuery](https://github.com/MihaelIsaev/FluentQuery) :penguin: - Powerful and easy to use Query Builder.
* [GoodExtensions-iOS](https://github.com/GoodRequest/GoodExtensions-iOS) - 📑 GoodExtensions is a collection of useful and frequently used extensions.
* [GoodUIKit](https://github.com/GoodRequest/GoodUIKit) - 📑 GoodUIKit is an extensions library filled with reusable UI snippets for faster and more efficient development.
* [Highlighter](https://github.com/younatics/Highlighter) - Highlight whatever you want! Highlighter will magically find UI objects such as UILabel, UITextView, UITexTfield, UIButton in your UITableViewCell or other Class.
* [LifetimeTracker](https://github.com/krzysztofzablocki/LifetimeTracker) - Surface retain cycle / memory issues right as you develop your application.
* [Lumos](https://github.com/sushinoya/Lumos) - An easy-to-use API for Objective-C runtime functions.
* [ObjectiveKit](https://github.com/marmelroy/ObjectiveKit) - API for Objective C runtime functions.
* [OpenSourceController](https://github.com/floriangbh/OpenSourceController) - The simplest way to display the librarie's licences used in your application.
* [Percentage](https://github.com/sindresorhus/Percentage) - Make percentages more readable and type-safe.
* [Periphery](https://github.com/peripheryapp/periphery) - A tool to identify unused code in Swift projects.
* [Playbook](https://github.com/playbook-ui/playbook-ios) - 📘A library for isolated developing UI components and automatically snapshots of them.
* [PrivacyFlash Pro](https://github.com/privacy-tech-lab/privacyflash-pro) - Generate a privacy policy for your Swift iOS app from its code.
* [protobuf-swift](https://github.com/alexeyxo/protobuf-swift) - ProtocolBuffers.
* [Prototope](http://khan.github.io/Prototope/) - Library of lightweight interfaces for prototyping, bridged to JS.
* [R.swift](https://github.com/mac-cain13/R.swift) - Tool to get strong typed, autocompleted resources like images, cells and segues.
* [RandomKit](https://github.com/nvzqz/RandomKit/) :penguin: - Random data generation.
* [ReadabilityKit](https://github.com/exyte/ReadabilityKit) - Preview extractor for news, articles and full-texts.
* [ReerKit](https://github.com/reers/ReerKit) - Powerful Swift foundation library of extensions and providing utility functions to supercharge your iOS/macOS/Linux development workflow.
* [ResourceKit](https://github.com/bannzai/ResourceKit) - Enable autocomplete use resources.
* [Result](https://github.com/antitypical/Result) - Type modelling the success/failure of arbitrary operations.
* [Rugby](https://github.com/swiftyfinch/Rugby) - 🏈 Cache CocoaPods for faster rebuild and indexing Xcode project.
* [Runes](https://github.com/thoughtbot/Runes) - Functional operators: flatMap, map, apply.
* [Solar](https://github.com/ceeK/Solar) - Calculate sunrise and sunset times given a location.
* [SpriteKit+Spring](https://github.com/ataugeron/SpriteKit-Spring) - SpriteKit API reproducing UIView's spring animations with SKAction.
* [Sugar](https://github.com/hyperoslo/Sugar) - Something sweet that goes great with your Cocoa.
* [swift-protobuf](https://github.com/apple/swift-protobuf) :penguin: - A plugin and runtime library for using Google's Protocol Buffer.
* [SwiftAutoGUI](https://github.com/NakaokaRei/SwiftAutoGUI) - Used to programmatically control the mouse & keyboard. A library for manipulating macOS with Swift.
* [SwiftBoost](https://github.com/sparrowcode/SwiftBoost) - Collection of Swift-extensions to boost development process.
* [Swiftbot](https://github.com/noppefoxwolf/Swiftbot) - run swift code on slack.
* [SwifterSwift](https://github.com/SwifterSwift/SwifterSwift) - A handy collection of more than 500 native extensions to boost your productivity.
* [SwiftGen-Storyboard](https://github.com/SwiftGen/SwiftGen#uistoryboard) - A tool to auto-generate `enums` for all your Storyboards, Scenes and Segues constants + appropriate convenience accessors.
* [SwiftLinkPreview](https://github.com/LeonardoCardoso/SwiftLinkPreview) - It makes a preview from an url, grabbing all information such as title, relevant texts and images.
* [SwiftPlantUML](https://github.com/MarcoEidinger/SwiftPlantUML) - A command-line tool and Swift Package to generate UML class from your Swift source code. Also available as Xcode Source Editor Extension.
* [SwiftRandom](https://github.com/thellimist/SwiftRandom) - A tiny generator of random data.
* [SwiftRater](https://github.com/takecian/SwiftRater) - A utility that reminds your iPhone app's users to review the app.
* [SwiftTweaks](https://github.com/bryanjclark/SwiftTweaks) - Tweak your iOS app without recompiling.
* [Swiftx](https://github.com/typelift/Swiftx) - Functional data types and functions for any project.
* [SwiftyUtils](https://github.com/tbaranes/SwiftyUtils) - All the reusable code that we need in each project.
* [Swiftz](https://github.com/typelift/Swiftz) - Functional programming.
* [Then](https://github.com/devxoul/Then) - Super sweet syntactic sugar for initializers.
* [TSAO](https://github.com/lilyball/swift-tsao) - Type-Safe Associated Objects.
* [URLQueryItemEncoder](https://github.com/pitiphong-p/URLQueryItemEncoder) - An Encoder for encoding any Encodable value into an array of URLQueryItem.
* [UTIKit](https://github.com/cockscomb/UTIKit) - an UTI (Uniform Type Identifier) wrapper.
* [Vaccine](https://github.com/zenangst/Vaccine) - Make your apps immune to recompile-decease.
* [WeakableSelf](https://github.com/vincent-pradeilles/weakable-self) - A micro-framework to encapsulate [weak self] and guard statements within closures.
* [WhatsNew](https://github.com/BalestraPatrick/WhatsNew) - Showcase new features after an app update similar to Pages, Numbers and Keynote.
* [WhatsNewKit](https://github.com/SvenTiigi/WhatsNewKit) - Showcase your awesome new app features.
* [XestiMonitors](https://github.com/eBardX/XestiMonitors) - An extensible monitoring framework.
* [ZamzamKit](https://github.com/basememara/ZamzamKit) - A collection of micro utilities and extensions for Standard Library, Foundation and UIKit.

### Validation
*A collection of validation libs.* [back to top](#readme) 

* [ATGValidator](https://github.com/altayer-digital/ATGValidator) - Rule based validation framework with form and card validation support for iOS.
* [FormValidatorSwift](https://github.com/ustwo/formvalidator-swift) - Allows you to validate inputs of text fields and text views in a convenient way.
* [Input Mask](https://github.com/RedMadRobot/input-mask-ios) - Pattern-based user input formatter, parser and validator for iOS.
* [RxValidator](https://github.com/vbmania/RxValidator) - Simple, Extensible, Flexible Validation Checker.
* [SwiftValidator](https://github.com/SwiftValidatorCommunity/SwiftValidator) - A rule-based validation library.
* [SwiftValidators](https://github.com/gkaimakas/SwiftValidators) - String validation for iOS (inspired by validator.js).
* [ValidatedPropertyKit](https://github.com/SvenTiigi/ValidatedPropertyKit) - Easily validate your Properties with Property Wrappers 👮.

#### Phone Numbers
*Libs to manage phone numbers.* [back to top](#readme) 

* [NKVPhonePicker](https://github.com/NikKovIos/NKVPhonePicker) - An UITextField subclass to simplify country code's picking.
* [PhoneNumberKit](https://github.com/marmelroy/PhoneNumberKit) - Framework for parsing, formatting and validating international phone numbers. Inspired by Google's libphonenumber.

### Version Manager
[back to top](#readme) 

* [AppVersionMonitor](https://github.com/eure/AppVersionMonitor) - Monitor iOS app version easily.
* [Siren](https://github.com/ArtSabintsev/Siren) - Notify users when a new version of your app is available and prompt them to upgrade.
* [Version](https://github.com/mrackwitz/Version) - Version represents and compares semantic versions.
* [Version Tracker Swift](https://github.com/tbaranes/VersionTrackerSwift) - Versions tracker for your iOS, OS X, and tvOS app.

### Video
[back to top](#readme) 

* [BMPlayer](https://github.com/BrikerMan/BMPlayer) - A video player for iOS, based on AVPlayer, support the horizontal, vertical screen. support adjust volume, brigtness and seek by slide.
* [Cabbage](https://github.com/VideoFlint/Cabbage) - A video composition framework build on top of AVFoundation.
* [Kitsunebi](https://github.com/noppefoxwolf/Kitsunebi) - Overlay alpha channel video animation player view using OpenGLES.
* [MMPlayerView](https://github.com/MillmanY/MMPlayerView) - Custom AVPlayerLayer on view and transition player with good effect like YouTube and Facebook.
* [MobilePlayer](https://github.com/sahin/mobileplayer-ios) - A powerful and completely customizable media player for iOS.
* [NextLevelSessionExporter](https://github.com/NextLevel/NextLevelSessionExporter) - Export and transcode media.
* [Player](https://github.com/piemonte/Player) - iOS video player, simple drop in component for playing and streaming media.
* [PlayerView](https://github.com/davidlondono/PlayerView) - Easy to use video player using a UIView, manage rate of reproduction, screenshots and callbacks-delegate for player state.
* [PryntTrimmerView](https://github.com/HHK1/PryntTrimmerView) - Trim and crop videos.
* [SwiftFFmpeg](https://github.com/sunlubo/SwiftFFmpeg) - A wrapper for the FFmpeg C API.
* [SwiftVideoBackground](https://github.com/dingwilson/SwiftVideoBackground) - Easy to Use UIView subclass for implementating a video background.
* [Swifty360Player](https://github.com/abdullahselek/Swifty360Player) - iOS 360-degree video player streaming from an AVPlayer.
* [YiVideoEditor](https://github.com/coderyi/YiVideoEditor) - a library for rotating, cropping, adding layers (watermark) and as well as adding audio (music) to the videos.

## Serverless

* [Azure Functions for Swift](https://github.com/SalehAlbuga/azure-functions-swift) :penguin: - Swift Worker for Azure Functions.


### Contributing

Please take a quick look at the [contribution guidelines](.github/CONTRIBUTING.md) first. If you see a package or project here that is no longer maintained or is not a good fit, please submit a pull request to improve this file. Thank you to all [contributors](https://github.com/matteocrippa/awesome-swift/graphs/contributors); you rock!!