// This file implements the IAsyncOperation Interface and Gateway for Python.
// Generated by makegw.py

#include "shell_pch.h"
#include "PyIAsyncOperation.h"

// @doc - This file contains autoduck documentation
// ---------------------------------------------------
//
// Interface Implementation

PyIAsyncOperation::PyIAsyncOperation(IUnknown *pdisp) : PyIUnknown(pdisp) { ob_type = &type; }

PyIAsyncOperation::~PyIAsyncOperation() {}

/* static */ IAsyncOperation *PyIAsyncOperation::GetI(PyObject *self)
{
    return (IAsyncOperation *)PyIUnknown::GetI(self);
}

// @pymethod |PyIAsyncOperation|SetAsyncMode|Description of SetAsyncMode.
PyObject *PyIAsyncOperation::SetAsyncMode(PyObject *self, PyObject *args)
{
    IAsyncOperation *pIAO = GetI(self);
    if (pIAO == NULL)
        return NULL;
    // @pyparm int|fDoOpAsync||Description for fDoOpAsync
    BOOL fDoOpAsync;
    if (!PyArg_ParseTuple(args, "i:SetAsyncMode", &fDoOpAsync))
        return NULL;
    HRESULT hr;
    PY_INTERFACE_PRECALL;
    hr = pIAO->SetAsyncMode(fDoOpAsync);

    PY_INTERFACE_POSTCALL;

    if (FAILED(hr))
        return PyCom_BuildPyException(hr, pIAO, IID_IAsyncOperation);
    Py_INCREF(Py_None);
    return Py_None;
}

// @pymethod bool|PyIAsyncOperation|GetAsyncMode|Description of GetAsyncMode.
PyObject *PyIAsyncOperation::GetAsyncMode(PyObject *self, PyObject *args)
{
    IAsyncOperation *pIAO = GetI(self);
    if (pIAO == NULL)
        return NULL;
    BOOL fIsOpAsync;
    if (!PyArg_ParseTuple(args, ":GetAsyncMode"))
        return NULL;
    HRESULT hr;
    PY_INTERFACE_PRECALL;
    hr = pIAO->GetAsyncMode(&fIsOpAsync);
    PY_INTERFACE_POSTCALL;
    if (FAILED(hr))
        return PyCom_BuildPyException(hr, pIAO, IID_IAsyncOperation);
    PyObject *rc = fIsOpAsync ? Py_True : Py_False;
    return rc;
}

// @pymethod |PyIAsyncOperation|StartOperation|Description of StartOperation.
PyObject *PyIAsyncOperation::StartOperation(PyObject *self, PyObject *args)
{
    IAsyncOperation *pIAO = GetI(self);
    if (pIAO == NULL)
        return NULL;
    // @pyparm <o PyIBindCtx>|pbcReserved||Description for pbcReserved
    PyObject *obpbcReserved;
    IBindCtx *pbcReserved;
    if (!PyArg_ParseTuple(args, "O:StartOperation", &obpbcReserved))
        return NULL;
    BOOL bPythonIsHappy = TRUE;
    if (bPythonIsHappy &&
        !PyCom_InterfaceFromPyInstanceOrObject(obpbcReserved, IID_IBindCtx, (void **)&pbcReserved, TRUE /* bNoneOK */))
        bPythonIsHappy = FALSE;
    if (!bPythonIsHappy)
        return NULL;
    HRESULT hr;
    PY_INTERFACE_PRECALL;
    hr = pIAO->StartOperation(pbcReserved);
    if (pbcReserved)
        pbcReserved->Release();

    PY_INTERFACE_POSTCALL;

    if (FAILED(hr))
        return PyCom_BuildPyException(hr, pIAO, IID_IAsyncOperation);
    Py_INCREF(Py_None);
    return Py_None;
}

// @pymethod |PyIAsyncOperation|InOperation|Description of InOperation.
PyObject *PyIAsyncOperation::InOperation(PyObject *self, PyObject *args)
{
    IAsyncOperation *pIAO = GetI(self);
    if (pIAO == NULL)
        return NULL;
    BOOL fInAsyncOp;
    if (!PyArg_ParseTuple(args, ":InOperation"))
        return NULL;
    HRESULT hr;
    PY_INTERFACE_PRECALL;
    hr = pIAO->InOperation(&fInAsyncOp);
    PY_INTERFACE_POSTCALL;
    if (FAILED(hr))
        return PyCom_BuildPyException(hr, pIAO, IID_IAsyncOperation);
    PyObject *rc = fInAsyncOp ? Py_True : Py_False;
    return rc;
}

// @pymethod |PyIAsyncOperation|EndOperation|Description of EndOperation.
PyObject *PyIAsyncOperation::EndOperation(PyObject *self, PyObject *args)
{
    IAsyncOperation *pIAO = GetI(self);
    if (pIAO == NULL)
        return NULL;
    // @pyparm int|hResult||Description for hResult
    // @pyparm <o PyIBindCtx>|pbcReserved||Description for pbcReserved
    // @pyparm int|dwEffects||Description for dwEffects
    PyObject *obpbcReserved;
    HRESULT hResult;
    IBindCtx *pbcReserved;
    DWORD dwEffects;
    if (!PyArg_ParseTuple(args, "lOl:EndOperation", &hResult, &obpbcReserved, &dwEffects))
        return NULL;
    BOOL bPythonIsHappy = TRUE;
    if (bPythonIsHappy &&
        !PyCom_InterfaceFromPyInstanceOrObject(obpbcReserved, IID_IBindCtx, (void **)&pbcReserved, TRUE /* bNoneOK */))
        bPythonIsHappy = FALSE;
    if (!bPythonIsHappy)
        return NULL;
    HRESULT hr;
    PY_INTERFACE_PRECALL;
    hr = pIAO->EndOperation(hResult, pbcReserved, dwEffects);
    if (pbcReserved)
        pbcReserved->Release();

    PY_INTERFACE_POSTCALL;

    if (FAILED(hr))
        return PyCom_BuildPyException(hr, pIAO, IID_IAsyncOperation);
    Py_INCREF(Py_None);
    return Py_None;
}

// @object PyIAsyncOperation|Description of the interface
static struct PyMethodDef PyIAsyncOperation_methods[] = {
    {"SetAsyncMode", PyIAsyncOperation::SetAsyncMode, 1},      // @pymeth SetAsyncMode|Description of SetAsyncMode
    {"GetAsyncMode", PyIAsyncOperation::GetAsyncMode, 1},      // @pymeth GetAsyncMode|Description of GetAsyncMode
    {"StartOperation", PyIAsyncOperation::StartOperation, 1},  // @pymeth StartOperation|Description of StartOperation
    {"InOperation", PyIAsyncOperation::InOperation, 1},        // @pymeth InOperation|Description of InOperation
    {"EndOperation", PyIAsyncOperation::EndOperation, 1},      // @pymeth EndOperation|Description of EndOperation
    {NULL}};

PyComTypeObject PyIAsyncOperation::type("PyIAsyncOperation", &PyIUnknown::type, sizeof(PyIAsyncOperation),
                                        PyIAsyncOperation_methods, GET_PYCOM_CTOR(PyIAsyncOperation));
// ---------------------------------------------------
//
// Gateway Implementation
STDMETHODIMP PyGAsyncOperation::SetAsyncMode(
    /* [in] */ BOOL fDoOpAsync)
{
    PY_GATEWAY_METHOD;
    HRESULT hr = InvokeViaPolicy("SetAsyncMode", NULL, "i", fDoOpAsync);
    return hr;
}

STDMETHODIMP PyGAsyncOperation::GetAsyncMode(
    /* [out] */ BOOL *pfIsOpAsync)
{
    if (!pfIsOpAsync)
        return E_POINTER;
    PY_GATEWAY_METHOD;
    PyObject *result;
    HRESULT hr = InvokeViaPolicy("GetAsyncMode", &result);
    if (FAILED(hr))
        return hr;
    if (!PyLong_Check(result)) {
        PyErr_Format(PyExc_TypeError, "Result for GetAsyncMode must be a bool (got '%s')", Py_TYPE(result)->tp_name);
        hr = MAKE_PYCOM_GATEWAY_FAILURE_CODE("GetAsyncMode");
    }
    else
        // NOTE: MSDN says "VARIANT_TRUE/VARIANT_FALSE, but fails to work!
        *pfIsOpAsync = PyLong_AsLong(result) ? TRUE : FALSE;
    Py_DECREF(result);
    return hr;
}

STDMETHODIMP PyGAsyncOperation::StartOperation(
    /* [optional][unique][in] */ IBindCtx *pbcReserved)
{
    PY_GATEWAY_METHOD;
    PyObject *obpbcReserved;
    obpbcReserved = PyCom_PyObjectFromIUnknown(pbcReserved, IID_IBindCtx, TRUE);
    HRESULT hr = InvokeViaPolicy("StartOperation", NULL, "O", obpbcReserved);
    Py_XDECREF(obpbcReserved);
    return hr;
}

STDMETHODIMP PyGAsyncOperation::InOperation(
    /* [out] */ BOOL *pfInAsyncOp)
{
    if (!pfInAsyncOp)
        return E_POINTER;
    PY_GATEWAY_METHOD;
    PyObject *result;
    HRESULT hr = InvokeViaPolicy("InOperation", &result);
    if (FAILED(hr))
        return hr;
    if (!PyLong_Check(result)) {
        PyErr_Format(PyExc_TypeError, "Result for InOperation must be a bool (got '%s')", Py_TYPE(result)->tp_name);
        hr = MAKE_PYCOM_GATEWAY_FAILURE_CODE("InOperation");
    }
    else
        // NOTE: MSDN says "VARIANT_TRUE/VARIANT_FALSE, but fails to work!
        *pfInAsyncOp = PyLong_AsLong(result) ? TRUE : FALSE;
    Py_DECREF(result);
    return hr;
}

STDMETHODIMP PyGAsyncOperation::EndOperation(
    /* [in] */ HRESULT hResult,
    /* [unique][in] */ IBindCtx *pbcReserved,
    /* [in] */ DWORD dwEffects)
{
    PY_GATEWAY_METHOD;
    PyObject *obpbcReserved;
    obpbcReserved = PyCom_PyObjectFromIUnknown(pbcReserved, IID_IBindCtx, TRUE);
    HRESULT hr = InvokeViaPolicy("EndOperation", NULL, "lOl", hResult, obpbcReserved, dwEffects);
    Py_XDECREF(obpbcReserved);
    return hr;
}
