# Awesome CSS Learning [![Awesome](https://awesome.re/badge.svg)](https://awesome.re) <a href="https://developer.mozilla.org/docs/Web/CSS"><img src="https://upload.wikimedia.org/wikipedia/commons/d/d5/CSS3_logo_and_wordmark.svg" width="125" align="right" alt="CSS Logo"></a>

> An awesome list limited to the best CSS learning resources

This list is mainly about [CSS](https://developer.mozilla.org/docs/Web/CSS) – the language and the modules. Not about naming conventions, architecture paradigms, frameworks, pre-processors, post-processors, CSS-in-JS or other aspects of todays CSS ecosystem.

*Please read the [contribution guidelines](.github/contributing.md) before contributing.*

## Contents

- [CSS References](#css-references)
- [CSS in a nutshell](#css-in-a-nutshell)
- [Fundamental concepts](#fundamental-concepts)
- [CSS units](#css-units)
- [Selectors](#selectors)
- [Custom properties (aka CSS variables)](#custom-properties-aka-css-variables)
- [Layout](#layout)
- [Animation](#animation)
- [Related](#related)

---

## CSS References

- [codrops](https://tympanus.net/codrops/css_reference/) - An extensive CSS reference offering way more content than [MDN](https://developer.mozilla.org/en-US/docs/Web/CSS/Reference).
- [Can I use](https://caniuse.com) - Interactive browser support tables for CSS (and HTML5).

## CSS in a nutshell

- [Introduction to CSS](https://scrimba.com/g/gintrotocss) - This screencast series will teach you the basics of CSS in about one hour.

## Fundamental concepts

- [The cascade](https://developer.mozilla.org/en-US/docs/Web/CSS/Cascade) - This article explains what the cascade is and how this affects you.
- [Specificity and inheritance](https://www.smashingmagazine.com/2010/04/css-specificity-and-inheritance/) - Understanding specificity and inheritance is important to master CSS. This article will help.
- [CSS Box Model](https://developer.mozilla.org/en-US/docs/Learn/CSS/Introduction_to_CSS/Box_model) - An article explaining the foundation of layout on the web.
  - Also have a look at the detailed information about the [box-sizing](https://css-tricks.com/box-sizing/) property.
- [Responsive Design](https://web.dev/learn/design/) - Extensive information about all aspects of responsive design to make sites that look great and work well for everyone.

## CSS units

- [The Lengths of CSS](https://css-tricks.com/the-lengths-of-css/) - Overview covering absolute and relative units.
- [Fun with Viewport Units](https://css-tricks.com/fun-viewport-units/) - Imparts the basics and shows some nifty use-cases.

## Selectors

- [Basic CSS Selectors](https://www.sitepoint.com/css-selectors/) - An introduction to the very basic CSS selectors you need to know.
- [Advanced CSS Selectors](https://www.smashingmagazine.com/2009/08/taming-advanced-css-selectors/) - Level up your knowledge. From attribute selectors to CSS3 pseudo classes.
- [CSS Diner](https://flukeout.github.io) - Learn how to use CSS selectors with this fun little game.

## Custom properties (aka CSS variables)

- [CSS Variables: Why Should You Care?](https://developers.google.com/web/updates/2016/02/css-variables-why-should-you-care) - A short introduction to CSS variables.
- [Locally Scoped CSS Variables: What, How, and Why](https://una.im/local-css-vars/) - Describes the advantages of locally scoped CSS variables.
- [Using CSS variables correctly](https://www.madebymike.com.au/writing/using-css-variables/) - Patterns and anti-patterns for using CSS variables.
- [Everything you need to know about CSS Variables](https://medium.freecodecamp.org/everything-you-need-to-know-about-css-variables-c74d922ea855) - In depth article going beyond the basics of CSS Variables using real-world examples.
- [Getting Reactive with CSS](https://www.youtube.com/watch?v=4IRPxCMAIfA) - Mindblowing talk about the possibilities of the combination of CSS variables and functional reactive programming in JavaScript.

## Layout

- [Learn CSS Layout](http://book.mixu.net/css) - Learn about CSS layout techniques in 5 chapters.
- [Layout Land](https://www.youtube.com/channel/UC7TizprGknbDalbHplROtag) - Jen Simmons video series about the new CSS Layout possibilities.
- [Laying Out The Future With Grid And Flexbox](https://www.youtube.com/watch?v=hj355PRbwSQ) - Introduction of a new layout system encompassing Flexbox, CSS Grid and the Box Alignment Module.

### Classic layouting

- [Floats](https://tympanus.net/codrops/css_reference/float/) - In depth information about how to use (and clear) floats.
- [Positioning Types](https://scotch.io/bar-talk/5-things-you-might-not-know-about-the-css-positioning-types) - A closer look at a few little-known things related to the CSS positioning layout method.
- [inline-block](https://iamsteve.me/blog/entry/inline_block) - Shows in which cases it makes sense to use the display property `inline-block` for layouting.

### Flexbox

- [A Complete Guide to Flexbox](https://css-tricks.com/snippets/css/a-guide-to-flexbox/) - All you need to know about Flexbox on one page.
<!--lint ignore no-dead-urls-->
- [Flexbox playground](https://codepen.io/enxaneta/full/adLPwv) - Play with Flexbox examples on CodePen.
- [Flexbox Defense](http://www.flexboxdefense.com) - A tower defense game in the browser to learn about Flexbox with fun.
- [Flexbox Froggy](https://flexboxfroggy.com) - Learn all the basics of Flexbox with a fun game involving frogs and lily pads.
- [Flexbugs](https://github.com/philipwalton/flexbugs) - Community-curated list of flexbox issues and cross-browser workarounds for them.
- [Flexbox Zombies](https://flexboxzombies.com) - A training course driven by a storyline where you use Flexbox and a crossbow to hunt zombies.
- [What the Flexbox?](https://flexbox.io/) - A simple, free 20 video course that will help you master CSS Flexbox!

### Grid

- [A Complete Guide to Grid](https://css-tricks.com/snippets/css/complete-guide-grid/) - All you need to know about CSS Grid Layout on one page.
- [Grid by Example](https://gridbyexample.com) - Besides examples of how to use Grid, this site also has additional useful learning resources.
- [Designing with Grid](https://talks.jensimmons.com/J5VRbA/designing-with-grid) - Talk about the new layout possibilities CSS Grid is offering.
- [Grid Garden](https://cssgridgarden.com) - Lovely game where you write CSS code to grow your carrot garden.
- [GridBugs](https://github.com/rachelandrew/gridbugs) - Community-curated list of Grid interop issues and workarounds for them.
- [Grid Critters](https://www.gridcritters.com) - Learn CSS grid layout by mastering an adventure game.
- [CSS Grid](https://cssgrid.io) - Learn CSS grid with Wes Bos - Free 4 hours video course, 25 Videos.

## Animation

- [CSS Transitions and Transforms for Beginners](https://robots.thoughtbot.com/transitions-and-transforms) - An introduction to CSS transitions and CSS (2D) transforms.
- [All you need to know about CSS Transitions](https://blog.alexmaccaw.com/all-you-need-to-know-about-css-transitions/) - Also addressing advanced topics from chaining and events to hardware acceleration and animation functions.
- [CSS 3D transforms](https://3dtransforms.desandro.com) - Multi page tutorial with examples like card flip and carousel effects.
- [CSS Animation for Beginners](https://robots.thoughtbot.com/css-animation-for-beginners) - Imparts the concepts of CSS animations with keyframes.
- [animatable](http://leaverou.github.io/animatable/) - Nice little page demonstrating which CSS properties are animatable. 

---

## Related

[Awesome JavaScript Learning](https://github.com/micromata/awesome-javascript-learning) - A tiny list limited to the best JavaScript learning resources.
