# Awesome JavaScript Learning [![Awesome](https://awesome.re/badge.svg)](https://awesome.re) <img src="https://cdn.rawgit.com/voodootikigod/logo.js/master/js.svg" width="125" align="right" alt="JS Logo">

> An awesome list limited to the best JavaScript learning resources

This list is mainly about JavaScript - the language. Not about APIs, tooling, frameworks or other aspects of todays JavaScript ecosystem.

*Please read the [contribution guidelines](.github/contributing.md) before contributing.*

## Contents

- [JavaScript References](#javascript-references)
- [Articles & Tutorials](#articles--tutorials)
- [Free eBooks](#free-ebooks)
- [Books](#books)
- [Blogs](#blogs)
- [Videos](#videos)
- [Interactive learning](#interactive-learning)
- [ES6 and above](#es6-and-above)
- [DOM related](#dom-related)
- [Node.js](#nodejs)
- [Related](#related)

---

## JavaScript References

- [MDN](https://developer.mozilla.org/docs/Web/JavaScript/Reference) - Simply the most extensive and up to date language reference.
- [DevDocs](http://devdocs.io/javascript) - Search MDN comfortably. Even offline.
- [JavaScript Notes & Reference](https://wesbos.com/javascript) - Detailed reference with code examples. Divided into topics covering basic and advanced subjects.
- [Simplified JavaScript Jargon](http://jargon.js.org) - Glossary which explains all the buzzwords from the JavaScript eco system.
- [Functional Programming Jargon](https://functional.works-hub.com/blog/Functional-Programming-Jargon) - Explains terms used in functional programming in the JavaScript context.
- [ECMAScript® Language Specification](http://ecma-international.org/publications/standards/Ecma-262.htm) - The standard JavaScript is based on. Only for very advanced learners.

## Articles & Tutorials

### Overall Topics

- [A re-introduction to JavaScript*](https://developer.mozilla.org/en-US/docs/Web/JavaScript/A_re-introduction_to_JavaScript) - Compact introduction covering types, variables, operators, control structures, functions and closures.
- [JavaScript.info](http://javascript.info) - A modern tutorial from the basics to advanced topics with simple, but detailed explanations.
- [Glossary of Modern JavaScript Concepts: Part 1](https://auth0.com/blog/glossary-of-modern-javascript-concepts/) - Learn the fundamentals of functional programming, reactive programming, and functional reactive programming in JavaScript.
- [Glossary of Modern JavaScript Concepts: Part 2](https://auth0.com/blog/glossary-of-modern-javascript-concepts-part-2/) -  Explains concepts like scope and closures, data flow, change detection, components, compilation, tree shaking.
- [Robust Client-Side JavaScript](https://molily.de/robust-javascript/) - Guide focused on writing robust code by describing possible failures and explaining how to prevent them.

*\*MDN offers a lot of [other guides](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Guide) for every level of knowledge to dig deeper.*

### Single Topics

- [JavaScript Closures Demystified](https://www.sitepoint.com/javascript-closures-demystified/) - Covering closures. From basics to use cases. Has useful comments.
- [Understanding Hoisting](https://scotch.io/tutorials/understanding-hoisting-in-javascript) - Detailed explanation of the concept of hoisting in JavaScript.
- [Array operations](https://danmartensen.svbtle.com/javascripts-map-reduce-and-filter) - Covering the usefulness of Array's map, reduce, and filter methods.
- [Promises](http://www.sohamkamani.com/blog/2016/08/28/incremenal-tutorial-to-promises/) - Learning promises step by step.
- [Async/Await](https://hackernoon.com/6-reasons-why-javascripts-async-await-blows-promises-away-tutorial-c7ec10518dd9) - Tutorial showing the advantages of consuming Promises via async functions.
- [Pure functions](https://medium.com/javascript-scene/master-the-javascript-interview-what-is-a-pure-function-d1c076bec976) - Answers the question »What is a Pure Function?« epicly.
- [Using Fetch](https://developer.mozilla.org/en-US/docs/Web/API/Fetch_API/Using_Fetch) - Describes thoroughly how to use the Fetch API to receive and send data. 
- [Chrome DevTools](https://developers.google.com/web/tools/chrome-devtools/) - Everything you need to know about the debugging tools built into Google Chrome.

## Free eBooks

- [Eloquent JavaScript](http://eloquentjavascript.net) - Covering the language and runtime specifics.
- [You Don't Know JS (book series)](https://github.com/getify/You-Dont-Know-JS) - Series of books diving deep into language.
- [Speaking JavaScript](http://speakingjs.com) - In-depth guide beginning with the basics.
- [JavaScript Design Patterns](http://addyosmani.com/resources/essentialjsdesignpatterns/book/) - Classical and JavaScript specific design patterns.
- [Mostly Adequate Guide to Functional Programming](https://mostly-adequate.gitbooks.io/mostly-adequate-guide/) - Excellent primer to functional programming using JavaScript.
- [Functional-Light JavaScript](https://github.com/getify/Functional-Light-JS) - This book explores the core principles of functional programming (FP) as they are applied to JavaScript.

## Books

Thin books which you can get through in a few days.

- [JavaScript: The Good Parts](http://shop.oreilly.com/product/9780596517748.do) - Classic material which still has relevance.
- [The Principles of Object-Oriented JavaScript](https://www.nostarch.com/oojs) - Comprehensible, especially interesting for people with a class based OOP background.
- [JavaScript Enlightenment](http://shop.oreilly.com/product/0636920027713.do) - Will solidify your understanding of the language.
- [Testing JavaScript Applications](https://www.manning.com/books/testing-javascript-applications) - A complete guide for JavaScript testing tools and techniques.
- [The Joy of JavaScript](https://www.manning.com/books/the-joy-of-javascript) - A book covering advanced language features like Iterators and Generators.

## Blogs

- [②ality](http://www.2ality.com) - Language features and APIs well explained by author and trainer Dr. Axel Rauschmayer.
- [Pony Foo](https://ponyfoo.com) - Detailed and high quality posts from Nicolás Bevacqua all related to JavaScript.

## Videos
<!--lint ignore no-repeat-punctuation-->
- [== ? === ??? ...#@^%](https://www.youtube.com/watch?v=qGyqzN0bjhc) - Basic talk about type coercion and strict type comparison.
- [FunFunFunction](https://www.youtube.com/channel/UCO1cgjhGzsSYb1rsB4bFe4Q) - Educational plus entertaining YouTube show covering language features as well as architectural topics amongst others. 
- [What the heck is the event loop anyway?](http://latentflip.com/loupe/?code=JC5vbignYnV0dG9uJywgJ2NsaWNrJywgZnVuY3Rpb24gb25DbGljaygpIHsKICAgIHNldFRpbWVvdXQoZnVuY3Rpb24gdGltZXIoKSB7CiAgICAgICAgY29uc29sZS5sb2coJ1lvdSBjbGlja2VkIHRoZSBidXR0b24hJyk7ICAgIAogICAgfSwgMjAwMCk7Cn0pOwoKY29uc29sZS5sb2coIkhpISIpOwoKc2V0VGltZW91dChmdW5jdGlvbiB0aW1lb3V0KCkgewogICAgY29uc29sZS5sb2coIkNsaWNrIHRoZSBidXR0b24hIik7Cn0sIDUwMDApOwoKY29uc29sZS5sb2coIldlbGNvbWUgdG8gbG91cGUuIik7!!!PGJ1dHRvbj5DbGljayBtZSE8L2J1dHRvbj4%3D) - Awesome talk about the way JavaScript works, and a tool for exploring the callstack.
- [Become a JavaScript Console Power-User](https://www.youtube.com/watch?v=4mf_yNLlgic) - Introduction to the browsers JavaScript console.
- [Debugging The Web](https://www.youtube.com/watch?v=HF1luRD4Qmk) - Learn state of the art in debugging using Chrome dev tools.
<!--lint ignore no-dead-urls-->
- [Promises Are So Passé](https://vimeo.com/181328943) - Talk that shows where async goes next, why it matters, and what you need to do to put it into practice today.
- [Learning Functional Programming with JavaScript](https://www.youtube.com/watch?v=e-5obm1G_FY) - Talk containing the best explanation of map/reduce.
- [Understand JavaScript's this Keyword in Depth](https://egghead.io/courses/understand-javascript-s-this-keyword-in-depth) - 18 minutes divided into 8 short videos to wrap you head around `this`.

## Interactive learning

- [Udacity Introduction to JavaScript](https://www.udacity.com/course/intro-to-javascript--cd2073) - They also offer more advanced courses.
- [Code School](https://www.codeschool.com/learn/javascript) - From Basics to Best Practices. Different courses related to JavaScript.
- [Functional programming](http://reactivex.io/learnrx/) - Learn basic principles of functional programming in an interactive way by using map, filter, concatAll, reduce and zip.
- [JavaScript30](https://javascript30.com) - Video course with 30 small and self-contained tutorials to build neat little things with plain JavaScript.
- [Learn JavaScript Online](https://learnjavascript.online) - Interactive JavaScript course with spaced repetiton flashcards app.
- [Exercism JavaScript Track](https://exercism.io/tracks/javascript) - Exercism provides individual practice and mentor-based learning for free.

## ES6 and above

- [Exploring ES6](http://exploringjs.com/es6.html) - Good introduction with in-depth chapters.
- [Exploring ES2016 and ES2017](http://exploringjs.com/es2016-es2017.html) - Follow up of »Exploring ES6«.
- [ES6 Overview](https://ponyfoo.com/articles/es6) - Bullet point overview including in-depth articles.
- [ES6 Katas](http://es6katas.org) - Learn ES6 by solving unit test online.
- [Practical ES6](https://github.com/mjavascript/practical-es6) - eBook with practical examples and advices.
- [30 seconds of code](https://github.com/Chalarangelo/30-seconds-of-code) - Useful ES6 snippets that you can understand in 30 seconds or less.
- [What's the difference between JavaScript and ECMAScript?](https://www.freecodecamp.org/news/whats-the-difference-between-javascript-and-ecmascript-cba48c73a2b5/) - Clears the confusion about ES6 and JavaScript.

## DOM related

- [DOM Enlightenment](https://domenlightenment.com/) - A whole book about how to access and manipulate the DOM without a library.
- [You Might Not Need jQuery](http://youmightnotneedjquery.com) - Get plain JavaScript code snippets (and see their jQuery equivalents).
- [Traversing the DOM with JavaScript](https://zellwk.com/blog/dom-traversals/) - A tutorial featuring native methods to traverse the DOM.

## Node.js

- [The Art of Node](https://github.com/maxogden/art-of-node#readme) - Introductory tutorial covering the basics. 
- [NodeSchool](https://nodeschool.io) - Interactive self guided workshops you can also do on your own.
- [Node Patterns](http://nodepatternsbooks.com) - Short books about code and networking patterns related to Node.js.
- [Learn Node](https://learnnode.com) - A premium training course to learn to build apps with Node.js, Express, MongoDB.

---

## Related

[Awesome CSS Learning](https://github.com/micromata/awesome-css-learning) - An awesome list limited to the best CSS learning resources.
