﻿// Visual Studio Shared Project
// Copyright(c) Microsoft Corporation
// All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the License); you may not use
// this file except in compliance with the License. You may obtain a copy of the
// License at http://www.apache.org/licenses/LICENSE-2.0
//
// THIS CODE IS PROVIDED ON AN  *AS IS* BASIS, WITHOUT WARRANTIES OR CONDITIONS
// OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION ANY
// IMPLIED WARRANTIES OR CONDITIONS OF TITLE, FITNESS FOR A PARTICULAR PURPOSE,
// MERCHANTABILITY OR NON-INFRINGEMENT.
//
// See the Apache Version 2.0 License for specific language governing
// permissions and limitations under the License.


namespace Microsoft.VisualStudioTools.Project {
    /// <summary>
    /// Represents a project element which lives on disk and is visible when Show All Files
    /// is enabled.
    /// </summary>
    sealed class AllFilesProjectElement : VirtualProjectElement {
        private string _itemType;

        public AllFilesProjectElement(string path, string itemType, CommonProjectNode project)
            : base(project) {
            Rename(path);
        }

        public override bool IsExcluded {
            get {
                return true;
            }
        }

        public new CommonProjectNode ItemProject {
            get {
                return (CommonProjectNode)base.ItemProject;
            }
        }

        protected override string ItemType {
            get {
                return _itemType;
            }
            set {
                _itemType = value;
                OnItemTypeChanged();
            }
        }
    }
}
