// Python Tools for Visual Studio
// Copyright(c) Microsoft Corporation
// All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the License); you may not use
// this file except in compliance with the License. You may obtain a copy of the
// License at http://www.apache.org/licenses/LICENSE-2.0
//
// THIS CODE IS PROVIDED ON AN  *AS IS* BASIS, WITHOUT WARRANTIES OR CONDITIONS
// OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION ANY
// IMPLIED WARRANTIES OR CONDITIONS OF TITLE, FITNESS FOR A PARTICULAR PURPOSE,
// MERCHANTABILITY OR NON-INFRINGEMENT.
//
// See the Apache Version 2.0 License for specific language governing
// permissions and limitations under the License.

using System.ComponentModel.Composition;
using Microsoft.VisualStudio.LanguageServer.Client;
using Microsoft.VisualStudio.Utilities;

namespace Microsoft.PythonTools {
    internal static class PythonCoreConstants {
        public const string ContentType = "Python";
        public const string ReplContentType = "PythonRepl";
        public const string BaseRegistryKey = "PythonTools";

        public const string LoggingRegistrySubkey = "Software\\Microsoft\\" + BaseRegistryKey + "\\Logging";

        [Export]
        [Name(ContentType)]
        [BaseDefinition(CodeRemoteContentDefinition.CodeRemoteContentTypeName)]
        internal static ContentTypeDefinition ContentTypeDefinition = null;

        [Export]
        [Name(ReplContentType)]
        [BaseDefinition(ContentType)]
        internal static ContentTypeDefinition ReplContentTypeDefinition = null;

        [Export]
        [FileExtension(".py")]
        [ContentType(ContentType)]
        internal static FileExtensionToContentTypeDefinition FileExtensionDefinition { get; set; }
    }
}
