﻿// Copyright (c) Microsoft. All rights reserved.

using System.Diagnostics.CodeAnalysis;
using System.Linq;
using System.Threading;
using System.Threading.Tasks;

namespace Microsoft.SemanticKernel.ImageToText;

/// <summary>
/// Class sponsor that holds extension methods for <see cref ="IImageToTextService" /> interface.
/// </summary>
[Experimental("SKEXP0001")]
public static class ImageToTextExtensions
{
    /// <summary>
    /// Get a single text generation result for the prompt and settings.
    /// </summary>
    /// <param name="imageToTextService">Image to text service</param>
    /// <param name="content">The image content to generate text from.</param>
    /// <param name="executionSettings">The AI execution settings (optional).</param>
    /// <param name="kernel">The <see cref="Kernel"/> containing services, plugins, and other state for use throughout the operation.</param>
    /// <param name="cancellationToken">The <see cref="CancellationToken"/> to monitor for cancellation requests. The default is <see cref="CancellationToken.None"/>.</param>
    /// <returns>The single text result generated by the remote model</returns>
    public static async Task<TextContent> GetTextContentAsync(
        this IImageToTextService imageToTextService,
        ImageContent content,
        PromptExecutionSettings? executionSettings = null,
        Kernel? kernel = null,
        CancellationToken cancellationToken = default)
        => (await imageToTextService.GetTextContentsAsync(content, executionSettings, kernel, cancellationToken).ConfigureAwait(false))
            .Single();
}
