﻿// Copyright (c) Microsoft. All rights reserved.

using System.Text.Json.Serialization;

namespace Microsoft.SemanticKernel.Connectors.Chroma;

/// <summary>
/// Chroma collection model.
/// </summary>
public class ChromaCollectionModel
{
    /// <summary>
    /// Identifier of collection generated by Chroma.
    /// </summary>
    [JsonPropertyName("id")]
    public string Id { get; set; } = string.Empty;

    /// <summary>
    /// Collection name provided by client.
    /// </summary>
    [JsonPropertyName("name")]
    public string Name { get; set; } = string.Empty;
}
