# Semantic Kernel Settings

## AI Service Settings used across SK

| Provider | Service | Constructor Settings | Environment Variable | Required? | Settings Class |
| --- | --- | --- | --- | --- | --- |
| OpenAI | [OpenAIChatCompletion](../../../semantic_kernel/connectors/ai/open_ai/services/open_ai_chat_completion.py) | ai_model_id, <br> api_key, <br> org_id | OPENAI_CHAT_MODEL_ID, <br> OPENAI_API_KEY, <br> OPENAI_ORG_ID | Yes, <br> Yes, <br> No | [OpenAISettings](../../../semantic_kernel/connectors/ai/open_ai/settings/open_ai_settings.py) |
|  | [OpenAITextCompletion](../../../semantic_kernel/connectors/ai/open_ai/services/open_ai_text_completion.py) | ai_model_id, <br> api_key, <br> org_id | OPENAI_TEXT_MODEL_ID, <br> OPENAI_API_KEY, <br> OPENAI_ORG_ID | Yes, <br> Yes, <br> No |  |
|  | [OpenAITextEmbedding](../../../semantic_kernel/connectors/ai/open_ai/services/open_ai_text_embedding.py) | ai_model_id, <br> api_key, <br> org_id | OPENAI_EMBEDDING_MODEL_ID, <br> OPENAI_API_KEY, <br> OPENAI_ORG_ID | Yes, <br> Yes, <br> No |  |
|  | [OpenAITextToImage](../../../semantic_kernel/connectors/ai/open_ai/services/open_ai_text_to_image.py) | ai_model_id, <br> api_key, <br> org_id | OPENAI_TEXT_TO_IMAGE_MODEL_ID, <br> OPENAI_API_KEY, <br> OPENAI_ORG_ID | Yes, <br> Yes, <br> No |  |
|  | [OpenAITextToAudio](../../../semantic_kernel/connectors/ai/open_ai/services/open_ai_text_to_audio.py) | ai_model_id, <br> api_key, <br> org_id | OPENAI_TEXT_TO_AUDIO_MODEL_ID, <br> OPENAI_API_KEY, <br> OPENAI_ORG_ID | Yes, <br> Yes, <br> No |  |
|  | [OpenAIAudioToText](../../../semantic_kernel/connectors/ai/open_ai/services/open_ai_audio_to_text.py) | ai_model_id, <br> api_key, <br> org_id | OPENAI_AUDIO_TO_TEXT_MODEL_ID, <br> OPENAI_API_KEY, <br> OPENAI_ORG_ID | Yes, <br> Yes, <br> No |  |
| Azure OpenAI | [AzureChatCompletion](../../../semantic_kernel/connectors/ai/open_ai/services/azure_chat_completion.py) | deployment_name, <br> api_key, <br> endpoint, <br> api_version, <br> base_url | AZURE_OPENAI_CHAT_DEPLOYMENT_NAME, <br> AZURE_OPENAI_API_KEY, <br> AZURE_OPENAI_ENDPOINT, <br> AZURE_OPENAI_API_VERSION, <br> AZURE_OPENAI_BASE_URL | Yes, <br> No, <br> Yes, <br> Yes, <br> Yes | [AzureOpenAISettings](../../../semantic_kernel/connectors/ai/open_ai/settings/azure_open_ai_settings.py) |
|  | [AzureTextEmbedding](../../../semantic_kernel/connectors/ai/open_ai/services/azure_text_embedding.py) | deployment_name, <br> api_key, <br> endpoint, <br> api_version, <br> base_url | AZURE_OPENAI_EMBEDDING_DEPLOYMENT_NAME, <br> AZURE_OPENAI_API_KEY, <br> AZURE_OPENAI_ENDPOINT, <br> AZURE_OPENAI_API_VERSION, <br> AZURE_OPENAI_BASE_URL | Yes, <br> No, <br> Yes, <br> Yes, <br> Yes |  |
|  | [AzureTextToImage](../../../semantic_kernel/connectors/ai/open_ai/services/azure_text_to_image.py) | deployment_name, <br> api_key, <br> endpoint | AZURE_OPENAI_TEXT_TO_IMAGE_DEPLOYMENT_NAME, <br> AZURE_OPENAI_API_KEY, <br> AZURE_OPENAI_ENDPOINT | Yes, <br> No, <br> Yes |  |
|  | [AzureTextToAudio](../../../semantic_kernel/connectors/ai/open_ai/services/azure_text_to_audio.py) | deployment_name, <br> api_key, <br> endpoint | AZURE_OPENAI_TEXT_TO_AUDIO_DEPLOYMENT_NAME, <br> AZURE_OPENAI_API_KEY, <br> AZURE_OPENAI_ENDPOINT | Yes, <br> No, <br> Yes |  |
|  | [AzureAudioToText](../../../semantic_kernel/connectors/ai/open_ai/services/azure_audio_to_text.py) | deployment_name, <br> api_key, <br> endpoint | AZURE_OPENAI_AUDIO_TO_TEXT_DEPLOYMENT_NAME, <br> AZURE_OPENAI_API_KEY, <br> AZURE_OPENAI_ENDPOINT | Yes, <br> No, <br> Yes |  |
| Azure AI Inference | [AzureAIInferenceChatCompletion](../../../semantic_kernel/connectors/ai/azure_ai_inference/services/azure_ai_inference_chat_completion.py) | ai_model_id, <br> api_key, <br> endpoint | N/A, <br> AZURE_AI_INFERENCE_API_KEY, <br> AZURE_AI_INFERENCE_ENDPOINT | Yes, <br> No, <br> Yes | [AzureAIInferenceSettings](../../../semantic_kernel/connectors/ai/azure_ai_inference/azure_ai_inference_settings.py) |
|  | [AzureAIInferenceTextEmbedding](../../../semantic_kernel/connectors/ai/azure_ai_inference/services/azure_ai_inference_text_embedding.py) | ai_model_id, <br> api_key, <br> endpoint | N/A, <br> AZURE_AI_INFERENCE_API_KEY, <br> AZURE_AI_INFERENCE_ENDPOINT | Yes, <br> No, <br> Yes |  |
| Anthropic | [AnthropicChatCompletion](../../../semantic_kernel/connectors/ai/anthropic/services/anthropic_chat_completion.py) | api_key, <br> ai_model_id | ANTHROPIC_API_KEY, <br> ANTHROPIC_CHAT_MODEL_ID | Yes, <br> Yes | [AnthropicSettings](../../../semantic_kernel/connectors/ai/anthropic/settings/anthropic_settings.py) |
| Bedrock | [BedrockChatCompletion](../../../semantic_kernel/connectors/ai/bedrock/services/bedrock_chat_completion.py) | model_id | BEDROCK_CHAT_MODEL_ID | Yes | [BedrockSettings](../../../semantic_kernel/connectors/ai/bedrock/bedrock_settings.py) |
|  | [BedrockTextCompletion](../../../semantic_kernel/connectors/ai/bedrock/services/bedrock_text_completion.py) | model_id | BEDROCK_TEXT_MODEL_ID | Yes |  |
|  | [BedrockTextEmbedding](../../../semantic_kernel/connectors/ai/bedrock/services/bedrock_text_embedding.py) | model_id | BEDROCK_EMBEDDING_MODEL_ID | Yes |  |
| Google AI | [GoogleAIChatCompletion](../../../semantic_kernel/connectors/ai/google/google_ai/services/google_ai_chat_completion.py) | gemini_model_id, <br> api_key | GOOGLE_AI_GEMINI_MODEL_ID, <br> GOOGLE_AI_API_KEY | Yes, <br> Yes | [GoogleAISettings](../../../semantic_kernel/connectors/ai/google/google_ai/google_ai_settings.py) |
|  | [GoogleAITextCompletion](../../../semantic_kernel/connectors/ai/google/google_ai/services/google_ai_text_completion.py) | gemini_model_id, <br> api_key | GOOGLE_AI_GEMINI_MODEL_ID, <br> GOOGLE_AI_API_KEY | Yes, <br> Yes |  |
|  | [GoogleAITextEmbedding](../../../semantic_kernel/connectors/ai/google/google_ai/services/google_ai_text_embedding.py) | embedding_model_id, <br> api_key | GOOGLE_AI_EMBEDDING_MODEL_ID, <br> GOOGLE_AI_API_KEY | Yes, <br> Yes |  |
| Vertex AI | [GoogleAIChatCompletion](../../../semantic_kernel/connectors/ai/google/google_ai/services/google_ai_chat_completion.py) | project_id, <br> region, <br> gemini_model_id | GOOGLE_AI_CLOUD_PROJECT_ID, <br> GOOGLE_AI_CLOUD_REGION, <br> GOOGLE_AI_GEMINI_MODEL_ID, <br> GOOGLE_AI_USE_VERTEXAI | Yes, <br> No, <br> Yes, <br> Yes (must set to true) | [GoogleAISettings](../../../semantic_kernel/connectors/ai/google/google_ai/google_ai_settings.py) |
|  | [GoogleAITextCompletion](../../../semantic_kernel/connectors/ai/google/google_ai/services/google_ai_text_completion.py) | project_id, <br> region, <br> gemini_model_id | GOOGLE_AI_CLOUD_PROJECT_ID, <br> GOOGLE_AI_CLOUD_REGION, <br> GOOGLE_AI_GEMINI_MODEL_ID, <br> GOOGLE_AI_USE_VERTEXAI | Yes, <br> No, <br> Yes, <br> Yes (must set to true) |  |
|  | [GoogleAITextEmbedding](../../../semantic_kernel/connectors/ai/google/google_ai/services/google_ai_text_embedding.py) | project_id, <br> region, <br> embedding_model_id | GOOGLE_AI_CLOUD_PROJECT_ID, <br> GOOGLE_AI_CLOUD_REGION, <br> GOOGLE_AI_EMBEDDING_MODEL_ID, <br> GOOGLE_AI_USE_VERTEXAI | Yes, <br> No, <br> Yes, <br> Yes (must set to true) |  |
| HuggingFace | [HuggingFaceTextCompletion](../../../semantic_kernel/connectors/ai/hugging_face/services/hf_text_completion.py) | ai_model_id | N/A | Yes | |
|  | [HuggingFaceTextEmbedding](../../../semantic_kernel/connectors/ai/hugging_face/services/hf_text_embedding.py) | ai_model_id | N/A | Yes | |
| NVIDIA NIM | [NvidiaChatCompletion](../../../semantic_kernel/connectors/ai/nvidia/services/nvidia_chat_completion.py) | ai_model_id, <br> api_key, <br> base_url | NVIDIA_CHAT_MODEL_ID, <br> NVIDIA_API_KEY, <br> NVIDIA_BASE_URL | Yes (default: meta/llama-3.1-8b-instruct), <br> Yes, <br> No | [NvidiaAISettings](../../../semantic_kernel/connectors/ai/nvidia/settings/nvidia_settings.py) |
|  | [NvidiaTextEmbedding](../../../semantic_kernel/connectors/ai/nvidia/services/nvidia_text_embedding.py) | ai_model_id, <br> api_key, <br> base_url | NVIDIA_API_KEY, <br> NVIDIA_TEXT_EMBEDDING_MODEL_ID, <br> NVIDIA_BASE_URL | Yes | [NvidiaAISettings](../../../semantic_kernel/connectors/ai/nvidia/settings/nvidia_settings.py) |
| Mistral AI | [MistralAIChatCompletion](../../../semantic_kernel/connectors/ai/mistral_ai/services/mistral_ai_chat_completion.py) | ai_model_id, <br> api_key | MISTRALAI_CHAT_MODEL_ID, <br> MISTRALAI_API_KEY | Yes, <br> Yes | [MistralAISettings](../../../semantic_kernel/connectors/ai/mistral_ai/settings/mistral_ai_settings.py) |
|  | [MistralAITextEmbedding](../../../semantic_kernel/connectors/ai/mistral_ai/services/mistral_ai_text_embedding.py) | ai_model_id, <br> api_key | MISTRALAI_EMBEDDING_MODEL_ID, <br> MISTRALAI_API_KEY | Yes, <br> Yes |  |
| Ollama | [OllamaChatCompletion](../../../semantic_kernel/connectors/ai/ollama/services/ollama_chat_completion.py) | ai_model_id, <br> host | OLLAMA_CHAT_MODEL_ID, <br> OLLAMA_HOST | Yes, <br> No | [OllamaSettings](../../../semantic_kernel/connectors/ai/ollama/ollama_settings.py) |
|  | [OllamaTextCompletion](../../../semantic_kernel/connectors/ai/ollama/services/ollama_text_completion.py) | ai_model_id, <br> host | OLLAMA_TEXT_MODEL_ID, <br> OLLAMA_HOST | Yes, <br> No |  |
|  | [OllamaTextEmbedding](../../../semantic_kernel/connectors/ai/ollama/services/ollama_text_embedding.py) | ai_model_id, <br> host | OLLAMA_EMBEDDING_MODEL_ID, <br> OLLAMA_HOST | Yes, <br> No |  |
| Onnx | [OnnxGenAIChatCompletion](../../../semantic_kernel/connectors/ai/onnx/services/onnx_gen_ai_chat_completion.py) | template, <br> ai_model_path | N/A, <br> ONNX_GEN_AI_CHAT_MODEL_FOLDER | Yes, <br> Yes | [OnnxGenAISettings](../../../semantic_kernel/connectors/ai/onnx/onnx_gen_ai_settings.py) |
|  | [OnnxGenAITextCompletion](../../../semantic_kernel/connectors/ai/onnx/services/onnx_gen_ai_text_completion.py) | ai_model_path | ONNX_GEN_AI_TEXT_MODEL_FOLDER | Yes |  |

## Agent Framework Settings used across SK

| Provider | Service | Constructor Settings | Environment Variable | Required? | Settings Class |
| --- | --- | --- | --- | --- | --- |
| OpenAI | [OpenAIAssistantAgent](../../../semantic_kernel/agents/open_ai/openai_assistant_agent.py) | ai_model_id, <br> api_key, <br> org_id | OPENAI_CHAT_MODEL_ID, <br> OPENAI_API_KEY, <br> OPENAI_ORG_ID | Yes, <br> Yes, <br> No | [OpenAISettings](../../../semantic_kernel/connectors/ai/open_ai/settings/open_ai_settings.py) |
|  | [OpenAIResponsesAgent](../../../semantic_kernel/agents/open_ai/openai_responses_agent.py) | ai_model_id, <br> api_key, <br> org_id | OPENAI_RESPONSES_MODEL_ID, <br> OPENAI_API_KEY, <br> OPENAI_ORG_ID | Yes, <br> Yes, <br> No | [OpenAISettings](../../../semantic_kernel/connectors/ai/open_ai/settings/open_ai_settings.py) |
| Azure OpenAI | [AzureAssistantAgent](../../../semantic_kernel/agents/open_ai/azure_assistant_agent.py) | deployment_name, <br> api_key, <br> endpoint, <br> api_version, <br> base_url | AZURE_OPENAI_CHAT_DEPLOYMENT_NAME, <br> AZURE_OPENAI_API_KEY, <br> AZURE_OPENAI_ENDPOINT, <br> AZURE_OPENAI_API_VERSION, <br> AZURE_OPENAI_BASE_URL | Yes, <br> No, <br> Yes, <br> Yes, <br> No | [AzureOpenAISettings](../../../semantic_kernel/connectors/ai/open_ai/settings/azure_open_ai_settings.py) |
|  | [AzureResponsesAgent](../../../semantic_kernel/agents/open_ai/azure_responses_agent.py) | deployment_name, <br> api_key, <br> endpoint, <br> api_version, <br> base_url | AZURE_OPENAI_RESPONSES_DEPLOYMENT_NAME, <br> AZURE_OPENAI_API_KEY, <br> AZURE_OPENAI_ENDPOINT, <br> AZURE_OPENAI_API_VERSION, <br> AZURE_OPENAI_BASE_URL | Yes, <br> No, <br> Yes, <br> Yes, <br> No | [AzureOpenAISettings](../../../semantic_kernel/connectors/ai/open_ai/settings/azure_open_ai_settings.py) |
| Azure AI | [AzureAIAgent](../../../semantic_kernel/agents/azure_ai/azure_ai_agent.py) | model_deployment_name, <br> endpoint, <br> agent_id, <br> bing_connection_id, <br> azure_ai_search_connection_id, <br> azure_ai_search_index_name, <br> api_version | AZURE_AI_AGENT_MODEL_DEPLOYMENT_NAME, <br> AZURE_AI_AGENT_ENDPOINT, <br> AZURE_AI_AGENT_AGENT_ID, <br> AZURE_AI_AGENT_BING_CONNECTION_ID, <br> AZURE_AI_AGENT_AZURE_AI_SEARCH_CONNECTION_ID, <br> AZURE_AI_AGENT_AZURE_AI_SEARCH_INDEX_NAME, <br> AZURE_AI_AGENT_API_VERSION | Yes, <br> Yes, <br> No, <br> No, <br> No, <br> No, <br> No | [AzureAIAgentSettings](../../../semantic_kernel/agents/azure_ai/azure_ai_agent_settings.py) |
| Bedrock | [BedrockAgent](../../../semantic_kernel/agents/bedrock/bedrock_agent.py) | agent_resource_role_arn, <br> foundation_model | BEDROCK_AGENT_AGENT_RESOURCE_ROLE_ARN, <br> BEDROCK_AGENT_FOUNDATION_MODEL | Yes, <br> Yes | [BedrockAgentSettings](../../../semantic_kernel/agents/bedrock/bedrock_agent_settings.py) |
| Copilot Studio | [CopilotStudioAgent](../../../semantic_kernel/agents/copilot_studio/copilot_studio_agent.py) | app_client_id, <br> tenant_id, <br> environment_id, <br> agent_identifier, <br> cloud, <br> copilot_agent_type, <br> custom_power_platform_cloud, <br> client_secret, <br> client_certificate, <br> user_assertion, <br> auth_mode | COPILOT_STUDIO_AGENT_APP_CLIENT_ID, <br> COPILOT_STUDIO_AGENT_TENANT_ID, <br> COPILOT_STUDIO_AGENT_ENVIRONMENT_ID, <br> COPILOT_STUDIO_AGENT_AGENT_IDENTIFIER, <br> COPILOT_STUDIO_AGENT_CLOUD, <br> COPILOT_STUDIO_AGENT_COPILOT_AGENT_TYPE, <br> COPILOT_STUDIO_AGENT_CUSTOM_POWER_PLATFORM_CLOUD, <br> COPILOT_STUDIO_AGENT_CLIENT_SECRET, <br> COPILOT_STUDIO_AGENT_CLIENT_CERTIFICATE, <br> COPILOT_STUDIO_AGENT_USER_ASSERTION, <br> COPILOT_STUDIO_AGENT_AUTH_MODE | No (varies by mode) | [CopilotStudioAgentSettings](../../../semantic_kernel/agents/copilot_studio/copilot_studio_agent_settings.py) |



## Memory Service Settings used across SK

| Provider | Service | Constructor Settings | Environment Variable | Required? | Settings Class |
| --- | --- | --- | --- | --- | --- |
| AstraDB | [AstraDBMemoryService](../../../semantic_kernel/connectors/memory/astradb/astradb_memory_store.py) | app_token, <br> db_id, <br> region, <br> keyspace | ASTRADB_APP_TOKEN, <br> ASTRADB_DB_ID, <br> ASTRADB_REGION, <br> ASTRADB_KEYSPACE | Yes, <br> Yes, <br> Yes, <br> Yes | [AstraDBSettings](../../../semantic_kernel/connectors/memory/astradb/astradb_settings.py) |
| Azure AI Search | [AzureAISearchMemoryService](../../../semantic_kernel/connectors/memory/azure_cognitive_search/azure_cognitive_search_memory_store.py) | api_key, <br> endpoint, <br> index_name | AZURE_AI_SEARCH_API_KEY, <br> AZURE_AI_SEARCH_ENDPOINT, <br> AZURE_AI_SEARCH_INDEX_NAME | No, <br> Yes, <br> No | [AzureAISearchSettings](../../../semantic_kernel/connectors/memory/azure_cognitive_search/azure_ai_search_settings.py) |
| Azure Cosmos DB | [AzureCosmosDBMemoryService](../../../semantic_kernel/connectors/memory/azure_cosmosdb/azure_cosmos_db_memory_store.py) | api, <br> connection_string | AZURE_COSMOS_DB_API, <br> AZURE_COSMOS_DB_CONNECTION_STRING or AZCOSMOS_CONNSTR | No, <br> No | [AzureCosmosDBSettings](../../../semantic_kernel/connectors/memory/azure_cosmosdb/azure_cosmosdb_settings.py) |
| Mongo DB Atlas | [MongoDBAtlasMemoryService](../../../semantic_kernel/connectors/memory/mongodb_atlas/mongodb_atlas_memory_store.py) | connection_string, <br> database_name, <br> index_name | MONGODB_ATLAS_CONNECTION_STRING, <br> MONGODB_ATLAS_DATABASE_NAME, <br> MONGODB_ATLAS_INDEX_NAME | Yes, <br> No, <br> No | [MongoDBAtlasSettings](../../../semantic_kernel/connectors/memory/mongodb_atlas/mongodb_atlas_settings.py) |
| Pinecone | [PineconeMemoryService](../../../semantic_kernel/connectors/memory/pinecone/pinecone_memory_store.py) | api_key | PINECONE_API_KEY | Yes | [PineconeSettings](../../../semantic_kernel/connectors/memory/pinecone/pinecone_settings.py) |
| Postgres | [PostgresMemoryService](../../../semantic_kernel/connectors/memory/postgres/postgres_memory_store.py) | connection_string | POSTGRES_CONNECTION_STRING | Yes | [PostgresSettings](../../../semantic_kernel/connectors/memory/postgres/postgres_settings.py) |
| Redis | [RedisMemoryService](../../../semantic_kernel/connectors/memory/redis/redis_memory_store.py) | connection_string | REDIS_CONNECTION_STRING | Yes | [RedisSettings](../../../semantic_kernel/connectors/memory/redis/redis_settings.py) |
| Weaviate | [WeaviateMemoryService](../../../semantic_kernel/connectors/memory/weaviate/weaviate_memory_store.py) | url, <br> api_key, <br> use_embed | WEAVIATE_URL, <br> WEAVIATE_API_KEY, <br> WEAVIATE_USE_EMBED | No, <br> No, <br> No | [WeaviateSettings](../../../semantic_kernel/connectors/memory/weaviate/weaviate_settings.py) |

## Other settings used

| Provider | Service | Constructor Settings | Environment Variable | Required? | Settings Class |
| --- | --- | --- | --- | --- | --- |
| Bing | [BingSearch](../../../semantic_kernel/connectors/search_engine/bing_connector.py) | api_key, <br> custom_config | BING_API_KEY, <br> BING_CUSTOM_CONFIG | No, <br> No | [BingSettings](../../../semantic_kernel/connectors/search_engine/bing_connector_settings.py) |
| Azure Container Apps Sessions | [ACASessionsPlugin](../../../semantic_kernel/core_plugins/sessions_python_tool/sessions_python_plugin.py) | pool_management_endpoint | ACA_POOL_MANAGEMENT_ENDPOINT | Yes | [ACASessionsSettings](../../../semantic_kernel/core_plugins/sessions_python_tool/sessions_python_settings.py) |
