---
status: approved
contact: eavanvalkenburg
date: 2024-04-08
deciders: eavanvalkenburg, markwallace, sergeymenshykh, sphenry
---

# Model Context Protocol integration

## Context and Problem Statement

[MCP](https://modelcontextprotocol.io/introduction) is rapidly gaining momentum as a standard for AI model interaction, and Semantic Kernel is well-positioned to leverage this trend. By integrating MCP, we can enhance the interoperability of our platform with other AI systems and tools, making it easier for developers to build applications that utilize multiple models and services.

This ADR will define the mapping of MCP concepts to Semantic Kernel concepts, this should provide a roadmap for the implementation of MCP in Semantic Kernel. Since MCP is actively being developed, this document will need to be updated as new concepts are added, or the practical implementation of the concepts changes.

## Design

The first high level concept is a `server` vs a `host`. A Server makes one or more capabilities available to any host, a host uses a Client to connect to a server, and allows the application to consume the capabilities of the server. The host can be a client to multiple servers, and a server can be hosted by multiple hosts.

## Design - Semantic Kernel as a Host

This means that we would like Semantic Kernel to be able to act as a host, and use the capabilities of a server. This is done by creating a plugin that uses the MCP SDK Clients to connect to a server, and exposes the capabilities of that server. 

### Concept mapping - Semantic Kernel as a (MCP)Host
| MCP Concept | Semantic Kernel Concept | Description |
| ----------- | ---------------------- | ----------- |
| [Server](https://modelcontextprotocol.io/docs/concepts/architecture) | Plugin | A server is exposed as a related set of functions, hence this maps to a plugin. |
| [Resources](https://modelcontextprotocol.io/docs/concepts/resources)   | Unclear | Since a resource is a very generic concept, it is likely to fit into any one SK Concept, but not all. We need to investigate this further. |
| [Prompts](https://modelcontextprotocol.io/docs/concepts/prompts) | External Prompt Rendering/Function call | A prompt is a capability that the developer of a server can create to allow a user a easier entry point to utilizing that server, it can contain a single sentence, that get's filled with the defined parameters, or a can be a set of messages back and forth, simulating a chat conversation, designed to jumpstart a certain outcome. This maps to a the rendering step of a PromptTemplate, but the server does the rendering, SK would consume that. The output is to be a list of PromptMessages (roughly equivalent to a list of ChatMessageContents), this can then be sent to a LLM for a completion, but it is unclear how this should work. |
| [Tools](https://modelcontextprotocol.io/docs/concepts/tools) | Function | A tool is a capability that the developer of a server can create to allow a user to utilize a certain functionality of the server. This maps to a function in Semantic Kernel, the most common way of using these is through function calling, so this maps nicely. This should include handling listChanged events. |
| [Sampling](https://modelcontextprotocol.io/docs/concepts/sampling) | get_chat_message_content | Sampling is a powerful MCP feature that allows servers to request LLM completions through the client, enabling sophisticated agentic behaviors while maintaining security and privacy. In other words, it would mean that the server sends a message to the SK host and the SK host calls a LLM with it. It does require mapping between the `ModelPreferences` and other details of the message between MCP and SK `PromptExecutionSettings` and service selectors. |
| [Roots](https://modelcontextprotocol.io/docs/concepts/roots) | Dependent on what context is available | Roots are a concept in MCP that define the boundaries where servers can operate. They provide a way for clients to inform servers about relevant resources and their locations, so SK should send the `roots` of the current context to the used server, it will depend on the specific context, for instance when using the FileIOPlugin for .Net this could be used. In Python we currently do not have this. |
| [Transports](https://modelcontextprotocol.io/docs/concepts/transports) | Different plugin implementations | SK should support all transports, and abstract away the differences between them. This means that the plugin should be able to use any transport, and the SK host should be able to use any transport, with just configuration changes. |
| [Completion](https://spec.modelcontextprotocol.io/specification/2025-03-26/server/utilities/completion/) | Unmapped | The completion for MCP is about completing the user input while typing, to auto-suggest the next character, for instance when entering a Resource URL. This is not a concept that we need to support in SK, a client built using SK can implement this. |
| [Progress](https://spec.modelcontextprotocol.io/specification/2025-03-26/basic/utilities/progress/) | Unmapped | The progress for MCP is about showing the progress of a long running task, this is not a concept that we need to support in SK, a client built using SK can implement this. |

## Design - Semantic Kernel as a Server
This means that we would like Semantic Kernel to be able to act as a server, and expose the capabilities of a Kernel and/or Agent to a host. 

### Concept mapping - Semantic Kernel as a Server
| MCP Concept | Semantic Kernel Concept | Description |
| ----------- | ---------------------- | ----------- |
| [Server](https://modelcontextprotocol.io/docs/concepts/architecture) | Kernel/Agent | A server is exposed as a related set of functions, so we can expose a single Kernel or a Agent as a MCP server, this can then be consumed by any compatible host. |
| [Resources](https://modelcontextprotocol.io/docs/concepts/resources)   | Unclear | Since a resource is a very generic concept, it is likely to fit into any one SK Concept, but not all. We need to investigate this further. |
| [Prompts](https://modelcontextprotocol.io/docs/concepts/prompts) | PromptTemplate | A prompt is a capability that the developer of the SK server can create to allow a user a easier entry point to utilizing that server, it can contain a single sentence, that get's filled with the defined parameters, or a can be a set of messages back and forth, simulating a chat conversation, designed to jumpstart a certain outcome. This maps to a PromptTemplate, but the output needs to be a list of PromptMessages (roughly equivalent to a list of ChatMessageContents), so some work is needed to enable this in a generic way. In this case the client asks for the prompt, supplying a set of arguments, those are then rendered by SK and turned into a list of ChatMessageContent, and then to a list of MCP PromptMessages. |
| [Tools](https://modelcontextprotocol.io/docs/concepts/tools) | Function | A tool is a capability that the developer of a server can create to allow a user to utilize a certain functionality of the server. This maps to a function in Semantic Kernel, the most common way of using these is through function calling, so this maps nicely. This should include listChanged events being emitted. |
| [Sampling](https://modelcontextprotocol.io/docs/concepts/sampling) | Unclear | Sampling is a powerful MCP feature that allows servers to request LLM completions through the client, enabling sophisticated agentic behaviors while maintaining security and privacy. In other words, it would mean that a SK server renders a prompt and then asks the client to use it's LLM's to do the completion, since this is a so core to SK it probably does not need to be mapped, as this is useful mostly for MCP servers, that do not interact with LLM's themselves. |
| [Roots](https://modelcontextprotocol.io/docs/concepts/roots) | Unclear | Roots are a concept in MCP that define the boundaries where servers can operate. They provide a way for clients to inform servers about relevant resources and their locations, so SK should send the `roots` of the current context to the used server, it is unclear how to map this at this time. |
| [Transports](https://modelcontextprotocol.io/docs/concepts/transports) | Language specific | For python, the SDK makes sure to unify the interaction and then host those interactions in one of the transport types, so no need to specify this in SK itself. |
| [Completion](https://spec.modelcontextprotocol.io/specification/2025-03-26/server/utilities/completion/) | Unmapped | The completion for MCP is about completing the user input while typing, to auto-suggest the next character, for instance when entering a Resource URL or a Prompt reference. For both it depends on what kind of support we will have for Prompt and Resources, but if we support them we should also support completions for them OOTB. |
| [Logging](https://spec.modelcontextprotocol.io/specification/2025-03-26/server/utilities/logging/) | Built-in loggers | The MCP logging is a way to log the interactions between the client and the server, we should probably add logging handlers by default, that can be set and changed by the client/host. |
| [Progress](https://spec.modelcontextprotocol.io/specification/2025-03-26/basic/utilities/progress/) | Unmapped | The progress for MCP is about showing the progress of a long running task, this might become interesting for Agents or Processes, that go off and do more complex long-running task, so providing updates to the client makes the experience better. Unclear how to implement this. |

