// Licensed to the LF AI & Data foundation under one
// or more contributor license agreements. See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership. The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License. You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

#pragma once

#ifdef __cplusplus
extern "C" {
#endif

typedef struct LoadResourceRequest {
    uint64_t max_memory_cost;    //memory cost (in bytes) during loading
    uint64_t max_disk_cost;      // disk cost (in bytes) during loading
    uint64_t final_memory_cost;  // final memory (in bytes) cost after loading
    uint64_t final_disk_cost;    // final disk cost (in bytes) after loading
    bool has_raw_data;           // the filed contains raw data or not
} LoadResourceRequest;

#ifdef __cplusplus
}
#endif
