// Licensed to the LF AI & Data foundation under one
// or more contributor license agreements. See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership. The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License. You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
#pragma once

#include <unistd.h>
#include <memory>
#include <string>
#include <vector>

#include "common/FieldData.h"

namespace milvus {

struct FieldDataInfo {
    FieldDataInfo() {
        arrow_reader_channel = std::make_shared<ArrowReaderChannel>();
    }

    FieldDataInfo(int64_t field_id,
                  size_t row_count,
                  std::string mmap_dir_path = "",
                  bool in_load_list = false)
        : field_id(field_id),
          row_count(row_count),
          mmap_dir_path(std::move(mmap_dir_path)),
          in_load_list(in_load_list) {
        arrow_reader_channel = std::make_shared<ArrowReaderChannel>();
    }

    FieldDataInfo(int64_t field_id,
                  int64_t main_field_id,
                  size_t row_count,
                  std::string mmap_dir_path = "",
                  bool in_load_list = false)
        : field_id(field_id),
          row_count(row_count),
          main_field_id(main_field_id),
          mmap_dir_path(std::move(mmap_dir_path)),
          in_load_list(in_load_list) {
        arrow_reader_channel = std::make_shared<ArrowReaderChannel>();
    }

    int64_t field_id;
    int64_t main_field_id{INVALID_FIELD_ID};  // used for json stats only
    size_t row_count;
    std::string mmap_dir_path{};
    std::shared_ptr<ArrowReaderChannel> arrow_reader_channel;
    bool in_load_list{false};
};
}  // namespace milvus
