// Licensed to the LF AI & Data foundation under one
// or more contributor license agreements. See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership. The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License. You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package components

import (
	"context"

	"github.com/milvus-io/milvus/internal/distributed/streamingnode"
	"github.com/milvus-io/milvus/internal/util/dependency"
	"github.com/milvus-io/milvus/pkg/v2/util/typeutil"
)

type StreamingNode struct {
	*streamingnode.Server
}

// NewStreamingNode creates a new StreamingNode
func NewStreamingNode(ctx context.Context, factory dependency.Factory) (*StreamingNode, error) {
	svr, err := streamingnode.NewServer(ctx, factory)
	if err != nil {
		return nil, err
	}
	return &StreamingNode{
		Server: svr,
	}, nil
}

func (q *StreamingNode) GetName() string {
	return typeutil.StreamingNodeRole
}
