// Licensed to the LF AI & Data foundation under one
// or more contributor license agreements. See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership. The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License. You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

#ifdef __cplusplus
extern "C" {
#endif

#include <stdint.h>
#include <stdlib.h>

#include "common/type_c.h"

typedef void* CBinarySet;

CStatus
NewBinarySet(CBinarySet* c_binary_set);

void
DeleteBinarySet(CBinarySet c_binary_set);

CStatus
AppendIndexBinary(CBinarySet c_binary_set,
                  void* index_binary,
                  int64_t index_size,
                  const char* c_index_key);

int
GetBinarySetSize(CBinarySet c_binary_set);

void
GetBinarySetKeys(CBinarySet c_binary_set, void* data);

int
GetBinarySetValueSize(CBinarySet c_set, const char* key);

// Note: the memory of data has been allocated outside
CStatus
CopyBinarySetValue(void* data, const char* key, CBinarySet c_set);

#ifdef __cplusplus
}
#endif
