// Licensed to the LF AI & Data foundation under one
// or more contributor license agreements. See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership. The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License. You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package metric

import "strings"

// PositivelyRelated returns true if the metric type is positively related,
// meaning higher scores indicate better similarity.
func PositivelyRelated(metricType string) bool {
	mUpper := strings.ToUpper(metricType)
	return mUpper == strings.ToUpper(IP) ||
		mUpper == strings.ToUpper(COSINE) ||
		mUpper == strings.ToUpper(BM25) ||
		mUpper == strings.ToUpper(MHJACCARD) ||
		mUpper == strings.ToUpper(MaxSim) ||
		mUpper == strings.ToUpper(MaxSimIP) ||
		mUpper == strings.ToUpper(MaxSimCosine)
}
