# Contributing to Mindsdb

Being part of the core MindsDB team is accessible to anyone who is motivated and wants to be part of that journey!

Please see below how to contribute to the project, also refer to the contributing documentation.

## How can you help us?

* Report a bug
* Improve documentation
* Discuss the code implementation
* Submit a bug fix
* Propose new features
* Test Mindsdb

## Code contributions

In general, we follow the "fork-and-pull" Git workflow.
1. Fork the Mindsdb repository
2. Clone the repository
3. Make changes and commit them
4. Push your local branch to your fork
5. Submit a Pull request so that we can review your changes
6. Write a commit message
7. Make sure that the CI tests are GREEN

> NOTE: Be sure to merge the latest from "upstream" before making a pull request! Also, make the PR to the `main` branch.

## Feature and Bug reports
We use GitHub issues to track bugs and features. Report them by opening a [new issue](https://github.com/mindsdb/mindsdb/issues/new/choose) and fill out all of the required inputs.

## Code review process

The Pull Request reviews are done on a regular basis. Please, make sure you respond to our feedback/questions.

## Community

If you have additional questions or you want to chat with the MindsDB core team, please join our [Slack community](https://mindsdb.com/joincommunity) or post at [Github Discussions](https://github.com/mindsdb/mindsdb/discussions).
 
To get updates on MindsDB’s latest announcements, releases, and events, sign up for our [Monthly Community Newsletter](https://mindsdb.com/newsletter/?utm_medium=community&utm_source=github&utm_campaign=mindsdb%20repo).

Join our mission of democratizing machine learning!

## Contributor Code of Conduct
Please note that this project is released with a [Contributor Code of Conduct](https://github.com/mindsdb/mindsdb/blob/main/CODE_OF_CONDUCT.md). By participating in this project, you agree to abide by its terms.

