---
title: Confluence
sidebarTitle: Confluence
---

This documentation describes the integration of MindsDB with [Confluence](https://www.atlassian.com/software/confluence), a popular collaboration and documentation tool developed by Atlassian.
The integration allows MindsDB to access data from Confluence and enhance it with AI capabilities.

## Prerequisites

Before proceeding, ensure the following prerequisites are met:

1. Install MindsDB locally via [Docker](https://docs.mindsdb.com/setup/self-hosted/docker) or [Docker Desktop](https://docs.mindsdb.com/setup/self-hosted/docker-desktop).

## Connection

Establish a connection to Confluence from MindsDB by executing the following SQL command and providing its [handler name](https://github.com/mindsdb/mindsdb/tree/main/mindsdb/integrations/handlers/confluence_handler) as an engine.

```sql
CREATE DATABASE confluence_datasource
WITH
    ENGINE = 'confluence',
    PARAMETERS = {
        "api_base": "https://example.atlassian.net",
        "username": "john.doe@example.com",
        "password": "a1b2c3d4e5f6g7h8i9j0k1l2m3n4o5p6"
    };
```

Required connection parameters include the following:

* `api_base`: The base URL for your Confluence instance/server.
* `username`: The email address associated with your Confluence account.
* `password`: The API token generated for your Confluence account.

<Tip>
Refer this [guide](https://support.atlassian.com/atlassian-account/docs/manage-api-tokens-for-your-atlassian-account/) for instructions on how to create API tokens for your account.
</Tip>

## Usage

Retrieve data from a specified table by providing the integration and table names:

```sql
SELECT *
FROM confluence_datasource.table_name
LIMIT 10;
```

<Note>
The above example utilize `confluence_datasource` as the datasource name, which is defined in the `CREATE DATABASE` command.
</Note>

## Supported Tables

* `spaces`: The table containing information about the spaces in Confluence.
* `pages`: The table containing information about the pages in Confluence.
* `blogposts`: The table containing information about the blog posts in Confluence.
* `whiteboards`: The table containing information about the whiteboards in Confluence.
* `databases`: The table containing information about the databases in Confluence.
* `tasks`: The table containing information about the tasks in Confluence.