import unittest
from mindsdb.integrations.handlers.sqlite_handler.sqlite_handler import SQLiteHandler
from mindsdb.api.executor.data_types.response_type import RESPONSE_TYPE


class SQLiteHandlerTest(unittest.TestCase):
    @classmethod
    def setUpClass(cls):
        cls.kwargs = {
            "db_file": "chinook.db",
        }
        cls.handler = SQLiteHandler('test_sqlite_handler', cls.kwargs)

    def test_0_check_connection(self):
        assert self.handler.check_connection()

    def test_1_native_query_select(self):
        query = "SELECT * FROM customers"
        result = self.handler.native_query(query)
        assert result.type is RESPONSE_TYPE.TABLE

    def test_2_get_tables(self):
        tables = self.handler.get_tables()
        assert tables.type is not RESPONSE_TYPE.ERROR

    def test_4_get_columns(self):
        columns = self.handler.get_columns('customers')
        assert columns.type is not RESPONSE_TYPE.ERROR


if __name__ == '__main__':
    unittest.main()
