# TDEngine Handler

This is the implementation of the  TDEngine handler for MindsDB.

##  TDEngine
TDengine is an open source, high-performance, cloud native time-series database optimized for Internet of Things (IoT), Connected Cars, and Industrial IoT. It enables efficient, real-time data ingestion, processing, and monitoring of TB and even PB scale data per day, generated by billions of sensors and data collectors. TDengine differentiates itself from other time-series databases with the following advantages:

* High Performance
* Simplified Solution
* Cloud Native
* Ease of Use
* Easy Data Analytics
* Open Source
  


## Implementation
This handler was implemented using the `taos/taosrest`, a Python library that allows you to use Python code to run SQL commands on TDEngine Server.

The required arguments to establish a connection are,
* `user`: username asscociated with server
* `password`: password to authenticate your access
* `url`: Url to TDEngine server. For local server url is localhost:6041 (Default)
* `token`: Unique token provide while using TDEngine Cloud.
* `database`: Database name to be connected


## Usage
In order to make use of this handler and connect to TDEngine in MindsDB, the following syntax can be used,

~~~~sql
CREATE DATABASE TDEngine_datasource
WITH
engine='tdengine',
parameters={
    "user":"root",
    "password":"taosdata",
    "url":"127.0.0.1:6041",
    "database":"test"
};
~~~~


**Note :-> You can sepecify token instead of user and password while using TDEngine.**


Now, you can use this established connection to query your database as follows,
~~~~sql
SELECT * FROM TDEngine_datasource.d0;
~~~~
