# Generated by Django 1.9.5 on 2016-11-05 13:24
from django.db import migrations, models
import django.utils.timezone


def move_dates(apps, schema_editor):
    """Move dates to models."""
    RelayDomain = apps.get_model("relaydomains", "RelayDomain")
    for model in [RelayDomain]:
        for instance in model.objects.all():
            instance.creation = instance.dates.creation
            instance.last_modification = instance.dates.last_modification
            instance.save()


class Migration(migrations.Migration):

    dependencies = [
        ("relaydomains", "0003_auto_20170116_1508"),
    ]

    operations = [
        migrations.AddField(
            model_name="relaydomain",
            name="creation",
            field=models.DateTimeField(default=django.utils.timezone.now),
        ),
        migrations.AddField(
            model_name="relaydomain",
            name="last_modification",
            field=models.DateTimeField(null=True),
        ),
        migrations.RunPython(move_dates),
    ]
