![banner](./TCS-banner.png)
# Awesome Theoretical Computer Science [![Awesome](https://awesome.re/badge-flat.svg)](https://awesome.re)
The interdisciplinary of Mathematics and Computer Science; It is distinguished by its emphasis on mathemtical technique and rigour.

---

## Contents
- [Broad Intros](#broad_intros)
  - [Lecture Notes](#broad_intros_lecture_notes) | [Lecture Videos Playlists](#broad_intros_lecture_videos_playlists) | [Books](#broad_intros_books) | [Handbooks](#broad_intros_handbooks)
- [Theory of Computation](#theory_of_computation)
  - [Introductory](#theory_of_computation_introductory)
    - [Lecture Notes](#theory_of_computation_introductory_lecture_notes) | [MOOC](#theory_of_computation_introductory_mooc) | [Books](#theory_of_computation_introductory_books) | [Puzzles and Problem Sets](#theory_of_computation_introductory_puzzles_and_problem_sets)
  - [Computational Complexity](#theory_of_computation_computational_complexity)
    - [Introductory](#theory_of_computation_computational_complexity_introductory)
      - [Lecture Videos Playlists](#theory_of_computation_computational_complexity_introductory_lecture_videos_playlists) | [Lecture Notes](#theory_of_computation_computational_complexity_introductory_lecture_notes) | [Books](#theory_of_computation_computational_complexity_introductory_books) | [Big Lists](#theory_of_computation_computational_complexity_introductory_big_lists)
    - [Communication Complexity](#theory_of_computation_computational_complexity_communication_complexity)
      - [Lecture Notes](#theory_of_computation_computational_complexity_communication_complexity_lecture_notes) | [Books](#theory_of_computation_computational_complexity_communication_complexity_books)
    - [Circuit Complexity](#theory_of_computation_computational_complexity_circuit_complexity)
      - [Books](#theory_of_computation_computational_complexity_circuit_complexity_books)
    - [Quantum Complexity](#theory_of_computation_computational_complexity_quantum_complexity)
      - [Lecture Videos Playlists](#theory_of_computation_computational_complexity_quantum_complexity_lecture_videos_playlists) | [Lecture Notes](#theory_of_computation_computational_complexity_quantum_complexity_lecture_notes)
    - [Proof Complexity](#theory_of_computation_computational_complexity_proof_complexity)
      - [Lecture Notes](#theory_of_computation_computational_complexity_proof_complexity_lecture_notes)
  - [Computability Theory](#theory_of_computation_computability_theory)
    - [Books](#theory_of_computation_computability_theory_books)
      - [Introductory](#theory_of_computation_computability_theory_books_introductory) | [Advanced](#theory_of_computation_computability_theory_books_advanced) | [Monograph](#theory_of_computation_computability_theory_books_monograph)
- [Logic](#logic)
  - [Computational Complexity](#logic_computational_complexity)
    - [Books](#logic_computational_complexity_books)
- [Programming Language Theory](#programming_language_theory)
  - [Basics](#programming_language_theory_basics)
    - [Lecture Notes](#programming_language_theory_basics_lecture_notes) | [Books](#programming_language_theory_basics_books)
  - [Introductory](#programming_language_theory_introductory)
    - [Books](#programming_language_theory_introductory_books)
  - [Formal Verification](#programming_language_theory_formal_verification)
    - [Lecture Notes](#programming_language_theory_formal_verification_lecture_notes) | [Books](#programming_language_theory_formal_verification_books)
  - [Type Theory](#programming_language_theory_type_theory)
    - [Lecture Notes](#programming_language_theory_type_theory_lecture_notes) | [Books](#programming_language_theory_type_theory_books)
  - [Functional Programming](#programming_language_theory_functional_programming)
    - [Lecture Notes](#programming_language_theory_functional_programming_lecture_notes)
- [Algorithms](#algorithms)
  - [General](#algorithms_general)
    - [Lecture Videos](#algorithms_general_lecture_videos) | [Lecture Notes](#algorithms_general_lecture_notes) | [Books](#algorithms_general_books)
  - [Lower Bounds](#algorithms_lower_bounds)
    - [Lecture Videos Playlists](#algorithms_lower_bounds_lecture_videos_playlists) | [Books](#algorithms_lower_bounds_books)
  - [Randomization & Probability](#algorithms_randomization__probability)
    - [Lecture Notes](#algorithms_randomization__probability_lecture_notes)
  - [Approximation](#algorithms_approximation)
    - [Lecture Notes](#algorithms_approximation_lecture_notes) | [Books](#algorithms_approximation_books)
  - [Parameterized](#algorithms_parameterized)
    - [Lecture Videos Playlist](#algorithms_parameterized_lecture_videos_playlist) | [Books](#algorithms_parameterized_books)
  - [Learning-augmented](#algorithms_learning-augmented)
    - [Lecture Notes](#algorithms_learning-augmented_lecture_notes) | [Big List](#algorithms_learning-augmented_big_list)
- [Information/Coding Theory](#informationcoding_theory)
  - [Lecture Notes](#informationcoding_theory_lecture_notes) | [Workshops](#informationcoding_theory_workshops) | [Conferences](#informationcoding_theory_conferences)
- [Cryptography](#cryptography)
  - [Books](#cryptography_books)
- [Machine Learning Theory](#machine_learning_theory)
  - [Lecture Notes](#machine_learning_theory_lecture_notes) | [Books](#machine_learning_theory_books) | [Workshops](#machine_learning_theory_workshops) | [Other](#machine_learning_theory_other)
- [Game Theory](#game_theory)
  - [Lecture Notes](#game_theory_lecture_notes) | [Books](#game_theory_books) | [Workshops](#game_theory_workshops)
- [Math and Logic](#math_and_logic)
  - [General](#math_and_logic_general)
    - [Lecture Videos Playlist](#math_and_logic_general_lecture_videos_playlist) | [Books](#math_and_logic_general_books) | [Lecture Notes](#math_and_logic_general_lecture_notes)
  - [TCS Toolkit](#math_and_logic_tcs_toolkit)
    - [Lecture Videos Playlists](#math_and_logic_tcs_toolkit_lecture_videos_playlists) | [Lecture Notes](#math_and_logic_tcs_toolkit_lecture_notes) | [Books](#math_and_logic_tcs_toolkit_books)
  - [Discrete Mathematics](#math_and_logic_discrete_mathematics)
    - [General](#math_and_logic_discrete_mathematics_general)
      - [Lecture Notes](#math_and_logic_discrete_mathematics_general_lecture_notes) | [Books](#math_and_logic_discrete_mathematics_general_books) | [MOOC](#math_and_logic_discrete_mathematics_general_mooc)
    - [Probabilistic Method](#math_and_logic_discrete_mathematics_probabilistic_method)
      - [Lecture Notes](#math_and_logic_discrete_mathematics_probabilistic_method_lecture_notes) | [Lecture Videos Playlist](#math_and_logic_discrete_mathematics_probabilistic_method_lecture_videos_playlist) | [Books](#math_and_logic_discrete_mathematics_probabilistic_method_books)
    - [Graph Theory](#math_and_logic_discrete_mathematics_graph_theory)
      - [Lecture Videos Playlist](#math_and_logic_discrete_mathematics_graph_theory_lecture_videos_playlist)
    - [Other](#math_and_logic_discrete_mathematics_other)
- [Physics](#physics)
  - [Lecture Notes](#physics_lecture_notes) | [Books](#physics_books) | [Monographs](#physics_monographs)
- [Philosophy](#philosophy)
  - [Lecture Notes](#philosophy_lecture_notes) | [Books](#philosophy_books) | [Papers](#philosophy_papers)
- [Surveys & Monographs](#surveys__monographs)
- [Community](#community)
  - [Conferences & Workshops](#community_conferences__workshops)
    - [Aggregators](#community_conferences__workshops_aggregators) | [Live](#community_conferences__workshops_live) | [Archived](#community_conferences__workshops_archived)
  - [Magazines & Newsletter](#community_magazines__newsletter)
  - [Associations](#community_associations)
  - [Blogs](#community_blogs)
    - [Aggregators](#community_blogs_aggregators) | [Selected Posts and Essays](#community_blogs_selected_posts_and_essays)
  - [Jobs](#community_jobs)
  - [Online Communities](#community_online_communities)
- [Other](#other)
  - [Podcasts](#other_podcasts) | [Popular Science](#other_popular_science) | [Cheat Sheets](#other_cheat_sheets)
- [Related Lists](#related_lists)

---

# Broad Intros<a name=broad_intros></a>
## Lecture Notes<a name=broad_intros_lecture_notes></a>
- [Barak. Introduction to TCS](https://introtcs.org/public/index.html) - A modern, brief, and accessible text which introduces theoretical computer science for undergrads. It includes topics not usually included in standard undergrad text-books.
## Lecture Videos Playlists<a name=broad_intros_lecture_videos_playlists></a>
- [Yanofsky. Theoretical Computer Science](https://www.youtube.com/playlist?list=PLCqUsBXxq16yBaN_hpo7dY2l9N-ZLtI-X) - undergrad introduction to theory of computation
- [Anil Ada. Great Ideas in Theoretical Computer Science. CMU](https://www.youtube.com/playlist?list=PLKzLTB8HeSUIuln-o1mbXfTr8HmIhiGEg) - A series of lectures on selected notable topics in theoretical computer science.
- [O'Donnell. Great Ideas in Theoretical Computer Science. CMU](https://www.youtube.com/playlist?list=PLm3J0oaFux3aafQm568blS9blxtA_EWQv) - A series of lectures on selected notable topics in theoretical computer science.
## Books<a name=broad_intros_books></a>
- [Wigderson. Mathematics and Computation: A Theory Revolutionizing Technology and Science](https://www.math.ias.edu/files/Book-online-Aug0619.pdf) - A sweeping survey of complexity theory, emphasizing the field’s insights and challenges. It explains the ideas and motivations leading to key models, notions, and results.
- [Moore & Mertens. The Nature of Computation](http://nature-of-computation.org/) - It spans complexity of mazes and games; optimization in theory and practice; randomized algorithms, interactive proofs, and pseudorandomness; Markov chains and phase transitions; and of quantum computing. It provides accessible explanations
## Handbooks<a name=broad_intros_handbooks></a>
- [Atallah & Blanton. Algorithms and Theory of Computation Handbook: General Concepts and Techniques](https://www.routledge.com/Algorithms-and-Theory-of-Computation-Handbook-Volume-1-General-Concepts/Atallah-Blanton/p/book/9781138113930) - A complete comprehensive encyclopediac handbook which surveys all related areas to theoretical computer science.
- [Atallah & Blanton. Algorithms and Theory of Computation Handbook: Special Topics and Techniques](https://www.routledge.com/Algorithms-and-Theory-of-Computation-Handbook-Volume-2-Special-Topics/Atallah-Blanton/p/book/9780367384845) - A complete comprehensive encyclopediac handbook which surveys all related areas to theoretical computer science.
- [Handbook of Theoretical Computer Science. Volume A: Algorithms and Complexity](https://mitpress.mit.edu/books/handbook-theoretical-computer-science-volume) - A complete comprehensive encyclopediac handbook which surveys all related areas to theoretical computer science.
- [Handbook of Theoretical Computer Science. Volume B: Formal Methods and Semantics](https://mitpress.mit.edu/books/handbook-theoretical-computer-science-2-vol-set) - A complete comprehensive encyclopediac handbook which surveys all related areas to theoretical computer science.
# Theory of Computation<a name=theory_of_computation></a>
## Introductory<a name=theory_of_computation_introductory></a>
### Lecture Notes<a name=theory_of_computation_introductory_lecture_notes></a>
- [Watrous. Introduction to The Theory of Computing](https://cs.uwaterloo.ca/~watrous/ToC-notes/) - undergrad introduction to theory of computation
### MOOC<a name=theory_of_computation_introductory_mooc></a>
- [Intro to Theoretical Computer Science](https://www.udacity.com/course/intro-to-theoretical-computer-science--cs313) - It teaches basic concepts in theoretical computer science, such as NP-completeness, and what they imply for solving tough algorithmic problems.
- [Computability, Complexity & Algorithms. Georgia Institute of Technology](https://www.udacity.com/course/computability-complexity-algorithms--ud061) - It focuses on the big fundamental questions of computing, and how understanding the power and limitations of algorithms helps us develop the tools to make real-world computers smarter, faster and safer.
### Books<a name=theory_of_computation_introductory_books></a>
- [Sipser. Introduction to Theory of Computation](https://www.cengage.com/c/introduction-to-the-theory-of-computation-3e-sipser/9781133187790/) - A standard text for introducing theory of computation for undergrads.
- [Hopcroft, Motwani & Ullman. Introduction to Automata Theory, Languages, and Computation](https://www.pearson.com/us/higher-education/program/Hopcroft-Introduction-to-Automata-Theory-Languages-and-Computation-3rd-Edition/PGM64331.html) - Introductory undergrad textbook for automata, languages and theory of computation topics.
### Puzzles and Problem Sets<a name=theory_of_computation_introductory_puzzles_and_problem_sets></a>
- [Zhu & Ko. Problem Solving in Automata, Languages, and Complexity](https://onlinelibrary.wiley.com/doi/book/10.1002/0471224642) - A problem-set text for automata, languages, and complexity.
## Computational Complexity<a name=theory_of_computation_computational_complexity></a>
### Introductory<a name=theory_of_computation_computational_complexity_introductory></a>
#### Lecture Videos Playlists<a name=theory_of_computation_computational_complexity_introductory_lecture_videos_playlists></a>
- [O'Donnell. Undergrad Complexity Theory. Fall 2019 (15-455)](https://www.youtube.com/playlist?list=PLm3J0oaFux3YL5vLXpzOyJiLtqLp6dCW2) ([Homework](https://www.cs.cmu.edu/~odonnell/15455-s17/)) - Undergraduate course on computational complexity theory; It follows the same spirit of Sipser's part III.
- [O'Donnell. Graduate Complexity Theory](https://www.youtube.com/playlist?list=PLm3J0oaFux3b8Gg1DdaJOzYNsaXYLAOKH) - It covers most of what is believed to be known to get started in complexity theory research.
#### Lecture Notes<a name=theory_of_computation_computational_complexity_introductory_lecture_notes></a>
- [Rudich & Wigderson. Computational Complexity Theory](http://www.ams.org/books/pcms/010/) - Three weeks of lectures from the IAS/Park City Mathematics Institute Summer School on computational complexity. Topics include reductions, lower-bounds, average-case complexity, randomness, interactive proof systems, probabilistically checkable proofs, quantum computing, and proof complexity.
#### Books<a name=theory_of_computation_computational_complexity_introductory_books></a>
- [Arora & Barak. Computational Complexity: A Modern Approach](https://theory.cs.princeton.edu/complexity/book.pdf) - A golden standard textbook, Surveying computational complexity theory for graduate students and researchers.
- [Goldreich. Computational Complexity: A Conceptual Perspective](http://www.wisdom.weizmann.ac.il/~oded/cc-book.html) - A grad introduction to computation complexity theory, emphasizing the idea behind concepts of complexity theory.
- [Goldreich. P, NP, and NP-Completeness: The Basics of Computational Complexity](http://www.wisdom.weizmann.ac.il/~oded/bc-book.html) - A very gentle introduction to some fundamental ideas of computational complexity like NP-completeness and P vs NP.
- [Ogihara & Hemaspaandra. The Complexity Theory Companion](https://www.springer.com/gp/book/9783540674191) - An accessible, algorithmically oriented, research-centered, up-to-date guide to some of the most interesting techniques of complexity theory.
- [Papadimitriou. Computational Complexity](https://www.pearson.com/us/higher-education/program/Papadimitriou-Computational-Complexity/PGM94583.html) - Body of knowledge for studying the performance and limitations of computer algorithms. Among topics covered are: reductions and NP-completeness, cryptography and protocols, randomized algorithms, and approximability of optimization problems, circuit complexity, the structural aspects of the P=NP question, parallel computation, and the polynomial hierarchy.
#### Big Lists<a name=theory_of_computation_computational_complexity_introductory_big_lists></a>
- [Complexity Zoo](https://complexityzoo.net/) - a wiki of complexity classes.
### Communication Complexity<a name=theory_of_computation_computational_complexity_communication_complexity></a>
#### Lecture Notes<a name=theory_of_computation_computational_complexity_communication_complexity_lecture_notes></a>
- [Mark Bun. CS591 Communication Complexity](https://cs-people.bu.edu/mbun/courses/591_F19/) - A graduate course which introduces the fundamental results and techniques in the area and some research frontier questions. Themes include: Communication models and the communication complexity zoo, Information vs. communication, Query-to-communication lifting, and Applications
#### Books<a name=theory_of_computation_computational_complexity_communication_complexity_books></a>
- [Rao & Yehudayoff. Communication Complexity and Applications](https://www.cambridge.org/core/books/communication-complexity/5F44993E3B2597174B71D3F21E748443) - An excellent and very readable introductory textbook to the field of communication complexity.
### Circuit Complexity<a name=theory_of_computation_computational_complexity_circuit_complexity></a>
#### Books<a name=theory_of_computation_computational_complexity_circuit_complexity_books></a>
- [Jukna. Boolean Function Complexity: Advances and Frontiers](https://www.springer.com/gp/book/9783642245077) - A modern textbook surveying circuit complexity.
- [Clote & Kranakis. Boolean Functions and Computation Models](https://www.springer.com/gp/book/9783540594369) - An introduction to circuit complexity, boolean functions, and computation models.
### Quantum Complexity<a name=theory_of_computation_computational_complexity_quantum_complexity></a>
#### Lecture Videos Playlists<a name=theory_of_computation_computational_complexity_quantum_complexity_lecture_videos_playlists></a>
- [Uni Paderborn. Quantum Complexity Theory. Winter 2020](https://www.youtube.com/playlist?list=PLZGjbQcY0aI7Yqwbwp-lsf1tTPyvkQG6h) - CS Masters level lectures on topics including Boson sampling, quantum interactive proofs, and quantum merlin arthur.
#### Lecture Notes<a name=theory_of_computation_computational_complexity_quantum_complexity_lecture_notes></a>
- [Henry Yuen. The Complexity of Entanglement. Fall 2020](https://www.henryyuen.net/fall2020/complexity_of_entanglement_notes.pdf) - Focuses on cutting edge topics in quantum information that relate to Complexity of Entanglement. - see this [class](https://www.henryyuen.net/classes/fall2020/) also
### Proof Complexity<a name=theory_of_computation_computational_complexity_proof_complexity></a>
#### Lecture Notes<a name=theory_of_computation_computational_complexity_proof_complexity_lecture_notes></a>
- [Robert Robere. Proof Complexity: Algorithms and Lower Bounds](https://www.cs.mcgill.ca/~robere/comp598/index.html) - An introduction to modern proof complexity, emphasizing its connections with computational complexity and algorithms in optimization.
## Computability Theory<a name=theory_of_computation_computability_theory></a>
### Books<a name=theory_of_computation_computability_theory_books></a>
#### Introductory<a name=theory_of_computation_computability_theory_books_introductory></a>
- [Cutland. Computability: An Introduction to Recursive Function Theory](https://www.cambridge.org/highereducation/books/computability/E8F085FDBECB8280F7723D71C1D2EE1C) - Intuitively, It explains the idea of a computable function: a function whose values can be calculated in an effective or automatic way.
- [Cooper. Computability Theory](https://www.routledge.com/Computability-Theory/Cooper-Cooper/p/book/9781584882374) - A concise, comprehensive, and authoritative introduction to contemporary computability theory, techniques, and results.
- [Davis. Computability and Unsolvability](https://www.amazon.com/Computability-Unsolvability-Prof-Martin-Davis/dp/0486614719) - In this classic text, Dr. Davis provides a clear introduction to computability, at an advanced undergraduate level, that serves the needs of specialists and non-specialists alike.
#### Advanced<a name=theory_of_computation_computability_theory_books_advanced></a>
- [Soare. Recursively Enumerable Sets and Degree](https://www.springer.com/gp/book/9783540666813) - It gives a complete account of the theory of r.e degrees. The definitions, results and proofs are always clearly motivated and explained before the formal presentation; the proofs are described with remarkable clarity and conciseness.
- [Odifreddi. Classical Recursion Theory: The Theory of Functions and Sets of Natural Numbers](https://archive.org/details/classicalrecursi0000odif) - An impressive presentation of classical recursion theory. It is highly recommended to everyone interested in recursion theory.
#### Monograph<a name=theory_of_computation_computability_theory_books_monograph></a>
- [Copeland, Posy & Shagrir (editors). Computability: Turing, Gödel, Church, and Beyond](https://mitpress.mit.edu/books/computability) - Computer scientists, mathematicians, and philosophers discuss the conceptual foundations of the notion of computability as well as recent theoretical developments.
# Logic<a name=logic></a>
## Computational Complexity<a name=logic_computational_complexity></a>
### Books<a name=logic_computational_complexity_books></a>
- [Pudlák. Logical Foundations of Mathematics and Computational Complexity: A Gentle Introduction](https://www.springer.com/gp/book/9783319001180) - Presents a wide range of results in logic and computational complexity.
# Programming Language Theory<a name=programming_language_theory></a>
## Basics<a name=programming_language_theory_basics></a>
### Lecture Notes<a name=programming_language_theory_basics_lecture_notes></a>
- [Cambridge Foundations of CS](https://www.cl.cam.ac.uk/teaching/2425/FoundsCS/materials.html) - It teaches programming and presents some fundamental principles of computer science, especially algorithm design.
### Books<a name=programming_language_theory_basics_books></a>
- Structure and Interpretation of Computer Programs - [MIT OCW](https://ocw.mit.edu/courses/6-001-structure-and-interpretation-of-computer-programs-spring-2005/pages/syllabus/), [HTML book](https://mitp-content-server.mit.edu/books/content/sectbyfn/books_pres_0/6515/sicp.zip/index.html), [Byford's playlist](https://www.youtube.com/playlist?list=PL7BcsI5ueSNFPCEisbaoQ0kXIDX9rR5FF), [Javascript book](https://github.com/source-academy/sicp?tab=readme-ov-file), [Python book](https://wizardforcel.gitbooks.io/sicp-in-python/content/index.html), [Berkeley for self-study](https://romanbird.github.io/sicp/#e682e189-1f90-4713-9dfe-35c92b7d1cdf), and [Berkeley 2024](https://cs61a.org/) - Fundamental principles of computer programming in Scheme, including recursion, abstraction, modularity, and programming language design and implementation.
## Introductory<a name=programming_language_theory_introductory></a>
### Books<a name=programming_language_theory_introductory_books></a>
- [Pierce. Software Foundations. Pennsylvania](https://softwarefoundations.cis.upenn.edu/) - A broad introduction series to the mathematical underpinnings of reliable software. It's composed of proof scripts for the Coq proof assistant. It's is intended for a broad range of readers, With no specific background assumed.
## Formal Verification<a name=programming_language_theory_formal_verification></a>
### Lecture Notes<a name=programming_language_theory_formal_verification_lecture_notes></a>
- [UW CSE505 18au Principles of PL](https://sites.google.com/cs.washington.edu/cse-505-18au/home) - Techniques for thinking crisply about programming languages, write some fascinating programs, and discuss various design tradeoffs.
### Books<a name=programming_language_theory_formal_verification_books></a>
- [Chlipala. Formal Reasoning About Programs](http://adam.chlipala.net/frap) - A book introducing both machine-checked proof with Coq Proof Assistant and approaches to formal reasoning about program correctness.
- [Lean Proof Assistant](https://lean-lang.org/documentation/) - Lean Proof Assistant.
## Type Theory<a name=programming_language_theory_type_theory></a>
### Lecture Notes<a name=programming_language_theory_type_theory_lecture_notes></a>
- [Martin-Löf. Intuitionistic Type Theory](https://raw.githubusercontent.com/michaelt/martin-lof/master/pdfs/Bibliopolis-Book-retypeset-1984.pdf) - Notes by Giovanni Sambin of a series of type theory lectures given in Padua, June 1980.
### Books<a name=programming_language_theory_type_theory_books></a>
- [Bengt. Programming in Martin-Löf's Type Theory](https://www.cse.chalmers.se/research/group/logic/book/book.pdf) - This book describes different type theories (theories of types, polymorphic and monomorphic sets, and subsets) from a computing science perspective.
- [The Univalent Foundations Program Institute for Advanced Study. Homotopy Type Theory: Univalent Foundations of Mathematics](https://homotopytypetheory.org/book) - The present book is intended as a first systematic exposition of the basics of univalent foundations, and a collection of examples of this new style of reasoning — but without requiring the reader to know or learn any formal logic, or to use any computer proof assistant.
## Functional Programming<a name=programming_language_theory_functional_programming></a>
### Lecture Notes<a name=programming_language_theory_functional_programming_lecture_notes></a>
- [Helsinki. Haskell MOOC](https://haskell.mooc.fi) - An online course on functional programming with Haskell programming language, and a live interactive Telegram community.
- [Cornell. Functional Programming in Ocaml](https://www.cs.cornell.edu/courses/cs3110/2024sp) - A modern course on data structures and functional programming using OCaml.
# Algorithms<a name=algorithms></a>
## General<a name=algorithms_general></a>
### Lecture Videos<a name=algorithms_general_lecture_videos></a>
- [Demaine/Ku/Soloman. Introduction to Algorithms. MIT](https://ocw.mit.edu/courses/6-006-introduction-to-algorithms-spring-2020/) - A first course on basic algorithms and data structures. — added by Erik himself!
- [Demaine/Devadas/Lynch. Design and Analysis of algorithms. MIT](https://ocw.mit.edu/courses/6-046j-design-and-analysis-of-algorithms-spring-2015/) - A second course on algorithms and data structures. — added by Erik himself!
- [Erik Demaine. Advanced Data Structures. MIT](https://ocw.mit.edu/courses/6-851-advanced-data-structures-spring-2012/) - It covers major results and current directions of research in data structure.
### Lecture Notes<a name=algorithms_general_lecture_notes></a>
- [Arora. Advanced Algorithm Design](https://www.cs.princeton.edu/courses/archive/fall15/cos521/) - Notably uses ideas such as randomness, approximation, high dimensional geometry. Faces uncertainty, approaches to handle big data, handling intractability, heuristic approaches, ..etc.
### Books<a name=algorithms_general_books></a>
- [Knuth. The Art of Computer Programming](https://en.wikipedia.org/wiki/The_Art_of_Computer_Programming) - A legendary series by Donald Knuth on design and analysis of algorithms.
## Lower Bounds<a name=algorithms_lower_bounds></a>
### Lecture Videos Playlists<a name=algorithms_lower_bounds_lecture_videos_playlists></a>
- [Demaine. Algorithmic Lower Bounds: Fun with Hardness Proofs](https://ocw.mit.edu/courses/electrical-engineering-and-computer-science/6-890-algorithmic-lower-bounds-fun-with-hardness-proofs-fall-2014/) - A class taking a practical approach to proving problems can't be solved efficient.
### Books<a name=algorithms_lower_bounds_books></a>
- [Demaine, Gasarch & Hajiaghayi. Computers and Intractability: A Guide to Algorithmic Lower Bounds](https://hardness.mit.edu/) - A sequel to Garey and Johnson's Computers and Intractability: A Guide to NP-Completeness. New topics include Parameterized Complexity, Lower bounds on approximation, Other hardness assumptions (ETH, 3SUM-conjecture, APSP-conjecture, UGC, Others), Online Algorithms, Streaming Algorithms, Polynomial Parity Arguments, and Parallelism.
- [Demaine. Games, Puzzles, and Computation](https://www.routledge.com/Games-Puzzles-and-Computation/Hearn-Demaine/p/book/9781568813226) - It shows that games and puzzles can serve as powerful models of computation, Offering a new way of thinking about computation.
## Randomization & Probability<a name=algorithms_randomization__probability></a>
### Lecture Notes<a name=algorithms_randomization__probability_lecture_notes></a>
- [Mary Wootters. Randomized Algorithms and Probabilistic Analysis. Stanford](https://web.stanford.edu/class/archive/cs/cs265/cs265.1232/) - Key tools of probabilistic analysis, and application of these tools to understand the behaviors of random processes and algorithms. Emphasis is on theoretical foundations, though applications will be discussed in machine learning and data analysis, networking, and systems. Topics include tail bounds, the probabilistic method, Markov chains, and martingales, with applications to analyzing random graphs, metric embeddings, and random walks.
- [Koutsoupias. Probability and Computing. Oxford](https://www.cs.ox.ac.uk/people/elias.koutsoupias/pc2018-19/) - Introduction to probabilistic methods in computer science.
- Harvey. [First](https://www.cs.ubc.ca/~nickhar/Book1.pdf) and [Second](https://www.cs.ubc.ca/~nickhar/Book2.pdf) Course in Randomized Algorithms. Columbia. - Respectively, undergrad and grad courses for probabilistic methods in algorithms.
- [Lee. Randomized Algorithms and Probabilistic Analysis. Washington.](https://homes.cs.washington.edu/~jrl/teaching/cse525sp19/) - Topics include Discrete probability, High-dimensional geometry and statistics, Information and entropy, and Markov chains and convergence to equilibrium.
- [Aspnes. Notes on Randomized Algorithms](https://www.cs.yale.edu/homes/aspnes/classes/469/notes.pdf) - Supplemental notes to the standard books by Mitzenmacher & Upfals, and Motwani & Raghavan.
## Approximation<a name=algorithms_approximation></a>
### Lecture Notes<a name=algorithms_approximation_lecture_notes></a>
- [Chekuri. Approximation Algorithmis Illinois](https://courses.engr.illinois.edu/cs583/fa2021/) - A broad introduction to results and techniques with an emphasis on fundamental problems and widely applicable tools. Also more advanced and specialized topics.
- [Dinitz. Approximation Algorithms. Johns Hopkins](https://www.cs.jhu.edu/~mdinitz/classes/ApproxAlgorithms/Spring2021/) - It includes greedy, local search, dynamic programming, randomized rounding, tree embeddings, and semidefinite programming.
- [Gupta & Ravi. Approximation Algorithms. CMU](http://www.cs.cmu.edu/afs/cs/academic/class/15854-f05/www/) - It includes convex programming-based, randomness, and metric methods.
### Books<a name=algorithms_approximation_books></a>
- [Williamson & Shmoys. The Design of Approximation Algorithms](https://www.designofapproxalgs.com/) - It includes greedy, local search algorithms, dynamic programming, linear and semidefinite programming, and randomization.
- [Du & Ko. Design and Analysis of Approximation Algorithms](https://u.pcloud.link/publink/show?code=XZpzNWXZSCkVs6BKd5RzyNhoRzfJCJoaqSok) - A technique-oriented approach provides a unified view. It includes detailed algorithms, proofs, analyses, examples, and applications from research papers.
- [Vijay Vazirani. Approximation Algorithms](https://u.pcloud.link/publink/show?code=XZgHNWXZkdvT8L18drSSgLP9vqBIDmbPreD7)
## Parameterized<a name=algorithms_parameterized></a>
### Lecture Videos Playlist<a name=algorithms_parameterized_lecture_videos_playlist></a>
- [Parametarized Algorithms by Warsaw](https://www.youtube.com/playlist?list=PLzdZSKerwrXpr6hWq1s63a42YbkocAK1Q)
### Books<a name=algorithms_parameterized_books></a>
- Fedor Fomin. Parametrized Algorithms - Modern comprehensive explanation of recent tools and techniques with exercises, for graduate students.
## Learning-augmented<a name=algorithms_learning-augmented></a>
### Lecture Notes<a name=algorithms_learning-augmented_lecture_notes></a>
- [Indyk & Daskalakis. Learning-augmented Algorithms. MIT](https://stellar.mit.edu/S/course/6/sp19/6.890/materials.html)
### Big List<a name=algorithms_learning-augmented_big_list></a>
- [Algorithms with Predictions](https://algorithms-with-predictions.github.io/)
# Information/Coding Theory<a name=informationcoding_theory></a>
## Lecture Notes<a name=informationcoding_theory_lecture_notes></a>
- [Madhu Sudan. Essential Coding Theory](http://people.seas.harvard.edu/~madhusudan/courses/Spring2020/) - Some elements of Algorithmic tasks of encoding and decoding and its connections with error-correction; These codes are now tools in the design and analysis of algorithms, and also in many aspects of computational complexity. The focus is on constructions of algorithmic and asymptotic importance. Requires only basic mathematical maturity.
- Scott Aaronson. Quantum Information Science. [Part I](https://www.scottaaronson.com/qclec.pdf) & [Part II](https://www.scottaaronson.com/qisii.pdf) - Part I: Presuppose only linear algebra and a bit of classical algorithms. Topics include quantum circuits, density matrices, entanglement entropy, Wiesner’s quantum money, QKD, quantum teleportation, the Bell inequality, interpretations of QM, the Shor 9-qubit code, and the algorithms of Deutsch-Jozsa, Bernstein-Vazirani, Simon, Shor, and Grover. Part II: Perspectives on quantum computing that go beyond the bare quantum circuit model, like Hamiltonians, Stabilizer formalism, Bosons and Fermions, Cluster states, and Matrix product states.
## Workshops<a name=informationcoding_theory_workshops></a>
- [Simons Institute. Information Theory Program](https://simons.berkeley.edu/programs/inftheory2015) - It aims to strengthen the ties between computation and communication communities. It explores (1) information theoretic techniques in complexity theory and combinatorics, (2) Coding theory and applications, and (3) information theory, machine learning, and big data.
## Conferences<a name=informationcoding_theory_conferences></a>
- [Compression+Computation 2022](https://sites.google.com/view/compression-computation-2022/program) - It bridges the gap of Theoretical Computer Science and Bioinformatics communities, On new data compression techniques, and computation over compressed data.
# Cryptography<a name=cryptography></a>
## Books<a name=cryptography_books></a>
- [Lindell. Tutorials on the Foundations of Cryptography](https://link.springer.com/book/10.1007/978-3-319-57048-8) - Advanced tutorials appropriate for self-study by experienced researchers,
- [Goldreich. Modern Cryptography, Probabilistic Proofs and Pseudorandomness](https://www.wisdom.weizmann.ac.il/~oded/book1.html) - An introduction to the interwoven domains of cryptography, proofs and randomness.
- [Goldreich. Randomized Methods in Computation](http://www.wisdom.weizmann.ac.il/~oded/rnd.html) - The aim of the current course is to make the students familiar with some of randomized methods.
# Machine Learning Theory<a name=machine_learning_theory></a>
## Lecture Notes<a name=machine_learning_theory_lecture_notes></a>
- [Blum. An Introduction to the Theory of Machine Learning. TTIC](https://home.ttic.edu/~avrim/MLT20/) - The basic theory underlying machine learning and the process of generalizing from data.
- [Telgarsky. Deep Learning Theory. Illinois](https://mjt.cs.illinois.edu/dlt/) - Focuses on simplified proofs over what appears in the literature, and classical perspective of achieving a low test error for binary classification with IID data via standard (typically ReLU) feedforward networks.
- [Vaughan. CS260: Machine Learning Theory](http://www.jennwv.com/courses/F11.html) - A broad overview of the theoretical foundations underlying common machine learning algorithms.
- [Livni. COS 511 Theoretical Machine Learning. Princeton](https://www.cs.princeton.edu/~rlivni/cos511/cos511.html) - Formally define and study various models that have been proposed for learning. The course will present and contrast the statistical, computational and online models for learning. We will present and rigorously analyze some of the most successful algorithms in machine learning that are extensively used today.
- [Moitra. Theoretical Foundations for Deep Learning. MIT](https://people.csail.mit.edu/moitra/408b.html) - It explores theoretical foundations for deep learning, emphasizing the following themes: (1) Approximation: What sorts of functions can be represented by deep networks, and does depth provably increase the expressive power? (2) Optimization: Essentially all optimization problems we want to solve in practice are non-convex. What frameworks can be used to analyze such problems? (3) Beyond-Worst Case Analysis: Deep networks can memorize worst-case data, so why do they generalize well on real-world data?
- [Arora. Overcoming Intractability in Machine Learning](https://www.cs.princeton.edu/courses/archive/spring15/cos598D/) - A seminar course that will focus on the following phenomenon: many problems in machine learning are formally intractable (e.g., NP-hard). Nevertheless they are solved in practice by heuristics. Can we design algorithms with provable guarantees (running time, solution quality)?
## Books<a name=machine_learning_theory_books></a>
- [Vazirani & Kearns. An Introduction to Computational Learning Theory](https://mitpress.mit.edu/books/introduction-computational-learning-theory) - Emphasizing issues of computational efficiency, It introduces a number of central topics in computational learning theory.
- [Shalev-Shwartz. Understanding Machine Learning: From Theory to Algorithms](https://www.cambridge.org/core/books/understanding-machine-learning/3059695661405D25673058E43C8BE2A6) - It provides an extensive theoretical account of the fundamental ideas underlying machine learning and the mathematical derivations that transform these principles into practical algorithms.
## Workshops<a name=machine_learning_theory_workshops></a>
- [Simons Institute. Foundations of Deep Learning Program](https://simons.berkeley.edu/programs/dl2019) - Aligning and focusing theoretical and applied researchers on the common purpose of building empirically relevant theoretical foundations of deep learning. Specifically, the intention was to identify and make progress on challenges that, on one hand, are key to guiding the real-world use of deep learning and, on the other hand, can be approached using theoretical methodology.
- [Simons Institute. Foundations of Data Science](https://simons.berkeley.edu/programs/datascience2018) - Identifying a set of core techniques and principles that form a foundation for the subject.
- [Foundations of Machine Learning](https://simons.berkeley.edu/programs/machinelearning2017) - Aims to grow the reach and impact of computer science theory within machine learning.
- [Toward Theoretical Understanding of Deep Learning](https://unsupervised.cs.princeton.edu/deeplearningtutorial.html)
- [A Brief Introduction to Theoretical Foundations of Machine Learning and Machine Teaching](https://simons.berkeley.edu/talks/tbd-288) - Formal methods and machine learning can inform each other from deductive and inductive reasoning perspectives.  This talk aims to facilitate the dialogue between the two communities by establishing some fundamental concepts in learning theory.
## Other<a name=machine_learning_theory_other></a>
- [Blum. Intro Machine Learning Theory](https://www.cs.cmu.edu/~avrim/Talks/mlt.pdf).
- [Blum, et.al. Machine Learning, Game Theory, and Mechanism Design for a Networked World](https://www.cs.cmu.edu/~mblum/search/AGTML35.pdf).
- [Agrawal & Jaiswal. When Machine Learning Meets AI and Game Theory](https://cs229.stanford.edu/proj2012/AgrawalJaiswal-WhenMachineLearningMeetsAIandGameTheory.pdf).
# Game Theory<a name=game_theory></a>
## Lecture Notes<a name=game_theory_lecture_notes></a>
- [Tim Roughgarden. Complexity Theory, Game Theory, and Economics: The Barbados Lectures](https://arxiv.org/abs/1801.00734) - A mini-course notes of two-fold goals: mini-course is twofold: (i) Explain how complexity theory has helped illuminate several barriers in economics and game theory; and (ii) Illustrate how game-theoretic questions have led to new and interesting complexity theory, including recent several breakthroughs.
- [Eva Tardos. Algorithmic Game Theory](http://www.cs.cornell.edu/courses/cs6840/2012sp/) - It combines algorithmic thinking with game-theoretic, or, more generally, economic concepts. The course will study a range of topics at this interface. The only prerequisite to the course is mathematical thinking.
- [Chekuri. Topics in Algorithms: Algorithmic Game Theory](https://chekuri.cs.illinois.edu/teaching/spring2008/agt.htm) - A broad graduate-level introduction to: auctions, existence and computation of equilibria in games and markets, algorithmic mechanism design, price of anarchy and price of stability, games relevant to networks and e-commerce. The emphasis will be on conceptual ideas and algorithmic aspects. No familiarity with game theory or economics will be assumed.
- [Penna. Algorithmic Game Theory](https://ml2.inf.ethz.ch/courses/agt/) - The course discusses algorithmic aspects of game theory, such as a general introduction to game theory, auctions, mechanisms, the costs of a central control optimum versus those of an equilibrium under selfish agents, and algorithms and complexity of computing equilibria.
- [Brown. Resources list for game theory](http://cs.brown.edu/courses/cs1951k/lectures/) - TAs based these notes in large part on the lecture notes and accompanying videos of Tim Roughgarden's CS 364A and CS 364B courses at Stanford, and Jason Hartline's Mechanism Design and Approximation textbook.
- [Fang. Advanced Topics in Machine Learning and Game Theory](https://feifang.info/advanced-topics-in-machine-learning-and-game-theory-fall-2021/) - A graduate-level course covering the topics at the intersection of machine learning and game theory.
- [Xu. Topics in Learning and Game Theory](http://www.haifeng-xu.com/cs6501sp21/index.htm) - A graduate level course covering topics at the interface between machine learning and game theory.
- [Tim Roughgarden. Foundations of Blockchains](https://timroughgarden.github.io/fob21/) - The science and technology of blockchain protocols and the applications built on top of them, with an emphasis on fundamental principles rather than specific protocols. - See also [Lecture Videos](https://www.youtube.com/playlist?list=PLEGCF-WLh2RLOHv_xUGLqRts_9JxrckiA).
## Books<a name=game_theory_books></a>
- [Apt & Grädel. Lectures in Game Theory for Computer Scientists](https://www.cambridge.org/us/academic/subjects/computer-science/programming-languages-and-applied-logic/lectures-game-theory-computer-scientists) - Games provide mathematical models for interaction, and numerous tasks in computer science can be formulated in game-theoretic terms.
- [Eva Tardos & et.al. Algorithmic Game Theory](https://www.cambridge.org/core/books/algorithmic-game-theory/0092C07CA8B724E1B1BE2238DDD66B38#fndtn-information) - Basic chapters on algorithmic methods for equilibria, mechanism design and combinatorial auctions are followed by chapters on important game theory applications such as incentives and pricing, cost sharing, information markets and cryptography and security.
## Workshops<a name=game_theory_workshops></a>
- [Simons Institute. Economics and Computation Program](https://simons.berkeley.edu/programs/economics2015) - The intersection is motivated by applications such as large-scale digital auctions and markets, and fundamental questions such as the computational complexity of Nash equilibria and complexity and approximation in mechanism design. Also, To productively model and study the Internet and its novel computational phenomena, Models and insights can be gained from from game theory and economic theory. The computational point of view, on the other hand, is essential to understand a world in which markets are networked and the default platforms of economic transactions are algorithmic.
- [Simons Institute. Learning and Games Program](https://simons.berkeley.edu/programs/games2022) - The intersection is manifested by (1) Data input to machine learning algorithms are generated by self-interested parties, (2) Machine learning is used to optimize economic systems or acts, (3) Machine learning models used in critical systems are becoming prone to adversarial attacks, and (4) Several machine learning approaches can be framed as finding the equilibrium of a game.
- [Eva Tardos. Learning and Efficiency in Games](https://simons.berkeley.edu/events/openlectures2015-fall-1) - How to quantify the impact of strategic user behavior on overall performance in games including traffic routing as well as online auctions.
# Math and Logic<a name=math_and_logic></a>
## General<a name=math_and_logic_general></a>
### Lecture Videos Playlist<a name=math_and_logic_general_lecture_videos_playlist></a>
- [Demaine, Abel & Chapman. Mathematics for Computer Science](https://ocw.mit.edu/courses/6-1200j-mathematics-for-computer-science-spring-2024/) - A junior introduction to discrete mathematics for computer scientists. - [Companion Textbook 2015](https://ocw.mit.edu/courses/electrical-engineering-and-computer-science/6-042j-mathematics-for-computer-science-spring-2015/readings/MIT6_042JS15_textbook.pdf)
### Books<a name=math_and_logic_general_books></a>
- [Knuth, Graham & Patashnik. Concrete Mathematics: A Foundation for Computer Science](https://www.pearson.com/us/higher-education/product/Graham-Concrete-Mathematics-A-Foundation-for-Computer-Science-2nd-Edition/9780134389981.html) - An expansion of the Mathematical Preliminaries section in Knuth's classic Art of Computer Programming, but the style of presentation is more leisurely, and individual topics are covered more deeply.
- [Aho & Ullman. Foundations of Computer Science](http://i.stanford.edu/~ullman/focs.html) - A classic math-oriented introduction to computer science.
- [Tu Delft. Delftse Foundations of Computation](https://books.open.tudelft.nl/home/catalog/book/211) - A textbook for a one quarter introductory course in theoretical computer science including logic, proof techniques, and set theory. It assumes no prerequisite other than basic programming.
- [Eck & Critchlow. Foundations of Computation](https://math.hws.edu/FoundationsOfComputation/) - for a one-semester course in theoretical computer science. It has no prerequisites other than introductory computer programming. It includes logic, sets, and function from discrete math, and automata, formal languages, and grammar from upper-level courses.
- [Comprehensive Mathematics for Computer Scientists](https://www.springer.com/series/5517) - A series dedicated to math topics and their relevance to computer science.
- [Krantz. Handbook of Logic and Proof Techniques for Computer Science](https://www.maa.org/press/maa-reviews/handbook-of-logic-and-proof-techniques-for-computer-science) - A concise offered as an accessible reference on mathematical logic for the professional computer scientist.
- [Makinson. Sets, Logic and Maths for Computing](https://www.springer.com/gp/book/9783030422172) - It presents a careful selection of the material most needed by students in their first two years studying computer science.
- [Yves Nievergelt. Logic, Mathematics, and Computer Science: Modern Foundations with Practical Applications](https://www.springer.com/gp/book/9781493932221) - For lower undergraduates, It introduces the reader to logic, proofs, sets, and number theory, Focusing on foundations. It provides complete details and derivations of formal proofs.
- [Lacona. LOGIC: Lecture Notes for Philosophy, Mathematics, and Computer Science](https://link.springer.com/book/10.1007/978-3-030-64811-4) - Suitable for undergraduate introductions to logic and early graduate courses on logic.
- [Ben-Ari. Mathematical Logic for Computer Science](https://www.springer.com/gp/book/9781447141280) - Semantic tableaux are used because they are theoretically sound and easy to understand.
- [Jeremy Kun. A Programmer's Introduction to Mathematics](https://pimbook.org/) - Uses your familiarity with ideas from programming and software to teach mathematics.
- [Vince. Foundation Mathematics for Computer Science: A Visual Approach](https://www.springer.com/gp/book/9783030420772) - A range of mathematical topics to provide a solid foundation for an undergraduate course in computer science, starting with a review of number systems and their relevance to digital computers, and finishing with differential and integral calculus.
- [Oberguggenberger & Ostermann. Analysis for Computer Scientists: Foundations, Methods, and Algorithms](https://www.springer.com/gp/book/9783319911540) - Presents an algorithmic approach to mathematical analysis, with a focus on modelling and on the applications of analysis.
### Lecture Notes<a name=math_and_logic_general_lecture_notes></a>
- [Paluszynski. Calculus for Computer Scientists](https://www.math.uni.wroc.pl/~mpal/academic/2013/lecture_notes.pdf) - calculus lecture notes taught for undergrad computer science students
## TCS Toolkit<a name=math_and_logic_tcs_toolkit></a>
### Lecture Videos Playlists<a name=math_and_logic_tcs_toolkit_lecture_videos_playlists></a>
- [O'Donnell. CS Theory Toolkit](https://www.youtube.com/playlist?list=PLm3J0oaFux3ZYpFLwwrlv_EHH9wtH6pnX) - It covers a large number of the math/CS topics that you need to know for reading and doing research in Computer Science Theory - alternatively: [bilibili](https://www.bilibili.com/video/BV1Ry4y1e7zR)
- [Madhur Tulsiani. Mathematical Toolkit](https://home.ttic.edu/~madhurt/courses/toolkit2021/index.html) - Things prof. Madhur wish he knew in first year of grad school.
- [Harsha & Strivastava. Toolkit for Theoretical Computer Science. Tata Institute](https://www.tifr.res.in/~prahladh/teaching/2020-21/toolkit/)
### Lecture Notes<a name=math_and_logic_tcs_toolkit_lecture_notes></a>
- [Gregory Valiant. The Modern Algorithmic Toolbox. Stanford](https://web.stanford.edu/class/cs168/) - It covers hashing, dimension reduction, linear and convex programming, gradient descent and regression, sampling and estimation, compressive sensing, linear-algebraic techniques (principal components analysis, singular value decomposition, spectral techniques), and an intro to differential privacy.
- [Zhou. A Theorist's Toolkit. Illinois](https://yuanz.web.illinois.edu/teaching/B609fa16/) - It covers a large number of the math/CS topics that you need to know for reading and doing research in Computer Science Theory.
- [O'Donnell. A Theorist's Toolkit. CMU](https://www.cs.cmu.edu/~odonnell/toolkit13/) - It covers a large number of the math/CS topics that you need to know for reading and doing research in Computer Science Theory.
- [Arora. Thinking Like a Theorist. Princeton](https://www.cs.princeton.edu/courses/archive/fall07/cos597D/Site/lectopics.html) - It covers a large number of the math/CS topics that you need to know for reading and doing research in Computer Science Theory.
- [Arora. A Theorist's Toolkit. Princeton](https://www.cs.princeton.edu/courses/archive/fall02/cs597D/) - Aimed primarily at first and second year graduate students who plan to do research in theoretical computer science. We will introduce probabilistic, algebraic, combinatorial, and algorithmic methods useful in proofs.
- [Kelner. Topics in Theoretical Computer Science: An Algorithmist's Toolkit. MIT](https://ocw.mit.edu/courses/18-409-topics-in-theoretical-computer-science-an-algorithmists-toolkit-fall-2009/) - It covers a collection of geometric techniques that apply broadly in modern algorithm design.
- [Maji & Valiant. Theoretical Computer Science Toolkit. Purdue](https://www.cs.purdue.edu/homes/hmaji/teaching/Spring%202023/CS-58500-Spring-2023.html)
### Books<a name=math_and_logic_tcs_toolkit_books></a>
- [Jukna. Extremal Combinatorics](https://web.vu.lt/mif/s.jukna/EC_Book_2nd/index.html) - Combinatorial techniques written largely with an eye to their applications in TCS, and mostly in complexity
## Discrete Mathematics<a name=math_and_logic_discrete_mathematics></a>
### General<a name=math_and_logic_discrete_mathematics_general></a>
#### Lecture Notes<a name=math_and_logic_discrete_mathematics_general_lecture_notes></a>
- [Aspnes. Notes on Discrete Mathematics](https://www.cs.yale.edu/homes/aspnes/classes/202/notes.pdf) - Fall 2017 of the Yale course CPSC 202a, Mathematical Tools for Computer Science.
- [Halpern. CS 2802: Discrete Structures - Honors. 2020. Cornell](https://www.cs.cornell.edu/courses/cs2802/2020fa/cs2802-20f-notes.html) - Honors lecture notes on discrete math - [Homework](https://www.cs.cornell.edu/courses/cs2802/2020fa/cs2802-20f-homework.html)
#### Books<a name=math_and_logic_discrete_mathematics_general_books></a>
- [Rosen. Handbook of Discrete and Combinatorial Mathematics](https://www.taylorfrancis.com/books/handbook-discrete-combinatorial-mathematics-kenneth-rosen-douglas-shier-wayne-goddard/e/10.1201/9781315156484) - A complete survey of roughly all topics of discrete math and their relevance to computing and communication engineering.
- [Rosen. Discrete Mathematics and Its Applications](https://www.mheducation.com/highered/product/discrete-mathematics-applications-rosen/M9780073383095.html) - A canonical discrete math textbook, accessible for even high school students.
- [Rosenberg & Trystram. Understand Mathematics, Understand Computing: Discrete Mathematics That All Computing Students Should Know](https://www.springer.com/gp/book/9783030583750) - It endows the reader with an operational conceptual and methodological understanding of discrete mathematics for computing
- [Gries & Schneider. A Logical Approach to Discrete Math](https://www.springer.com/gp/book/9780387941158) - It attempts to change the way we teach logic to beginning students. Instead of teaching logic as a subject in isolation, we regard it as a basic tool and show how to use it.
#### MOOC<a name=math_and_logic_discrete_mathematics_general_mooc></a>
- [Introduction to Discrete Mathematics for Computer Science. UC San-Diego](https://www.coursera.org/specializations/discrete-mathematics) - Learn the language of Computer Science. Learn the math that defines computer science, and practice applying it through mathematical proofs and Python code.
### Probabilistic Method<a name=math_and_logic_discrete_mathematics_probabilistic_method></a>
#### Lecture Notes<a name=math_and_logic_discrete_mathematics_probabilistic_method_lecture_notes></a>
- [Yufei. Probabilistic Methods in Combinatorics. MIT](https://ocw.mit.edu/courses/18-226-probabilistic-methods-in-combinatorics-fall-2022/pages/syllabus/) and [Yufei's Graph Theory book](https://yufeizhao.com/gtacbook/) - Showing some combinatorial object exists and prove that a certain random construction works with positive probability. The course focuses on methodology as well as combinatorial applications.
#### Lecture Videos Playlist<a name=math_and_logic_discrete_mathematics_probabilistic_method_lecture_videos_playlist></a>
- [Luke Postle. Probablistic Methods. Waterloo](https://www.youtube.com/playlist?list=PL2BdWtDKMS6nRF72s3TOGyBqXwMVHYiLU)
#### Books<a name=math_and_logic_discrete_mathematics_probabilistic_method_books></a>
- [Alon & Spencer. The Probabilistic Method](https://www.wiley.com/en-us/The+Probabilistic+Method%2C+4th+Edition-p-9781119061953) -  A standard reference for researchers in probabilistic methods in combinatorics. Shows also connections to theoretical computer science.
### Graph Theory<a name=math_and_logic_discrete_mathematics_graph_theory></a>
#### Lecture Videos Playlist<a name=math_and_logic_discrete_mathematics_graph_theory_lecture_videos_playlist></a>
- [Graph Theory by Waterloo](https://www.youtube.com/playlist?list=PL2BdWtDKMS6mplieDd_vls0TBX9Fq2jht)
### Other<a name=math_and_logic_discrete_mathematics_other></a>
- [Mariconda & Tonolo. Discrete Calculus: Methods for Counting](https://www.springer.com/gp/book/9783319030371) - An introduction to combinatorics, finite calculus, formal series, recurrences, and approximations of sums. Readers will find also deep insights into a range of less common topics rarely considered within a single book.
# Physics<a name=physics></a>
## Lecture Notes<a name=physics_lecture_notes></a>
- [Arora. The Computational Universe](https://www.cs.princeton.edu/courses/archive/spring11/cos116/lectures.php) - Takes us on a broad sweep of scientific knowledge and related technologies: propositional logic of the ancient Greeks (microprocessors); quantum mechanics (silicon chips); network and system phenomena (internet and search engines); computational intractability (secure encryption); and efficient algorithms (genomic sequencing).
## Books<a name=physics_books></a>
- [Feynman. Feynman And Computation: Exploring The Limits Of Computers](https://www.taylorfrancis.com/books/feynman-computation-anthony-hey/e/10.1201/9780429500459)
- Feynman’s Course on Computation - See also Preskill's update 40 years later [here](https://arxiv.org/abs/2106.10522)
## Monographs<a name=physics_monographs></a>
- [Susskind. Three Lectures on Complexity and Black Holes](https://link.springer.com/book/10.1007/978-3-030-45109-7) - Important connections between thermodynamics and complexity are proposed and discussed. Pedagogically written, serves as a fundamental introduction to black holes and their complex physical interpretation
# Philosophy<a name=philosophy></a>
## Lecture Notes<a name=philosophy_lecture_notes></a>
- [6.893 Philosophy and Theoretical Computer Science. MIT](https://stellar.mit.edu/S/course/6/fa11/6.893/index.html) - It examines the relevance of modern theoretical computer science to traditional questions in philosophy, and conversely, what philosophy can contribute to theoretical computer science.
## Books<a name=philosophy_books></a>
- [Knuth. Things a Computer Scientist Rarely Talks About](https://web.stanford.edu/group/cslipublications/cslipublications/site/1575863278.shtml) - A general illustration of relations between faith and science.
- [Floyd & Bokulich. Philosophical Explorations of the Legacy of Alan Turing: Turing 100](https://www.springer.com/gp/book/9783319532783) - Turing’s place in the history and philosophy of science.
## Papers<a name=philosophy_papers></a>
- [Aaronson. Why Should Philosophers Care About Computational Complexity Theory](https://www.scottaaronson.com/papers/philos.pdf) - It argues that computational complexity theory leads to new perspectives on the nature of mathematical knowledge and other philosophical questions.
- [Aharonov & Vazirani, Is Quantum Mechanics Falsifiable? A Computational Perspective on the Foundations of Quantum Mechanics](https://www.researchgate.net/publication/227171743_Is_Quantum_Mechanics_Falsifiable_A_computational_perspective_on_thefoundations_of_Quantum_Mechanics) - It describes how quantum mechanics can be tested in the limit of high complexity regime by extending the usual scientific paradigm to include.
- [Walter Dean. Computational Complexity Theory and the Philosophy of Mathematics](https://academic.oup.com/philmat/article/27/3/381/5613215) - It highlights the significance of complexity theory relative to questions traditionally asked by philosophers of mathematics while also attempting to isolate some new ones.
- [Stanford Encyclopedia of Philosophy. Computational Complexity Theory](https://plato.stanford.edu/entries/computational-complexity/) - The foundations of complexity theory, and its potential significance on philosophy of computer science, philosophy of mathematics and epistemology.
- [Philip Davis. Toward a Philosophy of Computation](https://www.jstor.org/stable/40247755) - Philosophical implication of mathematization and computerization of the world.
# Surveys & Monographs<a name=surveys__monographs></a>
- [Sommaruga & Strahm. Turing’s Revolution: The Impact of His Ideas about Computability](https://link.springer.com/book/10.1007/978-3-319-22156-4) - A collection of historical, technical and philosophical papers.
- [Harry Lewis. Ideas That Created the Future: Classic Papers of Computer Science ](https://mitpress.mit.edu/9780262045308/ideas-that-created-the-future/) - Classic papers by thinkers ranging from Aristotle and Leibniz to Norbert Wiener and Gordon Moore that chart the evolution of computer science.
- [Building Bridges I](https://rd.springer.com/book/10.1007/978-3-540-85221-6), [Building Bridges II](https://link.springer.com/book/10.1007/978-3-662-59204-5), [Fete of Combinatorics and Computer Science](https://link.springer.com/book/10.1007/978-3-642-13580-4) - Collected works in celebration of Laszlo Lovasz, Connecting discrete math with computer science.
- [Fortnow & Homer. A Short History of Computational Complexity](https://www.researchgate.net/profile/Lance-Fortnow/publication/220530495_A_Short_History_of_Computational_Complexity/links/0deec52bd7ab603fef000000/A-Short-History-of-Computational-Complexity.pdf) - A historical overview of computational complexity.
- [Goldreich. Providing Sound Foundations for Cryptography: On the Work of Shafi Goldwasser and Silvio Micali](http://www.wisdom.weizmann.ac.il/~oded/sst.html) - It explains the remarkable work of Shafi and Silvio and their works' implications on foundations of cryptography.
# Community<a name=community></a>
## Conferences & Workshops<a name=community_conferences__workshops></a>
### Aggregators<a name=community_conferences__workshops_aggregators></a>
- [Hermann's Conferences in TCS](https://www.lix.polytechnique.fr/~hermann/conf.php) - TCS Conferences collected in one table.
- [CS Theory Events Aggregator](https://cstheory-events.org/) - An aggregator for CS theory workshops and schools.
- [Theory Announcements](https://dmatheorynet.blogspot.com/) - DMANET spreads information on conferences, workshops, seminars etc. relating to discrete mathematics and algorithms.
- [Salamon's List](https://cstheory.stackexchange.com/a/7901/57686) - Selected Conferences.
### Live<a name=community_conferences__workshops_live></a>
- [Simons' Institute](https://simons.berkeley.edu/) - Programs, Events, and workshops, that aim toward maximizing impact and engagement across the theoretical computer science community.
- [TCS+](https://www.youtube.com/user/TCSplusSeminars) - A series of online seminars in theoretical computer science. The goal is to make engaging talks accessible to the widest possible audience.
- [CMU Theory](https://www.youtube.com/channel/UCWFp4UWNiOv71j0sPbdNiqw) - Aims for a mathematical understanding of fundamental issues in Computer Science, and to use this understanding to produce better algorithms, protocols, and systems, as well as identify the inherent limitations of efficient computation.
### Archived<a name=community_conferences__workshops_archived></a>
- [Turing Laureates Lectures](https://www.youtube.com/playlist?list=PLn0nrSd4xjjYCkOxtYqozyDuwt-4sC2L6) and [Turing Laureates Interviews](https://www.youtube.com/playlist?list=PLn0nrSd4xjjaSLBSzmno-3Ods6FJE9nlO) - ACM Turing Award Laureates delivers a lecture before a forum of their choice on a subject of their choice.
- [Computational Complexity](https://www.youtube.com/channel/UCzBw287tly0c2lE6a-9XymA) - Collection of workshops.
## Magazines & Newsletter<a name=community_magazines__newsletter></a>
- [EATCS Bulletin](https://eatcs.org/index.php/on-line-issues) - Surveys, tutorials, conferences reports, events, open problems and solutions, PhD Theses, and entertaining contributions.
- [SIGACT News](https://dl.acm.org/loi/sigact) - ACM's official theoretical computer science news feed.
- [Foundations and Trends in Theoretical Computer Science](https://www.nowpublishers.com/TCS) - It provides monographs written by leaders that give tutorial coverage of subjects, research retrospectives as well as survey papers that offer state-of-the-art reviews fall within the scope of the journal.
- [Quanta Magazine](https://www.quantamagazine.org/tag/computational-complexity) - Features breakthroughs in the field, written in an accessible style for non-experts.
## Associations<a name=community_associations></a>
- [ACM's SIGACT](https://sigact.org/)
- [European Association of TCS](https://www.eatcs.org/)
## Blogs<a name=community_blogs></a>
### Aggregators<a name=community_blogs_aggregators></a>
- [Theory of Computing Blog Aggregator](https://theory.report/) - A blog Aggregator for all blogs related to TCS.
### Selected Posts and Essays<a name=community_blogs_selected_posts_and_essays></a>
- [Omer Reingold. The Practice of Theory Research](https://omereingold.wordpress.com/cs-163-the-practice-of-theory-research/) - A research methods course, concentrating on the how rather than the what. It focuses on research practices common for computer science theory research.
- [Omer Reingold. TOC: a Personal Perspective (2021)](https://theorydish.blog/2021/04/15/toc-a-personal-perspective-2021/) - In celebration of 25 years for “TOC: a Scientific Perspective (1996),” by Oded Goldreich and Avi Wigderson. It spots the light on a criticism directed to TCS, that it is not as deep as Math and not as useful as CS.
- [Blum. You and Your Research: An Advice to a Beginning Graduate Student](https://www.cs.cmu.edu/~mblum/research/pdf/grad.html) - Manuel Blum, A very popular figure in TCS, gives research advices for juniors.
- [Dijkstra. The Three Golden Rules for Successful Scientific Research](https://link.springer.com/chapter/10.1007%2F978-1-4612-5695-3_58) - A note devoted to three rules that must be followed if you want to be successful in scientific research.
- [Goldreich. Essays and Opinions](http://www.wisdom.weizmann.ac.il/~oded/essays.html) - Personal Essays by Oded Goldreich. They are very unique in their conceptual message of TCS and its community.
- [Barak. Advice for The Budding Theorist](https://windowsontheory.org/2015/11/03/advice-for-the-budding-theorist/) - Tips for anyone interested in theoretical computer science.
- [Barak. Surveys For Students](https://thmatters.wordpress.com/surveys/) - Surveys for high-school, undergraduate, and even researchers.
- [Barak. Non-technical or Less-technical Writings and Talks](https://www.boazbarak.org/informal/) - Posts oriented more for a less-technically matured audience.
- [Lipton & Regan](https://rjlipton.wpcomstaging.com/2022/01/26/a-list-of-most-theory-blogs/) - A list of theory blogs for computer science.
- [Karp. A Personal View of Computer Science at Berkeley](https://www2.eecs.berkeley.edu/bears/CS_Anniversary/karp-talk.html) - Karp addresses: In 1968 computer science at Berkeley was problematic, with two departments working independently to develop programs, and his personal reflections.
- [Hamming. You and Your Research](https://www.cs.virginia.edu/~robins/YouAndYourResearch.html) - Why do so few scientists make significant contributions and so many are forgotten in the long run? The talk is about what Hamming has learned.
- [Weinberg. Four Golden Lessons](https://www.nature.com/articles/426389a) - Lessons for students and researchers given by Steven Weinberg.
- [Princeton's Companion. Advice to a Young Mathematician](http://assets.press.princeton.edu/chapters/gowers/gowers_VIII_6.pdf) - Five contributors draw on their experiences of mathematical life and research, and to offer advice that they might have liked to receive when they were just setting-out on their careers.
- [Terry. Career Advice](https://terrytao.wordpress.com/career-advice/) - A collection of various pieces of advice on academic career issues in mathematics, roughly arranged by the stage of career at which the advice is most pertinent.
- [Igor Pak. How to Start a Paper](https://igorpak.wordpress.com/2022/10/26/how-to-start-a-paper/) - Why should you introduce a conceptual preliminary motivating the story of your paper.
## Jobs<a name=community_jobs></a>
- [Rubinstein & Weinberg. Research Masters in TCS](https://www.cs.princeton.edu/~smattw/masters/masters.html) - A list of master programs in TCS.
- [CS Theory Jobs](https://cstheory-jobs.org) - TCS Jobs announcements.
- [Yaroslavtsev. Hires spreadsheet 2022](http://grigory.us/blog/posts/) - A crowdsourced spreadsheet created to collect information about theory hires in year 2022.
## Online Communities<a name=community_online_communities></a>
- [TCS Stack Exchange](https://cstheory.stackexchange.com/) - Research-oriented Q&A of theoretical computer science.
- [TCS Subreddit](https://www.reddit.com/r/theoreticalcs)- Theoretical computer science's subreddit.
# Other<a name=other></a>
## Podcasts<a name=other_podcasts></a>
- Lex Fridman - [Donald Knuth 1](https://www.youtube.com/watch?v=2BdBfsXbST8) | [Donald Knuth 2](https://www.youtube.com/watch?v=EE1R8FYUJm0) | [Silvio Micali](https://www.youtube.com/watch?v=zNdhgOk4-fE) | [Richard Karp](https://www.youtube.com/watch?v=KllCrlfLuzs) | [Scott Aaronson 1](https://www.youtube.com/watch?v=uX5t8EivCaM) | [Scott Aaronson 2](https://www.youtube.com/watch?v=nAMjv0NAESM)
- [Berkeley in the 80s](https://www.youtube.com/playlist?list=PLUFeA6y-5sFmXMJv2uAmMig3Urgfkg_2O) - Interviews with eminent figures in Berkeley.
- [Simons' Theory Shorts](https://www.youtube.com/playlist?list=PLgKuh-lKre134Psz9KECgjuwJ47l3IvqW) - Short accessible videos which populate theory of computation.
- [ACM ByteCast](https://www.youtube.com/playlist?list=PLn0nrSd4xjjbCHzgtvc9HDRU80HHaD0Lr) - Researchers, practitioners and innovators who are at the intersection of research and practice, sharing their experiences, lessons, visions for the future.
## Popular Science<a name=other_popular_science></a>
- [The Legacy of Alan Turing: Pushing the Boundaries of Computation (Volume 18, Issue 3, Spring 2012). ACM, XRDS](https://dl.acm.org/toc/xrds/2012/18/3) - ACM's students magazine special issue for theory of computation.
- [Fortnow. The Golden Ticket: P, NP, and the Search for the Impossible](https://goldenticket.fortnow.com) - A nontechnical introduction to P-NP, its rich history, and its algorithmic implications for everything we do with computers and beyond.
- [Ausiello. The Making of a New Science: A Personal Journey Through the Early Years of Theoretical Computer Science](https://link.springer.com/book/10.1007/978-3-319-62680-2) - A story about people, pioneers with diverse backgrounds and characters who established a new field.
- [Aaronson. Quantum Computing Since Democritus](https://assets.cambridge.org/97805211/99568/frontmatter/9780521199568_frontmatter.pdf) - It covers an amazing array of topics. Beginning in antiquity with Democritus, it progresses through logic and set theory,computability and complexity theory, quantum computing, cryptography, the information content of quantum states, and the interpretation of quantum mechanics.
- [Deutsch. The Fabric of Reality: The Science of Parallel Universes and Its Implications](http://www.daviddeutsch.org.uk/books/the-fabric-of-reality/) - The Fabric of Reality presents a startlingly integrated, rational and optimistic world view – the result of taking seriously the deepest ideas of modern science and the philosophy of science.
- [Papadimitriou. Turing: A Novel About Computation](https://mitpress.mit.edu/books/turing-novel-about-computation) - The world of computation according to Turing, an interactive tutoring program, as told to star-crossed lovers: a novel.
- [Teuscher. Alan Turing: Life and Legacy of a Great. Springer](https://link.springer.com/book/10.1007/978-3-662-05642-4) - Essays which spans the entire rich spectrum of Turing's life, research work and legacy.
- [Petzold. The Annotated Turing: A Guided Tour Through Alan Turing's Historic Paper on Computability and the Turing Machine](http://www.charlespetzold.com/AnnotatedTuring/) -  A Guided Tour through Alan Turing's Historic Paper on Computability and the Turing Machine.
- [Shasha & Lazere. Out of their Minds: The Lives and Discoveries of 15 Great Computer Scientists](https://www.springer.com/gp/book/9780387982694) - Interviews with era's greatest scientists about their inspirations, discoveries, and personal interests.
## Cheat Sheets<a name=other_cheat_sheets></a>
- [TCS Cheat Sheet](https://www.cosy.sbg.ac.at/~held/teaching/aads/TCS-cheat_sheet.pdf) - A sheet of notes containing essential toolboxes needed by any theoretical computer scientist.
- [Useful Inequalities Cheat Sheet](http://www.lkozma.net/inequalities_cheat_sheet/)
# Related Lists<a name=related_lists></a>
- [Algorithms](https://github.com/tayllan/awesome-algorithms).
- [Mathematics](https://github.com/rossant/awesome-math) - Freely available lecture notes on mathematics.
- [nLab](https://ncatlab.org/nlab/show/mathematics) & [Gratzer](https://github.com/jozefg/learn-tt) - Logic, Math, Proof Assistants, and Type Theory.
- [Cryptography](https://github.com/sobolevn/awesome-cryptography).
- [Quantum Computing](https://github.com/desireevl/awesome-quantum-computing).
- [Math](https://github.com/ossu/math) and [CS](https://github.com/ossu/computer-science) curricula by [Open Source Society University](https://github.com/ossu).
