# Contributing to Awesome Credit Modeling

Thank you for your interest and for taking the time to contribute!

**Working on your first Pull Request?** You can learn how from this *free* series [How to Contribute to an Open Source Project on GitHub](https://egghead.io/series/how-to-contribute-to-an-open-source-project-on-github) 

## Contribution Guidelines

Please ensure your pull request adheres to the following guidelines:

- Search previous suggestions before making a new one, as yours may be a duplicate.
- Make sure your resource is useful before submitting. That implies it being relevant to the topic and providing a perspective or insight not given by the current itens.
- Make an individual pull request for each suggestion.
- The commit message subject should idealy follow the `Add [Main Author], [Publication Year]` format.  
- The commit message body should idealy follow the `Add [Full Title] by [Main Author], [Publication Year] to the [Section] section` format.
- Titles should be [capitalized](http://grammar.yourdictionary.com/capitalization/rules-for-capitalization-in-titles.html).
- Articles/book chapters should be listed with their full and exact titles.
- New categories or improvements to the existing categorization are welcome.
  - When adding a new category, provide a brief explanation of your reasoning.
- Check your spelling and grammar.
- Make sure your text editor is set to remove trailing whitespace.

Thank you for your suggestions!

## Adding something to the list

1. Make sure you have a [GitHub Account](https://github.com/join)  
2. In the project page, click the [`README.md`](README.md) file  
3. Click on *Edit this file* (pencil icon)  

![Item 3 - Click on Edit](https://user-images.githubusercontent.com/57960694/87834572-2668b280-c861-11ea-8bee-4ff94220cfee.png)

4. An editor window will appear. Add your suggested change, making sure to follow the guidelines above.  
5. When you're done, describe your proposed changes, and then click on *Propose file change*.

![Item 5 - Propose file change](https://user-images.githubusercontent.com/57960694/87834568-25378580-c861-11ea-8ae5-bec529a481bd.png)

6. Finally, create your pull request 

![Item 6 - Create your pull request](https://user-images.githubusercontent.com/57960694/87834574-27014900-c861-11ea-843b-f2fdf7b130f1.png)
