/*
 * Copyright (c) "Neo4j"
 * Neo4j Sweden AB [https://neo4j.com]
 *
 * This file is part of Neo4j.
 *
 * Neo4j is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
package org.neo4j.bolt.transport.configuration;

import io.netty.channel.EventLoopGroup;
import io.netty.channel.ServerChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.channel.unix.DomainSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.ThreadFactory;

public class NioConfigurationProvider implements ServerConfigurationProvider {
    public static final NioConfigurationProvider INSTANCE = new NioConfigurationProvider();

    private NioConfigurationProvider() {}

    @Override
    public EventLoopGroup createEventLoopGroup(ThreadFactory threadFactory) {
        return new NioEventLoopGroup(0, threadFactory);
    }

    @Override
    public Class<? extends ServerChannel> getChannelClass(SocketAddress socketAddress) {
        if (socketAddress instanceof DomainSocketAddress) {
            throw new IllegalArgumentException("Unix Domain Sockets cannot be used with Nio Configuration.");
        } else {
            return NioServerSocketChannel.class;
        }
    }
}
