/*
 * Copyright (c) "Neo4j"
 * Neo4j Sweden AB [https://neo4j.com]
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.neo4j.cypher.internal.parser.v25;

import org.antlr.v4.runtime.tree.ParseTreeListener;

/**
 * A ParseTreeListener for Cypher25Parser.
 * Generated by org.neo4j.cypher.internal.parser.GenerateListenerMavenPlugin
 */
public interface Cypher25ParserListener extends ParseTreeListener {
    void exitStatements(Cypher25Parser.StatementsContext ctx);

    void exitStatement(Cypher25Parser.StatementContext ctx);

    void exitRegularQuery(Cypher25Parser.RegularQueryContext ctx);

    void exitSingleQuery(Cypher25Parser.SingleQueryContext ctx);

    void exitClause(Cypher25Parser.ClauseContext ctx);

    void exitUseClause(Cypher25Parser.UseClauseContext ctx);

    void exitGraphReference(Cypher25Parser.GraphReferenceContext ctx);

    void exitFinishClause(Cypher25Parser.FinishClauseContext ctx);

    void exitReturnClause(Cypher25Parser.ReturnClauseContext ctx);

    void exitReturnBody(Cypher25Parser.ReturnBodyContext ctx);

    void exitReturnItem(Cypher25Parser.ReturnItemContext ctx);

    void exitReturnItems(Cypher25Parser.ReturnItemsContext ctx);

    void exitOrderItem(Cypher25Parser.OrderItemContext ctx);

    void exitAscToken(Cypher25Parser.AscTokenContext ctx);

    void exitDescToken(Cypher25Parser.DescTokenContext ctx);

    void exitOrderBy(Cypher25Parser.OrderByContext ctx);

    void exitSkip(Cypher25Parser.SkipContext ctx);

    void exitLimit(Cypher25Parser.LimitContext ctx);

    void exitWhereClause(Cypher25Parser.WhereClauseContext ctx);

    void exitWithClause(Cypher25Parser.WithClauseContext ctx);

    void exitCreateClause(Cypher25Parser.CreateClauseContext ctx);

    void exitInsertClause(Cypher25Parser.InsertClauseContext ctx);

    void exitSetClause(Cypher25Parser.SetClauseContext ctx);

    void exitSetItem(Cypher25Parser.SetItemContext ctx);

    void exitRemoveClause(Cypher25Parser.RemoveClauseContext ctx);

    void exitRemoveItem(Cypher25Parser.RemoveItemContext ctx);

    void exitDeleteClause(Cypher25Parser.DeleteClauseContext ctx);

    void exitMatchClause(Cypher25Parser.MatchClauseContext ctx);

    void exitMatchMode(Cypher25Parser.MatchModeContext ctx);

    void exitHint(Cypher25Parser.HintContext ctx);

    void exitMergeClause(Cypher25Parser.MergeClauseContext ctx);

    void exitMergeAction(Cypher25Parser.MergeActionContext ctx);

    void exitUnwindClause(Cypher25Parser.UnwindClauseContext ctx);

    void exitCallClause(Cypher25Parser.CallClauseContext ctx);

    void exitProcedureName(Cypher25Parser.ProcedureNameContext ctx);

    void exitProcedureArgument(Cypher25Parser.ProcedureArgumentContext ctx);

    void exitProcedureResultItem(Cypher25Parser.ProcedureResultItemContext ctx);

    void exitLoadCSVClause(Cypher25Parser.LoadCSVClauseContext ctx);

    void exitForeachClause(Cypher25Parser.ForeachClauseContext ctx);

    void exitSubqueryClause(Cypher25Parser.SubqueryClauseContext ctx);

    void exitSubqueryScope(Cypher25Parser.SubqueryScopeContext ctx);

    void exitSubqueryInTransactionsParameters(Cypher25Parser.SubqueryInTransactionsParametersContext ctx);

    void exitSubqueryInTransactionsBatchParameters(Cypher25Parser.SubqueryInTransactionsBatchParametersContext ctx);

    void exitSubqueryInTransactionsErrorParameters(Cypher25Parser.SubqueryInTransactionsErrorParametersContext ctx);

    void exitSubqueryInTransactionsReportParameters(Cypher25Parser.SubqueryInTransactionsReportParametersContext ctx);

    void exitOrderBySkipLimitClause(Cypher25Parser.OrderBySkipLimitClauseContext ctx);

    void exitPatternList(Cypher25Parser.PatternListContext ctx);

    void exitInsertPatternList(Cypher25Parser.InsertPatternListContext ctx);

    void exitPattern(Cypher25Parser.PatternContext ctx);

    void exitInsertPattern(Cypher25Parser.InsertPatternContext ctx);

    void exitQuantifier(Cypher25Parser.QuantifierContext ctx);

    void exitAnonymousPattern(Cypher25Parser.AnonymousPatternContext ctx);

    void exitShortestPathPattern(Cypher25Parser.ShortestPathPatternContext ctx);

    void exitPatternElement(Cypher25Parser.PatternElementContext ctx);

    void exitSelector(Cypher25Parser.SelectorContext ctx);

    void exitGroupToken(Cypher25Parser.GroupTokenContext ctx);

    void exitPathToken(Cypher25Parser.PathTokenContext ctx);

    void exitPathPatternNonEmpty(Cypher25Parser.PathPatternNonEmptyContext ctx);

    void exitNodePattern(Cypher25Parser.NodePatternContext ctx);

    void exitInsertNodePattern(Cypher25Parser.InsertNodePatternContext ctx);

    void exitParenthesizedPath(Cypher25Parser.ParenthesizedPathContext ctx);

    void exitNodeLabels(Cypher25Parser.NodeLabelsContext ctx);

    void exitNodeLabelsIs(Cypher25Parser.NodeLabelsIsContext ctx);

    void exitDynamicExpression(Cypher25Parser.DynamicExpressionContext ctx);

    void exitDynamicAnyAllExpression(Cypher25Parser.DynamicAnyAllExpressionContext ctx);

    void exitDynamicLabelType(Cypher25Parser.DynamicLabelTypeContext ctx);

    void exitLabelType(Cypher25Parser.LabelTypeContext ctx);

    void exitRelType(Cypher25Parser.RelTypeContext ctx);

    void exitLabelOrRelType(Cypher25Parser.LabelOrRelTypeContext ctx);

    void exitProperties(Cypher25Parser.PropertiesContext ctx);

    void exitRelationshipPattern(Cypher25Parser.RelationshipPatternContext ctx);

    void exitInsertRelationshipPattern(Cypher25Parser.InsertRelationshipPatternContext ctx);

    void exitLeftArrow(Cypher25Parser.LeftArrowContext ctx);

    void exitArrowLine(Cypher25Parser.ArrowLineContext ctx);

    void exitRightArrow(Cypher25Parser.RightArrowContext ctx);

    void exitPathLength(Cypher25Parser.PathLengthContext ctx);

    void exitLabelExpression(Cypher25Parser.LabelExpressionContext ctx);

    void exitLabelExpression4(Cypher25Parser.LabelExpression4Context ctx);

    void exitLabelExpression4Is(Cypher25Parser.LabelExpression4IsContext ctx);

    void exitLabelExpression3(Cypher25Parser.LabelExpression3Context ctx);

    void exitLabelExpression3Is(Cypher25Parser.LabelExpression3IsContext ctx);

    void exitLabelExpression2(Cypher25Parser.LabelExpression2Context ctx);

    void exitLabelExpression2Is(Cypher25Parser.LabelExpression2IsContext ctx);

    void exitLabelExpression1(Cypher25Parser.LabelExpression1Context ctx);

    void exitLabelExpression1Is(Cypher25Parser.LabelExpression1IsContext ctx);

    void exitInsertNodeLabelExpression(Cypher25Parser.InsertNodeLabelExpressionContext ctx);

    void exitInsertRelationshipLabelExpression(Cypher25Parser.InsertRelationshipLabelExpressionContext ctx);

    void exitExpression(Cypher25Parser.ExpressionContext ctx);

    void exitExpression11(Cypher25Parser.Expression11Context ctx);

    void exitExpression10(Cypher25Parser.Expression10Context ctx);

    void exitExpression9(Cypher25Parser.Expression9Context ctx);

    void exitExpression8(Cypher25Parser.Expression8Context ctx);

    void exitExpression7(Cypher25Parser.Expression7Context ctx);

    void exitComparisonExpression6(Cypher25Parser.ComparisonExpression6Context ctx);

    void exitNormalForm(Cypher25Parser.NormalFormContext ctx);

    void exitExpression6(Cypher25Parser.Expression6Context ctx);

    void exitExpression5(Cypher25Parser.Expression5Context ctx);

    void exitExpression4(Cypher25Parser.Expression4Context ctx);

    void exitExpression3(Cypher25Parser.Expression3Context ctx);

    void exitExpression2(Cypher25Parser.Expression2Context ctx);

    void exitPostFix(Cypher25Parser.PostFixContext ctx);

    void exitProperty(Cypher25Parser.PropertyContext ctx);

    void exitDynamicProperty(Cypher25Parser.DynamicPropertyContext ctx);

    void exitPropertyExpression(Cypher25Parser.PropertyExpressionContext ctx);

    void exitDynamicPropertyExpression(Cypher25Parser.DynamicPropertyExpressionContext ctx);

    void exitExpression1(Cypher25Parser.Expression1Context ctx);

    void exitLiteral(Cypher25Parser.LiteralContext ctx);

    void exitCaseExpression(Cypher25Parser.CaseExpressionContext ctx);

    void exitCaseAlternative(Cypher25Parser.CaseAlternativeContext ctx);

    void exitExtendedCaseExpression(Cypher25Parser.ExtendedCaseExpressionContext ctx);

    void exitExtendedCaseAlternative(Cypher25Parser.ExtendedCaseAlternativeContext ctx);

    void exitExtendedWhen(Cypher25Parser.ExtendedWhenContext ctx);

    void exitListComprehension(Cypher25Parser.ListComprehensionContext ctx);

    void exitPatternComprehension(Cypher25Parser.PatternComprehensionContext ctx);

    void exitReduceExpression(Cypher25Parser.ReduceExpressionContext ctx);

    void exitListItemsPredicate(Cypher25Parser.ListItemsPredicateContext ctx);

    void exitNormalizeFunction(Cypher25Parser.NormalizeFunctionContext ctx);

    void exitTrimFunction(Cypher25Parser.TrimFunctionContext ctx);

    void exitPatternExpression(Cypher25Parser.PatternExpressionContext ctx);

    void exitShortestPathExpression(Cypher25Parser.ShortestPathExpressionContext ctx);

    void exitParenthesizedExpression(Cypher25Parser.ParenthesizedExpressionContext ctx);

    void exitMapProjection(Cypher25Parser.MapProjectionContext ctx);

    void exitMapProjectionElement(Cypher25Parser.MapProjectionElementContext ctx);

    void exitCountStar(Cypher25Parser.CountStarContext ctx);

    void exitExistsExpression(Cypher25Parser.ExistsExpressionContext ctx);

    void exitCountExpression(Cypher25Parser.CountExpressionContext ctx);

    void exitCollectExpression(Cypher25Parser.CollectExpressionContext ctx);

    void exitNumberLiteral(Cypher25Parser.NumberLiteralContext ctx);

    void exitSignedIntegerLiteral(Cypher25Parser.SignedIntegerLiteralContext ctx);

    void exitListLiteral(Cypher25Parser.ListLiteralContext ctx);

    void exitPropertyKeyName(Cypher25Parser.PropertyKeyNameContext ctx);

    void exitParameter(Cypher25Parser.ParameterContext ctx);

    void exitParameterName(Cypher25Parser.ParameterNameContext ctx);

    void exitFunctionInvocation(Cypher25Parser.FunctionInvocationContext ctx);

    void exitFunctionArgument(Cypher25Parser.FunctionArgumentContext ctx);

    void exitFunctionName(Cypher25Parser.FunctionNameContext ctx);

    void exitNamespace(Cypher25Parser.NamespaceContext ctx);

    void exitVariable(Cypher25Parser.VariableContext ctx);

    void exitNonEmptyNameList(Cypher25Parser.NonEmptyNameListContext ctx);

    void exitType(Cypher25Parser.TypeContext ctx);

    void exitTypePart(Cypher25Parser.TypePartContext ctx);

    void exitTypeName(Cypher25Parser.TypeNameContext ctx);

    void exitTypeNullability(Cypher25Parser.TypeNullabilityContext ctx);

    void exitTypeListSuffix(Cypher25Parser.TypeListSuffixContext ctx);

    void exitCommand(Cypher25Parser.CommandContext ctx);

    void exitCreateCommand(Cypher25Parser.CreateCommandContext ctx);

    void exitDropCommand(Cypher25Parser.DropCommandContext ctx);

    void exitShowCommand(Cypher25Parser.ShowCommandContext ctx);

    void exitShowCommandYield(Cypher25Parser.ShowCommandYieldContext ctx);

    void exitYieldItem(Cypher25Parser.YieldItemContext ctx);

    void exitYieldSkip(Cypher25Parser.YieldSkipContext ctx);

    void exitYieldLimit(Cypher25Parser.YieldLimitContext ctx);

    void exitYieldClause(Cypher25Parser.YieldClauseContext ctx);

    void exitCommandOptions(Cypher25Parser.CommandOptionsContext ctx);

    void exitTerminateCommand(Cypher25Parser.TerminateCommandContext ctx);

    void exitComposableCommandClauses(Cypher25Parser.ComposableCommandClausesContext ctx);

    void exitComposableShowCommandClauses(Cypher25Parser.ComposableShowCommandClausesContext ctx);

    void exitShowIndexCommand(Cypher25Parser.ShowIndexCommandContext ctx);

    void exitShowIndexType(Cypher25Parser.ShowIndexTypeContext ctx);

    void exitShowIndexesEnd(Cypher25Parser.ShowIndexesEndContext ctx);

    void exitShowConstraintCommand(Cypher25Parser.ShowConstraintCommandContext ctx);

    void exitShowConstraintEntity(Cypher25Parser.ShowConstraintEntityContext ctx);

    void exitConstraintExistType(Cypher25Parser.ConstraintExistTypeContext ctx);

    void exitShowConstraintsEnd(Cypher25Parser.ShowConstraintsEndContext ctx);

    void exitShowProcedures(Cypher25Parser.ShowProceduresContext ctx);

    void exitShowFunctions(Cypher25Parser.ShowFunctionsContext ctx);

    void exitFunctionToken(Cypher25Parser.FunctionTokenContext ctx);

    void exitExecutableBy(Cypher25Parser.ExecutableByContext ctx);

    void exitShowFunctionsType(Cypher25Parser.ShowFunctionsTypeContext ctx);

    void exitShowTransactions(Cypher25Parser.ShowTransactionsContext ctx);

    void exitTerminateTransactions(Cypher25Parser.TerminateTransactionsContext ctx);

    void exitShowSettings(Cypher25Parser.ShowSettingsContext ctx);

    void exitSettingToken(Cypher25Parser.SettingTokenContext ctx);

    void exitNamesAndClauses(Cypher25Parser.NamesAndClausesContext ctx);

    void exitStringsOrExpression(Cypher25Parser.StringsOrExpressionContext ctx);

    void exitCommandNodePattern(Cypher25Parser.CommandNodePatternContext ctx);

    void exitCommandRelPattern(Cypher25Parser.CommandRelPatternContext ctx);

    void exitCreateConstraint(Cypher25Parser.CreateConstraintContext ctx);

    void exitConstraintType(Cypher25Parser.ConstraintTypeContext ctx);

    void exitDropConstraint(Cypher25Parser.DropConstraintContext ctx);

    void exitCreateIndex(Cypher25Parser.CreateIndexContext ctx);

    void exitCreateIndex_(Cypher25Parser.CreateIndex_Context ctx);

    void exitCreateFulltextIndex(Cypher25Parser.CreateFulltextIndexContext ctx);

    void exitFulltextNodePattern(Cypher25Parser.FulltextNodePatternContext ctx);

    void exitFulltextRelPattern(Cypher25Parser.FulltextRelPatternContext ctx);

    void exitCreateLookupIndex(Cypher25Parser.CreateLookupIndexContext ctx);

    void exitLookupIndexNodePattern(Cypher25Parser.LookupIndexNodePatternContext ctx);

    void exitLookupIndexRelPattern(Cypher25Parser.LookupIndexRelPatternContext ctx);

    void exitDropIndex(Cypher25Parser.DropIndexContext ctx);

    void exitPropertyList(Cypher25Parser.PropertyListContext ctx);

    void exitEnclosedPropertyList(Cypher25Parser.EnclosedPropertyListContext ctx);

    void exitAlterCommand(Cypher25Parser.AlterCommandContext ctx);

    void exitRenameCommand(Cypher25Parser.RenameCommandContext ctx);

    void exitGrantCommand(Cypher25Parser.GrantCommandContext ctx);

    void exitDenyCommand(Cypher25Parser.DenyCommandContext ctx);

    void exitRevokeCommand(Cypher25Parser.RevokeCommandContext ctx);

    void exitUserNames(Cypher25Parser.UserNamesContext ctx);

    void exitRoleNames(Cypher25Parser.RoleNamesContext ctx);

    void exitRoleToken(Cypher25Parser.RoleTokenContext ctx);

    void exitEnableServerCommand(Cypher25Parser.EnableServerCommandContext ctx);

    void exitAlterServer(Cypher25Parser.AlterServerContext ctx);

    void exitRenameServer(Cypher25Parser.RenameServerContext ctx);

    void exitDropServer(Cypher25Parser.DropServerContext ctx);

    void exitShowServers(Cypher25Parser.ShowServersContext ctx);

    void exitAllocationCommand(Cypher25Parser.AllocationCommandContext ctx);

    void exitDeallocateDatabaseFromServers(Cypher25Parser.DeallocateDatabaseFromServersContext ctx);

    void exitReallocateDatabases(Cypher25Parser.ReallocateDatabasesContext ctx);

    void exitCreateRole(Cypher25Parser.CreateRoleContext ctx);

    void exitDropRole(Cypher25Parser.DropRoleContext ctx);

    void exitRenameRole(Cypher25Parser.RenameRoleContext ctx);

    void exitShowRoles(Cypher25Parser.ShowRolesContext ctx);

    void exitGrantRole(Cypher25Parser.GrantRoleContext ctx);

    void exitRevokeRole(Cypher25Parser.RevokeRoleContext ctx);

    void exitCreateUser(Cypher25Parser.CreateUserContext ctx);

    void exitDropUser(Cypher25Parser.DropUserContext ctx);

    void exitRenameUser(Cypher25Parser.RenameUserContext ctx);

    void exitAlterCurrentUser(Cypher25Parser.AlterCurrentUserContext ctx);

    void exitAlterUser(Cypher25Parser.AlterUserContext ctx);

    void exitRemoveNamedProvider(Cypher25Parser.RemoveNamedProviderContext ctx);

    void exitPassword(Cypher25Parser.PasswordContext ctx);

    void exitPasswordOnly(Cypher25Parser.PasswordOnlyContext ctx);

    void exitPasswordExpression(Cypher25Parser.PasswordExpressionContext ctx);

    void exitPasswordChangeRequired(Cypher25Parser.PasswordChangeRequiredContext ctx);

    void exitUserStatus(Cypher25Parser.UserStatusContext ctx);

    void exitHomeDatabase(Cypher25Parser.HomeDatabaseContext ctx);

    void exitSetAuthClause(Cypher25Parser.SetAuthClauseContext ctx);

    void exitUserAuthAttribute(Cypher25Parser.UserAuthAttributeContext ctx);

    void exitShowUsers(Cypher25Parser.ShowUsersContext ctx);

    void exitShowCurrentUser(Cypher25Parser.ShowCurrentUserContext ctx);

    void exitShowSupportedPrivileges(Cypher25Parser.ShowSupportedPrivilegesContext ctx);

    void exitShowPrivileges(Cypher25Parser.ShowPrivilegesContext ctx);

    void exitShowRolePrivileges(Cypher25Parser.ShowRolePrivilegesContext ctx);

    void exitShowUserPrivileges(Cypher25Parser.ShowUserPrivilegesContext ctx);

    void exitPrivilegeAsCommand(Cypher25Parser.PrivilegeAsCommandContext ctx);

    void exitPrivilegeToken(Cypher25Parser.PrivilegeTokenContext ctx);

    void exitPrivilege(Cypher25Parser.PrivilegeContext ctx);

    void exitAllPrivilege(Cypher25Parser.AllPrivilegeContext ctx);

    void exitAllPrivilegeType(Cypher25Parser.AllPrivilegeTypeContext ctx);

    void exitAllPrivilegeTarget(Cypher25Parser.AllPrivilegeTargetContext ctx);

    void exitCreatePrivilege(Cypher25Parser.CreatePrivilegeContext ctx);

    void exitCreatePrivilegeForDatabase(Cypher25Parser.CreatePrivilegeForDatabaseContext ctx);

    void exitCreateNodePrivilegeToken(Cypher25Parser.CreateNodePrivilegeTokenContext ctx);

    void exitCreateRelPrivilegeToken(Cypher25Parser.CreateRelPrivilegeTokenContext ctx);

    void exitCreatePropertyPrivilegeToken(Cypher25Parser.CreatePropertyPrivilegeTokenContext ctx);

    void exitActionForDBMS(Cypher25Parser.ActionForDBMSContext ctx);

    void exitDropPrivilege(Cypher25Parser.DropPrivilegeContext ctx);

    void exitLoadPrivilege(Cypher25Parser.LoadPrivilegeContext ctx);

    void exitShowPrivilege(Cypher25Parser.ShowPrivilegeContext ctx);

    void exitSetPrivilege(Cypher25Parser.SetPrivilegeContext ctx);

    void exitPasswordToken(Cypher25Parser.PasswordTokenContext ctx);

    void exitRemovePrivilege(Cypher25Parser.RemovePrivilegeContext ctx);

    void exitWritePrivilege(Cypher25Parser.WritePrivilegeContext ctx);

    void exitDatabasePrivilege(Cypher25Parser.DatabasePrivilegeContext ctx);

    void exitDbmsPrivilege(Cypher25Parser.DbmsPrivilegeContext ctx);

    void exitDbmsPrivilegeExecute(Cypher25Parser.DbmsPrivilegeExecuteContext ctx);

    void exitAdminToken(Cypher25Parser.AdminTokenContext ctx);

    void exitProcedureToken(Cypher25Parser.ProcedureTokenContext ctx);

    void exitIndexToken(Cypher25Parser.IndexTokenContext ctx);

    void exitConstraintToken(Cypher25Parser.ConstraintTokenContext ctx);

    void exitTransactionToken(Cypher25Parser.TransactionTokenContext ctx);

    void exitUserQualifier(Cypher25Parser.UserQualifierContext ctx);

    void exitExecuteFunctionQualifier(Cypher25Parser.ExecuteFunctionQualifierContext ctx);

    void exitExecuteProcedureQualifier(Cypher25Parser.ExecuteProcedureQualifierContext ctx);

    void exitSettingQualifier(Cypher25Parser.SettingQualifierContext ctx);

    void exitGlobs(Cypher25Parser.GlobsContext ctx);

    void exitGlob(Cypher25Parser.GlobContext ctx);

    void exitGlobRecursive(Cypher25Parser.GlobRecursiveContext ctx);

    void exitGlobPart(Cypher25Parser.GlobPartContext ctx);

    void exitQualifiedGraphPrivilegesWithProperty(Cypher25Parser.QualifiedGraphPrivilegesWithPropertyContext ctx);

    void exitQualifiedGraphPrivileges(Cypher25Parser.QualifiedGraphPrivilegesContext ctx);

    void exitLabelsResource(Cypher25Parser.LabelsResourceContext ctx);

    void exitPropertiesResource(Cypher25Parser.PropertiesResourceContext ctx);

    void exitNonEmptyStringList(Cypher25Parser.NonEmptyStringListContext ctx);

    void exitGraphQualifier(Cypher25Parser.GraphQualifierContext ctx);

    void exitGraphQualifierToken(Cypher25Parser.GraphQualifierTokenContext ctx);

    void exitRelToken(Cypher25Parser.RelTokenContext ctx);

    void exitElementToken(Cypher25Parser.ElementTokenContext ctx);

    void exitNodeToken(Cypher25Parser.NodeTokenContext ctx);

    void exitDatabaseScope(Cypher25Parser.DatabaseScopeContext ctx);

    void exitGraphScope(Cypher25Parser.GraphScopeContext ctx);

    void exitCreateCompositeDatabase(Cypher25Parser.CreateCompositeDatabaseContext ctx);

    void exitCreateDatabase(Cypher25Parser.CreateDatabaseContext ctx);

    void exitPrimaryTopology(Cypher25Parser.PrimaryTopologyContext ctx);

    void exitPrimaryToken(Cypher25Parser.PrimaryTokenContext ctx);

    void exitSecondaryTopology(Cypher25Parser.SecondaryTopologyContext ctx);

    void exitSecondaryToken(Cypher25Parser.SecondaryTokenContext ctx);

    void exitDropDatabase(Cypher25Parser.DropDatabaseContext ctx);

    void exitAliasAction(Cypher25Parser.AliasActionContext ctx);

    void exitAlterDatabase(Cypher25Parser.AlterDatabaseContext ctx);

    void exitAlterDatabaseAccess(Cypher25Parser.AlterDatabaseAccessContext ctx);

    void exitAlterDatabaseTopology(Cypher25Parser.AlterDatabaseTopologyContext ctx);

    void exitAlterDatabaseOption(Cypher25Parser.AlterDatabaseOptionContext ctx);

    void exitStartDatabase(Cypher25Parser.StartDatabaseContext ctx);

    void exitStopDatabase(Cypher25Parser.StopDatabaseContext ctx);

    void exitWaitClause(Cypher25Parser.WaitClauseContext ctx);

    void exitSecondsToken(Cypher25Parser.SecondsTokenContext ctx);

    void exitShowDatabase(Cypher25Parser.ShowDatabaseContext ctx);

    void exitAliasName(Cypher25Parser.AliasNameContext ctx);

    void exitDatabaseName(Cypher25Parser.DatabaseNameContext ctx);

    void exitCreateAlias(Cypher25Parser.CreateAliasContext ctx);

    void exitDropAlias(Cypher25Parser.DropAliasContext ctx);

    void exitAlterAlias(Cypher25Parser.AlterAliasContext ctx);

    void exitAlterAliasTarget(Cypher25Parser.AlterAliasTargetContext ctx);

    void exitAlterAliasUser(Cypher25Parser.AlterAliasUserContext ctx);

    void exitAlterAliasPassword(Cypher25Parser.AlterAliasPasswordContext ctx);

    void exitAlterAliasDriver(Cypher25Parser.AlterAliasDriverContext ctx);

    void exitAlterAliasProperties(Cypher25Parser.AlterAliasPropertiesContext ctx);

    void exitShowAliases(Cypher25Parser.ShowAliasesContext ctx);

    void exitSymbolicNameOrStringParameter(Cypher25Parser.SymbolicNameOrStringParameterContext ctx);

    void exitCommandNameExpression(Cypher25Parser.CommandNameExpressionContext ctx);

    void exitSymbolicNameOrStringParameterList(Cypher25Parser.SymbolicNameOrStringParameterListContext ctx);

    void exitSymbolicAliasNameList(Cypher25Parser.SymbolicAliasNameListContext ctx);

    void exitSymbolicAliasNameOrParameter(Cypher25Parser.SymbolicAliasNameOrParameterContext ctx);

    void exitSymbolicAliasName(Cypher25Parser.SymbolicAliasNameContext ctx);

    void exitStringListLiteral(Cypher25Parser.StringListLiteralContext ctx);

    void exitStringList(Cypher25Parser.StringListContext ctx);

    void exitStringLiteral(Cypher25Parser.StringLiteralContext ctx);

    void exitStringOrParameterExpression(Cypher25Parser.StringOrParameterExpressionContext ctx);

    void exitStringOrParameter(Cypher25Parser.StringOrParameterContext ctx);

    void exitUIntOrIntParameter(Cypher25Parser.UIntOrIntParameterContext ctx);

    void exitMapOrParameter(Cypher25Parser.MapOrParameterContext ctx);

    void exitMap(Cypher25Parser.MapContext ctx);

    void exitSymbolicNameString(Cypher25Parser.SymbolicNameStringContext ctx);

    void exitEscapedSymbolicNameString(Cypher25Parser.EscapedSymbolicNameStringContext ctx);

    void exitUnescapedSymbolicNameString(Cypher25Parser.UnescapedSymbolicNameStringContext ctx);

    void exitSymbolicLabelNameString(Cypher25Parser.SymbolicLabelNameStringContext ctx);

    void exitUnescapedLabelSymbolicNameString(Cypher25Parser.UnescapedLabelSymbolicNameStringContext ctx);

    void exitUnescapedLabelSymbolicNameString_(Cypher25Parser.UnescapedLabelSymbolicNameString_Context ctx);

    void exitEndOfFile(Cypher25Parser.EndOfFileContext ctx);
}
