/*
 * Copyright (c) "Neo4j"
 * Neo4j Sweden AB [https://neo4j.com]
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.neo4j.cypher.internal.parser.v5;

import org.antlr.v4.runtime.ParserRuleContext;

/**
 * Optimised implementation of Cypher5ParserListener.
 * Generated by org.neo4j.cypher.internal.parser.GenerateListenerMavenPlugin
 */
public abstract class AbstractCypher5AstBuilder implements Cypher5ParserListener {
    /**
     *
     * Optimised exit method.
     *
     * This compiles into a blazingly fast tableswitch (jump table)
     * and has been shown to be faster than the generated listeners that antlr provides.
     */
    @Override
    public final void exitEveryRule(ParserRuleContext ctx) {
        switch (ctx.getRuleIndex()) {
            case Cypher5Parser.RULE_statements -> exitStatements((Cypher5Parser.StatementsContext) ctx);
            case Cypher5Parser.RULE_statement -> exitStatement((Cypher5Parser.StatementContext) ctx);
            case Cypher5Parser.RULE_periodicCommitQueryHintFailure -> exitPeriodicCommitQueryHintFailure(
                    (Cypher5Parser.PeriodicCommitQueryHintFailureContext) ctx);
            case Cypher5Parser.RULE_regularQuery -> exitRegularQuery((Cypher5Parser.RegularQueryContext) ctx);
            case Cypher5Parser.RULE_singleQuery -> exitSingleQuery((Cypher5Parser.SingleQueryContext) ctx);
            case Cypher5Parser.RULE_clause -> exitClause((Cypher5Parser.ClauseContext) ctx);
            case Cypher5Parser.RULE_useClause -> exitUseClause((Cypher5Parser.UseClauseContext) ctx);
            case Cypher5Parser.RULE_graphReference -> exitGraphReference((Cypher5Parser.GraphReferenceContext) ctx);
            case Cypher5Parser.RULE_finishClause -> exitFinishClause((Cypher5Parser.FinishClauseContext) ctx);
            case Cypher5Parser.RULE_returnClause -> exitReturnClause((Cypher5Parser.ReturnClauseContext) ctx);
            case Cypher5Parser.RULE_returnBody -> exitReturnBody((Cypher5Parser.ReturnBodyContext) ctx);
            case Cypher5Parser.RULE_returnItem -> exitReturnItem((Cypher5Parser.ReturnItemContext) ctx);
            case Cypher5Parser.RULE_returnItems -> exitReturnItems((Cypher5Parser.ReturnItemsContext) ctx);
            case Cypher5Parser.RULE_orderItem -> exitOrderItem((Cypher5Parser.OrderItemContext) ctx);
            case Cypher5Parser.RULE_ascToken -> exitAscToken((Cypher5Parser.AscTokenContext) ctx);
            case Cypher5Parser.RULE_descToken -> exitDescToken((Cypher5Parser.DescTokenContext) ctx);
            case Cypher5Parser.RULE_orderBy -> exitOrderBy((Cypher5Parser.OrderByContext) ctx);
            case Cypher5Parser.RULE_skip -> exitSkip((Cypher5Parser.SkipContext) ctx);
            case Cypher5Parser.RULE_limit -> exitLimit((Cypher5Parser.LimitContext) ctx);
            case Cypher5Parser.RULE_whereClause -> exitWhereClause((Cypher5Parser.WhereClauseContext) ctx);
            case Cypher5Parser.RULE_withClause -> exitWithClause((Cypher5Parser.WithClauseContext) ctx);
            case Cypher5Parser.RULE_createClause -> exitCreateClause((Cypher5Parser.CreateClauseContext) ctx);
            case Cypher5Parser.RULE_insertClause -> exitInsertClause((Cypher5Parser.InsertClauseContext) ctx);
            case Cypher5Parser.RULE_setClause -> exitSetClause((Cypher5Parser.SetClauseContext) ctx);
            case Cypher5Parser.RULE_setItem -> exitSetItem((Cypher5Parser.SetItemContext) ctx);
            case Cypher5Parser.RULE_removeClause -> exitRemoveClause((Cypher5Parser.RemoveClauseContext) ctx);
            case Cypher5Parser.RULE_removeItem -> exitRemoveItem((Cypher5Parser.RemoveItemContext) ctx);
            case Cypher5Parser.RULE_deleteClause -> exitDeleteClause((Cypher5Parser.DeleteClauseContext) ctx);
            case Cypher5Parser.RULE_matchClause -> exitMatchClause((Cypher5Parser.MatchClauseContext) ctx);
            case Cypher5Parser.RULE_matchMode -> exitMatchMode((Cypher5Parser.MatchModeContext) ctx);
            case Cypher5Parser.RULE_hint -> exitHint((Cypher5Parser.HintContext) ctx);
            case Cypher5Parser.RULE_mergeClause -> exitMergeClause((Cypher5Parser.MergeClauseContext) ctx);
            case Cypher5Parser.RULE_mergeAction -> exitMergeAction((Cypher5Parser.MergeActionContext) ctx);
            case Cypher5Parser.RULE_unwindClause -> exitUnwindClause((Cypher5Parser.UnwindClauseContext) ctx);
            case Cypher5Parser.RULE_callClause -> exitCallClause((Cypher5Parser.CallClauseContext) ctx);
            case Cypher5Parser.RULE_procedureName -> exitProcedureName((Cypher5Parser.ProcedureNameContext) ctx);
            case Cypher5Parser.RULE_procedureArgument -> exitProcedureArgument(
                    (Cypher5Parser.ProcedureArgumentContext) ctx);
            case Cypher5Parser.RULE_procedureResultItem -> exitProcedureResultItem(
                    (Cypher5Parser.ProcedureResultItemContext) ctx);
            case Cypher5Parser.RULE_loadCSVClause -> exitLoadCSVClause((Cypher5Parser.LoadCSVClauseContext) ctx);
            case Cypher5Parser.RULE_foreachClause -> exitForeachClause((Cypher5Parser.ForeachClauseContext) ctx);
            case Cypher5Parser.RULE_subqueryClause -> exitSubqueryClause((Cypher5Parser.SubqueryClauseContext) ctx);
            case Cypher5Parser.RULE_subqueryScope -> exitSubqueryScope((Cypher5Parser.SubqueryScopeContext) ctx);
            case Cypher5Parser.RULE_subqueryInTransactionsParameters -> exitSubqueryInTransactionsParameters(
                    (Cypher5Parser.SubqueryInTransactionsParametersContext) ctx);
            case Cypher5Parser.RULE_subqueryInTransactionsBatchParameters -> exitSubqueryInTransactionsBatchParameters(
                    (Cypher5Parser.SubqueryInTransactionsBatchParametersContext) ctx);
            case Cypher5Parser.RULE_subqueryInTransactionsErrorParameters -> exitSubqueryInTransactionsErrorParameters(
                    (Cypher5Parser.SubqueryInTransactionsErrorParametersContext) ctx);
            case Cypher5Parser
                    .RULE_subqueryInTransactionsReportParameters -> exitSubqueryInTransactionsReportParameters(
                    (Cypher5Parser.SubqueryInTransactionsReportParametersContext) ctx);
            case Cypher5Parser.RULE_orderBySkipLimitClause -> exitOrderBySkipLimitClause(
                    (Cypher5Parser.OrderBySkipLimitClauseContext) ctx);
            case Cypher5Parser.RULE_patternList -> exitPatternList((Cypher5Parser.PatternListContext) ctx);
            case Cypher5Parser.RULE_insertPatternList -> exitInsertPatternList(
                    (Cypher5Parser.InsertPatternListContext) ctx);
            case Cypher5Parser.RULE_pattern -> exitPattern((Cypher5Parser.PatternContext) ctx);
            case Cypher5Parser.RULE_insertPattern -> exitInsertPattern((Cypher5Parser.InsertPatternContext) ctx);
            case Cypher5Parser.RULE_quantifier -> exitQuantifier((Cypher5Parser.QuantifierContext) ctx);
            case Cypher5Parser.RULE_anonymousPattern -> exitAnonymousPattern(
                    (Cypher5Parser.AnonymousPatternContext) ctx);
            case Cypher5Parser.RULE_shortestPathPattern -> exitShortestPathPattern(
                    (Cypher5Parser.ShortestPathPatternContext) ctx);
            case Cypher5Parser.RULE_patternElement -> exitPatternElement((Cypher5Parser.PatternElementContext) ctx);
            case Cypher5Parser.RULE_selector -> exitSelector((Cypher5Parser.SelectorContext) ctx);
            case Cypher5Parser.RULE_groupToken -> exitGroupToken((Cypher5Parser.GroupTokenContext) ctx);
            case Cypher5Parser.RULE_pathToken -> exitPathToken((Cypher5Parser.PathTokenContext) ctx);
            case Cypher5Parser.RULE_pathPatternNonEmpty -> exitPathPatternNonEmpty(
                    (Cypher5Parser.PathPatternNonEmptyContext) ctx);
            case Cypher5Parser.RULE_nodePattern -> exitNodePattern((Cypher5Parser.NodePatternContext) ctx);
            case Cypher5Parser.RULE_insertNodePattern -> exitInsertNodePattern(
                    (Cypher5Parser.InsertNodePatternContext) ctx);
            case Cypher5Parser.RULE_parenthesizedPath -> exitParenthesizedPath(
                    (Cypher5Parser.ParenthesizedPathContext) ctx);
            case Cypher5Parser.RULE_nodeLabels -> exitNodeLabels((Cypher5Parser.NodeLabelsContext) ctx);
            case Cypher5Parser.RULE_nodeLabelsIs -> exitNodeLabelsIs((Cypher5Parser.NodeLabelsIsContext) ctx);
            case Cypher5Parser.RULE_dynamicExpression -> exitDynamicExpression(
                    (Cypher5Parser.DynamicExpressionContext) ctx);
            case Cypher5Parser.RULE_dynamicAnyAllExpression -> exitDynamicAnyAllExpression(
                    (Cypher5Parser.DynamicAnyAllExpressionContext) ctx);
            case Cypher5Parser.RULE_dynamicLabelType -> exitDynamicLabelType(
                    (Cypher5Parser.DynamicLabelTypeContext) ctx);
            case Cypher5Parser.RULE_labelType -> exitLabelType((Cypher5Parser.LabelTypeContext) ctx);
            case Cypher5Parser.RULE_relType -> exitRelType((Cypher5Parser.RelTypeContext) ctx);
            case Cypher5Parser.RULE_labelOrRelType -> exitLabelOrRelType((Cypher5Parser.LabelOrRelTypeContext) ctx);
            case Cypher5Parser.RULE_properties -> exitProperties((Cypher5Parser.PropertiesContext) ctx);
            case Cypher5Parser.RULE_relationshipPattern -> exitRelationshipPattern(
                    (Cypher5Parser.RelationshipPatternContext) ctx);
            case Cypher5Parser.RULE_insertRelationshipPattern -> exitInsertRelationshipPattern(
                    (Cypher5Parser.InsertRelationshipPatternContext) ctx);
            case Cypher5Parser.RULE_leftArrow -> exitLeftArrow((Cypher5Parser.LeftArrowContext) ctx);
            case Cypher5Parser.RULE_arrowLine -> exitArrowLine((Cypher5Parser.ArrowLineContext) ctx);
            case Cypher5Parser.RULE_rightArrow -> exitRightArrow((Cypher5Parser.RightArrowContext) ctx);
            case Cypher5Parser.RULE_pathLength -> exitPathLength((Cypher5Parser.PathLengthContext) ctx);
            case Cypher5Parser.RULE_labelExpression -> exitLabelExpression((Cypher5Parser.LabelExpressionContext) ctx);
            case Cypher5Parser.RULE_labelExpression4 -> exitLabelExpression4(
                    (Cypher5Parser.LabelExpression4Context) ctx);
            case Cypher5Parser.RULE_labelExpression4Is -> exitLabelExpression4Is(
                    (Cypher5Parser.LabelExpression4IsContext) ctx);
            case Cypher5Parser.RULE_labelExpression3 -> exitLabelExpression3(
                    (Cypher5Parser.LabelExpression3Context) ctx);
            case Cypher5Parser.RULE_labelExpression3Is -> exitLabelExpression3Is(
                    (Cypher5Parser.LabelExpression3IsContext) ctx);
            case Cypher5Parser.RULE_labelExpression2 -> exitLabelExpression2(
                    (Cypher5Parser.LabelExpression2Context) ctx);
            case Cypher5Parser.RULE_labelExpression2Is -> exitLabelExpression2Is(
                    (Cypher5Parser.LabelExpression2IsContext) ctx);
            case Cypher5Parser.RULE_labelExpression1 -> exitLabelExpression1(
                    (Cypher5Parser.LabelExpression1Context) ctx);
            case Cypher5Parser.RULE_labelExpression1Is -> exitLabelExpression1Is(
                    (Cypher5Parser.LabelExpression1IsContext) ctx);
            case Cypher5Parser.RULE_insertNodeLabelExpression -> exitInsertNodeLabelExpression(
                    (Cypher5Parser.InsertNodeLabelExpressionContext) ctx);
            case Cypher5Parser.RULE_insertRelationshipLabelExpression -> exitInsertRelationshipLabelExpression(
                    (Cypher5Parser.InsertRelationshipLabelExpressionContext) ctx);
            case Cypher5Parser.RULE_expression -> exitExpression((Cypher5Parser.ExpressionContext) ctx);
            case Cypher5Parser.RULE_expression11 -> exitExpression11((Cypher5Parser.Expression11Context) ctx);
            case Cypher5Parser.RULE_expression10 -> exitExpression10((Cypher5Parser.Expression10Context) ctx);
            case Cypher5Parser.RULE_expression9 -> exitExpression9((Cypher5Parser.Expression9Context) ctx);
            case Cypher5Parser.RULE_expression8 -> exitExpression8((Cypher5Parser.Expression8Context) ctx);
            case Cypher5Parser.RULE_expression7 -> exitExpression7((Cypher5Parser.Expression7Context) ctx);
            case Cypher5Parser.RULE_comparisonExpression6 -> exitComparisonExpression6(
                    (Cypher5Parser.ComparisonExpression6Context) ctx);
            case Cypher5Parser.RULE_normalForm -> exitNormalForm((Cypher5Parser.NormalFormContext) ctx);
            case Cypher5Parser.RULE_expression6 -> exitExpression6((Cypher5Parser.Expression6Context) ctx);
            case Cypher5Parser.RULE_expression5 -> exitExpression5((Cypher5Parser.Expression5Context) ctx);
            case Cypher5Parser.RULE_expression4 -> exitExpression4((Cypher5Parser.Expression4Context) ctx);
            case Cypher5Parser.RULE_expression3 -> exitExpression3((Cypher5Parser.Expression3Context) ctx);
            case Cypher5Parser.RULE_expression2 -> exitExpression2((Cypher5Parser.Expression2Context) ctx);
            case Cypher5Parser.RULE_postFix -> exitPostFix((Cypher5Parser.PostFixContext) ctx);
            case Cypher5Parser.RULE_property -> exitProperty((Cypher5Parser.PropertyContext) ctx);
            case Cypher5Parser.RULE_dynamicProperty -> exitDynamicProperty((Cypher5Parser.DynamicPropertyContext) ctx);
            case Cypher5Parser.RULE_propertyExpression -> exitPropertyExpression(
                    (Cypher5Parser.PropertyExpressionContext) ctx);
            case Cypher5Parser.RULE_dynamicPropertyExpression -> exitDynamicPropertyExpression(
                    (Cypher5Parser.DynamicPropertyExpressionContext) ctx);
            case Cypher5Parser.RULE_expression1 -> exitExpression1((Cypher5Parser.Expression1Context) ctx);
            case Cypher5Parser.RULE_literal -> exitLiteral((Cypher5Parser.LiteralContext) ctx);
            case Cypher5Parser.RULE_caseExpression -> exitCaseExpression((Cypher5Parser.CaseExpressionContext) ctx);
            case Cypher5Parser.RULE_caseAlternative -> exitCaseAlternative((Cypher5Parser.CaseAlternativeContext) ctx);
            case Cypher5Parser.RULE_extendedCaseExpression -> exitExtendedCaseExpression(
                    (Cypher5Parser.ExtendedCaseExpressionContext) ctx);
            case Cypher5Parser.RULE_extendedCaseAlternative -> exitExtendedCaseAlternative(
                    (Cypher5Parser.ExtendedCaseAlternativeContext) ctx);
            case Cypher5Parser.RULE_extendedWhen -> exitExtendedWhen((Cypher5Parser.ExtendedWhenContext) ctx);
            case Cypher5Parser.RULE_listComprehension -> exitListComprehension(
                    (Cypher5Parser.ListComprehensionContext) ctx);
            case Cypher5Parser.RULE_patternComprehension -> exitPatternComprehension(
                    (Cypher5Parser.PatternComprehensionContext) ctx);
            case Cypher5Parser.RULE_reduceExpression -> exitReduceExpression(
                    (Cypher5Parser.ReduceExpressionContext) ctx);
            case Cypher5Parser.RULE_listItemsPredicate -> exitListItemsPredicate(
                    (Cypher5Parser.ListItemsPredicateContext) ctx);
            case Cypher5Parser.RULE_normalizeFunction -> exitNormalizeFunction(
                    (Cypher5Parser.NormalizeFunctionContext) ctx);
            case Cypher5Parser.RULE_trimFunction -> exitTrimFunction((Cypher5Parser.TrimFunctionContext) ctx);
            case Cypher5Parser.RULE_patternExpression -> exitPatternExpression(
                    (Cypher5Parser.PatternExpressionContext) ctx);
            case Cypher5Parser.RULE_shortestPathExpression -> exitShortestPathExpression(
                    (Cypher5Parser.ShortestPathExpressionContext) ctx);
            case Cypher5Parser.RULE_parenthesizedExpression -> exitParenthesizedExpression(
                    (Cypher5Parser.ParenthesizedExpressionContext) ctx);
            case Cypher5Parser.RULE_mapProjection -> exitMapProjection((Cypher5Parser.MapProjectionContext) ctx);
            case Cypher5Parser.RULE_mapProjectionElement -> exitMapProjectionElement(
                    (Cypher5Parser.MapProjectionElementContext) ctx);
            case Cypher5Parser.RULE_countStar -> exitCountStar((Cypher5Parser.CountStarContext) ctx);
            case Cypher5Parser.RULE_existsExpression -> exitExistsExpression(
                    (Cypher5Parser.ExistsExpressionContext) ctx);
            case Cypher5Parser.RULE_countExpression -> exitCountExpression((Cypher5Parser.CountExpressionContext) ctx);
            case Cypher5Parser.RULE_collectExpression -> exitCollectExpression(
                    (Cypher5Parser.CollectExpressionContext) ctx);
            case Cypher5Parser.RULE_numberLiteral -> exitNumberLiteral((Cypher5Parser.NumberLiteralContext) ctx);
            case Cypher5Parser.RULE_signedIntegerLiteral -> exitSignedIntegerLiteral(
                    (Cypher5Parser.SignedIntegerLiteralContext) ctx);
            case Cypher5Parser.RULE_listLiteral -> exitListLiteral((Cypher5Parser.ListLiteralContext) ctx);
            case Cypher5Parser.RULE_propertyKeyName -> exitPropertyKeyName((Cypher5Parser.PropertyKeyNameContext) ctx);
            case Cypher5Parser.RULE_parameter -> exitParameter((Cypher5Parser.ParameterContext) ctx);
            case Cypher5Parser.RULE_parameterName -> exitParameterName((Cypher5Parser.ParameterNameContext) ctx);
            case Cypher5Parser.RULE_functionInvocation -> exitFunctionInvocation(
                    (Cypher5Parser.FunctionInvocationContext) ctx);
            case Cypher5Parser.RULE_functionArgument -> exitFunctionArgument(
                    (Cypher5Parser.FunctionArgumentContext) ctx);
            case Cypher5Parser.RULE_functionName -> exitFunctionName((Cypher5Parser.FunctionNameContext) ctx);
            case Cypher5Parser.RULE_namespace -> exitNamespace((Cypher5Parser.NamespaceContext) ctx);
            case Cypher5Parser.RULE_variable -> exitVariable((Cypher5Parser.VariableContext) ctx);
            case Cypher5Parser.RULE_nonEmptyNameList -> exitNonEmptyNameList(
                    (Cypher5Parser.NonEmptyNameListContext) ctx);
            case Cypher5Parser.RULE_type -> exitType((Cypher5Parser.TypeContext) ctx);
            case Cypher5Parser.RULE_typePart -> exitTypePart((Cypher5Parser.TypePartContext) ctx);
            case Cypher5Parser.RULE_typeName -> exitTypeName((Cypher5Parser.TypeNameContext) ctx);
            case Cypher5Parser.RULE_typeNullability -> exitTypeNullability((Cypher5Parser.TypeNullabilityContext) ctx);
            case Cypher5Parser.RULE_typeListSuffix -> exitTypeListSuffix((Cypher5Parser.TypeListSuffixContext) ctx);
            case Cypher5Parser.RULE_command -> exitCommand((Cypher5Parser.CommandContext) ctx);
            case Cypher5Parser.RULE_createCommand -> exitCreateCommand((Cypher5Parser.CreateCommandContext) ctx);
            case Cypher5Parser.RULE_dropCommand -> exitDropCommand((Cypher5Parser.DropCommandContext) ctx);
            case Cypher5Parser.RULE_showCommand -> exitShowCommand((Cypher5Parser.ShowCommandContext) ctx);
            case Cypher5Parser.RULE_showCommandYield -> exitShowCommandYield(
                    (Cypher5Parser.ShowCommandYieldContext) ctx);
            case Cypher5Parser.RULE_yieldItem -> exitYieldItem((Cypher5Parser.YieldItemContext) ctx);
            case Cypher5Parser.RULE_yieldSkip -> exitYieldSkip((Cypher5Parser.YieldSkipContext) ctx);
            case Cypher5Parser.RULE_yieldLimit -> exitYieldLimit((Cypher5Parser.YieldLimitContext) ctx);
            case Cypher5Parser.RULE_yieldClause -> exitYieldClause((Cypher5Parser.YieldClauseContext) ctx);
            case Cypher5Parser.RULE_commandOptions -> exitCommandOptions((Cypher5Parser.CommandOptionsContext) ctx);
            case Cypher5Parser.RULE_terminateCommand -> exitTerminateCommand(
                    (Cypher5Parser.TerminateCommandContext) ctx);
            case Cypher5Parser.RULE_composableCommandClauses -> exitComposableCommandClauses(
                    (Cypher5Parser.ComposableCommandClausesContext) ctx);
            case Cypher5Parser.RULE_composableShowCommandClauses -> exitComposableShowCommandClauses(
                    (Cypher5Parser.ComposableShowCommandClausesContext) ctx);
            case Cypher5Parser.RULE_showBriefAndYield -> exitShowBriefAndYield(
                    (Cypher5Parser.ShowBriefAndYieldContext) ctx);
            case Cypher5Parser.RULE_showIndexCommand -> exitShowIndexCommand(
                    (Cypher5Parser.ShowIndexCommandContext) ctx);
            case Cypher5Parser.RULE_showIndexesAllowBrief -> exitShowIndexesAllowBrief(
                    (Cypher5Parser.ShowIndexesAllowBriefContext) ctx);
            case Cypher5Parser.RULE_showIndexesNoBrief -> exitShowIndexesNoBrief(
                    (Cypher5Parser.ShowIndexesNoBriefContext) ctx);
            case Cypher5Parser.RULE_showConstraintCommand -> exitShowConstraintCommand(
                    (Cypher5Parser.ShowConstraintCommandContext) ctx);
            case Cypher5Parser.RULE_constraintAllowYieldType -> exitConstraintAllowYieldType(
                    (Cypher5Parser.ConstraintAllowYieldTypeContext) ctx);
            case Cypher5Parser.RULE_constraintExistType -> exitConstraintExistType(
                    (Cypher5Parser.ConstraintExistTypeContext) ctx);
            case Cypher5Parser.RULE_constraintBriefAndYieldType -> exitConstraintBriefAndYieldType(
                    (Cypher5Parser.ConstraintBriefAndYieldTypeContext) ctx);
            case Cypher5Parser.RULE_showConstraintsAllowBriefAndYield -> exitShowConstraintsAllowBriefAndYield(
                    (Cypher5Parser.ShowConstraintsAllowBriefAndYieldContext) ctx);
            case Cypher5Parser.RULE_showConstraintsAllowBrief -> exitShowConstraintsAllowBrief(
                    (Cypher5Parser.ShowConstraintsAllowBriefContext) ctx);
            case Cypher5Parser.RULE_showConstraintsAllowYield -> exitShowConstraintsAllowYield(
                    (Cypher5Parser.ShowConstraintsAllowYieldContext) ctx);
            case Cypher5Parser.RULE_showProcedures -> exitShowProcedures((Cypher5Parser.ShowProceduresContext) ctx);
            case Cypher5Parser.RULE_showFunctions -> exitShowFunctions((Cypher5Parser.ShowFunctionsContext) ctx);
            case Cypher5Parser.RULE_functionToken -> exitFunctionToken((Cypher5Parser.FunctionTokenContext) ctx);
            case Cypher5Parser.RULE_executableBy -> exitExecutableBy((Cypher5Parser.ExecutableByContext) ctx);
            case Cypher5Parser.RULE_showFunctionsType -> exitShowFunctionsType(
                    (Cypher5Parser.ShowFunctionsTypeContext) ctx);
            case Cypher5Parser.RULE_showTransactions -> exitShowTransactions(
                    (Cypher5Parser.ShowTransactionsContext) ctx);
            case Cypher5Parser.RULE_terminateTransactions -> exitTerminateTransactions(
                    (Cypher5Parser.TerminateTransactionsContext) ctx);
            case Cypher5Parser.RULE_showSettings -> exitShowSettings((Cypher5Parser.ShowSettingsContext) ctx);
            case Cypher5Parser.RULE_settingToken -> exitSettingToken((Cypher5Parser.SettingTokenContext) ctx);
            case Cypher5Parser.RULE_namesAndClauses -> exitNamesAndClauses((Cypher5Parser.NamesAndClausesContext) ctx);
            case Cypher5Parser.RULE_stringsOrExpression -> exitStringsOrExpression(
                    (Cypher5Parser.StringsOrExpressionContext) ctx);
            case Cypher5Parser.RULE_commandNodePattern -> exitCommandNodePattern(
                    (Cypher5Parser.CommandNodePatternContext) ctx);
            case Cypher5Parser.RULE_commandRelPattern -> exitCommandRelPattern(
                    (Cypher5Parser.CommandRelPatternContext) ctx);
            case Cypher5Parser.RULE_createConstraint -> exitCreateConstraint(
                    (Cypher5Parser.CreateConstraintContext) ctx);
            case Cypher5Parser.RULE_constraintType -> exitConstraintType((Cypher5Parser.ConstraintTypeContext) ctx);
            case Cypher5Parser.RULE_dropConstraint -> exitDropConstraint((Cypher5Parser.DropConstraintContext) ctx);
            case Cypher5Parser.RULE_createIndex -> exitCreateIndex((Cypher5Parser.CreateIndexContext) ctx);
            case Cypher5Parser.RULE_oldCreateIndex -> exitOldCreateIndex((Cypher5Parser.OldCreateIndexContext) ctx);
            case Cypher5Parser.RULE_createIndex_ -> exitCreateIndex_((Cypher5Parser.CreateIndex_Context) ctx);
            case Cypher5Parser.RULE_createFulltextIndex -> exitCreateFulltextIndex(
                    (Cypher5Parser.CreateFulltextIndexContext) ctx);
            case Cypher5Parser.RULE_fulltextNodePattern -> exitFulltextNodePattern(
                    (Cypher5Parser.FulltextNodePatternContext) ctx);
            case Cypher5Parser.RULE_fulltextRelPattern -> exitFulltextRelPattern(
                    (Cypher5Parser.FulltextRelPatternContext) ctx);
            case Cypher5Parser.RULE_createLookupIndex -> exitCreateLookupIndex(
                    (Cypher5Parser.CreateLookupIndexContext) ctx);
            case Cypher5Parser.RULE_lookupIndexNodePattern -> exitLookupIndexNodePattern(
                    (Cypher5Parser.LookupIndexNodePatternContext) ctx);
            case Cypher5Parser.RULE_lookupIndexRelPattern -> exitLookupIndexRelPattern(
                    (Cypher5Parser.LookupIndexRelPatternContext) ctx);
            case Cypher5Parser.RULE_dropIndex -> exitDropIndex((Cypher5Parser.DropIndexContext) ctx);
            case Cypher5Parser.RULE_propertyList -> exitPropertyList((Cypher5Parser.PropertyListContext) ctx);
            case Cypher5Parser.RULE_enclosedPropertyList -> exitEnclosedPropertyList(
                    (Cypher5Parser.EnclosedPropertyListContext) ctx);
            case Cypher5Parser.RULE_alterCommand -> exitAlterCommand((Cypher5Parser.AlterCommandContext) ctx);
            case Cypher5Parser.RULE_renameCommand -> exitRenameCommand((Cypher5Parser.RenameCommandContext) ctx);
            case Cypher5Parser.RULE_grantCommand -> exitGrantCommand((Cypher5Parser.GrantCommandContext) ctx);
            case Cypher5Parser.RULE_denyCommand -> exitDenyCommand((Cypher5Parser.DenyCommandContext) ctx);
            case Cypher5Parser.RULE_revokeCommand -> exitRevokeCommand((Cypher5Parser.RevokeCommandContext) ctx);
            case Cypher5Parser.RULE_userNames -> exitUserNames((Cypher5Parser.UserNamesContext) ctx);
            case Cypher5Parser.RULE_roleNames -> exitRoleNames((Cypher5Parser.RoleNamesContext) ctx);
            case Cypher5Parser.RULE_roleToken -> exitRoleToken((Cypher5Parser.RoleTokenContext) ctx);
            case Cypher5Parser.RULE_enableServerCommand -> exitEnableServerCommand(
                    (Cypher5Parser.EnableServerCommandContext) ctx);
            case Cypher5Parser.RULE_alterServer -> exitAlterServer((Cypher5Parser.AlterServerContext) ctx);
            case Cypher5Parser.RULE_renameServer -> exitRenameServer((Cypher5Parser.RenameServerContext) ctx);
            case Cypher5Parser.RULE_dropServer -> exitDropServer((Cypher5Parser.DropServerContext) ctx);
            case Cypher5Parser.RULE_showServers -> exitShowServers((Cypher5Parser.ShowServersContext) ctx);
            case Cypher5Parser.RULE_allocationCommand -> exitAllocationCommand(
                    (Cypher5Parser.AllocationCommandContext) ctx);
            case Cypher5Parser.RULE_deallocateDatabaseFromServers -> exitDeallocateDatabaseFromServers(
                    (Cypher5Parser.DeallocateDatabaseFromServersContext) ctx);
            case Cypher5Parser.RULE_reallocateDatabases -> exitReallocateDatabases(
                    (Cypher5Parser.ReallocateDatabasesContext) ctx);
            case Cypher5Parser.RULE_createRole -> exitCreateRole((Cypher5Parser.CreateRoleContext) ctx);
            case Cypher5Parser.RULE_dropRole -> exitDropRole((Cypher5Parser.DropRoleContext) ctx);
            case Cypher5Parser.RULE_renameRole -> exitRenameRole((Cypher5Parser.RenameRoleContext) ctx);
            case Cypher5Parser.RULE_showRoles -> exitShowRoles((Cypher5Parser.ShowRolesContext) ctx);
            case Cypher5Parser.RULE_grantRole -> exitGrantRole((Cypher5Parser.GrantRoleContext) ctx);
            case Cypher5Parser.RULE_revokeRole -> exitRevokeRole((Cypher5Parser.RevokeRoleContext) ctx);
            case Cypher5Parser.RULE_createUser -> exitCreateUser((Cypher5Parser.CreateUserContext) ctx);
            case Cypher5Parser.RULE_dropUser -> exitDropUser((Cypher5Parser.DropUserContext) ctx);
            case Cypher5Parser.RULE_renameUser -> exitRenameUser((Cypher5Parser.RenameUserContext) ctx);
            case Cypher5Parser.RULE_alterCurrentUser -> exitAlterCurrentUser(
                    (Cypher5Parser.AlterCurrentUserContext) ctx);
            case Cypher5Parser.RULE_alterUser -> exitAlterUser((Cypher5Parser.AlterUserContext) ctx);
            case Cypher5Parser.RULE_removeNamedProvider -> exitRemoveNamedProvider(
                    (Cypher5Parser.RemoveNamedProviderContext) ctx);
            case Cypher5Parser.RULE_password -> exitPassword((Cypher5Parser.PasswordContext) ctx);
            case Cypher5Parser.RULE_passwordOnly -> exitPasswordOnly((Cypher5Parser.PasswordOnlyContext) ctx);
            case Cypher5Parser.RULE_passwordExpression -> exitPasswordExpression(
                    (Cypher5Parser.PasswordExpressionContext) ctx);
            case Cypher5Parser.RULE_passwordChangeRequired -> exitPasswordChangeRequired(
                    (Cypher5Parser.PasswordChangeRequiredContext) ctx);
            case Cypher5Parser.RULE_userStatus -> exitUserStatus((Cypher5Parser.UserStatusContext) ctx);
            case Cypher5Parser.RULE_homeDatabase -> exitHomeDatabase((Cypher5Parser.HomeDatabaseContext) ctx);
            case Cypher5Parser.RULE_setAuthClause -> exitSetAuthClause((Cypher5Parser.SetAuthClauseContext) ctx);
            case Cypher5Parser.RULE_userAuthAttribute -> exitUserAuthAttribute(
                    (Cypher5Parser.UserAuthAttributeContext) ctx);
            case Cypher5Parser.RULE_showUsers -> exitShowUsers((Cypher5Parser.ShowUsersContext) ctx);
            case Cypher5Parser.RULE_showCurrentUser -> exitShowCurrentUser((Cypher5Parser.ShowCurrentUserContext) ctx);
            case Cypher5Parser.RULE_showSupportedPrivileges -> exitShowSupportedPrivileges(
                    (Cypher5Parser.ShowSupportedPrivilegesContext) ctx);
            case Cypher5Parser.RULE_showPrivileges -> exitShowPrivileges((Cypher5Parser.ShowPrivilegesContext) ctx);
            case Cypher5Parser.RULE_showRolePrivileges -> exitShowRolePrivileges(
                    (Cypher5Parser.ShowRolePrivilegesContext) ctx);
            case Cypher5Parser.RULE_showUserPrivileges -> exitShowUserPrivileges(
                    (Cypher5Parser.ShowUserPrivilegesContext) ctx);
            case Cypher5Parser.RULE_privilegeAsCommand -> exitPrivilegeAsCommand(
                    (Cypher5Parser.PrivilegeAsCommandContext) ctx);
            case Cypher5Parser.RULE_privilegeToken -> exitPrivilegeToken((Cypher5Parser.PrivilegeTokenContext) ctx);
            case Cypher5Parser.RULE_privilege -> exitPrivilege((Cypher5Parser.PrivilegeContext) ctx);
            case Cypher5Parser.RULE_allPrivilege -> exitAllPrivilege((Cypher5Parser.AllPrivilegeContext) ctx);
            case Cypher5Parser.RULE_allPrivilegeType -> exitAllPrivilegeType(
                    (Cypher5Parser.AllPrivilegeTypeContext) ctx);
            case Cypher5Parser.RULE_allPrivilegeTarget -> exitAllPrivilegeTarget(
                    (Cypher5Parser.AllPrivilegeTargetContext) ctx);
            case Cypher5Parser.RULE_createPrivilege -> exitCreatePrivilege((Cypher5Parser.CreatePrivilegeContext) ctx);
            case Cypher5Parser.RULE_createPrivilegeForDatabase -> exitCreatePrivilegeForDatabase(
                    (Cypher5Parser.CreatePrivilegeForDatabaseContext) ctx);
            case Cypher5Parser.RULE_createNodePrivilegeToken -> exitCreateNodePrivilegeToken(
                    (Cypher5Parser.CreateNodePrivilegeTokenContext) ctx);
            case Cypher5Parser.RULE_createRelPrivilegeToken -> exitCreateRelPrivilegeToken(
                    (Cypher5Parser.CreateRelPrivilegeTokenContext) ctx);
            case Cypher5Parser.RULE_createPropertyPrivilegeToken -> exitCreatePropertyPrivilegeToken(
                    (Cypher5Parser.CreatePropertyPrivilegeTokenContext) ctx);
            case Cypher5Parser.RULE_actionForDBMS -> exitActionForDBMS((Cypher5Parser.ActionForDBMSContext) ctx);
            case Cypher5Parser.RULE_dropPrivilege -> exitDropPrivilege((Cypher5Parser.DropPrivilegeContext) ctx);
            case Cypher5Parser.RULE_loadPrivilege -> exitLoadPrivilege((Cypher5Parser.LoadPrivilegeContext) ctx);
            case Cypher5Parser.RULE_showPrivilege -> exitShowPrivilege((Cypher5Parser.ShowPrivilegeContext) ctx);
            case Cypher5Parser.RULE_setPrivilege -> exitSetPrivilege((Cypher5Parser.SetPrivilegeContext) ctx);
            case Cypher5Parser.RULE_passwordToken -> exitPasswordToken((Cypher5Parser.PasswordTokenContext) ctx);
            case Cypher5Parser.RULE_removePrivilege -> exitRemovePrivilege((Cypher5Parser.RemovePrivilegeContext) ctx);
            case Cypher5Parser.RULE_writePrivilege -> exitWritePrivilege((Cypher5Parser.WritePrivilegeContext) ctx);
            case Cypher5Parser.RULE_databasePrivilege -> exitDatabasePrivilege(
                    (Cypher5Parser.DatabasePrivilegeContext) ctx);
            case Cypher5Parser.RULE_dbmsPrivilege -> exitDbmsPrivilege((Cypher5Parser.DbmsPrivilegeContext) ctx);
            case Cypher5Parser.RULE_dbmsPrivilegeExecute -> exitDbmsPrivilegeExecute(
                    (Cypher5Parser.DbmsPrivilegeExecuteContext) ctx);
            case Cypher5Parser.RULE_adminToken -> exitAdminToken((Cypher5Parser.AdminTokenContext) ctx);
            case Cypher5Parser.RULE_procedureToken -> exitProcedureToken((Cypher5Parser.ProcedureTokenContext) ctx);
            case Cypher5Parser.RULE_indexToken -> exitIndexToken((Cypher5Parser.IndexTokenContext) ctx);
            case Cypher5Parser.RULE_constraintToken -> exitConstraintToken((Cypher5Parser.ConstraintTokenContext) ctx);
            case Cypher5Parser.RULE_transactionToken -> exitTransactionToken(
                    (Cypher5Parser.TransactionTokenContext) ctx);
            case Cypher5Parser.RULE_userQualifier -> exitUserQualifier((Cypher5Parser.UserQualifierContext) ctx);
            case Cypher5Parser.RULE_executeFunctionQualifier -> exitExecuteFunctionQualifier(
                    (Cypher5Parser.ExecuteFunctionQualifierContext) ctx);
            case Cypher5Parser.RULE_executeProcedureQualifier -> exitExecuteProcedureQualifier(
                    (Cypher5Parser.ExecuteProcedureQualifierContext) ctx);
            case Cypher5Parser.RULE_settingQualifier -> exitSettingQualifier(
                    (Cypher5Parser.SettingQualifierContext) ctx);
            case Cypher5Parser.RULE_globs -> exitGlobs((Cypher5Parser.GlobsContext) ctx);
            case Cypher5Parser.RULE_glob -> exitGlob((Cypher5Parser.GlobContext) ctx);
            case Cypher5Parser.RULE_globRecursive -> exitGlobRecursive((Cypher5Parser.GlobRecursiveContext) ctx);
            case Cypher5Parser.RULE_globPart -> exitGlobPart((Cypher5Parser.GlobPartContext) ctx);
            case Cypher5Parser.RULE_qualifiedGraphPrivilegesWithProperty -> exitQualifiedGraphPrivilegesWithProperty(
                    (Cypher5Parser.QualifiedGraphPrivilegesWithPropertyContext) ctx);
            case Cypher5Parser.RULE_qualifiedGraphPrivileges -> exitQualifiedGraphPrivileges(
                    (Cypher5Parser.QualifiedGraphPrivilegesContext) ctx);
            case Cypher5Parser.RULE_labelsResource -> exitLabelsResource((Cypher5Parser.LabelsResourceContext) ctx);
            case Cypher5Parser.RULE_propertiesResource -> exitPropertiesResource(
                    (Cypher5Parser.PropertiesResourceContext) ctx);
            case Cypher5Parser.RULE_nonEmptyStringList -> exitNonEmptyStringList(
                    (Cypher5Parser.NonEmptyStringListContext) ctx);
            case Cypher5Parser.RULE_graphQualifier -> exitGraphQualifier((Cypher5Parser.GraphQualifierContext) ctx);
            case Cypher5Parser.RULE_graphQualifierToken -> exitGraphQualifierToken(
                    (Cypher5Parser.GraphQualifierTokenContext) ctx);
            case Cypher5Parser.RULE_relToken -> exitRelToken((Cypher5Parser.RelTokenContext) ctx);
            case Cypher5Parser.RULE_elementToken -> exitElementToken((Cypher5Parser.ElementTokenContext) ctx);
            case Cypher5Parser.RULE_nodeToken -> exitNodeToken((Cypher5Parser.NodeTokenContext) ctx);
            case Cypher5Parser.RULE_databaseScope -> exitDatabaseScope((Cypher5Parser.DatabaseScopeContext) ctx);
            case Cypher5Parser.RULE_graphScope -> exitGraphScope((Cypher5Parser.GraphScopeContext) ctx);
            case Cypher5Parser.RULE_createCompositeDatabase -> exitCreateCompositeDatabase(
                    (Cypher5Parser.CreateCompositeDatabaseContext) ctx);
            case Cypher5Parser.RULE_createDatabase -> exitCreateDatabase((Cypher5Parser.CreateDatabaseContext) ctx);
            case Cypher5Parser.RULE_primaryTopology -> exitPrimaryTopology((Cypher5Parser.PrimaryTopologyContext) ctx);
            case Cypher5Parser.RULE_primaryToken -> exitPrimaryToken((Cypher5Parser.PrimaryTokenContext) ctx);
            case Cypher5Parser.RULE_secondaryTopology -> exitSecondaryTopology(
                    (Cypher5Parser.SecondaryTopologyContext) ctx);
            case Cypher5Parser.RULE_secondaryToken -> exitSecondaryToken((Cypher5Parser.SecondaryTokenContext) ctx);
            case Cypher5Parser.RULE_dropDatabase -> exitDropDatabase((Cypher5Parser.DropDatabaseContext) ctx);
            case Cypher5Parser.RULE_aliasAction -> exitAliasAction((Cypher5Parser.AliasActionContext) ctx);
            case Cypher5Parser.RULE_alterDatabase -> exitAlterDatabase((Cypher5Parser.AlterDatabaseContext) ctx);
            case Cypher5Parser.RULE_alterDatabaseAccess -> exitAlterDatabaseAccess(
                    (Cypher5Parser.AlterDatabaseAccessContext) ctx);
            case Cypher5Parser.RULE_alterDatabaseTopology -> exitAlterDatabaseTopology(
                    (Cypher5Parser.AlterDatabaseTopologyContext) ctx);
            case Cypher5Parser.RULE_alterDatabaseOption -> exitAlterDatabaseOption(
                    (Cypher5Parser.AlterDatabaseOptionContext) ctx);
            case Cypher5Parser.RULE_startDatabase -> exitStartDatabase((Cypher5Parser.StartDatabaseContext) ctx);
            case Cypher5Parser.RULE_stopDatabase -> exitStopDatabase((Cypher5Parser.StopDatabaseContext) ctx);
            case Cypher5Parser.RULE_waitClause -> exitWaitClause((Cypher5Parser.WaitClauseContext) ctx);
            case Cypher5Parser.RULE_secondsToken -> exitSecondsToken((Cypher5Parser.SecondsTokenContext) ctx);
            case Cypher5Parser.RULE_showDatabase -> exitShowDatabase((Cypher5Parser.ShowDatabaseContext) ctx);
            case Cypher5Parser.RULE_aliasName -> exitAliasName((Cypher5Parser.AliasNameContext) ctx);
            case Cypher5Parser.RULE_databaseName -> exitDatabaseName((Cypher5Parser.DatabaseNameContext) ctx);
            case Cypher5Parser.RULE_createAlias -> exitCreateAlias((Cypher5Parser.CreateAliasContext) ctx);
            case Cypher5Parser.RULE_dropAlias -> exitDropAlias((Cypher5Parser.DropAliasContext) ctx);
            case Cypher5Parser.RULE_alterAlias -> exitAlterAlias((Cypher5Parser.AlterAliasContext) ctx);
            case Cypher5Parser.RULE_alterAliasTarget -> exitAlterAliasTarget(
                    (Cypher5Parser.AlterAliasTargetContext) ctx);
            case Cypher5Parser.RULE_alterAliasUser -> exitAlterAliasUser((Cypher5Parser.AlterAliasUserContext) ctx);
            case Cypher5Parser.RULE_alterAliasPassword -> exitAlterAliasPassword(
                    (Cypher5Parser.AlterAliasPasswordContext) ctx);
            case Cypher5Parser.RULE_alterAliasDriver -> exitAlterAliasDriver(
                    (Cypher5Parser.AlterAliasDriverContext) ctx);
            case Cypher5Parser.RULE_alterAliasProperties -> exitAlterAliasProperties(
                    (Cypher5Parser.AlterAliasPropertiesContext) ctx);
            case Cypher5Parser.RULE_showAliases -> exitShowAliases((Cypher5Parser.ShowAliasesContext) ctx);
            case Cypher5Parser.RULE_symbolicNameOrStringParameter -> exitSymbolicNameOrStringParameter(
                    (Cypher5Parser.SymbolicNameOrStringParameterContext) ctx);
            case Cypher5Parser.RULE_commandNameExpression -> exitCommandNameExpression(
                    (Cypher5Parser.CommandNameExpressionContext) ctx);
            case Cypher5Parser.RULE_symbolicNameOrStringParameterList -> exitSymbolicNameOrStringParameterList(
                    (Cypher5Parser.SymbolicNameOrStringParameterListContext) ctx);
            case Cypher5Parser.RULE_symbolicAliasNameList -> exitSymbolicAliasNameList(
                    (Cypher5Parser.SymbolicAliasNameListContext) ctx);
            case Cypher5Parser.RULE_symbolicAliasNameOrParameter -> exitSymbolicAliasNameOrParameter(
                    (Cypher5Parser.SymbolicAliasNameOrParameterContext) ctx);
            case Cypher5Parser.RULE_symbolicAliasName -> exitSymbolicAliasName(
                    (Cypher5Parser.SymbolicAliasNameContext) ctx);
            case Cypher5Parser.RULE_stringListLiteral -> exitStringListLiteral(
                    (Cypher5Parser.StringListLiteralContext) ctx);
            case Cypher5Parser.RULE_stringList -> exitStringList((Cypher5Parser.StringListContext) ctx);
            case Cypher5Parser.RULE_stringLiteral -> exitStringLiteral((Cypher5Parser.StringLiteralContext) ctx);
            case Cypher5Parser.RULE_stringOrParameterExpression -> exitStringOrParameterExpression(
                    (Cypher5Parser.StringOrParameterExpressionContext) ctx);
            case Cypher5Parser.RULE_stringOrParameter -> exitStringOrParameter(
                    (Cypher5Parser.StringOrParameterContext) ctx);
            case Cypher5Parser.RULE_uIntOrIntParameter -> exitUIntOrIntParameter(
                    (Cypher5Parser.UIntOrIntParameterContext) ctx);
            case Cypher5Parser.RULE_mapOrParameter -> exitMapOrParameter((Cypher5Parser.MapOrParameterContext) ctx);
            case Cypher5Parser.RULE_map -> exitMap((Cypher5Parser.MapContext) ctx);
            case Cypher5Parser.RULE_symbolicVariableNameString -> exitSymbolicVariableNameString(
                    (Cypher5Parser.SymbolicVariableNameStringContext) ctx);
            case Cypher5Parser.RULE_escapedSymbolicVariableNameString -> exitEscapedSymbolicVariableNameString(
                    (Cypher5Parser.EscapedSymbolicVariableNameStringContext) ctx);
            case Cypher5Parser.RULE_unescapedSymbolicVariableNameString -> exitUnescapedSymbolicVariableNameString(
                    (Cypher5Parser.UnescapedSymbolicVariableNameStringContext) ctx);
            case Cypher5Parser.RULE_symbolicNameString -> exitSymbolicNameString(
                    (Cypher5Parser.SymbolicNameStringContext) ctx);
            case Cypher5Parser.RULE_escapedSymbolicNameString -> exitEscapedSymbolicNameString(
                    (Cypher5Parser.EscapedSymbolicNameStringContext) ctx);
            case Cypher5Parser.RULE_unescapedSymbolicNameString -> exitUnescapedSymbolicNameString(
                    (Cypher5Parser.UnescapedSymbolicNameStringContext) ctx);
            case Cypher5Parser.RULE_symbolicLabelNameString -> exitSymbolicLabelNameString(
                    (Cypher5Parser.SymbolicLabelNameStringContext) ctx);
            case Cypher5Parser.RULE_unescapedLabelSymbolicNameString -> exitUnescapedLabelSymbolicNameString(
                    (Cypher5Parser.UnescapedLabelSymbolicNameStringContext) ctx);
            case Cypher5Parser.RULE_unescapedLabelSymbolicNameString_ -> exitUnescapedLabelSymbolicNameString_(
                    (Cypher5Parser.UnescapedLabelSymbolicNameString_Context) ctx);
            case Cypher5Parser.RULE_endOfFile -> exitEndOfFile((Cypher5Parser.EndOfFileContext) ctx);
            default -> throw new IllegalStateException("Unknown rule index " + ctx.getRuleIndex());
        }
    }
}
