#
# Copyright (c) "Neo4j"
# Neo4j Sweden AB [https://neo4j.com]
#
# This file is part of Neo4j.
#
# Neo4j is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <https://www.gnu.org/licenses/>.
#

#encoding: utf-8

Feature: QuantifiedPathPatternGpmTests

  # The scenarios in this feature represent examples from the document "Testing GPM" with
  # the numbers indicating which of the rows in that document the scenario refers to.
  Background:
    Given an empty graph
    And having executed:
    """
      CREATE (a:Person {name: "Chris", age: 30, city:"Paris"})-[:E {id:3, weight:3}]->(b:Person {name:"Diana", age: 35, city:"Paris"}),
             (d:Person:A {name:'Alice', age: 20, city:"Oslo"})-[:E {id:1, weight:6}]->(a),
             (:Person{name:"Bob", age: 25, city:"London"})-[:E {id:2, weight:2}]->(a),
             (b)-[:E {id:5, weight:7}]->(:Person{name:"Tony", age: 40, city:"Oslo"}),
             (b)-[:E {id:4, weight:1}]->(:Person{name:"Sue", age: 32, city:"London"}),
             (d)-[:K {id:6, weight:3}]->(a),
             (a)-[:K {id:7, weight:2}]->(b)
    """

  Scenario Outline: 4, 5, 7, 8 - Simple quantified relationship
    When executing query:
    """
      MATCH <pattern>
      RETURN a
    """
    Then the result should be, in any order:
      | a                                                                                                                                                          |
      | [(:Person {city: 'Paris', name: 'Chris', age: 30})]                                                                                                        |
      | [(:Person {city: 'Paris', name: 'Chris', age: 30})]                                                                                                        |
      | [(:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})]                                                     |
      | [(:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})]                                                     |
      | [(:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})]                                                     |
      | [(:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})]                                                     |
      | [(:Person {city: 'Paris', name: 'Diana', age: 35})]                                                                                                        |
      | [(:Person {city: 'Paris', name: 'Diana', age: 35})]                                                                                                        |
      | [(:Person:A {city: 'Oslo', name: 'Alice', age: 20})]                                                                                                       |
      | [(:Person:A {city: 'Oslo', name: 'Alice', age: 20})]                                                                                                       |
      | [(:Person:A {city: 'Oslo', name: 'Alice', age: 20}), (:Person {city: 'Paris', name: 'Chris', age: 30})]                                                    |
      | [(:Person:A {city: 'Oslo', name: 'Alice', age: 20}), (:Person {city: 'Paris', name: 'Chris', age: 30})]                                                    |
      | [(:Person:A {city: 'Oslo', name: 'Alice', age: 20}), (:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})] |
      | [(:Person:A {city: 'Oslo', name: 'Alice', age: 20}), (:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})] |
      | [(:Person:A {city: 'Oslo', name: 'Alice', age: 20}), (:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})] |
      | [(:Person:A {city: 'Oslo', name: 'Alice', age: 20}), (:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})] |
      | [(:Person:A {city: 'Oslo', name: 'Alice', age: 20}), (:Person {city: 'Paris', name: 'Chris', age: 30})]                                                    |
      | [(:Person:A {city: 'Oslo', name: 'Alice', age: 20}), (:Person {city: 'Paris', name: 'Chris', age: 30})]                                                    |
      | [(:Person:A {city: 'Oslo', name: 'Alice', age: 20}), (:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})] |
      | [(:Person:A {city: 'Oslo', name: 'Alice', age: 20}), (:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})] |
      | [(:Person:A {city: 'Oslo', name: 'Alice', age: 20}), (:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})] |
      | [(:Person:A {city: 'Oslo', name: 'Alice', age: 20}), (:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})] |
      | [(:Person {city: 'London', name: 'Bob', age: 25})]                                                                                                         |
      | [(:Person {city: 'London', name: 'Bob', age: 25}), (:Person {city: 'Paris', name: 'Chris', age: 30})]                                                      |
      | [(:Person {city: 'London', name: 'Bob', age: 25}), (:Person {city: 'Paris', name: 'Chris', age: 30})]                                                      |
      | [(:Person {city: 'London', name: 'Bob', age: 25}), (:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})]   |
      | [(:Person {city: 'London', name: 'Bob', age: 25}), (:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})]   |
      | [(:Person {city: 'London', name: 'Bob', age: 25}), (:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})]   |
      | [(:Person {city: 'London', name: 'Bob', age: 25}), (:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})]   |
    Examples:
      | pattern         |
      | ((a)-->(b))+    |
      | ((a)-->(b)){1,} |
      | ((a)-[]->(b))+  |
      | ((a)-[r]->(b))+ |


  Scenario: 6 - Simple quantified relationship, limited range
    When executing query:
    """
      MATCH ((a)-->(b)){1, 2}
      RETURN a
    """
    Then the result should be, in any order:
      | a                                                                                                       |
      | [(:Person {city: 'Paris', name: 'Chris', age: 30})]                                                     |
      | [(:Person {city: 'Paris', name: 'Chris', age: 30})]                                                     |
      | [(:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})]  |
      | [(:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})]  |
      | [(:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})]  |
      | [(:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})]  |
      | [(:Person {city: 'Paris', name: 'Diana', age: 35})]                                                     |
      | [(:Person {city: 'Paris', name: 'Diana', age: 35})]                                                     |
      | [(:Person:A {city: 'Oslo', name: 'Alice', age: 20})]                                                    |
      | [(:Person:A {city: 'Oslo', name: 'Alice', age: 20})]                                                    |
      | [(:Person:A {city: 'Oslo', name: 'Alice', age: 20}), (:Person {city: 'Paris', name: 'Chris', age: 30})] |
      | [(:Person:A {city: 'Oslo', name: 'Alice', age: 20}), (:Person {city: 'Paris', name: 'Chris', age: 30})] |
      | [(:Person:A {city: 'Oslo', name: 'Alice', age: 20}), (:Person {city: 'Paris', name: 'Chris', age: 30})] |
      | [(:Person:A {city: 'Oslo', name: 'Alice', age: 20}), (:Person {city: 'Paris', name: 'Chris', age: 30})] |
      | [(:Person {city: 'London', name: 'Bob', age: 25})]                                                      |
      | [(:Person {city: 'London', name: 'Bob', age: 25}), (:Person {city: 'Paris', name: 'Chris', age: 30})]   |
      | [(:Person {city: 'London', name: 'Bob', age: 25}), (:Person {city: 'Paris', name: 'Chris', age: 30})]   |

  Scenario: 9 - Simple quantified relationship, output x and a
    When executing query:
    """
      MATCH (x) ((a)-[r]->(b))+
      RETURN x, a
    """
    Then the result should be, in any order:
      | x                                                  | a                                                                                                                                                          |
      | (:Person {city: 'Paris', name: 'Chris', age: 30})  | [(:Person {city: 'Paris', name: 'Chris', age: 30})]                                                                                                        |
      | (:Person {city: 'Paris', name: 'Chris', age: 30})  | [(:Person {city: 'Paris', name: 'Chris', age: 30})]                                                                                                        |
      | (:Person {city: 'Paris', name: 'Chris', age: 30})  | [(:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})]                                                     |
      | (:Person {city: 'Paris', name: 'Chris', age: 30})  | [(:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})]                                                     |
      | (:Person {city: 'Paris', name: 'Chris', age: 30})  | [(:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})]                                                     |
      | (:Person {city: 'Paris', name: 'Chris', age: 30})  | [(:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})]                                                     |
      | (:Person {city: 'Paris', name: 'Diana', age: 35})  | [(:Person {city: 'Paris', name: 'Diana', age: 35})]                                                                                                        |
      | (:Person {city: 'Paris', name: 'Diana', age: 35})  | [(:Person {city: 'Paris', name: 'Diana', age: 35})]                                                                                                        |
      | (:Person:A {city: 'Oslo', name: 'Alice', age: 20}) | [(:Person:A {city: 'Oslo', name: 'Alice', age: 20})]                                                                                                       |
      | (:Person:A {city: 'Oslo', name: 'Alice', age: 20}) | [(:Person:A {city: 'Oslo', name: 'Alice', age: 20})]                                                                                                       |
      | (:Person:A {city: 'Oslo', name: 'Alice', age: 20}) | [(:Person:A {city: 'Oslo', name: 'Alice', age: 20}), (:Person {city: 'Paris', name: 'Chris', age: 30})]                                                    |
      | (:Person:A {city: 'Oslo', name: 'Alice', age: 20}) | [(:Person:A {city: 'Oslo', name: 'Alice', age: 20}), (:Person {city: 'Paris', name: 'Chris', age: 30})]                                                    |
      | (:Person:A {city: 'Oslo', name: 'Alice', age: 20}) | [(:Person:A {city: 'Oslo', name: 'Alice', age: 20}), (:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})] |
      | (:Person:A {city: 'Oslo', name: 'Alice', age: 20}) | [(:Person:A {city: 'Oslo', name: 'Alice', age: 20}), (:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})] |
      | (:Person:A {city: 'Oslo', name: 'Alice', age: 20}) | [(:Person:A {city: 'Oslo', name: 'Alice', age: 20}), (:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})] |
      | (:Person:A {city: 'Oslo', name: 'Alice', age: 20}) | [(:Person:A {city: 'Oslo', name: 'Alice', age: 20}), (:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})] |
      | (:Person:A {city: 'Oslo', name: 'Alice', age: 20}) | [(:Person:A {city: 'Oslo', name: 'Alice', age: 20}), (:Person {city: 'Paris', name: 'Chris', age: 30})]                                                    |
      | (:Person:A {city: 'Oslo', name: 'Alice', age: 20}) | [(:Person:A {city: 'Oslo', name: 'Alice', age: 20}), (:Person {city: 'Paris', name: 'Chris', age: 30})]                                                    |
      | (:Person:A {city: 'Oslo', name: 'Alice', age: 20}) | [(:Person:A {city: 'Oslo', name: 'Alice', age: 20}), (:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})] |
      | (:Person:A {city: 'Oslo', name: 'Alice', age: 20}) | [(:Person:A {city: 'Oslo', name: 'Alice', age: 20}), (:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})] |
      | (:Person:A {city: 'Oslo', name: 'Alice', age: 20}) | [(:Person:A {city: 'Oslo', name: 'Alice', age: 20}), (:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})] |
      | (:Person:A {city: 'Oslo', name: 'Alice', age: 20}) | [(:Person:A {city: 'Oslo', name: 'Alice', age: 20}), (:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})] |
      | (:Person {city: 'London', name: 'Bob', age: 25})   | [(:Person {city: 'London', name: 'Bob', age: 25})]                                                                                                         |
      | (:Person {city: 'London', name: 'Bob', age: 25})   | [(:Person {city: 'London', name: 'Bob', age: 25}), (:Person {city: 'Paris', name: 'Chris', age: 30})]                                                      |
      | (:Person {city: 'London', name: 'Bob', age: 25})   | [(:Person {city: 'London', name: 'Bob', age: 25}), (:Person {city: 'Paris', name: 'Chris', age: 30})]                                                      |
      | (:Person {city: 'London', name: 'Bob', age: 25})   | [(:Person {city: 'London', name: 'Bob', age: 25}), (:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})]   |
      | (:Person {city: 'London', name: 'Bob', age: 25})   | [(:Person {city: 'London', name: 'Bob', age: 25}), (:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})]   |
      | (:Person {city: 'London', name: 'Bob', age: 25})   | [(:Person {city: 'London', name: 'Bob', age: 25}), (:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})]   |
      | (:Person {city: 'London', name: 'Bob', age: 25})   | [(:Person {city: 'London', name: 'Bob', age: 25}), (:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})]   |

  Scenario: 10 - Simple quantified relationship, output all variables
    When executing query:
    """
      MATCH (x) ((a)-[r]->(b))+ (y)
      RETURN x, a, r, b, y
    """
    Then the result should be, in any order:
      | x                                                  | a                                                                                                                                                          | r                                                                           | b                                                                                                                                                        | y                                                 |
      | (:Person {city: 'Paris', name: 'Chris', age: 30})  | [(:Person {city: 'Paris', name: 'Chris', age: 30})]                                                                                                        | [[:K {weight: 2, id: 7}]]                                                   | [(:Person {city: 'Paris', name: 'Diana', age: 35})]                                                                                                      | (:Person {city: 'Paris', name: 'Diana', age: 35}) |
      | (:Person {city: 'Paris', name: 'Chris', age: 30})  | [(:Person {city: 'Paris', name: 'Chris', age: 30})]                                                                                                        | [[:E {weight: 3, id: 3}]]                                                   | [(:Person {city: 'Paris', name: 'Diana', age: 35})]                                                                                                      | (:Person {city: 'Paris', name: 'Diana', age: 35}) |
      | (:Person {city: 'Paris', name: 'Chris', age: 30})  | [(:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})]                                                     | [[:E {weight: 3, id: 3}], [:E {weight: 1, id: 4}]]                          | [(:Person {city: 'Paris', name: 'Diana', age: 35}), (:Person {city: 'London', name: 'Sue', age: 32})]                                                    | (:Person {city: 'London', name: 'Sue', age: 32})  |
      | (:Person {city: 'Paris', name: 'Chris', age: 30})  | [(:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})]                                                     | [[:E {weight: 3, id: 3}], [:E {weight: 7, id: 5}]]                          | [(:Person {city: 'Paris', name: 'Diana', age: 35}), (:Person {city: 'Oslo', name: 'Tony', age: 40})]                                                     | (:Person {city: 'Oslo', name: 'Tony', age: 40})   |
      | (:Person {city: 'Paris', name: 'Chris', age: 30})  | [(:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})]                                                     | [[:K {weight: 2, id: 7}], [:E {weight: 1, id: 4}]]                          | [(:Person {city: 'Paris', name: 'Diana', age: 35}), (:Person {city: 'London', name: 'Sue', age: 32})]                                                    | (:Person {city: 'London', name: 'Sue', age: 32})  |
      | (:Person {city: 'Paris', name: 'Chris', age: 30})  | [(:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})]                                                     | [[:K {weight: 2, id: 7}], [:E {weight: 7, id: 5}]]                          | [(:Person {city: 'Paris', name: 'Diana', age: 35}), (:Person {city: 'Oslo', name: 'Tony', age: 40})]                                                     | (:Person {city: 'Oslo', name: 'Tony', age: 40})   |
      | (:Person {city: 'Paris', name: 'Diana', age: 35})  | [(:Person {city: 'Paris', name: 'Diana', age: 35})]                                                                                                        | [[:E {weight: 1, id: 4}]]                                                   | [(:Person {city: 'London', name: 'Sue', age: 32})]                                                                                                       | (:Person {city: 'London', name: 'Sue', age: 32})  |
      | (:Person {city: 'Paris', name: 'Diana', age: 35})  | [(:Person {city: 'Paris', name: 'Diana', age: 35})]                                                                                                        | [[:E {weight: 7, id: 5}]]                                                   | [(:Person {city: 'Oslo', name: 'Tony', age: 40})]                                                                                                        | (:Person {city: 'Oslo', name: 'Tony', age: 40})   |
      | (:Person:A {city: 'Oslo', name: 'Alice', age: 20}) | [(:Person:A {city: 'Oslo', name: 'Alice', age: 20})]                                                                                                       | [[:K {weight: 3, id: 6}]]                                                   | [(:Person {city: 'Paris', name: 'Chris', age: 30})]                                                                                                      | (:Person {city: 'Paris', name: 'Chris', age: 30}) |
      | (:Person:A {city: 'Oslo', name: 'Alice', age: 20}) | [(:Person:A {city: 'Oslo', name: 'Alice', age: 20})]                                                                                                       | [[:E {weight: 6, id: 1}]]                                                   | [(:Person {city: 'Paris', name: 'Chris', age: 30})]                                                                                                      | (:Person {city: 'Paris', name: 'Chris', age: 30}) |
      | (:Person:A {city: 'Oslo', name: 'Alice', age: 20}) | [(:Person:A {city: 'Oslo', name: 'Alice', age: 20}), (:Person {city: 'Paris', name: 'Chris', age: 30})]                                                    | [[:E {weight: 6, id: 1}], [:K {weight: 2, id: 7}]]                          | [(:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})]                                                   | (:Person {city: 'Paris', name: 'Diana', age: 35}) |
      | (:Person:A {city: 'Oslo', name: 'Alice', age: 20}) | [(:Person:A {city: 'Oslo', name: 'Alice', age: 20}), (:Person {city: 'Paris', name: 'Chris', age: 30})]                                                    | [[:E {weight: 6, id: 1}], [:E {weight: 3, id: 3}]]                          | [(:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})]                                                   | (:Person {city: 'Paris', name: 'Diana', age: 35}) |
      | (:Person:A {city: 'Oslo', name: 'Alice', age: 20}) | [(:Person:A {city: 'Oslo', name: 'Alice', age: 20}), (:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})] | [[:E {weight: 6, id: 1}], [:E {weight: 3, id: 3}], [:E {weight: 1, id: 4}]] | [(:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35}), (:Person {city: 'London', name: 'Sue', age: 32})] | (:Person {city: 'London', name: 'Sue', age: 32})  |
      | (:Person:A {city: 'Oslo', name: 'Alice', age: 20}) | [(:Person:A {city: 'Oslo', name: 'Alice', age: 20}), (:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})] | [[:E {weight: 6, id: 1}], [:E {weight: 3, id: 3}], [:E {weight: 7, id: 5}]] | [(:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35}), (:Person {city: 'Oslo', name: 'Tony', age: 40})]  | (:Person {city: 'Oslo', name: 'Tony', age: 40})   |
      | (:Person:A {city: 'Oslo', name: 'Alice', age: 20}) | [(:Person:A {city: 'Oslo', name: 'Alice', age: 20}), (:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})] | [[:E {weight: 6, id: 1}], [:K {weight: 2, id: 7}], [:E {weight: 1, id: 4}]] | [(:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35}), (:Person {city: 'London', name: 'Sue', age: 32})] | (:Person {city: 'London', name: 'Sue', age: 32})  |
      | (:Person:A {city: 'Oslo', name: 'Alice', age: 20}) | [(:Person:A {city: 'Oslo', name: 'Alice', age: 20}), (:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})] | [[:E {weight: 6, id: 1}], [:K {weight: 2, id: 7}], [:E {weight: 7, id: 5}]] | [(:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35}), (:Person {city: 'Oslo', name: 'Tony', age: 40})]  | (:Person {city: 'Oslo', name: 'Tony', age: 40})   |
      | (:Person:A {city: 'Oslo', name: 'Alice', age: 20}) | [(:Person:A {city: 'Oslo', name: 'Alice', age: 20}), (:Person {city: 'Paris', name: 'Chris', age: 30})]                                                    | [[:K {weight: 3, id: 6}], [:K {weight: 2, id: 7}]]                          | [(:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})]                                                   | (:Person {city: 'Paris', name: 'Diana', age: 35}) |
      | (:Person:A {city: 'Oslo', name: 'Alice', age: 20}) | [(:Person:A {city: 'Oslo', name: 'Alice', age: 20}), (:Person {city: 'Paris', name: 'Chris', age: 30})]                                                    | [[:K {weight: 3, id: 6}], [:E {weight: 3, id: 3}]]                          | [(:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})]                                                   | (:Person {city: 'Paris', name: 'Diana', age: 35}) |
      | (:Person:A {city: 'Oslo', name: 'Alice', age: 20}) | [(:Person:A {city: 'Oslo', name: 'Alice', age: 20}), (:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})] | [[:K {weight: 3, id: 6}], [:E {weight: 3, id: 3}], [:E {weight: 1, id: 4}]] | [(:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35}), (:Person {city: 'London', name: 'Sue', age: 32})] | (:Person {city: 'London', name: 'Sue', age: 32})  |
      | (:Person:A {city: 'Oslo', name: 'Alice', age: 20}) | [(:Person:A {city: 'Oslo', name: 'Alice', age: 20}), (:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})] | [[:K {weight: 3, id: 6}], [:E {weight: 3, id: 3}], [:E {weight: 7, id: 5}]] | [(:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35}), (:Person {city: 'Oslo', name: 'Tony', age: 40})]  | (:Person {city: 'Oslo', name: 'Tony', age: 40})   |
      | (:Person:A {city: 'Oslo', name: 'Alice', age: 20}) | [(:Person:A {city: 'Oslo', name: 'Alice', age: 20}), (:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})] | [[:K {weight: 3, id: 6}], [:K {weight: 2, id: 7}], [:E {weight: 1, id: 4}]] | [(:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35}), (:Person {city: 'London', name: 'Sue', age: 32})] | (:Person {city: 'London', name: 'Sue', age: 32})  |
      | (:Person:A {city: 'Oslo', name: 'Alice', age: 20}) | [(:Person:A {city: 'Oslo', name: 'Alice', age: 20}), (:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})] | [[:K {weight: 3, id: 6}], [:K {weight: 2, id: 7}], [:E {weight: 7, id: 5}]] | [(:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35}), (:Person {city: 'Oslo', name: 'Tony', age: 40})]  | (:Person {city: 'Oslo', name: 'Tony', age: 40})   |
      | (:Person {city: 'London', name: 'Bob', age: 25})   | [(:Person {city: 'London', name: 'Bob', age: 25})]                                                                                                         | [[:E {weight: 2, id: 2}]]                                                   | [(:Person {city: 'Paris', name: 'Chris', age: 30})]                                                                                                      | (:Person {city: 'Paris', name: 'Chris', age: 30}) |
      | (:Person {city: 'London', name: 'Bob', age: 25})   | [(:Person {city: 'London', name: 'Bob', age: 25}), (:Person {city: 'Paris', name: 'Chris', age: 30})]                                                      | [[:E {weight: 2, id: 2}], [:K {weight: 2, id: 7}]]                          | [(:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})]                                                   | (:Person {city: 'Paris', name: 'Diana', age: 35}) |
      | (:Person {city: 'London', name: 'Bob', age: 25})   | [(:Person {city: 'London', name: 'Bob', age: 25}), (:Person {city: 'Paris', name: 'Chris', age: 30})]                                                      | [[:E {weight: 2, id: 2}], [:E {weight: 3, id: 3}]]                          | [(:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})]                                                   | (:Person {city: 'Paris', name: 'Diana', age: 35}) |
      | (:Person {city: 'London', name: 'Bob', age: 25})   | [(:Person {city: 'London', name: 'Bob', age: 25}), (:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})]   | [[:E {weight: 2, id: 2}], [:E {weight: 3, id: 3}], [:E {weight: 1, id: 4}]] | [(:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35}), (:Person {city: 'London', name: 'Sue', age: 32})] | (:Person {city: 'London', name: 'Sue', age: 32})  |
      | (:Person {city: 'London', name: 'Bob', age: 25})   | [(:Person {city: 'London', name: 'Bob', age: 25}), (:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})]   | [[:E {weight: 2, id: 2}], [:E {weight: 3, id: 3}], [:E {weight: 7, id: 5}]] | [(:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35}), (:Person {city: 'Oslo', name: 'Tony', age: 40})]  | (:Person {city: 'Oslo', name: 'Tony', age: 40})   |
      | (:Person {city: 'London', name: 'Bob', age: 25})   | [(:Person {city: 'London', name: 'Bob', age: 25}), (:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})]   | [[:E {weight: 2, id: 2}], [:K {weight: 2, id: 7}], [:E {weight: 1, id: 4}]] | [(:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35}), (:Person {city: 'London', name: 'Sue', age: 32})] | (:Person {city: 'London', name: 'Sue', age: 32})  |
      | (:Person {city: 'London', name: 'Bob', age: 25})   | [(:Person {city: 'London', name: 'Bob', age: 25}), (:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})]   | [[:E {weight: 2, id: 2}], [:K {weight: 2, id: 7}], [:E {weight: 7, id: 5}]] | [(:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35}), (:Person {city: 'Oslo', name: 'Tony', age: 40})]  | (:Person {city: 'Oslo', name: 'Tony', age: 40})   |

  Scenario: 11 - Simple quantified relationship, no lower bound, output all variables
    When executing query:
    """
      MATCH (x) ((a)-[r]->(b))*
      RETURN x, a, r, b
    """
    Then the result should be, in any order:
      | x                                                  | a                                                                                                                                                          | r                                                                           | b                                                                                                                                                        |
      | (:Person {city: 'Paris', name: 'Chris', age: 30})  | []                                                                                                                                                         | []                                                                          | []                                                                                                                                                       |
      | (:Person {city: 'Paris', name: 'Chris', age: 30})  | [(:Person {city: 'Paris', name: 'Chris', age: 30})]                                                                                                        | [[:K {weight: 2, id: 7}]]                                                   | [(:Person {city: 'Paris', name: 'Diana', age: 35})]                                                                                                      |
      | (:Person {city: 'Paris', name: 'Chris', age: 30})  | [(:Person {city: 'Paris', name: 'Chris', age: 30})]                                                                                                        | [[:E {weight: 3, id: 3}]]                                                   | [(:Person {city: 'Paris', name: 'Diana', age: 35})]                                                                                                      |
      | (:Person {city: 'Paris', name: 'Chris', age: 30})  | [(:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})]                                                     | [[:E {weight: 3, id: 3}], [:E {weight: 1, id: 4}]]                          | [(:Person {city: 'Paris', name: 'Diana', age: 35}), (:Person {city: 'London', name: 'Sue', age: 32})]                                                    |
      | (:Person {city: 'Paris', name: 'Chris', age: 30})  | [(:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})]                                                     | [[:E {weight: 3, id: 3}], [:E {weight: 7, id: 5}]]                          | [(:Person {city: 'Paris', name: 'Diana', age: 35}), (:Person {city: 'Oslo', name: 'Tony', age: 40})]                                                     |
      | (:Person {city: 'Paris', name: 'Chris', age: 30})  | [(:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})]                                                     | [[:K {weight: 2, id: 7}], [:E {weight: 1, id: 4}]]                          | [(:Person {city: 'Paris', name: 'Diana', age: 35}), (:Person {city: 'London', name: 'Sue', age: 32})]                                                    |
      | (:Person {city: 'Paris', name: 'Chris', age: 30})  | [(:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})]                                                     | [[:K {weight: 2, id: 7}], [:E {weight: 7, id: 5}]]                          | [(:Person {city: 'Paris', name: 'Diana', age: 35}), (:Person {city: 'Oslo', name: 'Tony', age: 40})]                                                     |
      | (:Person {city: 'Paris', name: 'Diana', age: 35})  | []                                                                                                                                                         | []                                                                          | []                                                                                                                                                       |
      | (:Person {city: 'Paris', name: 'Diana', age: 35})  | [(:Person {city: 'Paris', name: 'Diana', age: 35})]                                                                                                        | [[:E {weight: 1, id: 4}]]                                                   | [(:Person {city: 'London', name: 'Sue', age: 32})]                                                                                                       |
      | (:Person {city: 'Paris', name: 'Diana', age: 35})  | [(:Person {city: 'Paris', name: 'Diana', age: 35})]                                                                                                        | [[:E {weight: 7, id: 5}]]                                                   | [(:Person {city: 'Oslo', name: 'Tony', age: 40})]                                                                                                        |
      | (:Person:A {city: 'Oslo', name: 'Alice', age: 20}) | []                                                                                                                                                         | []                                                                          | []                                                                                                                                                       |
      | (:Person:A {city: 'Oslo', name: 'Alice', age: 20}) | [(:Person:A {city: 'Oslo', name: 'Alice', age: 20})]                                                                                                       | [[:K {weight: 3, id: 6}]]                                                   | [(:Person {city: 'Paris', name: 'Chris', age: 30})]                                                                                                      |
      | (:Person:A {city: 'Oslo', name: 'Alice', age: 20}) | [(:Person:A {city: 'Oslo', name: 'Alice', age: 20})]                                                                                                       | [[:E {weight: 6, id: 1}]]                                                   | [(:Person {city: 'Paris', name: 'Chris', age: 30})]                                                                                                      |
      | (:Person:A {city: 'Oslo', name: 'Alice', age: 20}) | [(:Person:A {city: 'Oslo', name: 'Alice', age: 20}), (:Person {city: 'Paris', name: 'Chris', age: 30})]                                                    | [[:E {weight: 6, id: 1}], [:K {weight: 2, id: 7}]]                          | [(:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})]                                                   |
      | (:Person:A {city: 'Oslo', name: 'Alice', age: 20}) | [(:Person:A {city: 'Oslo', name: 'Alice', age: 20}), (:Person {city: 'Paris', name: 'Chris', age: 30})]                                                    | [[:E {weight: 6, id: 1}], [:E {weight: 3, id: 3}]]                          | [(:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})]                                                   |
      | (:Person:A {city: 'Oslo', name: 'Alice', age: 20}) | [(:Person:A {city: 'Oslo', name: 'Alice', age: 20}), (:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})] | [[:E {weight: 6, id: 1}], [:E {weight: 3, id: 3}], [:E {weight: 1, id: 4}]] | [(:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35}), (:Person {city: 'London', name: 'Sue', age: 32})] |
      | (:Person:A {city: 'Oslo', name: 'Alice', age: 20}) | [(:Person:A {city: 'Oslo', name: 'Alice', age: 20}), (:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})] | [[:E {weight: 6, id: 1}], [:E {weight: 3, id: 3}], [:E {weight: 7, id: 5}]] | [(:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35}), (:Person {city: 'Oslo', name: 'Tony', age: 40})]  |
      | (:Person:A {city: 'Oslo', name: 'Alice', age: 20}) | [(:Person:A {city: 'Oslo', name: 'Alice', age: 20}), (:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})] | [[:E {weight: 6, id: 1}], [:K {weight: 2, id: 7}], [:E {weight: 1, id: 4}]] | [(:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35}), (:Person {city: 'London', name: 'Sue', age: 32})] |
      | (:Person:A {city: 'Oslo', name: 'Alice', age: 20}) | [(:Person:A {city: 'Oslo', name: 'Alice', age: 20}), (:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})] | [[:E {weight: 6, id: 1}], [:K {weight: 2, id: 7}], [:E {weight: 7, id: 5}]] | [(:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35}), (:Person {city: 'Oslo', name: 'Tony', age: 40})]  |
      | (:Person:A {city: 'Oslo', name: 'Alice', age: 20}) | [(:Person:A {city: 'Oslo', name: 'Alice', age: 20}), (:Person {city: 'Paris', name: 'Chris', age: 30})]                                                    | [[:K {weight: 3, id: 6}], [:K {weight: 2, id: 7}]]                          | [(:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})]                                                   |
      | (:Person:A {city: 'Oslo', name: 'Alice', age: 20}) | [(:Person:A {city: 'Oslo', name: 'Alice', age: 20}), (:Person {city: 'Paris', name: 'Chris', age: 30})]                                                    | [[:K {weight: 3, id: 6}], [:E {weight: 3, id: 3}]]                          | [(:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})]                                                   |
      | (:Person:A {city: 'Oslo', name: 'Alice', age: 20}) | [(:Person:A {city: 'Oslo', name: 'Alice', age: 20}), (:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})] | [[:K {weight: 3, id: 6}], [:E {weight: 3, id: 3}], [:E {weight: 1, id: 4}]] | [(:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35}), (:Person {city: 'London', name: 'Sue', age: 32})] |
      | (:Person:A {city: 'Oslo', name: 'Alice', age: 20}) | [(:Person:A {city: 'Oslo', name: 'Alice', age: 20}), (:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})] | [[:K {weight: 3, id: 6}], [:E {weight: 3, id: 3}], [:E {weight: 7, id: 5}]] | [(:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35}), (:Person {city: 'Oslo', name: 'Tony', age: 40})]  |
      | (:Person:A {city: 'Oslo', name: 'Alice', age: 20}) | [(:Person:A {city: 'Oslo', name: 'Alice', age: 20}), (:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})] | [[:K {weight: 3, id: 6}], [:K {weight: 2, id: 7}], [:E {weight: 1, id: 4}]] | [(:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35}), (:Person {city: 'London', name: 'Sue', age: 32})] |
      | (:Person:A {city: 'Oslo', name: 'Alice', age: 20}) | [(:Person:A {city: 'Oslo', name: 'Alice', age: 20}), (:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})] | [[:K {weight: 3, id: 6}], [:K {weight: 2, id: 7}], [:E {weight: 7, id: 5}]] | [(:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35}), (:Person {city: 'Oslo', name: 'Tony', age: 40})]  |
      | (:Person {city: 'London', name: 'Bob', age: 25})   | []                                                                                                                                                         | []                                                                          | []                                                                                                                                                       |
      | (:Person {city: 'London', name: 'Bob', age: 25})   | [(:Person {city: 'London', name: 'Bob', age: 25})]                                                                                                         | [[:E {weight: 2, id: 2}]]                                                   | [(:Person {city: 'Paris', name: 'Chris', age: 30})]                                                                                                      |
      | (:Person {city: 'London', name: 'Bob', age: 25})   | [(:Person {city: 'London', name: 'Bob', age: 25}), (:Person {city: 'Paris', name: 'Chris', age: 30})]                                                      | [[:E {weight: 2, id: 2}], [:K {weight: 2, id: 7}]]                          | [(:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})]                                                   |
      | (:Person {city: 'London', name: 'Bob', age: 25})   | [(:Person {city: 'London', name: 'Bob', age: 25}), (:Person {city: 'Paris', name: 'Chris', age: 30})]                                                      | [[:E {weight: 2, id: 2}], [:E {weight: 3, id: 3}]]                          | [(:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})]                                                   |
      | (:Person {city: 'London', name: 'Bob', age: 25})   | [(:Person {city: 'London', name: 'Bob', age: 25}), (:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})]   | [[:E {weight: 2, id: 2}], [:E {weight: 3, id: 3}], [:E {weight: 1, id: 4}]] | [(:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35}), (:Person {city: 'London', name: 'Sue', age: 32})] |
      | (:Person {city: 'London', name: 'Bob', age: 25})   | [(:Person {city: 'London', name: 'Bob', age: 25}), (:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})]   | [[:E {weight: 2, id: 2}], [:E {weight: 3, id: 3}], [:E {weight: 7, id: 5}]] | [(:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35}), (:Person {city: 'Oslo', name: 'Tony', age: 40})]  |
      | (:Person {city: 'London', name: 'Bob', age: 25})   | [(:Person {city: 'London', name: 'Bob', age: 25}), (:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})]   | [[:E {weight: 2, id: 2}], [:K {weight: 2, id: 7}], [:E {weight: 1, id: 4}]] | [(:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35}), (:Person {city: 'London', name: 'Sue', age: 32})] |
      | (:Person {city: 'London', name: 'Bob', age: 25})   | [(:Person {city: 'London', name: 'Bob', age: 25}), (:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})]   | [[:E {weight: 2, id: 2}], [:K {weight: 2, id: 7}], [:E {weight: 7, id: 5}]] | [(:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35}), (:Person {city: 'Oslo', name: 'Tony', age: 40})]  |
      | (:Person {city: 'Oslo', name: 'Tony', age: 40})    | []                                                                                                                                                         | []                                                                          | []                                                                                                                                                       |
      | (:Person {city: 'London', name: 'Sue', age: 32})   | []                                                                                                                                                         | []                                                                          | []                                                                                                                                                       |

  Scenario: 12 - Simple quantified relationship, no lower bound, incl. target node, output all variables
    When executing query:
    """
      MATCH (x) ((a)-[r]->(b))* (y)
      RETURN x, a, r, b, y
    """
    Then the result should be, in any order:
      | x                                                  | a                                                                                                                                                          | r                                                                           | b                                                                                                                                                        | y                                                  |
      | (:Person {city: 'Paris', name: 'Chris', age: 30})  | []                                                                                                                                                         | []                                                                          | []                                                                                                                                                       | (:Person {city: 'Paris', name: 'Chris', age: 30})  |
      | (:Person {city: 'Paris', name: 'Chris', age: 30})  | [(:Person {city: 'Paris', name: 'Chris', age: 30})]                                                                                                        | [[:K {weight: 2, id: 7}]]                                                   | [(:Person {city: 'Paris', name: 'Diana', age: 35})]                                                                                                      | (:Person {city: 'Paris', name: 'Diana', age: 35})  |
      | (:Person {city: 'Paris', name: 'Chris', age: 30})  | [(:Person {city: 'Paris', name: 'Chris', age: 30})]                                                                                                        | [[:E {weight: 3, id: 3}]]                                                   | [(:Person {city: 'Paris', name: 'Diana', age: 35})]                                                                                                      | (:Person {city: 'Paris', name: 'Diana', age: 35})  |
      | (:Person {city: 'Paris', name: 'Chris', age: 30})  | [(:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})]                                                     | [[:E {weight: 3, id: 3}], [:E {weight: 1, id: 4}]]                          | [(:Person {city: 'Paris', name: 'Diana', age: 35}), (:Person {city: 'London', name: 'Sue', age: 32})]                                                    | (:Person {city: 'London', name: 'Sue', age: 32})   |
      | (:Person {city: 'Paris', name: 'Chris', age: 30})  | [(:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})]                                                     | [[:E {weight: 3, id: 3}], [:E {weight: 7, id: 5}]]                          | [(:Person {city: 'Paris', name: 'Diana', age: 35}), (:Person {city: 'Oslo', name: 'Tony', age: 40})]                                                     | (:Person {city: 'Oslo', name: 'Tony', age: 40})    |
      | (:Person {city: 'Paris', name: 'Chris', age: 30})  | [(:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})]                                                     | [[:K {weight: 2, id: 7}], [:E {weight: 1, id: 4}]]                          | [(:Person {city: 'Paris', name: 'Diana', age: 35}), (:Person {city: 'London', name: 'Sue', age: 32})]                                                    | (:Person {city: 'London', name: 'Sue', age: 32})   |
      | (:Person {city: 'Paris', name: 'Chris', age: 30})  | [(:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})]                                                     | [[:K {weight: 2, id: 7}], [:E {weight: 7, id: 5}]]                          | [(:Person {city: 'Paris', name: 'Diana', age: 35}), (:Person {city: 'Oslo', name: 'Tony', age: 40})]                                                     | (:Person {city: 'Oslo', name: 'Tony', age: 40})    |
      | (:Person {city: 'Paris', name: 'Diana', age: 35})  | []                                                                                                                                                         | []                                                                          | []                                                                                                                                                       | (:Person {city: 'Paris', name: 'Diana', age: 35})  |
      | (:Person {city: 'Paris', name: 'Diana', age: 35})  | [(:Person {city: 'Paris', name: 'Diana', age: 35})]                                                                                                        | [[:E {weight: 1, id: 4}]]                                                   | [(:Person {city: 'London', name: 'Sue', age: 32})]                                                                                                       | (:Person {city: 'London', name: 'Sue', age: 32})   |
      | (:Person {city: 'Paris', name: 'Diana', age: 35})  | [(:Person {city: 'Paris', name: 'Diana', age: 35})]                                                                                                        | [[:E {weight: 7, id: 5}]]                                                   | [(:Person {city: 'Oslo', name: 'Tony', age: 40})]                                                                                                        | (:Person {city: 'Oslo', name: 'Tony', age: 40})    |
      | (:Person:A {city: 'Oslo', name: 'Alice', age: 20}) | []                                                                                                                                                         | []                                                                          | []                                                                                                                                                       | (:Person:A {city: 'Oslo', name: 'Alice', age: 20}) |
      | (:Person:A {city: 'Oslo', name: 'Alice', age: 20}) | [(:Person:A {city: 'Oslo', name: 'Alice', age: 20})]                                                                                                       | [[:K {weight: 3, id: 6}]]                                                   | [(:Person {city: 'Paris', name: 'Chris', age: 30})]                                                                                                      | (:Person {city: 'Paris', name: 'Chris', age: 30})  |
      | (:Person:A {city: 'Oslo', name: 'Alice', age: 20}) | [(:Person:A {city: 'Oslo', name: 'Alice', age: 20})]                                                                                                       | [[:E {weight: 6, id: 1}]]                                                   | [(:Person {city: 'Paris', name: 'Chris', age: 30})]                                                                                                      | (:Person {city: 'Paris', name: 'Chris', age: 30})  |
      | (:Person:A {city: 'Oslo', name: 'Alice', age: 20}) | [(:Person:A {city: 'Oslo', name: 'Alice', age: 20}), (:Person {city: 'Paris', name: 'Chris', age: 30})]                                                    | [[:E {weight: 6, id: 1}], [:K {weight: 2, id: 7}]]                          | [(:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})]                                                   | (:Person {city: 'Paris', name: 'Diana', age: 35})  |
      | (:Person:A {city: 'Oslo', name: 'Alice', age: 20}) | [(:Person:A {city: 'Oslo', name: 'Alice', age: 20}), (:Person {city: 'Paris', name: 'Chris', age: 30})]                                                    | [[:E {weight: 6, id: 1}], [:E {weight: 3, id: 3}]]                          | [(:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})]                                                   | (:Person {city: 'Paris', name: 'Diana', age: 35})  |
      | (:Person:A {city: 'Oslo', name: 'Alice', age: 20}) | [(:Person:A {city: 'Oslo', name: 'Alice', age: 20}), (:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})] | [[:E {weight: 6, id: 1}], [:E {weight: 3, id: 3}], [:E {weight: 1, id: 4}]] | [(:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35}), (:Person {city: 'London', name: 'Sue', age: 32})] | (:Person {city: 'London', name: 'Sue', age: 32})   |
      | (:Person:A {city: 'Oslo', name: 'Alice', age: 20}) | [(:Person:A {city: 'Oslo', name: 'Alice', age: 20}), (:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})] | [[:E {weight: 6, id: 1}], [:E {weight: 3, id: 3}], [:E {weight: 7, id: 5}]] | [(:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35}), (:Person {city: 'Oslo', name: 'Tony', age: 40})]  | (:Person {city: 'Oslo', name: 'Tony', age: 40})    |
      | (:Person:A {city: 'Oslo', name: 'Alice', age: 20}) | [(:Person:A {city: 'Oslo', name: 'Alice', age: 20}), (:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})] | [[:E {weight: 6, id: 1}], [:K {weight: 2, id: 7}], [:E {weight: 1, id: 4}]] | [(:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35}), (:Person {city: 'London', name: 'Sue', age: 32})] | (:Person {city: 'London', name: 'Sue', age: 32})   |
      | (:Person:A {city: 'Oslo', name: 'Alice', age: 20}) | [(:Person:A {city: 'Oslo', name: 'Alice', age: 20}), (:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})] | [[:E {weight: 6, id: 1}], [:K {weight: 2, id: 7}], [:E {weight: 7, id: 5}]] | [(:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35}), (:Person {city: 'Oslo', name: 'Tony', age: 40})]  | (:Person {city: 'Oslo', name: 'Tony', age: 40})    |
      | (:Person:A {city: 'Oslo', name: 'Alice', age: 20}) | [(:Person:A {city: 'Oslo', name: 'Alice', age: 20}), (:Person {city: 'Paris', name: 'Chris', age: 30})]                                                    | [[:K {weight: 3, id: 6}], [:K {weight: 2, id: 7}]]                          | [(:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})]                                                   | (:Person {city: 'Paris', name: 'Diana', age: 35})  |
      | (:Person:A {city: 'Oslo', name: 'Alice', age: 20}) | [(:Person:A {city: 'Oslo', name: 'Alice', age: 20}), (:Person {city: 'Paris', name: 'Chris', age: 30})]                                                    | [[:K {weight: 3, id: 6}], [:E {weight: 3, id: 3}]]                          | [(:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})]                                                   | (:Person {city: 'Paris', name: 'Diana', age: 35})  |
      | (:Person:A {city: 'Oslo', name: 'Alice', age: 20}) | [(:Person:A {city: 'Oslo', name: 'Alice', age: 20}), (:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})] | [[:K {weight: 3, id: 6}], [:E {weight: 3, id: 3}], [:E {weight: 1, id: 4}]] | [(:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35}), (:Person {city: 'London', name: 'Sue', age: 32})] | (:Person {city: 'London', name: 'Sue', age: 32})   |
      | (:Person:A {city: 'Oslo', name: 'Alice', age: 20}) | [(:Person:A {city: 'Oslo', name: 'Alice', age: 20}), (:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})] | [[:K {weight: 3, id: 6}], [:E {weight: 3, id: 3}], [:E {weight: 7, id: 5}]] | [(:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35}), (:Person {city: 'Oslo', name: 'Tony', age: 40})]  | (:Person {city: 'Oslo', name: 'Tony', age: 40})    |
      | (:Person:A {city: 'Oslo', name: 'Alice', age: 20}) | [(:Person:A {city: 'Oslo', name: 'Alice', age: 20}), (:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})] | [[:K {weight: 3, id: 6}], [:K {weight: 2, id: 7}], [:E {weight: 1, id: 4}]] | [(:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35}), (:Person {city: 'London', name: 'Sue', age: 32})] | (:Person {city: 'London', name: 'Sue', age: 32})   |
      | (:Person:A {city: 'Oslo', name: 'Alice', age: 20}) | [(:Person:A {city: 'Oslo', name: 'Alice', age: 20}), (:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})] | [[:K {weight: 3, id: 6}], [:K {weight: 2, id: 7}], [:E {weight: 7, id: 5}]] | [(:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35}), (:Person {city: 'Oslo', name: 'Tony', age: 40})]  | (:Person {city: 'Oslo', name: 'Tony', age: 40})    |
      | (:Person {city: 'London', name: 'Bob', age: 25})   | []                                                                                                                                                         | []                                                                          | []                                                                                                                                                       | (:Person {city: 'London', name: 'Bob', age: 25})   |
      | (:Person {city: 'London', name: 'Bob', age: 25})   | [(:Person {city: 'London', name: 'Bob', age: 25})]                                                                                                         | [[:E {weight: 2, id: 2}]]                                                   | [(:Person {city: 'Paris', name: 'Chris', age: 30})]                                                                                                      | (:Person {city: 'Paris', name: 'Chris', age: 30})  |
      | (:Person {city: 'London', name: 'Bob', age: 25})   | [(:Person {city: 'London', name: 'Bob', age: 25}), (:Person {city: 'Paris', name: 'Chris', age: 30})]                                                      | [[:E {weight: 2, id: 2}], [:K {weight: 2, id: 7}]]                          | [(:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})]                                                   | (:Person {city: 'Paris', name: 'Diana', age: 35})  |
      | (:Person {city: 'London', name: 'Bob', age: 25})   | [(:Person {city: 'London', name: 'Bob', age: 25}), (:Person {city: 'Paris', name: 'Chris', age: 30})]                                                      | [[:E {weight: 2, id: 2}], [:E {weight: 3, id: 3}]]                          | [(:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})]                                                   | (:Person {city: 'Paris', name: 'Diana', age: 35})  |
      | (:Person {city: 'London', name: 'Bob', age: 25})   | [(:Person {city: 'London', name: 'Bob', age: 25}), (:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})]   | [[:E {weight: 2, id: 2}], [:E {weight: 3, id: 3}], [:E {weight: 1, id: 4}]] | [(:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35}), (:Person {city: 'London', name: 'Sue', age: 32})] | (:Person {city: 'London', name: 'Sue', age: 32})   |
      | (:Person {city: 'London', name: 'Bob', age: 25})   | [(:Person {city: 'London', name: 'Bob', age: 25}), (:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})]   | [[:E {weight: 2, id: 2}], [:E {weight: 3, id: 3}], [:E {weight: 7, id: 5}]] | [(:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35}), (:Person {city: 'Oslo', name: 'Tony', age: 40})]  | (:Person {city: 'Oslo', name: 'Tony', age: 40})    |
      | (:Person {city: 'London', name: 'Bob', age: 25})   | [(:Person {city: 'London', name: 'Bob', age: 25}), (:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})]   | [[:E {weight: 2, id: 2}], [:K {weight: 2, id: 7}], [:E {weight: 1, id: 4}]] | [(:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35}), (:Person {city: 'London', name: 'Sue', age: 32})] | (:Person {city: 'London', name: 'Sue', age: 32})   |
      | (:Person {city: 'London', name: 'Bob', age: 25})   | [(:Person {city: 'London', name: 'Bob', age: 25}), (:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})]   | [[:E {weight: 2, id: 2}], [:K {weight: 2, id: 7}], [:E {weight: 7, id: 5}]] | [(:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35}), (:Person {city: 'Oslo', name: 'Tony', age: 40})]  | (:Person {city: 'Oslo', name: 'Tony', age: 40})    |
      | (:Person {city: 'Oslo', name: 'Tony', age: 40})    | []                                                                                                                                                         | []                                                                          | []                                                                                                                                                       | (:Person {city: 'Oslo', name: 'Tony', age: 40})    |
      | (:Person {city: 'London', name: 'Sue', age: 32})   | []                                                                                                                                                         | []                                                                          | []                                                                                                                                                       | (:Person {city: 'London', name: 'Sue', age: 32})   |

  Scenario: 13 - Simple quantified relationship with juxtaposed relationship, output all variables
    When executing query:
    """
      MATCH (x)-->(z) ((a)-[r]->(b))+
      RETURN x, z, a, r, b
    """
    Then the result should be, in any order:
      | x                                                  | z                                                 | a                                                                                                      | r                                                  | b                                                                                                     |
      | (:Person {city: 'London', name: 'Bob', age: 25})   | (:Person {city: 'Paris', name: 'Chris', age: 30}) | [(:Person {city: 'Paris', name: 'Chris', age: 30})]                                                    | [[:K {weight: 2, id: 7}]]                          | [(:Person {city: 'Paris', name: 'Diana', age: 35})]                                                   |
      | (:Person {city: 'London', name: 'Bob', age: 25})   | (:Person {city: 'Paris', name: 'Chris', age: 30}) | [(:Person {city: 'Paris', name: 'Chris', age: 30})]                                                    | [[:E {weight: 3, id: 3}]]                          | [(:Person {city: 'Paris', name: 'Diana', age: 35})]                                                   |
      | (:Person {city: 'London', name: 'Bob', age: 25})   | (:Person {city: 'Paris', name: 'Chris', age: 30}) | [(:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})] | [[:E {weight: 3, id: 3}], [:E {weight: 1, id: 4}]] | [(:Person {city: 'Paris', name: 'Diana', age: 35}), (:Person {city: 'London', name: 'Sue', age: 32})] |
      | (:Person {city: 'London', name: 'Bob', age: 25})   | (:Person {city: 'Paris', name: 'Chris', age: 30}) | [(:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})] | [[:E {weight: 3, id: 3}], [:E {weight: 7, id: 5}]] | [(:Person {city: 'Paris', name: 'Diana', age: 35}), (:Person {city: 'Oslo', name: 'Tony', age: 40})]  |
      | (:Person {city: 'London', name: 'Bob', age: 25})   | (:Person {city: 'Paris', name: 'Chris', age: 30}) | [(:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})] | [[:K {weight: 2, id: 7}], [:E {weight: 1, id: 4}]] | [(:Person {city: 'Paris', name: 'Diana', age: 35}), (:Person {city: 'London', name: 'Sue', age: 32})] |
      | (:Person {city: 'London', name: 'Bob', age: 25})   | (:Person {city: 'Paris', name: 'Chris', age: 30}) | [(:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})] | [[:K {weight: 2, id: 7}], [:E {weight: 7, id: 5}]] | [(:Person {city: 'Paris', name: 'Diana', age: 35}), (:Person {city: 'Oslo', name: 'Tony', age: 40})]  |
      | (:Person:A {city: 'Oslo', name: 'Alice', age: 20}) | (:Person {city: 'Paris', name: 'Chris', age: 30}) | [(:Person {city: 'Paris', name: 'Chris', age: 30})]                                                    | [[:K {weight: 2, id: 7}]]                          | [(:Person {city: 'Paris', name: 'Diana', age: 35})]                                                   |
      | (:Person:A {city: 'Oslo', name: 'Alice', age: 20}) | (:Person {city: 'Paris', name: 'Chris', age: 30}) | [(:Person {city: 'Paris', name: 'Chris', age: 30})]                                                    | [[:E {weight: 3, id: 3}]]                          | [(:Person {city: 'Paris', name: 'Diana', age: 35})]                                                   |
      | (:Person:A {city: 'Oslo', name: 'Alice', age: 20}) | (:Person {city: 'Paris', name: 'Chris', age: 30}) | [(:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})] | [[:E {weight: 3, id: 3}], [:E {weight: 1, id: 4}]] | [(:Person {city: 'Paris', name: 'Diana', age: 35}), (:Person {city: 'London', name: 'Sue', age: 32})] |
      | (:Person:A {city: 'Oslo', name: 'Alice', age: 20}) | (:Person {city: 'Paris', name: 'Chris', age: 30}) | [(:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})] | [[:E {weight: 3, id: 3}], [:E {weight: 7, id: 5}]] | [(:Person {city: 'Paris', name: 'Diana', age: 35}), (:Person {city: 'Oslo', name: 'Tony', age: 40})]  |
      | (:Person:A {city: 'Oslo', name: 'Alice', age: 20}) | (:Person {city: 'Paris', name: 'Chris', age: 30}) | [(:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})] | [[:K {weight: 2, id: 7}], [:E {weight: 1, id: 4}]] | [(:Person {city: 'Paris', name: 'Diana', age: 35}), (:Person {city: 'London', name: 'Sue', age: 32})] |
      | (:Person:A {city: 'Oslo', name: 'Alice', age: 20}) | (:Person {city: 'Paris', name: 'Chris', age: 30}) | [(:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})] | [[:K {weight: 2, id: 7}], [:E {weight: 7, id: 5}]] | [(:Person {city: 'Paris', name: 'Diana', age: 35}), (:Person {city: 'Oslo', name: 'Tony', age: 40})]  |
      | (:Person:A {city: 'Oslo', name: 'Alice', age: 20}) | (:Person {city: 'Paris', name: 'Chris', age: 30}) | [(:Person {city: 'Paris', name: 'Chris', age: 30})]                                                    | [[:K {weight: 2, id: 7}]]                          | [(:Person {city: 'Paris', name: 'Diana', age: 35})]                                                   |
      | (:Person:A {city: 'Oslo', name: 'Alice', age: 20}) | (:Person {city: 'Paris', name: 'Chris', age: 30}) | [(:Person {city: 'Paris', name: 'Chris', age: 30})]                                                    | [[:E {weight: 3, id: 3}]]                          | [(:Person {city: 'Paris', name: 'Diana', age: 35})]                                                   |
      | (:Person:A {city: 'Oslo', name: 'Alice', age: 20}) | (:Person {city: 'Paris', name: 'Chris', age: 30}) | [(:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})] | [[:E {weight: 3, id: 3}], [:E {weight: 1, id: 4}]] | [(:Person {city: 'Paris', name: 'Diana', age: 35}), (:Person {city: 'London', name: 'Sue', age: 32})] |
      | (:Person:A {city: 'Oslo', name: 'Alice', age: 20}) | (:Person {city: 'Paris', name: 'Chris', age: 30}) | [(:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})] | [[:E {weight: 3, id: 3}], [:E {weight: 7, id: 5}]] | [(:Person {city: 'Paris', name: 'Diana', age: 35}), (:Person {city: 'Oslo', name: 'Tony', age: 40})]  |
      | (:Person:A {city: 'Oslo', name: 'Alice', age: 20}) | (:Person {city: 'Paris', name: 'Chris', age: 30}) | [(:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})] | [[:K {weight: 2, id: 7}], [:E {weight: 1, id: 4}]] | [(:Person {city: 'Paris', name: 'Diana', age: 35}), (:Person {city: 'London', name: 'Sue', age: 32})] |
      | (:Person:A {city: 'Oslo', name: 'Alice', age: 20}) | (:Person {city: 'Paris', name: 'Chris', age: 30}) | [(:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})] | [[:K {weight: 2, id: 7}], [:E {weight: 7, id: 5}]] | [(:Person {city: 'Paris', name: 'Diana', age: 35}), (:Person {city: 'Oslo', name: 'Tony', age: 40})]  |
      | (:Person {city: 'Paris', name: 'Chris', age: 30})  | (:Person {city: 'Paris', name: 'Diana', age: 35}) | [(:Person {city: 'Paris', name: 'Diana', age: 35})]                                                    | [[:E {weight: 1, id: 4}]]                          | [(:Person {city: 'London', name: 'Sue', age: 32})]                                                    |
      | (:Person {city: 'Paris', name: 'Chris', age: 30})  | (:Person {city: 'Paris', name: 'Diana', age: 35}) | [(:Person {city: 'Paris', name: 'Diana', age: 35})]                                                    | [[:E {weight: 7, id: 5}]]                          | [(:Person {city: 'Oslo', name: 'Tony', age: 40})]                                                     |
      | (:Person {city: 'Paris', name: 'Chris', age: 30})  | (:Person {city: 'Paris', name: 'Diana', age: 35}) | [(:Person {city: 'Paris', name: 'Diana', age: 35})]                                                    | [[:E {weight: 1, id: 4}]]                          | [(:Person {city: 'London', name: 'Sue', age: 32})]                                                    |
      | (:Person {city: 'Paris', name: 'Chris', age: 30})  | (:Person {city: 'Paris', name: 'Diana', age: 35}) | [(:Person {city: 'Paris', name: 'Diana', age: 35})]                                                    | [[:E {weight: 7, id: 5}]]                          | [(:Person {city: 'Oslo', name: 'Tony', age: 40})]                                                     |

  Scenario Outline: 14, 15 - Simple quantified relationship with filter on the first node , output all variables
    When executing query:
    """
      MATCH <pattern>
      RETURN a, r ,b
    """
    Then the result should be, in any order:
      | a                                                                                                                                                          | r                                                                           | b                                                                                                                                                        |
      | [(:Person {city: 'Paris', name: 'Chris', age: 30})]                                                                                                        | [[:K {weight: 2, id: 7}]]                                                   | [(:Person {city: 'Paris', name: 'Diana', age: 35})]                                                                                                      |
      | [(:Person {city: 'Paris', name: 'Chris', age: 30})]                                                                                                        | [[:E {weight: 3, id: 3}]]                                                   | [(:Person {city: 'Paris', name: 'Diana', age: 35})]                                                                                                      |
      | [(:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})]                                                     | [[:E {weight: 3, id: 3}], [:E {weight: 1, id: 4}]]                          | [(:Person {city: 'Paris', name: 'Diana', age: 35}), (:Person {city: 'London', name: 'Sue', age: 32})]                                                    |
      | [(:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})]                                                     | [[:E {weight: 3, id: 3}], [:E {weight: 7, id: 5}]]                          | [(:Person {city: 'Paris', name: 'Diana', age: 35}), (:Person {city: 'Oslo', name: 'Tony', age: 40})]                                                     |
      | [(:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})]                                                     | [[:K {weight: 2, id: 7}], [:E {weight: 1, id: 4}]]                          | [(:Person {city: 'Paris', name: 'Diana', age: 35}), (:Person {city: 'London', name: 'Sue', age: 32})]                                                    |
      | [(:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})]                                                     | [[:K {weight: 2, id: 7}], [:E {weight: 7, id: 5}]]                          | [(:Person {city: 'Paris', name: 'Diana', age: 35}), (:Person {city: 'Oslo', name: 'Tony', age: 40})]                                                     |
      | [(:Person {city: 'Paris', name: 'Diana', age: 35})]                                                                                                        | [[:E {weight: 1, id: 4}]]                                                   | [(:Person {city: 'London', name: 'Sue', age: 32})]                                                                                                       |
      | [(:Person {city: 'Paris', name: 'Diana', age: 35})]                                                                                                        | [[:E {weight: 7, id: 5}]]                                                   | [(:Person {city: 'Oslo', name: 'Tony', age: 40})]                                                                                                        |
      | [(:Person:A {city: 'Oslo', name: 'Alice', age: 20})]                                                                                                       | [[:K {weight: 3, id: 6}]]                                                   | [(:Person {city: 'Paris', name: 'Chris', age: 30})]                                                                                                      |
      | [(:Person:A {city: 'Oslo', name: 'Alice', age: 20})]                                                                                                       | [[:E {weight: 6, id: 1}]]                                                   | [(:Person {city: 'Paris', name: 'Chris', age: 30})]                                                                                                      |
      | [(:Person:A {city: 'Oslo', name: 'Alice', age: 20}), (:Person {city: 'Paris', name: 'Chris', age: 30})]                                                    | [[:E {weight: 6, id: 1}], [:K {weight: 2, id: 7}]]                          | [(:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})]                                                   |
      | [(:Person:A {city: 'Oslo', name: 'Alice', age: 20}), (:Person {city: 'Paris', name: 'Chris', age: 30})]                                                    | [[:E {weight: 6, id: 1}], [:E {weight: 3, id: 3}]]                          | [(:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})]                                                   |
      | [(:Person:A {city: 'Oslo', name: 'Alice', age: 20}), (:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})] | [[:E {weight: 6, id: 1}], [:E {weight: 3, id: 3}], [:E {weight: 1, id: 4}]] | [(:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35}), (:Person {city: 'London', name: 'Sue', age: 32})] |
      | [(:Person:A {city: 'Oslo', name: 'Alice', age: 20}), (:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})] | [[:E {weight: 6, id: 1}], [:E {weight: 3, id: 3}], [:E {weight: 7, id: 5}]] | [(:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35}), (:Person {city: 'Oslo', name: 'Tony', age: 40})]  |
      | [(:Person:A {city: 'Oslo', name: 'Alice', age: 20}), (:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})] | [[:E {weight: 6, id: 1}], [:K {weight: 2, id: 7}], [:E {weight: 1, id: 4}]] | [(:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35}), (:Person {city: 'London', name: 'Sue', age: 32})] |
      | [(:Person:A {city: 'Oslo', name: 'Alice', age: 20}), (:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})] | [[:E {weight: 6, id: 1}], [:K {weight: 2, id: 7}], [:E {weight: 7, id: 5}]] | [(:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35}), (:Person {city: 'Oslo', name: 'Tony', age: 40})]  |
      | [(:Person:A {city: 'Oslo', name: 'Alice', age: 20}), (:Person {city: 'Paris', name: 'Chris', age: 30})]                                                    | [[:K {weight: 3, id: 6}], [:K {weight: 2, id: 7}]]                          | [(:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})]                                                   |
      | [(:Person:A {city: 'Oslo', name: 'Alice', age: 20}), (:Person {city: 'Paris', name: 'Chris', age: 30})]                                                    | [[:K {weight: 3, id: 6}], [:E {weight: 3, id: 3}]]                          | [(:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})]                                                   |
      | [(:Person:A {city: 'Oslo', name: 'Alice', age: 20}), (:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})] | [[:K {weight: 3, id: 6}], [:E {weight: 3, id: 3}], [:E {weight: 1, id: 4}]] | [(:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35}), (:Person {city: 'London', name: 'Sue', age: 32})] |
      | [(:Person:A {city: 'Oslo', name: 'Alice', age: 20}), (:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})] | [[:K {weight: 3, id: 6}], [:E {weight: 3, id: 3}], [:E {weight: 7, id: 5}]] | [(:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35}), (:Person {city: 'Oslo', name: 'Tony', age: 40})]  |
      | [(:Person:A {city: 'Oslo', name: 'Alice', age: 20}), (:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})] | [[:K {weight: 3, id: 6}], [:K {weight: 2, id: 7}], [:E {weight: 1, id: 4}]] | [(:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35}), (:Person {city: 'London', name: 'Sue', age: 32})] |
      | [(:Person:A {city: 'Oslo', name: 'Alice', age: 20}), (:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})] | [[:K {weight: 3, id: 6}], [:K {weight: 2, id: 7}], [:E {weight: 7, id: 5}]] | [(:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35}), (:Person {city: 'Oslo', name: 'Tony', age: 40})]  |
      | [(:Person {city: 'London', name: 'Bob', age: 25})]                                                                                                         | [[:E {weight: 2, id: 2}]]                                                   | [(:Person {city: 'Paris', name: 'Chris', age: 30})]                                                                                                      |
      | [(:Person {city: 'London', name: 'Bob', age: 25}), (:Person {city: 'Paris', name: 'Chris', age: 30})]                                                      | [[:E {weight: 2, id: 2}], [:K {weight: 2, id: 7}]]                          | [(:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})]                                                   |
      | [(:Person {city: 'London', name: 'Bob', age: 25}), (:Person {city: 'Paris', name: 'Chris', age: 30})]                                                      | [[:E {weight: 2, id: 2}], [:E {weight: 3, id: 3}]]                          | [(:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})]                                                   |
      | [(:Person {city: 'London', name: 'Bob', age: 25}), (:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})]   | [[:E {weight: 2, id: 2}], [:E {weight: 3, id: 3}], [:E {weight: 1, id: 4}]] | [(:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35}), (:Person {city: 'London', name: 'Sue', age: 32})] |
      | [(:Person {city: 'London', name: 'Bob', age: 25}), (:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})]   | [[:E {weight: 2, id: 2}], [:E {weight: 3, id: 3}], [:E {weight: 7, id: 5}]] | [(:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35}), (:Person {city: 'Oslo', name: 'Tony', age: 40})]  |
      | [(:Person {city: 'London', name: 'Bob', age: 25}), (:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})]   | [[:E {weight: 2, id: 2}], [:K {weight: 2, id: 7}], [:E {weight: 1, id: 4}]] | [(:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35}), (:Person {city: 'London', name: 'Sue', age: 32})] |
      | [(:Person {city: 'London', name: 'Bob', age: 25}), (:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})]   | [[:E {weight: 2, id: 2}], [:K {weight: 2, id: 7}], [:E {weight: 7, id: 5}]] | [(:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35}), (:Person {city: 'Oslo', name: 'Tony', age: 40})]  |
    Examples:
      | pattern                   |
      | ((a:Person)-[r]->(b))+    |
      | ((a:Person\|A)-[r]->(b))+ |

  Scenario: 16 - Simple quantified relationship with label expression containing AND, output all variables
    When executing query:
    """
      MATCH ((a:Person&A)-[r]->(b))+
      RETURN a, r, b
    """
    Then the result should be, in any order:
      | a                                                    | r                         | b                                                   |
      | [(:Person:A {city: 'Oslo', name: 'Alice', age: 20})] | [[:K {weight: 3, id: 6}]] | [(:Person {city: 'Paris', name: 'Chris', age: 30})] |
      | [(:Person:A {city: 'Oslo', name: 'Alice', age: 20})] | [[:E {weight: 6, id: 1}]] | [(:Person {city: 'Paris', name: 'Chris', age: 30})] |

  Scenario Outline: 17, 18, 22 - Simple quantified relationship with juxtaposed node with label expression, output all variables
    When executing query:
    """
      MATCH <pattern>
      RETURN x, a, r, b
    """
    Then the result should be, in any order:
      | x                                                  | a                                                                                                                                                          | r                                                                           | b                                                                                                                                                        |
      | (:Person:A {city: 'Oslo', name: 'Alice', age: 20}) | [(:Person:A {city: 'Oslo', name: 'Alice', age: 20})]                                                                                                       | [[:K {weight: 3, id: 6}]]                                                   | [(:Person {city: 'Paris', name: 'Chris', age: 30})]                                                                                                      |
      | (:Person:A {city: 'Oslo', name: 'Alice', age: 20}) | [(:Person:A {city: 'Oslo', name: 'Alice', age: 20})]                                                                                                       | [[:E {weight: 6, id: 1}]]                                                   | [(:Person {city: 'Paris', name: 'Chris', age: 30})]                                                                                                      |
      | (:Person:A {city: 'Oslo', name: 'Alice', age: 20}) | [(:Person:A {city: 'Oslo', name: 'Alice', age: 20}), (:Person {city: 'Paris', name: 'Chris', age: 30})]                                                    | [[:E {weight: 6, id: 1}], [:K {weight: 2, id: 7}]]                          | [(:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})]                                                   |
      | (:Person:A {city: 'Oslo', name: 'Alice', age: 20}) | [(:Person:A {city: 'Oslo', name: 'Alice', age: 20}), (:Person {city: 'Paris', name: 'Chris', age: 30})]                                                    | [[:E {weight: 6, id: 1}], [:E {weight: 3, id: 3}]]                          | [(:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})]                                                   |
      | (:Person:A {city: 'Oslo', name: 'Alice', age: 20}) | [(:Person:A {city: 'Oslo', name: 'Alice', age: 20}), (:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})] | [[:E {weight: 6, id: 1}], [:E {weight: 3, id: 3}], [:E {weight: 1, id: 4}]] | [(:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35}), (:Person {city: 'London', name: 'Sue', age: 32})] |
      | (:Person:A {city: 'Oslo', name: 'Alice', age: 20}) | [(:Person:A {city: 'Oslo', name: 'Alice', age: 20}), (:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})] | [[:E {weight: 6, id: 1}], [:E {weight: 3, id: 3}], [:E {weight: 7, id: 5}]] | [(:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35}), (:Person {city: 'Oslo', name: 'Tony', age: 40})]  |
      | (:Person:A {city: 'Oslo', name: 'Alice', age: 20}) | [(:Person:A {city: 'Oslo', name: 'Alice', age: 20}), (:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})] | [[:E {weight: 6, id: 1}], [:K {weight: 2, id: 7}], [:E {weight: 1, id: 4}]] | [(:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35}), (:Person {city: 'London', name: 'Sue', age: 32})] |
      | (:Person:A {city: 'Oslo', name: 'Alice', age: 20}) | [(:Person:A {city: 'Oslo', name: 'Alice', age: 20}), (:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})] | [[:E {weight: 6, id: 1}], [:K {weight: 2, id: 7}], [:E {weight: 7, id: 5}]] | [(:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35}), (:Person {city: 'Oslo', name: 'Tony', age: 40})]  |
      | (:Person:A {city: 'Oslo', name: 'Alice', age: 20}) | [(:Person:A {city: 'Oslo', name: 'Alice', age: 20}), (:Person {city: 'Paris', name: 'Chris', age: 30})]                                                    | [[:K {weight: 3, id: 6}], [:K {weight: 2, id: 7}]]                          | [(:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})]                                                   |
      | (:Person:A {city: 'Oslo', name: 'Alice', age: 20}) | [(:Person:A {city: 'Oslo', name: 'Alice', age: 20}), (:Person {city: 'Paris', name: 'Chris', age: 30})]                                                    | [[:K {weight: 3, id: 6}], [:E {weight: 3, id: 3}]]                          | [(:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})]                                                   |
      | (:Person:A {city: 'Oslo', name: 'Alice', age: 20}) | [(:Person:A {city: 'Oslo', name: 'Alice', age: 20}), (:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})] | [[:K {weight: 3, id: 6}], [:E {weight: 3, id: 3}], [:E {weight: 1, id: 4}]] | [(:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35}), (:Person {city: 'London', name: 'Sue', age: 32})] |
      | (:Person:A {city: 'Oslo', name: 'Alice', age: 20}) | [(:Person:A {city: 'Oslo', name: 'Alice', age: 20}), (:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})] | [[:K {weight: 3, id: 6}], [:E {weight: 3, id: 3}], [:E {weight: 7, id: 5}]] | [(:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35}), (:Person {city: 'Oslo', name: 'Tony', age: 40})]  |
      | (:Person:A {city: 'Oslo', name: 'Alice', age: 20}) | [(:Person:A {city: 'Oslo', name: 'Alice', age: 20}), (:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})] | [[:K {weight: 3, id: 6}], [:K {weight: 2, id: 7}], [:E {weight: 1, id: 4}]] | [(:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35}), (:Person {city: 'London', name: 'Sue', age: 32})] |
      | (:Person:A {city: 'Oslo', name: 'Alice', age: 20}) | [(:Person:A {city: 'Oslo', name: 'Alice', age: 20}), (:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})] | [[:K {weight: 3, id: 6}], [:K {weight: 2, id: 7}], [:E {weight: 7, id: 5}]] | [(:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35}), (:Person {city: 'Oslo', name: 'Tony', age: 40})]  |
    Examples:
      | pattern                                    |
      | (x:Person&A)((a)-[r]->(b))+                |
      | (x:Person&A)((a:Person\|A)-[r]->(b))+      |
      | (x:Person&A)((a:Person\|A)-[r:E\|K]->(b))+ |

  Scenario: 19 - Simple quantified relationship with filter on relationship, output all variables
    When executing query:
    """
      MATCH ((a)-[r:E]->(b))+
      RETURN a, r, b
    """
    Then the result should be, in any order:
      | a                                                                                                                                                          | r                                                                           | b                                                                                                                                                        |
      | [(:Person {city: 'Paris', name: 'Chris', age: 30})]                                                                                                        | [[:E {weight: 3, id: 3}]]                                                   | [(:Person {city: 'Paris', name: 'Diana', age: 35})]                                                                                                      |
      | [(:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})]                                                     | [[:E {weight: 3, id: 3}], [:E {weight: 1, id: 4}]]                          | [(:Person {city: 'Paris', name: 'Diana', age: 35}), (:Person {city: 'London', name: 'Sue', age: 32})]                                                    |
      | [(:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})]                                                     | [[:E {weight: 3, id: 3}], [:E {weight: 7, id: 5}]]                          | [(:Person {city: 'Paris', name: 'Diana', age: 35}), (:Person {city: 'Oslo', name: 'Tony', age: 40})]                                                     |
      | [(:Person {city: 'Paris', name: 'Diana', age: 35})]                                                                                                        | [[:E {weight: 1, id: 4}]]                                                   | [(:Person {city: 'London', name: 'Sue', age: 32})]                                                                                                       |
      | [(:Person {city: 'Paris', name: 'Diana', age: 35})]                                                                                                        | [[:E {weight: 7, id: 5}]]                                                   | [(:Person {city: 'Oslo', name: 'Tony', age: 40})]                                                                                                        |
      | [(:Person:A {city: 'Oslo', name: 'Alice', age: 20})]                                                                                                       | [[:E {weight: 6, id: 1}]]                                                   | [(:Person {city: 'Paris', name: 'Chris', age: 30})]                                                                                                      |
      | [(:Person:A {city: 'Oslo', name: 'Alice', age: 20}), (:Person {city: 'Paris', name: 'Chris', age: 30})]                                                    | [[:E {weight: 6, id: 1}], [:E {weight: 3, id: 3}]]                          | [(:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})]                                                   |
      | [(:Person:A {city: 'Oslo', name: 'Alice', age: 20}), (:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})] | [[:E {weight: 6, id: 1}], [:E {weight: 3, id: 3}], [:E {weight: 1, id: 4}]] | [(:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35}), (:Person {city: 'London', name: 'Sue', age: 32})] |
      | [(:Person:A {city: 'Oslo', name: 'Alice', age: 20}), (:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})] | [[:E {weight: 6, id: 1}], [:E {weight: 3, id: 3}], [:E {weight: 7, id: 5}]] | [(:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35}), (:Person {city: 'Oslo', name: 'Tony', age: 40})]  |
      | [(:Person {city: 'London', name: 'Bob', age: 25})]                                                                                                         | [[:E {weight: 2, id: 2}]]                                                   | [(:Person {city: 'Paris', name: 'Chris', age: 30})]                                                                                                      |
      | [(:Person {city: 'London', name: 'Bob', age: 25}), (:Person {city: 'Paris', name: 'Chris', age: 30})]                                                      | [[:E {weight: 2, id: 2}], [:E {weight: 3, id: 3}]]                          | [(:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})]                                                   |
      | [(:Person {city: 'London', name: 'Bob', age: 25}), (:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})]   | [[:E {weight: 2, id: 2}], [:E {weight: 3, id: 3}], [:E {weight: 1, id: 4}]] | [(:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35}), (:Person {city: 'London', name: 'Sue', age: 32})] |
      | [(:Person {city: 'London', name: 'Bob', age: 25}), (:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})]   | [[:E {weight: 2, id: 2}], [:E {weight: 3, id: 3}], [:E {weight: 7, id: 5}]] | [(:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35}), (:Person {city: 'Oslo', name: 'Tony', age: 40})]  |

  Scenario: 20 - Simple quantified relationship with relationship type expression, output all variables
    When executing query:
    """
      MATCH ((a)-[r:E|K]->(b))+
      RETURN a, r, b
    """
    Then the result should be, in any order:
      | a                                                                                                                                                          | r                                                                           | b                                                                                                                                                        |
      | [(:Person {city: 'Paris', name: 'Chris', age: 30})]                                                                                                        | [[:K {weight: 2, id: 7}]]                                                   | [(:Person {city: 'Paris', name: 'Diana', age: 35})]                                                                                                      |
      | [(:Person {city: 'Paris', name: 'Chris', age: 30})]                                                                                                        | [[:E {weight: 3, id: 3}]]                                                   | [(:Person {city: 'Paris', name: 'Diana', age: 35})]                                                                                                      |
      | [(:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})]                                                     | [[:E {weight: 3, id: 3}], [:E {weight: 1, id: 4}]]                          | [(:Person {city: 'Paris', name: 'Diana', age: 35}), (:Person {city: 'London', name: 'Sue', age: 32})]                                                    |
      | [(:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})]                                                     | [[:E {weight: 3, id: 3}], [:E {weight: 7, id: 5}]]                          | [(:Person {city: 'Paris', name: 'Diana', age: 35}), (:Person {city: 'Oslo', name: 'Tony', age: 40})]                                                     |
      | [(:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})]                                                     | [[:K {weight: 2, id: 7}], [:E {weight: 1, id: 4}]]                          | [(:Person {city: 'Paris', name: 'Diana', age: 35}), (:Person {city: 'London', name: 'Sue', age: 32})]                                                    |
      | [(:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})]                                                     | [[:K {weight: 2, id: 7}], [:E {weight: 7, id: 5}]]                          | [(:Person {city: 'Paris', name: 'Diana', age: 35}), (:Person {city: 'Oslo', name: 'Tony', age: 40})]                                                     |
      | [(:Person {city: 'Paris', name: 'Diana', age: 35})]                                                                                                        | [[:E {weight: 1, id: 4}]]                                                   | [(:Person {city: 'London', name: 'Sue', age: 32})]                                                                                                       |
      | [(:Person {city: 'Paris', name: 'Diana', age: 35})]                                                                                                        | [[:E {weight: 7, id: 5}]]                                                   | [(:Person {city: 'Oslo', name: 'Tony', age: 40})]                                                                                                        |
      | [(:Person:A {city: 'Oslo', name: 'Alice', age: 20})]                                                                                                       | [[:K {weight: 3, id: 6}]]                                                   | [(:Person {city: 'Paris', name: 'Chris', age: 30})]                                                                                                      |
      | [(:Person:A {city: 'Oslo', name: 'Alice', age: 20})]                                                                                                       | [[:E {weight: 6, id: 1}]]                                                   | [(:Person {city: 'Paris', name: 'Chris', age: 30})]                                                                                                      |
      | [(:Person:A {city: 'Oslo', name: 'Alice', age: 20}), (:Person {city: 'Paris', name: 'Chris', age: 30})]                                                    | [[:E {weight: 6, id: 1}], [:K {weight: 2, id: 7}]]                          | [(:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})]                                                   |
      | [(:Person:A {city: 'Oslo', name: 'Alice', age: 20}), (:Person {city: 'Paris', name: 'Chris', age: 30})]                                                    | [[:E {weight: 6, id: 1}], [:E {weight: 3, id: 3}]]                          | [(:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})]                                                   |
      | [(:Person:A {city: 'Oslo', name: 'Alice', age: 20}), (:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})] | [[:E {weight: 6, id: 1}], [:E {weight: 3, id: 3}], [:E {weight: 1, id: 4}]] | [(:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35}), (:Person {city: 'London', name: 'Sue', age: 32})] |
      | [(:Person:A {city: 'Oslo', name: 'Alice', age: 20}), (:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})] | [[:E {weight: 6, id: 1}], [:E {weight: 3, id: 3}], [:E {weight: 7, id: 5}]] | [(:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35}), (:Person {city: 'Oslo', name: 'Tony', age: 40})]  |
      | [(:Person:A {city: 'Oslo', name: 'Alice', age: 20}), (:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})] | [[:E {weight: 6, id: 1}], [:K {weight: 2, id: 7}], [:E {weight: 1, id: 4}]] | [(:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35}), (:Person {city: 'London', name: 'Sue', age: 32})] |
      | [(:Person:A {city: 'Oslo', name: 'Alice', age: 20}), (:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})] | [[:E {weight: 6, id: 1}], [:K {weight: 2, id: 7}], [:E {weight: 7, id: 5}]] | [(:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35}), (:Person {city: 'Oslo', name: 'Tony', age: 40})]  |
      | [(:Person:A {city: 'Oslo', name: 'Alice', age: 20}), (:Person {city: 'Paris', name: 'Chris', age: 30})]                                                    | [[:K {weight: 3, id: 6}], [:K {weight: 2, id: 7}]]                          | [(:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})]                                                   |
      | [(:Person:A {city: 'Oslo', name: 'Alice', age: 20}), (:Person {city: 'Paris', name: 'Chris', age: 30})]                                                    | [[:K {weight: 3, id: 6}], [:E {weight: 3, id: 3}]]                          | [(:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})]                                                   |
      | [(:Person:A {city: 'Oslo', name: 'Alice', age: 20}), (:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})] | [[:K {weight: 3, id: 6}], [:E {weight: 3, id: 3}], [:E {weight: 1, id: 4}]] | [(:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35}), (:Person {city: 'London', name: 'Sue', age: 32})] |
      | [(:Person:A {city: 'Oslo', name: 'Alice', age: 20}), (:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})] | [[:K {weight: 3, id: 6}], [:E {weight: 3, id: 3}], [:E {weight: 7, id: 5}]] | [(:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35}), (:Person {city: 'Oslo', name: 'Tony', age: 40})]  |
      | [(:Person:A {city: 'Oslo', name: 'Alice', age: 20}), (:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})] | [[:K {weight: 3, id: 6}], [:K {weight: 2, id: 7}], [:E {weight: 1, id: 4}]] | [(:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35}), (:Person {city: 'London', name: 'Sue', age: 32})] |
      | [(:Person:A {city: 'Oslo', name: 'Alice', age: 20}), (:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})] | [[:K {weight: 3, id: 6}], [:K {weight: 2, id: 7}], [:E {weight: 7, id: 5}]] | [(:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35}), (:Person {city: 'Oslo', name: 'Tony', age: 40})]  |
      | [(:Person {city: 'London', name: 'Bob', age: 25})]                                                                                                         | [[:E {weight: 2, id: 2}]]                                                   | [(:Person {city: 'Paris', name: 'Chris', age: 30})]                                                                                                      |
      | [(:Person {city: 'London', name: 'Bob', age: 25}), (:Person {city: 'Paris', name: 'Chris', age: 30})]                                                      | [[:E {weight: 2, id: 2}], [:K {weight: 2, id: 7}]]                          | [(:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})]                                                   |
      | [(:Person {city: 'London', name: 'Bob', age: 25}), (:Person {city: 'Paris', name: 'Chris', age: 30})]                                                      | [[:E {weight: 2, id: 2}], [:E {weight: 3, id: 3}]]                          | [(:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})]                                                   |
      | [(:Person {city: 'London', name: 'Bob', age: 25}), (:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})]   | [[:E {weight: 2, id: 2}], [:E {weight: 3, id: 3}], [:E {weight: 1, id: 4}]] | [(:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35}), (:Person {city: 'London', name: 'Sue', age: 32})] |
      | [(:Person {city: 'London', name: 'Bob', age: 25}), (:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})]   | [[:E {weight: 2, id: 2}], [:E {weight: 3, id: 3}], [:E {weight: 7, id: 5}]] | [(:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35}), (:Person {city: 'Oslo', name: 'Tony', age: 40})]  |
      | [(:Person {city: 'London', name: 'Bob', age: 25}), (:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})]   | [[:E {weight: 2, id: 2}], [:K {weight: 2, id: 7}], [:E {weight: 1, id: 4}]] | [(:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35}), (:Person {city: 'London', name: 'Sue', age: 32})] |
      | [(:Person {city: 'London', name: 'Bob', age: 25}), (:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})]   | [[:E {weight: 2, id: 2}], [:K {weight: 2, id: 7}], [:E {weight: 7, id: 5}]] | [(:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35}), (:Person {city: 'Oslo', name: 'Tony', age: 40})]  |

  Scenario: 21 - Simple quantified relationship with juxtaposed node with label expression and relationship type expression, output all variables
    When executing query:
    """
      MATCH (x:Person&A)((a)-[r:E]->(b))+
      RETURN x, a, r, b
    """
    Then the result should be, in any order:
      | x                                                  | a                                                                                                                                                          | r                                                                           | b                                                                                                                                                        |
      | (:Person:A {city: 'Oslo', name: 'Alice', age: 20}) | [(:Person:A {city: 'Oslo', name: 'Alice', age: 20})]                                                                                                       | [[:E {weight: 6, id: 1}]]                                                   | [(:Person {city: 'Paris', name: 'Chris', age: 30})]                                                                                                      |
      | (:Person:A {city: 'Oslo', name: 'Alice', age: 20}) | [(:Person:A {city: 'Oslo', name: 'Alice', age: 20}), (:Person {city: 'Paris', name: 'Chris', age: 30})]                                                    | [[:E {weight: 6, id: 1}], [:E {weight: 3, id: 3}]]                          | [(:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})]                                                   |
      | (:Person:A {city: 'Oslo', name: 'Alice', age: 20}) | [(:Person:A {city: 'Oslo', name: 'Alice', age: 20}), (:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})] | [[:E {weight: 6, id: 1}], [:E {weight: 3, id: 3}], [:E {weight: 1, id: 4}]] | [(:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35}), (:Person {city: 'London', name: 'Sue', age: 32})] |
      | (:Person:A {city: 'Oslo', name: 'Alice', age: 20}) | [(:Person:A {city: 'Oslo', name: 'Alice', age: 20}), (:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})] | [[:E {weight: 6, id: 1}], [:E {weight: 3, id: 3}], [:E {weight: 7, id: 5}]] | [(:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35}), (:Person {city: 'Oslo', name: 'Tony', age: 40})]  |

  Scenario: 23 - Quantified Path Pattern with two relationships, output all variables
    When executing query:
    """
      MATCH ((a)-[r]->(b)-[s]->(c))+
      RETURN a, r, b, s, c
    """
    Then the result should be, in any order:
      | a                                                    | r                         | b                                                   | s                         | c                                                   |
      | [(:Person {city: 'Paris', name: 'Chris', age: 30})]  | [[:K {weight: 2, id: 7}]] | [(:Person {city: 'Paris', name: 'Diana', age: 35})] | [[:E {weight: 1, id: 4}]] | [(:Person {city: 'London', name: 'Sue', age: 32})]  |
      | [(:Person {city: 'Paris', name: 'Chris', age: 30})]  | [[:K {weight: 2, id: 7}]] | [(:Person {city: 'Paris', name: 'Diana', age: 35})] | [[:E {weight: 7, id: 5}]] | [(:Person {city: 'Oslo', name: 'Tony', age: 40})]   |
      | [(:Person {city: 'Paris', name: 'Chris', age: 30})]  | [[:E {weight: 3, id: 3}]] | [(:Person {city: 'Paris', name: 'Diana', age: 35})] | [[:E {weight: 1, id: 4}]] | [(:Person {city: 'London', name: 'Sue', age: 32})]  |
      | [(:Person {city: 'Paris', name: 'Chris', age: 30})]  | [[:E {weight: 3, id: 3}]] | [(:Person {city: 'Paris', name: 'Diana', age: 35})] | [[:E {weight: 7, id: 5}]] | [(:Person {city: 'Oslo', name: 'Tony', age: 40})]   |
      | [(:Person:A {city: 'Oslo', name: 'Alice', age: 20})] | [[:K {weight: 3, id: 6}]] | [(:Person {city: 'Paris', name: 'Chris', age: 30})] | [[:K {weight: 2, id: 7}]] | [(:Person {city: 'Paris', name: 'Diana', age: 35})] |
      | [(:Person:A {city: 'Oslo', name: 'Alice', age: 20})] | [[:K {weight: 3, id: 6}]] | [(:Person {city: 'Paris', name: 'Chris', age: 30})] | [[:E {weight: 3, id: 3}]] | [(:Person {city: 'Paris', name: 'Diana', age: 35})] |
      | [(:Person:A {city: 'Oslo', name: 'Alice', age: 20})] | [[:E {weight: 6, id: 1}]] | [(:Person {city: 'Paris', name: 'Chris', age: 30})] | [[:K {weight: 2, id: 7}]] | [(:Person {city: 'Paris', name: 'Diana', age: 35})] |
      | [(:Person:A {city: 'Oslo', name: 'Alice', age: 20})] | [[:E {weight: 6, id: 1}]] | [(:Person {city: 'Paris', name: 'Chris', age: 30})] | [[:E {weight: 3, id: 3}]] | [(:Person {city: 'Paris', name: 'Diana', age: 35})] |
      | [(:Person {city: 'London', name: 'Bob', age: 25})]   | [[:E {weight: 2, id: 2}]] | [(:Person {city: 'Paris', name: 'Chris', age: 30})] | [[:K {weight: 2, id: 7}]] | [(:Person {city: 'Paris', name: 'Diana', age: 35})] |
      | [(:Person {city: 'London', name: 'Bob', age: 25})]   | [[:E {weight: 2, id: 2}]] | [(:Person {city: 'Paris', name: 'Chris', age: 30})] | [[:E {weight: 3, id: 3}]] | [(:Person {city: 'Paris', name: 'Diana', age: 35})] |

  Scenario: 24 - Quantified Path Pattern with two relationships with relationship type expressions, output all variables
    When executing query:
    """
      MATCH ((a)-[r:K]->(b)-[s:E]->(c))+
      RETURN a, r, b, s, c
    """
    Then the result should be, in any order:
      | a                                                    | r                         | b                                                   | s                         | c                                                   |
      | [(:Person {city: 'Paris', name: 'Chris', age: 30})]  | [[:K {weight: 2, id: 7}]] | [(:Person {city: 'Paris', name: 'Diana', age: 35})] | [[:E {weight: 1, id: 4}]] | [(:Person {city: 'London', name: 'Sue', age: 32})]  |
      | [(:Person {city: 'Paris', name: 'Chris', age: 30})]  | [[:K {weight: 2, id: 7}]] | [(:Person {city: 'Paris', name: 'Diana', age: 35})] | [[:E {weight: 7, id: 5}]] | [(:Person {city: 'Oslo', name: 'Tony', age: 40})]   |
      | [(:Person:A {city: 'Oslo', name: 'Alice', age: 20})] | [[:K {weight: 3, id: 6}]] | [(:Person {city: 'Paris', name: 'Chris', age: 30})] | [[:E {weight: 3, id: 3}]] | [(:Person {city: 'Paris', name: 'Diana', age: 35})] |

  Scenario: 25 - Quantified Path Pattern with two relationships with relationship type expressions, output all variables
    When executing query:
    """
      MATCH ((a)-[r:E]->(b)-[s:E]->(c))+
      RETURN a, r, b, s, c
    """
    Then the result should be, in any order:
      | a                                                    | r                         | b                                                   | s                         | c                                                   |
      | [(:Person {city: 'Paris', name: 'Chris', age: 30})]  | [[:E {weight: 3, id: 3}]] | [(:Person {city: 'Paris', name: 'Diana', age: 35})] | [[:E {weight: 1, id: 4}]] | [(:Person {city: 'London', name: 'Sue', age: 32})]  |
      | [(:Person {city: 'Paris', name: 'Chris', age: 30})]  | [[:E {weight: 3, id: 3}]] | [(:Person {city: 'Paris', name: 'Diana', age: 35})] | [[:E {weight: 7, id: 5}]] | [(:Person {city: 'Oslo', name: 'Tony', age: 40})]   |
      | [(:Person:A {city: 'Oslo', name: 'Alice', age: 20})] | [[:E {weight: 6, id: 1}]] | [(:Person {city: 'Paris', name: 'Chris', age: 30})] | [[:E {weight: 3, id: 3}]] | [(:Person {city: 'Paris', name: 'Diana', age: 35})] |
      | [(:Person {city: 'London', name: 'Bob', age: 25})]   | [[:E {weight: 2, id: 2}]] | [(:Person {city: 'Paris', name: 'Chris', age: 30})] | [[:E {weight: 3, id: 3}]] | [(:Person {city: 'Paris', name: 'Diana', age: 35})] |

  Scenario: 26 - Quantified Path Pattern with two relationships with relationship type expressions and juxtaposed relationship, output all variables
    When executing query:
    """
      MATCH (x)-[y:E]->(z)((a)-[r:E]->(b)-[s:E]->(c))+
      RETURN x, y, z, a, r, b, s, c
    """
    Then the result should be, in any order:
      | x                                                  | y                       | z                                                 | a                                                   | r                         | b                                                   | s                         | c                                                  |
      | (:Person:A {city: 'Oslo', name: 'Alice', age: 20}) | [:E {weight: 6, id: 1}] | (:Person {city: 'Paris', name: 'Chris', age: 30}) | [(:Person {city: 'Paris', name: 'Chris', age: 30})] | [[:E {weight: 3, id: 3}]] | [(:Person {city: 'Paris', name: 'Diana', age: 35})] | [[:E {weight: 1, id: 4}]] | [(:Person {city: 'London', name: 'Sue', age: 32})] |
      | (:Person {city: 'London', name: 'Bob', age: 25})   | [:E {weight: 2, id: 2}] | (:Person {city: 'Paris', name: 'Chris', age: 30}) | [(:Person {city: 'Paris', name: 'Chris', age: 30})] | [[:E {weight: 3, id: 3}]] | [(:Person {city: 'Paris', name: 'Diana', age: 35})] | [[:E {weight: 1, id: 4}]] | [(:Person {city: 'London', name: 'Sue', age: 32})] |
      | (:Person:A {city: 'Oslo', name: 'Alice', age: 20}) | [:E {weight: 6, id: 1}] | (:Person {city: 'Paris', name: 'Chris', age: 30}) | [(:Person {city: 'Paris', name: 'Chris', age: 30})] | [[:E {weight: 3, id: 3}]] | [(:Person {city: 'Paris', name: 'Diana', age: 35})] | [[:E {weight: 7, id: 5}]] | [(:Person {city: 'Oslo', name: 'Tony', age: 40})]  |
      | (:Person {city: 'London', name: 'Bob', age: 25})   | [:E {weight: 2, id: 2}] | (:Person {city: 'Paris', name: 'Chris', age: 30}) | [(:Person {city: 'Paris', name: 'Chris', age: 30})] | [[:E {weight: 3, id: 3}]] | [(:Person {city: 'Paris', name: 'Diana', age: 35})] | [[:E {weight: 7, id: 5}]] | [(:Person {city: 'Oslo', name: 'Tony', age: 40})]  |

  Scenario: 27 - Quantified Path Pattern with two relationships with relationship type expressions and juxtaposed relationship with relationship type, output all variables
    When executing query:
    """
      MATCH (x)-[y:E]->(z)((a)-[r:K]->(b)-[s:E]->(c))+
      RETURN x, y, z, a, r, b, s, c
    """
    Then the result should be, in any order:
      | x                                                  | y                       | z                                                 | a                                                   | r                         | b                                                   | s                         | c                                                  |
      | (:Person:A {city: 'Oslo', name: 'Alice', age: 20}) | [:E {weight: 6, id: 1}] | (:Person {city: 'Paris', name: 'Chris', age: 30}) | [(:Person {city: 'Paris', name: 'Chris', age: 30})] | [[:K {weight: 2, id: 7}]] | [(:Person {city: 'Paris', name: 'Diana', age: 35})] | [[:E {weight: 1, id: 4}]] | [(:Person {city: 'London', name: 'Sue', age: 32})] |
      | (:Person {city: 'London', name: 'Bob', age: 25})   | [:E {weight: 2, id: 2}] | (:Person {city: 'Paris', name: 'Chris', age: 30}) | [(:Person {city: 'Paris', name: 'Chris', age: 30})] | [[:K {weight: 2, id: 7}]] | [(:Person {city: 'Paris', name: 'Diana', age: 35})] | [[:E {weight: 1, id: 4}]] | [(:Person {city: 'London', name: 'Sue', age: 32})] |
      | (:Person:A {city: 'Oslo', name: 'Alice', age: 20}) | [:E {weight: 6, id: 1}] | (:Person {city: 'Paris', name: 'Chris', age: 30}) | [(:Person {city: 'Paris', name: 'Chris', age: 30})] | [[:K {weight: 2, id: 7}]] | [(:Person {city: 'Paris', name: 'Diana', age: 35})] | [[:E {weight: 7, id: 5}]] | [(:Person {city: 'Oslo', name: 'Tony', age: 40})]  |
      | (:Person {city: 'London', name: 'Bob', age: 25})   | [:E {weight: 2, id: 2}] | (:Person {city: 'Paris', name: 'Chris', age: 30}) | [(:Person {city: 'Paris', name: 'Chris', age: 30})] | [[:K {weight: 2, id: 7}]] | [(:Person {city: 'Paris', name: 'Diana', age: 35})] | [[:E {weight: 7, id: 5}]] | [(:Person {city: 'Oslo', name: 'Tony', age: 40})]  |

  Scenario: 28 - Simple quantified relationship joined on middle node of two relationships long path, output all variables
    When executing query:
    """
      MATCH (x)-->(y)-->(z), (y)((a)-[r:E]->(b))+
      RETURN x, y, z, a, r, b
    """
    Then the result should be, in any order:
      | x                                                  | y                                                 | z                                                 | a                                                                                                      | r                                                  | b                                                                                                     |
      | (:Person {city: 'Paris', name: 'Chris', age: 30})  | (:Person {city: 'Paris', name: 'Diana', age: 35}) | (:Person {city: 'Oslo', name: 'Tony', age: 40})   | [(:Person {city: 'Paris', name: 'Diana', age: 35})]                                                    | [[:E {weight: 1, id: 4}]]                          | [(:Person {city: 'London', name: 'Sue', age: 32})]                                                    |
      | (:Person {city: 'Paris', name: 'Chris', age: 30})  | (:Person {city: 'Paris', name: 'Diana', age: 35}) | (:Person {city: 'Oslo', name: 'Tony', age: 40})   | [(:Person {city: 'Paris', name: 'Diana', age: 35})]                                                    | [[:E {weight: 1, id: 4}]]                          | [(:Person {city: 'London', name: 'Sue', age: 32})]                                                    |
      | (:Person {city: 'Paris', name: 'Chris', age: 30})  | (:Person {city: 'Paris', name: 'Diana', age: 35}) | (:Person {city: 'London', name: 'Sue', age: 32})  | [(:Person {city: 'Paris', name: 'Diana', age: 35})]                                                    | [[:E {weight: 7, id: 5}]]                          | [(:Person {city: 'Oslo', name: 'Tony', age: 40})]                                                     |
      | (:Person {city: 'Paris', name: 'Chris', age: 30})  | (:Person {city: 'Paris', name: 'Diana', age: 35}) | (:Person {city: 'London', name: 'Sue', age: 32})  | [(:Person {city: 'Paris', name: 'Diana', age: 35})]                                                    | [[:E {weight: 7, id: 5}]]                          | [(:Person {city: 'Oslo', name: 'Tony', age: 40})]                                                     |
      | (:Person:A {city: 'Oslo', name: 'Alice', age: 20}) | (:Person {city: 'Paris', name: 'Chris', age: 30}) | (:Person {city: 'Paris', name: 'Diana', age: 35}) | [(:Person {city: 'Paris', name: 'Chris', age: 30})]                                                    | [[:E {weight: 3, id: 3}]]                          | [(:Person {city: 'Paris', name: 'Diana', age: 35})]                                                   |
      | (:Person:A {city: 'Oslo', name: 'Alice', age: 20}) | (:Person {city: 'Paris', name: 'Chris', age: 30}) | (:Person {city: 'Paris', name: 'Diana', age: 35}) | [(:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})] | [[:E {weight: 3, id: 3}], [:E {weight: 1, id: 4}]] | [(:Person {city: 'Paris', name: 'Diana', age: 35}), (:Person {city: 'London', name: 'Sue', age: 32})] |
      | (:Person:A {city: 'Oslo', name: 'Alice', age: 20}) | (:Person {city: 'Paris', name: 'Chris', age: 30}) | (:Person {city: 'Paris', name: 'Diana', age: 35}) | [(:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})] | [[:E {weight: 3, id: 3}], [:E {weight: 7, id: 5}]] | [(:Person {city: 'Paris', name: 'Diana', age: 35}), (:Person {city: 'Oslo', name: 'Tony', age: 40})]  |
      | (:Person {city: 'London', name: 'Bob', age: 25})   | (:Person {city: 'Paris', name: 'Chris', age: 30}) | (:Person {city: 'Paris', name: 'Diana', age: 35}) | [(:Person {city: 'Paris', name: 'Chris', age: 30})]                                                    | [[:E {weight: 3, id: 3}]]                          | [(:Person {city: 'Paris', name: 'Diana', age: 35})]                                                   |
      | (:Person {city: 'London', name: 'Bob', age: 25})   | (:Person {city: 'Paris', name: 'Chris', age: 30}) | (:Person {city: 'Paris', name: 'Diana', age: 35}) | [(:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})] | [[:E {weight: 3, id: 3}], [:E {weight: 1, id: 4}]] | [(:Person {city: 'Paris', name: 'Diana', age: 35}), (:Person {city: 'London', name: 'Sue', age: 32})] |
      | (:Person {city: 'London', name: 'Bob', age: 25})   | (:Person {city: 'Paris', name: 'Chris', age: 30}) | (:Person {city: 'Paris', name: 'Diana', age: 35}) | [(:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})] | [[:E {weight: 3, id: 3}], [:E {weight: 7, id: 5}]] | [(:Person {city: 'Paris', name: 'Diana', age: 35}), (:Person {city: 'Oslo', name: 'Tony', age: 40})]  |
      | (:Person:A {city: 'Oslo', name: 'Alice', age: 20}) | (:Person {city: 'Paris', name: 'Chris', age: 30}) | (:Person {city: 'Paris', name: 'Diana', age: 35}) | [(:Person {city: 'Paris', name: 'Chris', age: 30})]                                                    | [[:E {weight: 3, id: 3}]]                          | [(:Person {city: 'Paris', name: 'Diana', age: 35})]                                                   |
      | (:Person:A {city: 'Oslo', name: 'Alice', age: 20}) | (:Person {city: 'Paris', name: 'Chris', age: 30}) | (:Person {city: 'Paris', name: 'Diana', age: 35}) | [(:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})] | [[:E {weight: 3, id: 3}], [:E {weight: 1, id: 4}]] | [(:Person {city: 'Paris', name: 'Diana', age: 35}), (:Person {city: 'London', name: 'Sue', age: 32})] |
      | (:Person:A {city: 'Oslo', name: 'Alice', age: 20}) | (:Person {city: 'Paris', name: 'Chris', age: 30}) | (:Person {city: 'Paris', name: 'Diana', age: 35}) | [(:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})] | [[:E {weight: 3, id: 3}], [:E {weight: 7, id: 5}]] | [(:Person {city: 'Paris', name: 'Diana', age: 35}), (:Person {city: 'Oslo', name: 'Tony', age: 40})]  |

  Scenario: 29 - Simple quantified relationship with equality predicate on outer nodes, output all variables
    When executing query:
    """
      MATCH (p) ((a)-[r]->(b))+ (q WHERE p.city = q.city)
      RETURN p, a, r, b, q
    """
    Then the result should be, in any order:
      | p                                                  | a                                                                                                                                                          | r                                                                           | b                                                                                                                                                        | q                                                 |
      | (:Person {city: 'Paris', name: 'Chris', age: 30})  | [(:Person {city: 'Paris', name: 'Chris', age: 30})]                                                                                                        | [[:K {weight: 2, id: 7}]]                                                   | [(:Person {city: 'Paris', name: 'Diana', age: 35})]                                                                                                      | (:Person {city: 'Paris', name: 'Diana', age: 35}) |
      | (:Person {city: 'Paris', name: 'Chris', age: 30})  | [(:Person {city: 'Paris', name: 'Chris', age: 30})]                                                                                                        | [[:E {weight: 3, id: 3}]]                                                   | [(:Person {city: 'Paris', name: 'Diana', age: 35})]                                                                                                      | (:Person {city: 'Paris', name: 'Diana', age: 35}) |
      | (:Person:A {city: 'Oslo', name: 'Alice', age: 20}) | [(:Person:A {city: 'Oslo', name: 'Alice', age: 20}), (:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})] | [[:E {weight: 6, id: 1}], [:E {weight: 3, id: 3}], [:E {weight: 7, id: 5}]] | [(:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35}), (:Person {city: 'Oslo', name: 'Tony', age: 40})]  | (:Person {city: 'Oslo', name: 'Tony', age: 40})   |
      | (:Person:A {city: 'Oslo', name: 'Alice', age: 20}) | [(:Person:A {city: 'Oslo', name: 'Alice', age: 20}), (:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})] | [[:E {weight: 6, id: 1}], [:K {weight: 2, id: 7}], [:E {weight: 7, id: 5}]] | [(:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35}), (:Person {city: 'Oslo', name: 'Tony', age: 40})]  | (:Person {city: 'Oslo', name: 'Tony', age: 40})   |
      | (:Person:A {city: 'Oslo', name: 'Alice', age: 20}) | [(:Person:A {city: 'Oslo', name: 'Alice', age: 20}), (:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})] | [[:K {weight: 3, id: 6}], [:E {weight: 3, id: 3}], [:E {weight: 7, id: 5}]] | [(:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35}), (:Person {city: 'Oslo', name: 'Tony', age: 40})]  | (:Person {city: 'Oslo', name: 'Tony', age: 40})   |
      | (:Person:A {city: 'Oslo', name: 'Alice', age: 20}) | [(:Person:A {city: 'Oslo', name: 'Alice', age: 20}), (:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})] | [[:K {weight: 3, id: 6}], [:K {weight: 2, id: 7}], [:E {weight: 7, id: 5}]] | [(:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35}), (:Person {city: 'Oslo', name: 'Tony', age: 40})]  | (:Person {city: 'Oslo', name: 'Tony', age: 40})   |
      | (:Person {city: 'London', name: 'Bob', age: 25})   | [(:Person {city: 'London', name: 'Bob', age: 25}), (:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})]   | [[:E {weight: 2, id: 2}], [:E {weight: 3, id: 3}], [:E {weight: 1, id: 4}]] | [(:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35}), (:Person {city: 'London', name: 'Sue', age: 32})] | (:Person {city: 'London', name: 'Sue', age: 32})  |
      | (:Person {city: 'London', name: 'Bob', age: 25})   | [(:Person {city: 'London', name: 'Bob', age: 25}), (:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})]   | [[:E {weight: 2, id: 2}], [:K {weight: 2, id: 7}], [:E {weight: 1, id: 4}]] | [(:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35}), (:Person {city: 'London', name: 'Sue', age: 32})] | (:Person {city: 'London', name: 'Sue', age: 32})  |

  Scenario: 30 - Simple quantified relationship with comparison predicate on target node, output all variables
    When executing query:
    """
      MATCH ((a:Person)-[r]->(b WHERE a.age < b.age))+
      RETURN a, r, b
    """
    Then the result should be, in any order:
      | a                                                                                                                                                          | r                                                                           | b                                                                                                                                                       |
      | [(:Person {city: 'Paris', name: 'Chris', age: 30})]                                                                                                        | [[:K {weight: 2, id: 7}]]                                                   | [(:Person {city: 'Paris', name: 'Diana', age: 35})]                                                                                                     |
      | [(:Person {city: 'Paris', name: 'Chris', age: 30})]                                                                                                        | [[:E {weight: 3, id: 3}]]                                                   | [(:Person {city: 'Paris', name: 'Diana', age: 35})]                                                                                                     |
      | [(:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})]                                                     | [[:E {weight: 3, id: 3}], [:E {weight: 7, id: 5}]]                          | [(:Person {city: 'Paris', name: 'Diana', age: 35}), (:Person {city: 'Oslo', name: 'Tony', age: 40})]                                                    |
      | [(:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})]                                                     | [[:K {weight: 2, id: 7}], [:E {weight: 7, id: 5}]]                          | [(:Person {city: 'Paris', name: 'Diana', age: 35}), (:Person {city: 'Oslo', name: 'Tony', age: 40})]                                                    |
      | [(:Person {city: 'Paris', name: 'Diana', age: 35})]                                                                                                        | [[:E {weight: 7, id: 5}]]                                                   | [(:Person {city: 'Oslo', name: 'Tony', age: 40})]                                                                                                       |
      | [(:Person:A {city: 'Oslo', name: 'Alice', age: 20})]                                                                                                       | [[:K {weight: 3, id: 6}]]                                                   | [(:Person {city: 'Paris', name: 'Chris', age: 30})]                                                                                                     |
      | [(:Person:A {city: 'Oslo', name: 'Alice', age: 20})]                                                                                                       | [[:E {weight: 6, id: 1}]]                                                   | [(:Person {city: 'Paris', name: 'Chris', age: 30})]                                                                                                     |
      | [(:Person:A {city: 'Oslo', name: 'Alice', age: 20}), (:Person {city: 'Paris', name: 'Chris', age: 30})]                                                    | [[:E {weight: 6, id: 1}], [:K {weight: 2, id: 7}]]                          | [(:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})]                                                  |
      | [(:Person:A {city: 'Oslo', name: 'Alice', age: 20}), (:Person {city: 'Paris', name: 'Chris', age: 30})]                                                    | [[:E {weight: 6, id: 1}], [:E {weight: 3, id: 3}]]                          | [(:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})]                                                  |
      | [(:Person:A {city: 'Oslo', name: 'Alice', age: 20}), (:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})] | [[:E {weight: 6, id: 1}], [:E {weight: 3, id: 3}], [:E {weight: 7, id: 5}]] | [(:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35}), (:Person {city: 'Oslo', name: 'Tony', age: 40})] |
      | [(:Person:A {city: 'Oslo', name: 'Alice', age: 20}), (:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})] | [[:E {weight: 6, id: 1}], [:K {weight: 2, id: 7}], [:E {weight: 7, id: 5}]] | [(:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35}), (:Person {city: 'Oslo', name: 'Tony', age: 40})] |
      | [(:Person:A {city: 'Oslo', name: 'Alice', age: 20}), (:Person {city: 'Paris', name: 'Chris', age: 30})]                                                    | [[:K {weight: 3, id: 6}], [:K {weight: 2, id: 7}]]                          | [(:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})]                                                  |
      | [(:Person:A {city: 'Oslo', name: 'Alice', age: 20}), (:Person {city: 'Paris', name: 'Chris', age: 30})]                                                    | [[:K {weight: 3, id: 6}], [:E {weight: 3, id: 3}]]                          | [(:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})]                                                  |
      | [(:Person:A {city: 'Oslo', name: 'Alice', age: 20}), (:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})] | [[:K {weight: 3, id: 6}], [:E {weight: 3, id: 3}], [:E {weight: 7, id: 5}]] | [(:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35}), (:Person {city: 'Oslo', name: 'Tony', age: 40})] |
      | [(:Person:A {city: 'Oslo', name: 'Alice', age: 20}), (:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})] | [[:K {weight: 3, id: 6}], [:K {weight: 2, id: 7}], [:E {weight: 7, id: 5}]] | [(:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35}), (:Person {city: 'Oslo', name: 'Tony', age: 40})] |
      | [(:Person {city: 'London', name: 'Bob', age: 25})]                                                                                                         | [[:E {weight: 2, id: 2}]]                                                   | [(:Person {city: 'Paris', name: 'Chris', age: 30})]                                                                                                     |
      | [(:Person {city: 'London', name: 'Bob', age: 25}), (:Person {city: 'Paris', name: 'Chris', age: 30})]                                                      | [[:E {weight: 2, id: 2}], [:K {weight: 2, id: 7}]]                          | [(:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})]                                                  |
      | [(:Person {city: 'London', name: 'Bob', age: 25}), (:Person {city: 'Paris', name: 'Chris', age: 30})]                                                      | [[:E {weight: 2, id: 2}], [:E {weight: 3, id: 3}]]                          | [(:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})]                                                  |
      | [(:Person {city: 'London', name: 'Bob', age: 25}), (:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})]   | [[:E {weight: 2, id: 2}], [:E {weight: 3, id: 3}], [:E {weight: 7, id: 5}]] | [(:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35}), (:Person {city: 'Oslo', name: 'Tony', age: 40})] |
      | [(:Person {city: 'London', name: 'Bob', age: 25}), (:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})]   | [[:E {weight: 2, id: 2}], [:K {weight: 2, id: 7}], [:E {weight: 7, id: 5}]] | [(:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35}), (:Person {city: 'Oslo', name: 'Tony', age: 40})] |

  Scenario: 31 - Simple quantified relationship with comparison predicate on relationship, output all variables
    When executing query:
    """
      MATCH ((a:Person)-[r WHERE r.weight < 5]->(b))+
      RETURN a, r, b
    """
    Then the result should be, in any order:
      | a                                                                                                                                                          | r                                                                           | b                                                                                                                                                        |
      | [(:Person {city: 'Paris', name: 'Chris', age: 30})]                                                                                                        | [[:K {weight: 2, id: 7}]]                                                   | [(:Person {city: 'Paris', name: 'Diana', age: 35})]                                                                                                      |
      | [(:Person {city: 'Paris', name: 'Chris', age: 30})]                                                                                                        | [[:E {weight: 3, id: 3}]]                                                   | [(:Person {city: 'Paris', name: 'Diana', age: 35})]                                                                                                      |
      | [(:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})]                                                     | [[:E {weight: 3, id: 3}], [:E {weight: 1, id: 4}]]                          | [(:Person {city: 'Paris', name: 'Diana', age: 35}), (:Person {city: 'London', name: 'Sue', age: 32})]                                                    |
      | [(:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})]                                                     | [[:K {weight: 2, id: 7}], [:E {weight: 1, id: 4}]]                          | [(:Person {city: 'Paris', name: 'Diana', age: 35}), (:Person {city: 'London', name: 'Sue', age: 32})]                                                    |
      | [(:Person {city: 'Paris', name: 'Diana', age: 35})]                                                                                                        | [[:E {weight: 1, id: 4}]]                                                   | [(:Person {city: 'London', name: 'Sue', age: 32})]                                                                                                       |
      | [(:Person:A {city: 'Oslo', name: 'Alice', age: 20})]                                                                                                       | [[:K {weight: 3, id: 6}]]                                                   | [(:Person {city: 'Paris', name: 'Chris', age: 30})]                                                                                                      |
      | [(:Person:A {city: 'Oslo', name: 'Alice', age: 20}), (:Person {city: 'Paris', name: 'Chris', age: 30})]                                                    | [[:K {weight: 3, id: 6}], [:K {weight: 2, id: 7}]]                          | [(:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})]                                                   |
      | [(:Person:A {city: 'Oslo', name: 'Alice', age: 20}), (:Person {city: 'Paris', name: 'Chris', age: 30})]                                                    | [[:K {weight: 3, id: 6}], [:E {weight: 3, id: 3}]]                          | [(:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})]                                                   |
      | [(:Person:A {city: 'Oslo', name: 'Alice', age: 20}), (:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})] | [[:K {weight: 3, id: 6}], [:E {weight: 3, id: 3}], [:E {weight: 1, id: 4}]] | [(:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35}), (:Person {city: 'London', name: 'Sue', age: 32})] |
      | [(:Person:A {city: 'Oslo', name: 'Alice', age: 20}), (:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})] | [[:K {weight: 3, id: 6}], [:K {weight: 2, id: 7}], [:E {weight: 1, id: 4}]] | [(:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35}), (:Person {city: 'London', name: 'Sue', age: 32})] |
      | [(:Person {city: 'London', name: 'Bob', age: 25})]                                                                                                         | [[:E {weight: 2, id: 2}]]                                                   | [(:Person {city: 'Paris', name: 'Chris', age: 30})]                                                                                                      |
      | [(:Person {city: 'London', name: 'Bob', age: 25}), (:Person {city: 'Paris', name: 'Chris', age: 30})]                                                      | [[:E {weight: 2, id: 2}], [:K {weight: 2, id: 7}]]                          | [(:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})]                                                   |
      | [(:Person {city: 'London', name: 'Bob', age: 25}), (:Person {city: 'Paris', name: 'Chris', age: 30})]                                                      | [[:E {weight: 2, id: 2}], [:E {weight: 3, id: 3}]]                          | [(:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})]                                                   |
      | [(:Person {city: 'London', name: 'Bob', age: 25}), (:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})]   | [[:E {weight: 2, id: 2}], [:E {weight: 3, id: 3}], [:E {weight: 1, id: 4}]] | [(:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35}), (:Person {city: 'London', name: 'Sue', age: 32})] |
      | [(:Person {city: 'London', name: 'Bob', age: 25}), (:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})]   | [[:E {weight: 2, id: 2}], [:K {weight: 2, id: 7}], [:E {weight: 1, id: 4}]] | [(:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35}), (:Person {city: 'London', name: 'Sue', age: 32})] |

  Scenario: 32 - Simple quantified relationship with comparison predicate on relationship and target node, output all variables
    When executing query:
    """
      MATCH ((a:Person)-[r WHERE r.weight < 5]->(b WHERE b.city = "Oslo"))+
      RETURN a, r, b
    """
    Then the result should be, in any order:
      | a | r | b |

  Scenario: 33 - Simple quantified relationship with predicate on quantified path pattern, output all variables
    When executing query:
    """
      MATCH ((a:Person)-[r]->(b) WHERE NOT a.city = "Oslo")+
      RETURN a, r, b
    """
    Then the result should be, in any order:
      | a                                                                                                                                                        | r                                                                           | b                                                                                                                                                        |
      | [(:Person {city: 'Paris', name: 'Chris', age: 30})]                                                                                                      | [[:K {weight: 2, id: 7}]]                                                   | [(:Person {city: 'Paris', name: 'Diana', age: 35})]                                                                                                      |
      | [(:Person {city: 'Paris', name: 'Chris', age: 30})]                                                                                                      | [[:E {weight: 3, id: 3}]]                                                   | [(:Person {city: 'Paris', name: 'Diana', age: 35})]                                                                                                      |
      | [(:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})]                                                   | [[:E {weight: 3, id: 3}], [:E {weight: 1, id: 4}]]                          | [(:Person {city: 'Paris', name: 'Diana', age: 35}), (:Person {city: 'London', name: 'Sue', age: 32})]                                                    |
      | [(:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})]                                                   | [[:E {weight: 3, id: 3}], [:E {weight: 7, id: 5}]]                          | [(:Person {city: 'Paris', name: 'Diana', age: 35}), (:Person {city: 'Oslo', name: 'Tony', age: 40})]                                                     |
      | [(:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})]                                                   | [[:K {weight: 2, id: 7}], [:E {weight: 1, id: 4}]]                          | [(:Person {city: 'Paris', name: 'Diana', age: 35}), (:Person {city: 'London', name: 'Sue', age: 32})]                                                    |
      | [(:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})]                                                   | [[:K {weight: 2, id: 7}], [:E {weight: 7, id: 5}]]                          | [(:Person {city: 'Paris', name: 'Diana', age: 35}), (:Person {city: 'Oslo', name: 'Tony', age: 40})]                                                     |
      | [(:Person {city: 'Paris', name: 'Diana', age: 35})]                                                                                                      | [[:E {weight: 1, id: 4}]]                                                   | [(:Person {city: 'London', name: 'Sue', age: 32})]                                                                                                       |
      | [(:Person {city: 'Paris', name: 'Diana', age: 35})]                                                                                                      | [[:E {weight: 7, id: 5}]]                                                   | [(:Person {city: 'Oslo', name: 'Tony', age: 40})]                                                                                                        |
      | [(:Person {city: 'London', name: 'Bob', age: 25})]                                                                                                       | [[:E {weight: 2, id: 2}]]                                                   | [(:Person {city: 'Paris', name: 'Chris', age: 30})]                                                                                                      |
      | [(:Person {city: 'London', name: 'Bob', age: 25}), (:Person {city: 'Paris', name: 'Chris', age: 30})]                                                    | [[:E {weight: 2, id: 2}], [:K {weight: 2, id: 7}]]                          | [(:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})]                                                   |
      | [(:Person {city: 'London', name: 'Bob', age: 25}), (:Person {city: 'Paris', name: 'Chris', age: 30})]                                                    | [[:E {weight: 2, id: 2}], [:E {weight: 3, id: 3}]]                          | [(:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})]                                                   |
      | [(:Person {city: 'London', name: 'Bob', age: 25}), (:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})] | [[:E {weight: 2, id: 2}], [:E {weight: 3, id: 3}], [:E {weight: 1, id: 4}]] | [(:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35}), (:Person {city: 'London', name: 'Sue', age: 32})] |
      | [(:Person {city: 'London', name: 'Bob', age: 25}), (:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})] | [[:E {weight: 2, id: 2}], [:E {weight: 3, id: 3}], [:E {weight: 7, id: 5}]] | [(:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35}), (:Person {city: 'Oslo', name: 'Tony', age: 40})]  |
      | [(:Person {city: 'London', name: 'Bob', age: 25}), (:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})] | [[:E {weight: 2, id: 2}], [:K {weight: 2, id: 7}], [:E {weight: 1, id: 4}]] | [(:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35}), (:Person {city: 'London', name: 'Sue', age: 32})] |
      | [(:Person {city: 'London', name: 'Bob', age: 25}), (:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})] | [[:E {weight: 2, id: 2}], [:K {weight: 2, id: 7}], [:E {weight: 7, id: 5}]] | [(:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35}), (:Person {city: 'Oslo', name: 'Tony', age: 40})]  |

  Scenario: 34 - Simple quantified relationship with predicate on both start and target nodes, output all variables
    When executing query:
    """
      MATCH ((a:Person)-[r]->(b) WHERE NOT a.city = "Oslo" AND NOT b.city = "Oslo")+
      RETURN a, r, b
    """
    Then the result should be, in any order:
      | a                                                                                                                                                        | r                                                                           | b                                                                                                                                                        |
      | [(:Person {city: 'Paris', name: 'Chris', age: 30})]                                                                                                      | [[:K {weight: 2, id: 7}]]                                                   | [(:Person {city: 'Paris', name: 'Diana', age: 35})]                                                                                                      |
      | [(:Person {city: 'Paris', name: 'Chris', age: 30})]                                                                                                      | [[:E {weight: 3, id: 3}]]                                                   | [(:Person {city: 'Paris', name: 'Diana', age: 35})]                                                                                                      |
      | [(:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})]                                                   | [[:E {weight: 3, id: 3}], [:E {weight: 1, id: 4}]]                          | [(:Person {city: 'Paris', name: 'Diana', age: 35}), (:Person {city: 'London', name: 'Sue', age: 32})]                                                    |
      | [(:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})]                                                   | [[:K {weight: 2, id: 7}], [:E {weight: 1, id: 4}]]                          | [(:Person {city: 'Paris', name: 'Diana', age: 35}), (:Person {city: 'London', name: 'Sue', age: 32})]                                                    |
      | [(:Person {city: 'Paris', name: 'Diana', age: 35})]                                                                                                      | [[:E {weight: 1, id: 4}]]                                                   | [(:Person {city: 'London', name: 'Sue', age: 32})]                                                                                                       |
      | [(:Person {city: 'London', name: 'Bob', age: 25})]                                                                                                       | [[:E {weight: 2, id: 2}]]                                                   | [(:Person {city: 'Paris', name: 'Chris', age: 30})]                                                                                                      |
      | [(:Person {city: 'London', name: 'Bob', age: 25}), (:Person {city: 'Paris', name: 'Chris', age: 30})]                                                    | [[:E {weight: 2, id: 2}], [:K {weight: 2, id: 7}]]                          | [(:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})]                                                   |
      | [(:Person {city: 'London', name: 'Bob', age: 25}), (:Person {city: 'Paris', name: 'Chris', age: 30})]                                                    | [[:E {weight: 2, id: 2}], [:E {weight: 3, id: 3}]]                          | [(:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})]                                                   |
      | [(:Person {city: 'London', name: 'Bob', age: 25}), (:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})] | [[:E {weight: 2, id: 2}], [:E {weight: 3, id: 3}], [:E {weight: 1, id: 4}]] | [(:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35}), (:Person {city: 'London', name: 'Sue', age: 32})] |
      | [(:Person {city: 'London', name: 'Bob', age: 25}), (:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35})] | [[:E {weight: 2, id: 2}], [:K {weight: 2, id: 7}], [:E {weight: 1, id: 4}]] | [(:Person {city: 'Paris', name: 'Chris', age: 30}), (:Person {city: 'Paris', name: 'Diana', age: 35}), (:Person {city: 'London', name: 'Sue', age: 32})] |

  Scenario: 35 - Simple quantified relationship with predicate on relationship as well as combined predicate on path pattern, output all variables
    When executing query:
    """
      MATCH ((a:Person)-[r WHERE r.weight > 5]->(b) WHERE a.age + b.age > 50)+
      RETURN a, r, b
    """
    Then the result should be, in any order:
      | a                                                   | r                         | b                                                 |
      | [(:Person {city: 'Paris', name: 'Diana', age: 35})] | [[:E {weight: 7, id: 5}]] | [(:Person {city: 'Oslo', name: 'Tony', age: 40})] |
