/*
 * Copyright (c) "Neo4j"
 * Neo4j Sweden AB [https://neo4j.com]
 *
 * This file is part of Neo4j.
 *
 * Neo4j is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
package org.neo4j.logging.event;

import static org.mockito.Mockito.mock;
import static org.mockito.Mockito.verify;
import static org.mockito.Mockito.verifyNoMoreInteractions;

import java.util.LinkedList;
import java.util.List;
import org.junit.jupiter.api.Test;
import org.neo4j.logging.Log;

class CappedDebugEventPublisherTest {

    private final Log log = mock(Log.class);

    @Test
    void shouldRespectMiscFilter() {
        var filterResult = new LinkedList<>(List.of(true, false, true));
        var publisher = CappedDebugEventPublisher.capped(new LoggingDebugEventPublisher(log), filterResult::poll);

        publisher.publish(Type.Info, "first");
        publisher.publish(Type.Warn, "second");
        publisher.publish(Type.Error, "third");

        verify(log).info("%s %s", "first", Parameters.EMPTY);
        verify(log).error("%s %s", "third", Parameters.EMPTY);
        verifyNoMoreInteractions(log);
    }
}
