/*
 * Copyright (c) "Neo4j"
 * Neo4j Sweden AB [https://neo4j.com]
 *
 * This file is part of Neo4j.
 *
 * Neo4j is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
package org.neo4j.harness;

import org.neo4j.annotations.service.ServiceProvider;
import org.neo4j.kernel.api.procedure.GlobalProcedures;
import org.neo4j.kernel.extension.ExtensionFactory;
import org.neo4j.kernel.extension.context.ExtensionContext;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;

// This ensures a non-public mechanism for adding new context components
// to Procedures is testable via Harness. While this is not public API,
// this is a vital mechanism to cover use cases Procedures need to cover,
// and is in place as an approach that should either eventually be made
// public, or the relevant use cases addressed in other ways.
@ServiceProvider
public class MyExtensionThatAddsInjectable extends ExtensionFactory<MyExtensionThatAddsInjectable.Dependencies> {
    static final String NAME = "my-ext";

    public MyExtensionThatAddsInjectable() {
        super(NAME);
    }

    @Override
    public Lifecycle newInstance(ExtensionContext context, Dependencies dependencies) {
        dependencies.procedures().registerComponent(SomeService.class, ctx -> new SomeService(), true);
        return new LifecycleAdapter();
    }

    public interface Dependencies {
        GlobalProcedures procedures();
    }
}
