/*
 * Copyright (c) "Neo4j"
 * Neo4j Sweden AB [https://neo4j.com]
 *
 * This file is part of Neo4j.
 *
 * Neo4j is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
package org.neo4j.internal.schema.constraints;

import org.neo4j.internal.schema.ConstraintDescriptor;
import org.neo4j.internal.schema.EndpointType;

public interface RelationshipEndpointLabelConstraintDescriptor extends ConstraintDescriptor {
    EndpointType endpointType();

    @Override
    RelationshipEndpointLabelConstraintDescriptor withName(String name);

    @Override
    RelationshipEndpointLabelConstraintDescriptor withId(long id);

    /**
     * @return the id of the required label in the endpoint, enforced by this constraint
     */
    int endpointLabelId();
}
