# Awesome Stock Resources [![Awesome](https://cdn.rawgit.com/sindresorhus/awesome/d7305f38d29fed78fa85652e3a63e154dd8e8829/media/badge.svg)](https://github.com/sindresorhus/awesome) [![Github Workflow](https://img.shields.io/github/actions/workflow/status/neutraltone/awesome-stock-resources/main.yml)](https://github.com/neutraltone/awesome-stock-resources/actions) [![Support Me via Paypal](https://img.shields.io/badge/Donate-PayPal-blue.svg)](https://www.paypal.me/tonyphipps) [![Buy Me a Coffee](https://img.shields.io/badge/Donate-Buy_Me_a_Coffee-orange.svg)](https://buymeacoffee.com/neutraltone)

![Introductory images](/img/splash.jpg)

> A curated list of awesome stock photography, video and illustration websites.

I try my best to maintain this repository and keep it up-to-date but if you spot a broken link or a resource which isn't listed, please, feel free to make a pull request.

## Table of Contents

* [Photography](#photography)
  * [CC0-license](#cc0-license)
  * [Custom License / Usage](#custom-license--usage)
  * [Public Domain](#public-domain)
  * [Attribution required licenses](#attribution-required-licenses)
  * [Unspecified License](#unspecified-license)
* [Illustration](#illustration)
* [Vector Graphics](#vector-graphics)
* [Videos](#videos)
* [Patterns](#patterns)
* [Textures](#textures)
* [Fonts](#fonts)
* [Icons](#icons)
  * [Icon Fonts](#icon-fonts)
  * [Icons Packages and Collections](#icons-packages-and-collections)
* [Colors](#colors)
* [Aggregated Content](#aggregated-content)
* [HTML Templates](#html-templates)
* [Sounds & Music](#sounds--music)
* [Paid Resources](#paid-resources)
* [How to Contribute](#how-to-contribute)
* [How to Share](#how-to-share)
* [Donate](#donate-heart)
* [License](#license)

## Photography

### CC0-license

All the resources below have specifically specified that their content is [:copyright: CC0-licensed](https://creativecommons.org/publicdomain/zero/1.0/).

* [Altphotos](https://altphotos.com) - Handpicked free high-resolution photos added daily.
* [Barn Images](https://barnimages.com/) - Barn Images offers you a collection of free high-resolution non-stock photography.
* [CC0.Photo](https://cc0.photo/) - CC0.photo is a project initiated by Raffael Herrmann, which serves you with free photos.
* [Crow the Stone](https://crowthestone.tumblr.com/) - Free photos to use any way you want.
* [Cupcake](https://cupcake.nilssonlee.se/) - Free do what ever you want photos by [Jonas Nilsson Lee](https://twitter.com/nilsson_jonas).
* [FindA.Photo](https://finda.photo/) - search through thousands of CC0 photos by keyword and color.
* [Free Nature Stock](https://freenaturestock.com/) - Royalty-free, use them however you want, Nature Stock Photos.
* [Freely Photos](https://freelyphotos.com/) - Totally free high quality Christian stock photography.
* [Gratisography](https://gratisography.com/) - Free high-resolution pictures you can use on your personal and commercial projects. New pictures added weekly.
* [Jay Mantri](https://jaymantri.com/) - Free pics. Do anything. Make magic.
* [Jéshoots](https://jeshoots.com/) - Photos for business or personal use in high resolution for free.
* [LibreShot](https://libreshot.com/) - A collection of hundreds of high quality free stock images for personal or commercial use.
* [Life of Pix](https://www.lifeofpix.com/) - Free high-resolution photos, no copyright restrictions. Photographs added weekly.
* [Little Visuals](https://littlevisuals.co/) - Hi-res images zipped up in your inbox. Use them anyway you want.
* [Magdeleine](https://magdeleine.co/) - A selection of free photos curated by [Magdeleine](https://twitter.com/MagdeleinePhoto).
* [Moveast](https://moveast.me/) - This is a journey of a Portuguese guy moving.
* [Negative Space](https://negativespace.co/) - Stock photos added every week.
* [Openverse](https://openverse.org) - A meta search across several libraries to find adaptable / editable images and audio files.
* [Pexels](https://pexels.com/) - 20 new high-quality photos daily.
* [Photo Crops](https://www.photocrops.com/) - Five high resolution photos added every week, sometimes more.
* [Pickle Jar](https://www.picklejar.in/) - High-resolution images of everyday india. One new image every day.
* [Pickupimage](https://pickupimage.com/) - Free download high quality premium free stock images, public domain photos.
* [Realgraphy](https://realgraphy.org/) - Authentic Non-Stock Photos for Free. Forever.
* [Realistic Shots](https://realisticshots.com/) - 7 new photos added every week.
* [Skitter Photo](https://skitterphoto.com/) - Public domain pictures and stock photos for commercial use.
* [Snappy Goat](https://snappygoat.com/) - Over 12 million public domain & CC0 licensed images.
* [SpaceX Photos](https://www.flickr.com/photos/spacex/) - Promotional SpaceX stock photography.
* [Splashbase](https://www.splashbase.co/) - Search & discover free, hi-resolution photos & videos.
* [Stockified](https://www.stockified.com/) - Free pictures taken in India by Kiran BV and Aditya G Bharadwaj
* [Stocksnap](https://stocksnap.io/) - Hundreds of high resolution images added weekly.
* [Streetwill](https://streetwill.co/) - Free hi-resolution vintage photos to use any way you want.
* [The Pic Pac](https://thepicpac.com/) - New pacs on Monday, free pics Tuesday - Sunday.
* [Travel Coffee Book](https://travelcoffeebook.com/) - Travel photography.
* [WordPress Photo Directory](https://wordpress.org/photos/) - Free, high-quality, community-submitted photographs suitable for use within WordPress sites and elsewhere.

### Custom License / Usage

These following photography resources are those who have declared their own usage and restriction terms. These can be found by clicking the *(license)* link next to the resource.

* [Bara Art](https://www.bara-art.com/) - [:copyright:](https://www.bara-art.com/about/) The world always needs high quality photography! Here they are for you, so make something awesome out of them.
* [Compfight.com](https://compfight.com/) - [:copyright:](https://www.flickr.com/creativecommons/) An image search engine tailored to efficiently locate images for blogs, comps, inspiration, and research.
* [Death to the Stock Photo](https://join.deathtothestockphoto.com/) - [:copyright:](https://www.mediafire.com/file/2ifplcw682487nz/Death+to+the+Stock+Photo+-+Photograph+End+User+License+%281-2014%29+%281%29.pdf) Free monthly photos for all your creative needs.
* [Designer Pics](https://www.designerspics.com) - [:copyright:](https://www.designerspics.com/faq-and-terms/) Free photographs for personal and commercial by [Jeshu John](https://twitter.com/jeshujohn).
* [Freerange](https://freerangestock.com/) - [:copyright:](https://freerangestock.com/licensing.php) Quality stock photos for commercial and non-commercial use. For free.
* [ISO Republic](https://isorepublic.com/) - [:copyright:](https://isorepublic.com/terms/) ISO Republic provides exclusive free stock photos for creatives.
* [Kaboom Pics](https://kaboompics.com/) - [:copyright:](https://kaboompics.com/page/license-and-faq) Great place to get breathtaking Free Pictures for business or personal projects.
* [morgueFile](https://morguefile.com/) - [:copyright:](https://morguefile.com/terms) Free photo archive by creatives, for creatives.
* [Photober](https://www.photober.com/) - [:copyright:](https://www.photober.com/terms/) Free of charge photo downloading site for personal or commercial use.
* [PhotoStockEditor](https://photostockeditor.com) - [:copyright:](https://photostockeditor.com/#small-dialog) High-resolution weekly images for Personal & Commercial use.
* [Pic Jumbo](https://picjumbo.com/) - [:copyright:](https://picjumbo.com/faq-and-terms/) Totally free photos for your commercial & personal works.
* [Picography](https://picography.co/) - [:copyright:](https://picography.co/terms/) Free hi-resolution photos. Use them however you like.
* [Pixabay](https://pixabay.com) - [:copyright:](https://pixabay.com/service/license-summary/) Stock photos, illustrations, vectors and videos.
* [Reshot](https://www.reshot.com/) - [:copyright:](https://www.reshot.com/license) Handpicked, non-stocky images. Yours to use as you wish.
* [Startup Stock Photos](https://startupstockphotos.com/) - [:copyright:](https://startupstockphotos.com/terms-of-use) Startup based photography.
* [Unsplash](https://unsplash.com/) - [:copyright:](https://unsplash.com/license) User submitted, free high-resolution photos.

### Public Domain

A collection of links to public domain photography resources.

* [Good Free Photos](https://www.goodfreephotos.com) - [:copyright:](https://www.goodfreephotos.com/pages/creative-commons-license-terms) A large free stock photo site with thousands of public domain photos including landscapes, objects, animals, plants, textures, and many other free photos. All photos taken by [the website owner](https://www.goodfreephotos.com/pages/about-me).
* [Flickr Commons](https://www.flickr.com/commons) - [:copyright:](https://www.flickr.com/commons/usage/) Flickr's catalogue of the worlds public photo archives.
* [New Old Stock](https://nos.twnsnd.co/) - [:copyright:](https://nos.twnsnd.co/rights-and-usage) Vintage photos from the public archive. of known copyright restrictions.
* [NYPL Digital Collections](https://digitalcollections.nypl.org/) - [:copyright:](https://www.nypl.org/help/about-nypl/legal-notices/website-terms-and-conditions) 180.000 items are Public Domain since January 6th 2016 [Public Domain Collections: Free to Share & Reuse](https://www.nypl.org/research/collections/digital-collections/public-domain)
* [Project Apollo Archive](https://www.flickr.com/people/projectapolloarchive/?rb=1) - [:copyright:](https://creativecommons.org/publicdomain/mark/1.0/) High-resolution Apollo imagery scanned by NASA's Johnson Space Center.
* [Public Domain Archive](https://publicdomainarchive.com/) - [:copyright:](https://creativecommons.org/publicdomain/zero/1.0/) New stock photos every single week.

### Attribution Required licenses

The photographs on the following resources require Attribution unless otherwise stated on the website itself. These use a mixture of license, all of which have been linked to next to them.

* [BucketListly](https://photos.bucketlistly.com/) - A free creative common collection of travel photos anyone can use.
* [IM Creator](https://imcreator.com/free) - Also includes Website templates and icons. Some ([CC0-licensed](https://creativecommons.org/publicdomain/zero/1.0/)) works, check the license before use.
* [NASA Jet Propulsion Laboratory](https://www.jpl.nasa.gov/spaceimages/) - [:copyright:](https://www.jpl.nasa.gov/imagepolicy/) Graphics and photos of space and spaceflight.
* [UKBlackTech](https://ukblacktech.com/stockphotos/) - [:copyright:](https://creativecommons.org/licenses/by/4.0/) Photographers of British based BAME (Black, Asian, and minority ethnic) people in tech.
* [Women of Color in Tech](https://www.flickr.com/photos/wocintechchat/) - [:copyright:](https://creativecommons.org/licenses/by/2.0/) Licensed picture from Women of Color in Tech.

### Unspecified License

These resources haven't specified any formal terms of use or licenses.

* [Freejpg](https://en.freejpg.com.ar/) - Free image bank for commercial and editorial use.
* [Refe Real Life Photos](https://getrefe.tumblr.com) - Free real life photos from [REFE](https://getrefe.com/).
* [titania foto](https://www.titania-foto.com) - The free image database
* [Mockup World](https://www.mockupworld.co) - A mixture of free and premium mockup in-situation templates.
* [Wunderstock](https://www.Wunderstock.com/) - 670 (and counting) free HD images for your web and design projects.

## Illustration

A collection of illustration resources which contain a mixture of historical archive, contemporary and public domain assets.

* [Biodiversity Heritage Library](https://www.flickr.com/people/biodivlibrary/) [:copyright:](https://creativecommons.org/publicdomain/mark/1.0/) [:copyright:](https://creativecommons.org/licenses/by/2.0/) A mix of Public Domain and Attribution (CC BY 2.0) licenses. Nearly 150,000 exquisite, historical illustrations of life on Earth.
* [British Library Illustration Archive](https://www.flickr.com/photos/britishlibrary/albums/72157640831988343/) - [:copyright:](https://www.bl.uk/terms) The British Library’s collections on Flickr Commons offer access to millions of public domain images.
* [Old Book Illustrations](https://www.oldbookillustrations.com/) - [:copyright:](https://www.oldbookillustrations.com/terms-of-use/) A massive collection of illustrations from old books.
* [unDraw](https://undraw.co/) - [:copyright:](https://undraw.co/license) Open-source illustrations for every project you can imagine and create.
* [WooBro.design](https://woobro.design/) - [:copyright:](https://creativecommons.org/licenses/by/4.0/) CC-BY licensed vector image illustrations with sources.

## Vector Graphics

A collection of resources which contain stock graphical elements which don't fit in the other sections.

* [AMCharts - Free SVG Maps](https://www.amcharts.com/svg-maps/) - [:copyright:](https://creativecommons.org/licenses/by-nc/4.0/) A directory of free non-commercial, attribution licensed SVG maps in two level of details: High and low.
* [Bioicons](https://bioicons.com/) - [:copyright:](https://creativecommons.org/licenses/by-sa/4.0/) High quality science illustrations.
* [Facebook Design Resource](https://facebook.design/) - [:copyright:](https://facebook.design/disclaimer.html) A collection for design resources from Facebook including iOS9 GUI and various popular device templates.
* [FreeVectors.net](https://www.freeVectors.net) - [:copyright:](https://www.freevectors.net/terms) A fun little community of vector lovers who share free vector graphics.
* [Humaans](https://www.humaaans.com/) - [:copyright:](https://creativecommons.org/share-your-work/public-domain/cc0/) CC0 licensed clipart images of humans.
* [Logo Dust](https://logodust.com/) - [:copyright:](https://creativecommons.org/licenses/by/4.0/) Free CC Attribution 4.0 logo designs for your projects.
* [Mega Doodles Pack](https://github.com/MariaLetta/mega-doodles-pack) - [:copyright:](https://creativecommons.org/licenses/by-sa/4.0/) Free and big CC Attribution-ShareAlike 4.0 vector pack with hand-drawn doodles for presentations, social media, blog posts and so on. 
* [Open Doodles](https://www.opendoodles.com) - [:copyright:](https://creativecommons.org/publicdomain/zero/1.0/) CC-0-licensed vector sketches/cliparts with generator and compositions.
* [Sketch Repo](https://sketchrepo.com/) - [:copyright:](https://sketchrepo.com/about/) Sketch Repo is a great place to discover Sketch App resources for your next design project.
* [Vecteezy](https://www.vecteezy.com/) - [:copyright:](https://www.vecteezy.com/terms) Discover & download free vector art from a community of Illustrators.

## Videos

A selection of websites offering high quality video stock.

* [Coverr](https://coverr.co/) - [:copyright:](https://creativecommons.org/publicdomain/zero/1.0/) Beautiful, free, CC0 licensed videos for your homepage. 7 new videos every Monday.
* [FreeStockVideo](https://free-stock.video/) - [:copyright:](https://creativecommons.org/publicdomain/zero/1.0/) Free Beautiful Video & Footage Clips.
* [Life of Vids](https://www.lifeofvids.com/) - [:copyright:](https://creativecommons.org/publicdomain/zero/1.0/) Free royalty-free videos, clips & loops.
* [Mazwai](https://mazwai.com/) - Great collection of free creative commons HD video clips & footages. Check each video for licensing terms.
* [Mixkit](https://mixkit.co/free-stock-video/) - [:copyright:](https://mixkit.co/license/#videoFree) High-quality stock videos that are completely free.
* [Pexels Videos](https://videos.pexels.com/) - [:copyright:](https://creativecommons.org/publicdomain/zero/1.0/) Completely free, CC0 licensed stock videos.
* [Videezy](https://www.videezy.com) - [:copyright:](https://www.videezy.com/terms) Free stock videos, 4k footage, and free HD video clips.
* [Vidsplay](https://www.vidsplay.com/) - [:copyright:](https://www.vidsplay.com/terms.html) Free HD stock footage (Attribution required).
* [VYOO](https://www.veed.io/vyoo) - [:copyright:](https://www.veed.io/vyoo/terms) Beautiful, Free Vertical Videos.

## Patterns

A mixture of CSS and image based pattern resources.

* [CSS3 Patterns Gallery](https://lea.verou.me/css3patterns/) - CSS3 based repeatable patterns.
* [Hero Patterns](https://www.heropatterns.com/) - A collection of free CC Attribution 4.0 repeatable SVG background patterns.
* [Subtle Patterns](https://www.toptal.com/designers/subtlepatterns/) - Image based background textures and patterns.
* [The Pattern Library](https://thepatternlibrary.com/) - A collection of bold, bright and funky repeatable patterns.
* [UI Gradients](https://uigradients.com/) - Nice, subtle linear gradients to use in your designs.

## Textures

Websites offering images suitable for texturing objects for 3D graphics.

* [TextureHaven](https://texturehaven.com) - [:copyright: CC0-licensed](https://creativecommons.org/publicdomain/zero/1.0/) High quality set of textures with CC0 license.

## Fonts

A mixture of free and open source font resources.

* [Beautiful Web Type](https://beautifulwebtype.com) - A showcase of the best typefaces from the Google web fonts directory.
* [Brick](https://github.com/alfredxing/brick) - Webfonts that actually look good.
* [Font Fabric](https://www.fontfabric.com/category/free/) - Font Fabric's free fonts.
* [Font Squirrel](https://www.fontsquirrel.com) - Handpicked fonts free for commercial use.
* [Google Fonts](https://fonts.google.com/) - Interactive directory of free hosted application programming interfaces for web fonts.
* [Open Type Foundry](https://open-foundry.com/hot30) - [:copyright:](https://open-foundry.com/info) A new platform for open-source fonts in a noise-free environment.
* [The League of Movable Type](https://www.theleagueofmoveabletype.com/) - Open-source type foundry.

## Icons

### Icon Fonts

A collection for icon font resources, most of which also include SVGs, which can be used in your interface and website designs.

* [Devicons](https://vorillaz.github.io/devicons/#/main) - [:copyright:](https://choosealicense.com/licenses/mit/) Meet Devicons, an iconic font made for developers, code jedis, ninjas, HTTPsters, evangelists and nerds(sic). 100+ icons ready to use in your next project.
* [Iconfinder](https://www.iconfinder.com/) - Iconfinder provides beautiful icons to millions of designers and developers. Most icons are available under attribution. See individual licenses for more details.
* [Font Awesome](https://fontawesome.io/) - [:copyright:](https://choosealicense.com/licenses/mit/) MIT licensed icon font.
* [Fontello](https://fontello.com/) - [:copyright:](https://github.com/fontello/fontello/wiki/What-about-license%3F) - Fontello is a tool to quickly pack vector images into webfonts. Also includes a section of stock icons.
* [Foundation Icon Fonts 3](https://zurb.com/playground/foundation-icon-fonts-3) - [:copyright:](https://choosealicense.com/licenses/mit/) An icon font from Zurb, the people behind the Foundation framework.
* [IcoMoon](https://icomoon.io/) - [:copyright:](https://creativecommons.org/licenses/by/4.0/) Custom built and crisp icon fonts, done right.
* [Iconstore](https://iconstore.co/) - [:copyright:](https://iconstore.co/license/) Free Icons by First-Class Designers.
* [Ionicons](https://ionicons.com/) - [:copyright:](https://choosealicense.com/licenses/mit/) The premium icon font for Ionic Framework. 100% free and open source.
* [Ligature Symbols](https://kudakurage.com/ligature_symbols/) - [:copyright:](https://scripts.sil.org/cms/scripts/page.php?site_id=nrsi&id=OFL&_sc=1) Really clean icon set including all major topics.
* [Material Design Icons](https://material.io/icons/) - [:copyright:](https://creativecommons.org/licenses/by/4.0/) Google's Material Icons.
* [Octicons](https://octicons.github.com/) - [:copyright:](https://choosealicense.com/licenses/mit/) GitHub's Icons.
* [Open Iconic](https://useiconic.com/open) - [:copyright: (font)](https://scripts.sil.org/cms/scripts/page.php?item_id=OFL_web&_sc=1) [:copyright: (icons)](https://creativecommons.org/licenses/by-sa/3.0/) Icon set with 223 marks in SVG.
* [Pathlove Icons](https://pathlove.com/icons/) - [:copyright:](https://creativecommons.org/licenses/by-nc-nd/4.0/) 100+ cute and vibrant icons. Free for personal and commercial use; attribution required.
* [Simple Icons](https://simpleicons.org/) -[:copyright:](https://github.com/simple-icons/simple-icons/blob/develop/LICENSE.md) Free SVG icons for popular brands.
* [Social Stackicons](https://stackicons.com/) - [:copyright:](https://choosealicense.com/licenses/mit/) Icon set with over 60 social brands.
* [Standart](https://standart.io/) - Standart: free SVG icons for use in your project.
* [To icon](https://www.toicon.com/) - [:copyright:](https://www.toicon.com/license) Collection of SVG icons for your project.
* [Topcoat Icons](https://github.com/topcoat/icons) - [:copyright:](https://www.apache.org/licenses/LICENSE-2.0) Icons by [Topcoat](https://topcoat.io/).
* [Typicons](https://s-ings.com/typicons/) - [:copyright: (font)](https://scripts.sil.org/cms/scripts/page.php?item_id=OFL_web&_sc=1) [:copyright: (icons)](https://creativecommons.org/licenses/by-sa/3.0/) Rounded icon set with 336 icons.
* [Weather Icons](https://erikflowers.github.io/weather-icons/) - Weather Icons is the only icon font and CSS with 222 weather themed icons.
* [WeLoveIconFonts](https://weloveiconfonts.com) – A free & open source icon fonts hosting service (like Google Web Fonts, but icon fonts only).

### Icons Packages and Collections

A collection for SVG icon resources which can be used in your interface and website designs.

* [Atlas Icons](https://atlasicons.vectoricons.net/) - [:copyright:](https://opensource.org/licenses/MIT) 2,701 free consistent icons.
* [BlendIcons](https://blendicons.com/) - [:copyright:](https://blendicons.com/page/licence) Free, world top icons.
* [Bootstrap Icons](https://icons.getbootstrap.com/) - [:copyright:](https://github.com/twbs/icons/blob/main/LICENSE) Free, high quality, open source icon library with over 1,800 icons.
* [Doodle Icons](https://khushmeen.com/icons.html) - [:copyright:](https://creativecommons.org/publicdomain/zero/1.0/) 400+ handcrafted icons free for your next project.
* [Entypo](https://www.entypo.com/) - [:copyright:](https://creativecommons.org/licenses/by-sa/3.0/) Carefully crafted iconset by [Daniel Bruce](https://www.danielbruce.se/).
* [Flowbite](https://flowbite.com/icons/) - [:copyright:](https://opensource.org/licenses/MIT) Free and open-source SVG icons.
* [Fluent UI System Icons](https://github.com/microsoft/fluentui-system-icons) - [:copyright:](https://opensource.org/licenses/MIT) Fluent System Icons are a collection of familiar, friendly and modern icons from Microsoft.
* [Free Icons](https://www.iconshock.com/freeicons/) - A collection from all the open source icon collections available.
* [Free Icons](https://icons.download/) - [:copyright:](https://icons.download/license.html) Open-source vector icons in 16 styles for any project.
* [Game Icons](https://game-icons.net/) - [:copyright:](https://creativecommons.org/licenses/by/3.0/) A growing collection of SVG icons aimed mostly at video games.
* [Glow Icons](https://www.glowui.com/icons) - [:copyright:](https://opensource.org/licenses/MIT) 442 open source icons in 2 styles, made for interfaces.
* [Heroicons](https://heroicons.com/) - [:copyright:](https://opensource.org/licenses/MIT) Beautiful, free SVG icons from the makers of Tailwind CSS.
* [Humbleicons](https://humbleicons.com/) - [:copyright:](https://opensource.org/licenses/MIT) A pack of 227 simple, neutral, carefully crafted icons that you can use in your personal and commercial projects for free.
* [Iconhunt](https://www.iconhunt.site/) - A search engine with 150.000+ free, open sources icons.
* [Iconmonstr](https://iconmonstr.com/) - [:copyright:](https://iconmonstr.com/license/) A huge selection of icons in SVG and PNG format.
* [Iconoir](https://iconoir.com/) - [:copyright:](https://opensource.org/licenses/MIT) A Simple and Definitive Open-Source Icons Library.
* [Lucide](https://lucide.dev/) - [:copyright:](https://lucide.dev/license) Beautiful & consistent icon toolkit made by the community.
* [Maps Icon](https://github.com/djaiss/mapsicon) - [:copyright:](https://github.com/djaiss/mapsicon#license) Mapsicon is a free collection of maps for nearly every country in the world, available in 11 different sizes, ranging from 16x16 pixels to 1024x1024 pixels, as well as .svg format.
* [Material Design Icons](https://www.materialui.co/icons) - A collections of free, material design style icons.
* [Obra Icons](https://icons.obra.studio/) - [:copyright:](https://icons.obra.studio/licensing-agreement) A simple, consistent set of icons, perfect for user interfaces.
* [Simple Icons](https://github.com/simple-icons/simple-icons) - [:copyright:](https://artlibre.org/licence/lal/en/) SVG icons for popular brands.
* [The Noun Project](https://thenounproject.com/) - [:copyright:](https://thenounproject.com/accounts/pricing/) Over 150,000 icons designed by creators from around the world. Free users must give credit to the creator.
* [Unicorn icons](https://unicornicons.com/) - [:copyright:](https://unicornicons.com/license) 100+ playful animated and customizable icons, available in JSON and SVG format.

## Colors

A selection of websites offering color schemes.

* [Bootflat](https://bootflat.github.io/color-picker.html) - Bootflat Flat UI color picker is a project digging the Flat Color Picker which gives you the perfect colors for flat designs.
* [Brand Colors](https://brandcolors.net/) - Official color codes for the world's biggest brands.
* [Branition Colors](https://branition.com/colors) - Hand-curated collection of color pallets best fitted for branding.
* [Color Hunt](https://colorhunt.co/) - A place to discover, create, and share color palettes.
* [Colorful Gradients](https://colorfulgradients.tumblr.com/) - Gradients automatically created by a computer. 48 times daily.
* [Colour Lovers](https://www.colourlovers.com) - A creative community where people from around the world create and share colors, palettes and patterns.
* [Coolhue 2.0](https://webkul.github.io/coolhue/) - Coolest handpicked Gradient Palette and Swatch for your next super amazing stuff.
* [Coolors](https://coolors.co/) - The super fast color schemes generator for cool designers.
* [Flat UI Colors](https://flatuicolors.com/) - Flat color picker which gives you the perfect colors for flat designs.
* [Material Design Colors](https://www.materialui.co/colors) - Material ui color palette for Android, Web & iOS.
* [Material Palette](https://www.materialpalette.com/) - Generate & export your Material Design color palette.

## Aggregated Content

A liberal mixture of content aggregated from other free resources and made available at one central point.

* [All The Free Stock](https://allthefreestock.com) - One stop resource for free stock images, videos, sounds and more.
* [Avopix](https://avopix.com) - More than 15 000 absolutely free stock photos and vectors.
* [Libre Stock](https://librestock.com/) - Search engine for stock photo websites.
* [Stock Up](https://www.sitebuilderreport.com/stock-up) - Searching 9,301 (and counting) free stock photos across 25 websites.
* [The Stocks](https://thestocks.im/) - The best royalty free stock photos in one place.

## HTML Templates

Various different websites offering free HTML templates and themes.

* [Bootswatch](https://bootswatch.com/) - [:copyright:](https://raw.githubusercontent.com/thomaspark/bootswatch/master/LICENSE) Free themes for Bootstrap.
* [HTML5 Up](https://html5up.net/) - [:copyright:](https://creativecommons.org/licenses/by/3.0/) HTML5 UP makes spiffy HTML5 site templates.
* [HTMLrev](https://htmlrev.com/) - HTMLrev provides free HTML templates for websites and landing pages.
* [Start Bootstrap](https://startbootstrap.com/) - [:copyright:](https://opensource.org/licenses/MIT) Free Bootstrap templates and themes.
* [Templated](https://templated.live/) - [:copyright:](https://templated.live/license) A collection of 867 free CSS and HTML5 site templates, designed & built by Cherry + AJ and released under the Creative Commons.
* [Themezy](https://www.themezy.com/) - [:copyright:](https://www.themezy.com/terms) Free WordPress themes and website templates.

## Sounds & Music

Free resources for stock sound and music to be used on creative projects

* [Bensound](https://www.bensound.com) - [:copyright:](https://www.bensound.com/licensing) Royalty free music by Bensound.
* [ccMixter](https://ccmixter.org/) - [:copyright:](https://ccmixter.org/how-to-attribute-ccmixter-tracks) ccMixter.org offers over 30,000 original tracks that can be used freely in YouTube videos, remixes, mobile apps, games, and more.
* [Free Music Archive](https://freemusicarchive.org/) - [:copyright:](https://creativecommons.org/) An interactive library of high-quality, legal audio downloads directed by [WFMU](https://wfmu.org/), the most renowned freeform radio station in America.
* [Free To Use](https://freetouse.com/music) - [:copyright:](https://freetouse.com/music/usage-policy) Download unlimited background music 100% for free – no registration required. With no copyright claims, all our music is safe and free to use in your videos.
* [Freesound](https://freesound.org/) - [:copyright:](https://freesound.org/help/about/) Collaborative database of audio snippets, samples, recordings and bleeps.
* [FreeSoundEffects](https://free-sound-effects.net/) - [:copyright:](https://creativecommons.org/) For YouTube, filmmakers, games, podcasts and to use in your next video project, for free!
* [Internet Archive’s Netlabels Collection](https://archive.org/details/netlabels) - [:copyright:](https://creativecommons.org/) Netlabels collection hosts complete, freely downloadable/streamable.
* [Jamendo](https://www.jamendo.com/start) - [:copyright:](https://creativecommons.org/) Independent music community with a large collect of creative commons licensed music.
* [Sound Image](https://soundimage.org/) - [:copyright:](https://creativecommons.org/licenses/by/4.0/) Over 1000 tracks of free music and sound effects for your projects by Eric Matyas.
* [SoundBible](https://soundbible.com) - [:copyright:](https://soundbible.com/about.php) Thousands of free sound effects, sound clips, and straight up sounds.
* [Tunetank](https://tunetank.com/) - [:copyright:](https://tunetank.com/license/) Exclusive royalty free music for YouTube videos without copyright claims.
* [Unminus](https://www.unminus.com/) - [:copyright:](https://www.unminus.com/license) Download Royalty Free Music for YouTube Videos, Podcasts and Apps. No Copyright CC0 Music inspired by Unsplash.

## Paid Resources

And last, but not least, a selection of the best paid resources.

* [Adobe Stock](https://stock.adobe.com/) - Photos, Illustrations, Vectors.
* [Fotolia](https://us.fotolia.com/) - Photos, Illustrations, Vectors, Videos.
* [Inky Deals](https://www.inkydeals.com/) - Premium resources at insane discounts.
* [Shutterstock](https://shutterstock.com/) - Photos, Vectors, Editorial, Footages, Music.
* [Stocksy](https://stocksy.com/) - "Cliché-free" Photos.
* [Graphic River](https://graphicriver.net/) - Hand-reviewed graphic assets from a community of designers.
.



## How to Contribute

Please read [CONTRIBUTING](/CONTRIBUTING.md).

## How to Share

* [Share on Twitter](https://twitter.com/home?status=Checkout%20this%20Awesome%20Stock%20Resources%20list%20from%20%40neutraltone.%20https%3A%2F%2Fgithub.com%2Fneutraltone%2Fawesome-stock-resources%20%23design)
* [Share on Facebook](https://www.facebook.com/sharer/sharer.php?s=100&p[url]=https://github.com/neutraltone/awesome-stock-resources&p[images][0]=&p[title]=Awesome%20Stock%20Resources&p[summary]=)
* [Share on LinkedIn](https://www.linkedin.com/shareArticle?mini=true&url=https://github.com/neutraltone/awesome-stock-resources&title=Awesome%20Stock%20Resources&summary=&source=)


## Donate :heart:

And finally, if you appreciate this list and find it useful, please consider helping to support the ongoing maintenance by donating:

[!["Support Me via PayPal"](https://img.shields.io/badge/Donate-PayPal-blue.svg)](https://www.paypal.me/tonyphipps)
[!["Buy Me A Coffee"](https://www.buymeacoffee.com/assets/img/custom_images/orange_img.png)](https://www.buymeacoffee.com/neutraltone)

## License

[![CC0](https://licensebuttons.net/p/zero/1.0/88x31.png)](https://creativecommons.org/publicdomain/zero/1.0/)

To the extent possible under law, [Tony Phipps](https://twitter.com/neutraltone) has waived all copyright and related or neighboring rights to this work.
